/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.test.driver.codec;

import java.io.DataOutput;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Date;
import org.apache.qpid.protonj2.test.driver.codec.AtomicElement;
import org.apache.qpid.protonj2.test.driver.codec.Codec;
import org.apache.qpid.protonj2.test.driver.codec.Element;

class TimestampElement
extends AtomicElement<Date> {
    private final Date value;

    TimestampElement(Element<?> parent, Element<?> prev, Date d) {
        super(parent, prev);
        this.value = d;
    }

    @Override
    public int size() {
        return this.isElementOfArray() ? 8 : 9;
    }

    @Override
    public Date getValue() {
        return this.value;
    }

    @Override
    public Codec.DataType getDataType() {
        return Codec.DataType.TIMESTAMP;
    }

    @Override
    public int encode(DataOutput output) {
        try {
            int size = this.size();
            if (size == 9) {
                output.writeByte(-125);
            }
            output.writeLong(this.value.getTime());
            return size;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

