/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.test.driver.codec;

import java.io.DataOutput;
import java.io.IOException;
import java.io.UncheckedIOException;
import org.apache.qpid.protonj2.test.driver.codec.ArrayElement;
import org.apache.qpid.protonj2.test.driver.codec.AtomicElement;
import org.apache.qpid.protonj2.test.driver.codec.Codec;
import org.apache.qpid.protonj2.test.driver.codec.Element;
import org.apache.qpid.protonj2.test.driver.codec.primitives.UnsignedInteger;

class UnsignedIntegerElement
extends AtomicElement<UnsignedInteger> {
    private final UnsignedInteger value;

    UnsignedIntegerElement(Element<?> parent, Element<?> prev, UnsignedInteger i) {
        super(parent, prev);
        this.value = i;
    }

    @Override
    public int size() {
        if (this.isElementOfArray()) {
            ArrayElement parent = (ArrayElement)this.parent();
            if (parent.constructorType() == ArrayElement.TINY) {
                if (this.value.intValue() == 0) {
                    return 0;
                }
                parent.setConstructorType(ArrayElement.SMALL);
            }
            if (parent.constructorType() == ArrayElement.SMALL) {
                if (0 <= this.value.intValue() && this.value.intValue() <= 255) {
                    return 1;
                }
                parent.setConstructorType(ArrayElement.LARGE);
            }
            return 4;
        }
        return 0 == this.value.intValue() ? 1 : (1 <= this.value.intValue() && this.value.intValue() <= 255 ? 2 : 5);
    }

    @Override
    public UnsignedInteger getValue() {
        return this.value;
    }

    @Override
    public Codec.DataType getDataType() {
        return Codec.DataType.UINT;
    }

    @Override
    public int encode(DataOutput output) {
        try {
            int size = this.size();
            switch (size) {
                case 1: {
                    if (this.isElementOfArray()) {
                        output.writeByte((byte)this.value.intValue());
                        break;
                    }
                    output.writeByte(67);
                    break;
                }
                case 2: {
                    output.writeByte(82);
                    output.writeByte((byte)this.value.intValue());
                    break;
                }
                case 5: {
                    output.writeByte(112);
                }
                case 4: {
                    output.writeInt(this.value.intValue());
                }
            }
            return size;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

