/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.test.driver.codec;

import java.io.DataOutput;
import java.io.IOException;
import java.io.UncheckedIOException;
import org.apache.qpid.protonj2.test.driver.codec.AtomicElement;
import org.apache.qpid.protonj2.test.driver.codec.Codec;
import org.apache.qpid.protonj2.test.driver.codec.Element;
import org.apache.qpid.protonj2.test.driver.codec.primitives.UnsignedShort;

class UnsignedShortElement
extends AtomicElement<UnsignedShort> {
    private final UnsignedShort value;

    UnsignedShortElement(Element<?> parent, Element<?> prev, UnsignedShort ub) {
        super(parent, prev);
        this.value = ub;
    }

    @Override
    public int size() {
        return this.isElementOfArray() ? 2 : 3;
    }

    @Override
    public UnsignedShort getValue() {
        return this.value;
    }

    @Override
    public Codec.DataType getDataType() {
        return Codec.DataType.USHORT;
    }

    @Override
    public int encode(DataOutput output) {
        try {
            if (this.isElementOfArray()) {
                output.writeShort(this.value.shortValue());
                return 2;
            }
            output.writeByte(96);
            output.writeShort(this.value.shortValue());
            return 3;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

