/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.test.driver.expectations;

import java.nio.ByteBuffer;
import org.apache.qpid.protonj2.test.driver.AMQPTestDriver;
import org.apache.qpid.protonj2.test.driver.ScriptedExpectation;
import org.apache.qpid.protonj2.test.driver.actions.AMQPHeaderInjectAction;
import org.apache.qpid.protonj2.test.driver.actions.ByteBufferInjectAction;
import org.apache.qpid.protonj2.test.driver.codec.transport.AMQPHeader;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;

public class AMQPHeaderExpectation
implements ScriptedExpectation {
    private final AMQPHeader expected;
    private final AMQPTestDriver driver;

    public AMQPHeaderExpectation(AMQPHeader expected, AMQPTestDriver driver) {
        this.expected = expected;
        this.driver = driver;
    }

    public AMQPHeaderInjectAction respondWithAMQPHeader() {
        AMQPHeaderInjectAction response = new AMQPHeaderInjectAction(this.driver, AMQPHeader.getAMQPHeader());
        this.driver.addScriptedElement(response);
        return response;
    }

    public AMQPHeaderInjectAction respondWithSASLHeader() {
        AMQPHeaderInjectAction response = new AMQPHeaderInjectAction(this.driver, AMQPHeader.getSASLHeader());
        this.driver.addScriptedElement(response);
        return response;
    }

    public ByteBufferInjectAction respondWithBytes(byte[] buffer) {
        ByteBuffer copy = ByteBuffer.allocate(buffer.length);
        copy.put(buffer).flip().asReadOnlyBuffer();
        ByteBufferInjectAction response = new ByteBufferInjectAction(this.driver, copy.asReadOnlyBuffer());
        this.driver.addScriptedElement(response);
        return response;
    }

    public ByteBufferInjectAction respondWithBytes(ByteBuffer buffer) {
        ByteBufferInjectAction response = new ByteBufferInjectAction(this.driver, buffer);
        this.driver.addScriptedElement(response);
        return response;
    }

    @Override
    public void handleAMQPHeader(AMQPHeader header, AMQPTestDriver driver) {
        MatcherAssert.assertThat((String)"AMQP Header should match expected.", (Object)this.expected, (Matcher)CoreMatchers.equalTo((Object)header));
    }

    @Override
    public void handleSASLHeader(AMQPHeader header, AMQPTestDriver driver) {
        MatcherAssert.assertThat((String)"SASL Header should match expected.", (Object)this.expected, (Matcher)CoreMatchers.equalTo((Object)header));
    }
}

