/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.test.driver.expectations;

import java.nio.ByteBuffer;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.qpid.protonj2.test.driver.AMQPTestDriver;
import org.apache.qpid.protonj2.test.driver.LinkTracker;
import org.apache.qpid.protonj2.test.driver.SessionTracker;
import org.apache.qpid.protonj2.test.driver.actions.DetachInjectAction;
import org.apache.qpid.protonj2.test.driver.codec.ListDescribedType;
import org.apache.qpid.protonj2.test.driver.codec.primitives.Symbol;
import org.apache.qpid.protonj2.test.driver.codec.primitives.UnsignedInteger;
import org.apache.qpid.protonj2.test.driver.codec.primitives.UnsignedShort;
import org.apache.qpid.protonj2.test.driver.codec.transport.Detach;
import org.apache.qpid.protonj2.test.driver.codec.transport.ErrorCondition;
import org.apache.qpid.protonj2.test.driver.codec.util.TypeMapper;
import org.apache.qpid.protonj2.test.driver.expectations.AbstractExpectation;
import org.apache.qpid.protonj2.test.driver.matchers.transport.DetachMatcher;
import org.apache.qpid.protonj2.test.driver.matchers.transport.ErrorConditionMatcher;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;

public class DetachExpectation
extends AbstractExpectation<Detach> {
    private final DetachMatcher matcher = new DetachMatcher();
    private DetachInjectAction response;

    public DetachExpectation(AMQPTestDriver driver) {
        super(driver);
        this.withHandle(CoreMatchers.notNullValue());
    }

    public DetachExpectation onChannel(int channel) {
        super.onChannel(channel);
        return this;
    }

    public DetachExpectation optional() {
        return (DetachExpectation)super.optional();
    }

    public DetachInjectAction respond() {
        this.response = new DetachInjectAction(this.driver);
        this.driver.addScriptedElement(this.response);
        return this.response;
    }

    public DetachExpectation withPredicate(Predicate<Detach> predicate) {
        super.withPredicate(predicate);
        return this;
    }

    public DetachExpectation withCapture(Consumer<Detach> capture) {
        super.withCapture(capture);
        return this;
    }

    @Override
    public void handleDetach(int frameSize, Detach detach, ByteBuffer payload, int channel, AMQPTestDriver context) {
        super.handleDetach(frameSize, detach, payload, channel, context);
        UnsignedShort remoteChannel = UnsignedShort.valueOf(channel);
        SessionTracker session = this.driver.sessions().getSessionFromRemoteChannel(remoteChannel);
        if (session == null) {
            throw new AssertionError((Object)String.format("Received Detach on channel [%s] that has no matching Session for that remote channel. ", remoteChannel));
        }
        LinkTracker link = session.handleRemoteDetach(detach);
        if (link == null) {
            throw new AssertionError((Object)String.format("Received Detach on channel [%s] that has no matching Attached link for that remote handle. ", detach.getHandle()));
        }
        if (this.response != null) {
            if (this.response.onChannel() == -1) {
                this.response.onChannel(link.getSession().getLocalChannel());
            }
            if (this.response.getPerformative().getHandle() == null) {
                this.response.withHandle(link.getHandle());
            }
            if (this.response.getPerformative().getClosed() == null) {
                this.response.withClosed(detach.getClosed());
            }
        }
    }

    public DetachExpectation withHandle(int handle) {
        return this.withHandle(CoreMatchers.equalTo((Object)UnsignedInteger.valueOf(handle)));
    }

    public DetachExpectation withHandle(long handle) {
        return this.withHandle(CoreMatchers.equalTo((Object)UnsignedInteger.valueOf(handle)));
    }

    public DetachExpectation withHandle(UnsignedInteger handle) {
        return this.withHandle(CoreMatchers.equalTo((Object)handle));
    }

    public DetachExpectation withClosed(boolean closed) {
        return this.withClosed(CoreMatchers.equalTo((Object)closed));
    }

    public DetachExpectation withError(ErrorCondition error) {
        return this.withError(CoreMatchers.equalTo((Object)error));
    }

    public DetachExpectation withError(String condition, String description) {
        return this.withError(CoreMatchers.equalTo((Object)new ErrorCondition(Symbol.valueOf(condition), description)));
    }

    public DetachExpectation withError(String condition, String description, Map<String, Object> info) {
        return this.withError(CoreMatchers.equalTo((Object)new ErrorCondition(Symbol.valueOf(condition), description, TypeMapper.toSymbolKeyedMap(info))));
    }

    public DetachExpectation withError(Symbol condition, String description) {
        return this.withError(CoreMatchers.equalTo((Object)new ErrorCondition(condition, description)));
    }

    public DetachExpectation withError(Symbol condition, String description, Map<Symbol, Object> info) {
        return this.withError(CoreMatchers.equalTo((Object)new ErrorCondition(condition, description, info)));
    }

    public DetachExpectation withError(String condition) {
        return this.withError((Matcher<?>)new ErrorConditionMatcher().withCondition(condition));
    }

    public DetachExpectation withError(String condition, Matcher<?> descriptionMatcher) {
        return this.withError((Matcher<?>)new ErrorConditionMatcher().withCondition(condition).withDescription(descriptionMatcher));
    }

    public DetachExpectation withError(String condition, Matcher<?> descriptionMatcher, Matcher<?> infoMapMatcher) {
        return this.withError((Matcher<?>)new ErrorConditionMatcher().withCondition(condition).withDescription(descriptionMatcher).withInfo(infoMapMatcher));
    }

    public DetachExpectation withHandle(Matcher<?> m) {
        this.matcher.addFieldMatcher(Detach.Field.HANDLE, m);
        return this;
    }

    public DetachExpectation withClosed(Matcher<?> m) {
        this.matcher.addFieldMatcher(Detach.Field.CLOSED, m);
        return this;
    }

    public DetachExpectation withError(Matcher<?> m) {
        this.matcher.addFieldMatcher(Detach.Field.ERROR, m);
        return this;
    }

    @Override
    protected Matcher<ListDescribedType> getExpectationMatcher() {
        return this.matcher;
    }

    @Override
    protected Class<Detach> getExpectedTypeClass() {
        return Detach.class;
    }
}

