/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.test.driver.expectations;

import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.qpid.protonj2.test.driver.AMQPTestDriver;
import org.apache.qpid.protonj2.test.driver.SessionTracker;
import org.apache.qpid.protonj2.test.driver.codec.ListDescribedType;
import org.apache.qpid.protonj2.test.driver.codec.primitives.Binary;
import org.apache.qpid.protonj2.test.driver.codec.primitives.Symbol;
import org.apache.qpid.protonj2.test.driver.codec.primitives.UnsignedInteger;
import org.apache.qpid.protonj2.test.driver.codec.primitives.UnsignedShort;
import org.apache.qpid.protonj2.test.driver.codec.transport.DeliveryState;
import org.apache.qpid.protonj2.test.driver.codec.transport.Disposition;
import org.apache.qpid.protonj2.test.driver.codec.transport.Role;
import org.apache.qpid.protonj2.test.driver.expectations.AbstractExpectation;
import org.apache.qpid.protonj2.test.driver.matchers.messaging.AcceptedMatcher;
import org.apache.qpid.protonj2.test.driver.matchers.messaging.ModifiedMatcher;
import org.apache.qpid.protonj2.test.driver.matchers.messaging.RejectedMatcher;
import org.apache.qpid.protonj2.test.driver.matchers.messaging.ReleasedMatcher;
import org.apache.qpid.protonj2.test.driver.matchers.transactions.DeclaredMatcher;
import org.apache.qpid.protonj2.test.driver.matchers.transactions.TransactionalStateMatcher;
import org.apache.qpid.protonj2.test.driver.matchers.transport.DispositionMatcher;
import org.apache.qpid.protonj2.test.driver.matchers.transport.ErrorConditionMatcher;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;

public class DispositionExpectation
extends AbstractExpectation<Disposition> {
    private final DispositionMatcher matcher = new DispositionMatcher();
    private final DeliveryStateBuilder stateBuilder = new DeliveryStateBuilder();

    public DispositionExpectation(AMQPTestDriver driver) {
        super(driver);
        this.withRole(CoreMatchers.notNullValue());
        this.withFirst(CoreMatchers.notNullValue());
    }

    public DispositionExpectation optional() {
        return (DispositionExpectation)super.optional();
    }

    public DispositionExpectation onChannel(int channel) {
        super.onChannel(channel);
        return this;
    }

    public DispositionExpectation withPredicate(Predicate<Disposition> predicate) {
        super.withPredicate(predicate);
        return this;
    }

    public DispositionExpectation withCapture(Consumer<Disposition> capture) {
        super.withCapture(capture);
        return this;
    }

    @Override
    public void handleDisposition(int frameSize, Disposition disposition, ByteBuffer payload, int channel, AMQPTestDriver context) {
        super.handleDisposition(frameSize, disposition, payload, channel, context);
        UnsignedShort remoteChannel = UnsignedShort.valueOf(channel);
        SessionTracker session = this.driver.sessions().getSessionFromRemoteChannel(remoteChannel);
        if (session == null) {
            throw new AssertionError((Object)String.format("Received Disposition on channel [%s] that has no matching Session for that remote channel. ", remoteChannel));
        }
        session.handleDisposition(disposition);
    }

    public DispositionExpectation withRole(boolean role) {
        this.withRole(CoreMatchers.equalTo((Object)role));
        return this;
    }

    public DispositionExpectation withRole(Boolean role) {
        this.withRole(CoreMatchers.equalTo((Object)role));
        return this;
    }

    public DispositionExpectation withRole(Role role) {
        this.withRole(CoreMatchers.equalTo((Object)role.getValue()));
        return this;
    }

    public DispositionExpectation withFirst(int first) {
        return this.withFirst(CoreMatchers.equalTo((Object)UnsignedInteger.valueOf(first)));
    }

    public DispositionExpectation withFirst(long first) {
        return this.withFirst(CoreMatchers.equalTo((Object)UnsignedInteger.valueOf(first)));
    }

    public DispositionExpectation withFirst(UnsignedInteger first) {
        return this.withFirst(CoreMatchers.equalTo((Object)first));
    }

    public DispositionExpectation withLast(int last) {
        return this.withLast(CoreMatchers.equalTo((Object)UnsignedInteger.valueOf(last)));
    }

    public DispositionExpectation withLast(long last) {
        return this.withLast(CoreMatchers.equalTo((Object)UnsignedInteger.valueOf(last)));
    }

    public DispositionExpectation withLast(UnsignedInteger last) {
        return this.withLast(CoreMatchers.equalTo((Object)last));
    }

    public DispositionExpectation withSettled(boolean settled) {
        return this.withSettled(CoreMatchers.equalTo((Object)settled));
    }

    public DispositionExpectation withState(DeliveryState state) {
        return this.withState(CoreMatchers.equalTo((Object)state));
    }

    public DeliveryStateBuilder withState() {
        return this.stateBuilder;
    }

    public DispositionExpectation withBatchable(boolean batchable) {
        return this.withBatchable(CoreMatchers.equalTo((Object)batchable));
    }

    public DispositionExpectation withRole(Matcher<?> m) {
        this.matcher.addFieldMatcher(Disposition.Field.ROLE, m);
        return this;
    }

    public DispositionExpectation withFirst(Matcher<?> m) {
        this.matcher.addFieldMatcher(Disposition.Field.FIRST, m);
        return this;
    }

    public DispositionExpectation withLast(Matcher<?> m) {
        this.matcher.addFieldMatcher(Disposition.Field.LAST, m);
        return this;
    }

    public DispositionExpectation withSettled(Matcher<?> m) {
        this.matcher.addFieldMatcher(Disposition.Field.SETTLED, m);
        return this;
    }

    public DispositionExpectation withState(Matcher<?> m) {
        this.matcher.addFieldMatcher(Disposition.Field.STATE, m);
        return this;
    }

    public DispositionExpectation withBatchable(Matcher<?> m) {
        this.matcher.addFieldMatcher(Disposition.Field.BATCHABLE, m);
        return this;
    }

    @Override
    protected Matcher<ListDescribedType> getExpectationMatcher() {
        return this.matcher;
    }

    @Override
    protected Class<Disposition> getExpectedTypeClass() {
        return Disposition.class;
    }

    public final class DeliveryStateBuilder {
        public DispositionExpectation accepted() {
            DispositionExpectation.this.withState((Matcher<?>)new AcceptedMatcher());
            return DispositionExpectation.this;
        }

        public DispositionExpectation released() {
            DispositionExpectation.this.withState((Matcher<?>)new ReleasedMatcher());
            return DispositionExpectation.this;
        }

        public DispositionExpectation rejected() {
            DispositionExpectation.this.withState((Matcher<?>)new RejectedMatcher());
            return DispositionExpectation.this;
        }

        public DispositionExpectation rejected(String condition) {
            DispositionExpectation.this.withState((Matcher<?>)new RejectedMatcher().withError((Matcher<?>)new ErrorConditionMatcher().withCondition(condition)));
            return DispositionExpectation.this;
        }

        public DispositionExpectation rejected(Symbol condition) {
            DispositionExpectation.this.withState((Matcher<?>)new RejectedMatcher().withError((Matcher<?>)new ErrorConditionMatcher().withCondition(condition)));
            return DispositionExpectation.this;
        }

        public DispositionExpectation rejected(Matcher<?> condition) {
            DispositionExpectation.this.withState((Matcher<?>)new RejectedMatcher().withError((Matcher<?>)new ErrorConditionMatcher().withCondition(condition)));
            return DispositionExpectation.this;
        }

        public DispositionExpectation rejected(String condition, String description) {
            DispositionExpectation.this.withState((Matcher<?>)new RejectedMatcher().withError((Matcher<?>)new ErrorConditionMatcher().withCondition(condition).withDescription(description)));
            return DispositionExpectation.this;
        }

        public DispositionExpectation rejected(Symbol condition, String description) {
            DispositionExpectation.this.withState((Matcher<?>)new RejectedMatcher().withError((Matcher<?>)new ErrorConditionMatcher().withCondition(condition).withDescription(description)));
            return DispositionExpectation.this;
        }

        public DispositionExpectation rejected(String condition, Matcher<?> description) {
            DispositionExpectation.this.withState((Matcher<?>)new RejectedMatcher().withError((Matcher<?>)new ErrorConditionMatcher().withCondition(condition).withDescription(description)));
            return DispositionExpectation.this;
        }

        public DispositionExpectation rejected(Symbol condition, Matcher<?> description) {
            DispositionExpectation.this.withState((Matcher<?>)new RejectedMatcher().withError((Matcher<?>)new ErrorConditionMatcher().withCondition(condition).withDescription(description)));
            return DispositionExpectation.this;
        }

        public DispositionExpectation rejected(String condition, String description, Map<String, Object> info) {
            DispositionExpectation.this.withState((Matcher<?>)new RejectedMatcher().withError((Matcher<?>)new ErrorConditionMatcher().withCondition(condition).withDescription(description).withInfo(info)));
            return DispositionExpectation.this;
        }

        public DispositionExpectation rejected(Symbol condition, String description, Map<String, Object> info) {
            DispositionExpectation.this.withState((Matcher<?>)new RejectedMatcher().withError((Matcher<?>)new ErrorConditionMatcher().withCondition(condition).withDescription(description).withInfo(info)));
            return DispositionExpectation.this;
        }

        public DispositionExpectation rejected(String condition, String description, Matcher<?> info) {
            DispositionExpectation.this.withState((Matcher<?>)new RejectedMatcher().withError((Matcher<?>)new ErrorConditionMatcher().withCondition(condition).withDescription(description).withInfo(info)));
            return DispositionExpectation.this;
        }

        public DispositionExpectation rejected(Symbol condition, String description, Matcher<?> info) {
            DispositionExpectation.this.withState((Matcher<?>)new RejectedMatcher().withError((Matcher<?>)new ErrorConditionMatcher().withCondition(condition).withDescription(description).withInfo(info)));
            return DispositionExpectation.this;
        }

        public DispositionExpectation rejected(Matcher<?> condition, Matcher<?> description) {
            DispositionExpectation.this.withState((Matcher<?>)new RejectedMatcher().withError((Matcher<?>)new ErrorConditionMatcher().withCondition(condition).withDescription(description)));
            return DispositionExpectation.this;
        }

        public DispositionExpectation rejected(Matcher<?> condition, Matcher<?> description, Matcher<?> info) {
            DispositionExpectation.this.withState((Matcher<?>)new RejectedMatcher().withError((Matcher<?>)new ErrorConditionMatcher().withCondition(condition).withDescription(description).withInfo(info)));
            return DispositionExpectation.this;
        }

        public DispositionExpectation modified() {
            DispositionExpectation.this.withState((Matcher<?>)new ModifiedMatcher());
            return DispositionExpectation.this;
        }

        public DispositionExpectation modified(boolean failed) {
            DispositionExpectation.this.withState((Matcher<?>)new ModifiedMatcher().withDeliveryFailed(failed));
            return DispositionExpectation.this;
        }

        public DispositionExpectation modified(boolean failed, boolean undeliverableHere) {
            DispositionExpectation.this.withState((Matcher<?>)new ModifiedMatcher().withDeliveryFailed(failed).withUndeliverableHere(undeliverableHere));
            return DispositionExpectation.this;
        }

        public DispositionExpectation modified(boolean failed, boolean undeliverableHere, Map<String, Object> annotations) {
            DispositionExpectation.this.withState((Matcher<?>)new ModifiedMatcher().withDeliveryFailed(failed).withUndeliverableHere(undeliverableHere).withMessageAnnotations(annotations));
            return DispositionExpectation.this;
        }

        public DispositionExpectation modified(boolean failed, boolean undeliverableHere, Matcher<?> annotations) {
            DispositionExpectation.this.withState((Matcher<?>)new ModifiedMatcher().withDeliveryFailed(failed).withUndeliverableHere(undeliverableHere).withMessageAnnotations(annotations));
            return DispositionExpectation.this;
        }

        public DispositionExpectation declared() {
            byte[] txnId = new byte[4];
            Random rand = new Random();
            rand.setSeed(System.nanoTime());
            rand.nextBytes(txnId);
            DispositionExpectation.this.withState((Matcher<?>)new DeclaredMatcher().withTxnId(txnId));
            return DispositionExpectation.this;
        }

        public DispositionExpectation declared(byte[] txnId) {
            DispositionExpectation.this.withState((Matcher<?>)new DeclaredMatcher().withTxnId(txnId));
            return DispositionExpectation.this;
        }

        public DispositionTransactionalStateMatcher transactional() {
            DispositionTransactionalStateMatcher matcher = new DispositionTransactionalStateMatcher(DispositionExpectation.this);
            DispositionExpectation.this.withState((Matcher<?>)matcher);
            return matcher;
        }
    }

    public static class DispositionTransactionalStateMatcher
    extends TransactionalStateMatcher {
        private final DispositionExpectation expectation;

        public DispositionTransactionalStateMatcher(DispositionExpectation expectation) {
            this.expectation = expectation;
        }

        public DispositionExpectation also() {
            return this.expectation;
        }

        public DispositionExpectation and() {
            return this.expectation;
        }

        @Override
        public DispositionTransactionalStateMatcher withTxnId(byte[] txnId) {
            super.withTxnId(CoreMatchers.equalTo((Object)new Binary(txnId)));
            return this;
        }

        @Override
        public DispositionTransactionalStateMatcher withTxnId(Binary txnId) {
            super.withTxnId(CoreMatchers.equalTo((Object)txnId));
            return this;
        }

        @Override
        public DispositionTransactionalStateMatcher withOutcome(DeliveryState outcome) {
            super.withOutcome(CoreMatchers.equalTo((Object)outcome));
            return this;
        }

        @Override
        public DispositionTransactionalStateMatcher withTxnId(Matcher<?> m) {
            super.withOutcome(m);
            return this;
        }

        @Override
        public DispositionTransactionalStateMatcher withOutcome(Matcher<?> m) {
            super.withOutcome(m);
            return this;
        }

        public DispositionTransactionalStateMatcher withAccepted() {
            super.withOutcome((Matcher<?>)new AcceptedMatcher());
            return this;
        }

        public DispositionTransactionalStateMatcher withReleased() {
            super.withOutcome((Matcher<?>)new ReleasedMatcher());
            return this;
        }

        public DispositionTransactionalStateMatcher withRejected() {
            super.withOutcome((Matcher<?>)new RejectedMatcher());
            return this;
        }

        public DispositionTransactionalStateMatcher withRejected(String condition, String description) {
            super.withOutcome((Matcher<?>)new RejectedMatcher().withError((Matcher<?>)new ErrorConditionMatcher().withCondition(condition).withDescription(description)));
            return this;
        }

        public DispositionTransactionalStateMatcher withRejected(Symbol condition, String description) {
            super.withOutcome((Matcher<?>)new RejectedMatcher().withError((Matcher<?>)new ErrorConditionMatcher().withCondition(condition).withDescription(description)));
            return this;
        }

        public DispositionTransactionalStateMatcher withRejected(String condition, String description, Map<String, Object> info) {
            super.withOutcome((Matcher<?>)new RejectedMatcher().withError((Matcher<?>)new ErrorConditionMatcher().withCondition(condition).withDescription(description).withInfo(info)));
            return this;
        }

        public DispositionTransactionalStateMatcher withRejected(Symbol condition, String description, Map<String, Object> info) {
            super.withOutcome((Matcher<?>)new RejectedMatcher().withError((Matcher<?>)new ErrorConditionMatcher().withCondition(condition).withDescription(description).withInfo(info)));
            return this;
        }

        public DispositionTransactionalStateMatcher withRejected(String condition, String description, Matcher<?> info) {
            super.withOutcome((Matcher<?>)new RejectedMatcher().withError((Matcher<?>)new ErrorConditionMatcher().withCondition(condition).withDescription(description).withInfo(info)));
            return this;
        }

        public DispositionTransactionalStateMatcher withRejected(Symbol condition, String description, Matcher<?> info) {
            super.withOutcome((Matcher<?>)new RejectedMatcher().withError((Matcher<?>)new ErrorConditionMatcher().withCondition(condition).withDescription(description).withInfo(info)));
            return this;
        }

        public DispositionTransactionalStateMatcher withModified() {
            super.withOutcome((Matcher<?>)new ModifiedMatcher());
            return this;
        }

        public DispositionTransactionalStateMatcher withModified(boolean failed) {
            super.withOutcome((Matcher<?>)new ModifiedMatcher().withDeliveryFailed(failed));
            return this;
        }

        public DispositionTransactionalStateMatcher withModified(boolean failed, boolean undeliverableHere) {
            super.withOutcome((Matcher<?>)new ModifiedMatcher().withDeliveryFailed(failed).withUndeliverableHere(undeliverableHere));
            return this;
        }

        public DispositionTransactionalStateMatcher withModified(boolean failed, boolean undeliverableHere, Map<String, Object> annotations) {
            super.withOutcome((Matcher<?>)new ModifiedMatcher().withDeliveryFailed(failed).withUndeliverableHere(undeliverableHere).withMessageAnnotations(annotations));
            return this;
        }

        public DispositionTransactionalStateMatcher withModified(boolean failed, boolean undeliverableHere, Matcher<?> annotations) {
            super.withOutcome((Matcher<?>)new ModifiedMatcher().withDeliveryFailed(failed).withUndeliverableHere(undeliverableHere).withMessageAnnotations(annotations));
            return this;
        }
    }
}

