/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.test.driver.expectations;

import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.qpid.protonj2.test.driver.AMQPTestDriver;
import org.apache.qpid.protonj2.test.driver.ScriptedAction;
import org.apache.qpid.protonj2.test.driver.codec.ListDescribedType;
import org.apache.qpid.protonj2.test.driver.codec.primitives.Binary;
import org.apache.qpid.protonj2.test.driver.codec.primitives.UnsignedByte;
import org.apache.qpid.protonj2.test.driver.codec.security.SaslCode;
import org.apache.qpid.protonj2.test.driver.codec.security.SaslOutcome;
import org.apache.qpid.protonj2.test.driver.expectations.AbstractExpectation;
import org.apache.qpid.protonj2.test.driver.matchers.security.SaslOutcomeMatcher;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;

public class SaslOutcomeExpectation
extends AbstractExpectation<SaslOutcome> {
    private final SaslOutcomeMatcher matcher = new SaslOutcomeMatcher();

    public SaslOutcomeExpectation(AMQPTestDriver driver) {
        super(driver);
    }

    public SaslOutcomeExpectation withPredicate(Predicate<SaslOutcome> predicate) {
        super.withPredicate(predicate);
        return this;
    }

    public SaslOutcomeExpectation withCapture(Consumer<SaslOutcome> capture) {
        super.withCapture(capture);
        return this;
    }

    @Override
    public ScriptedAction performAfterwards() {
        return new ScriptedAction(){

            @Override
            public ScriptedAction queue() {
                throw new UnsupportedOperationException("Cannot be called on this action");
            }

            @Override
            public ScriptedAction perform(AMQPTestDriver driver) {
                driver.resetToExpectingAMQPHeader();
                return null;
            }

            @Override
            public ScriptedAction now() {
                throw new UnsupportedOperationException("Cannot be called on this action");
            }

            @Override
            public ScriptedAction later(int waitTime) {
                throw new UnsupportedOperationException("Cannot be called on this action");
            }
        };
    }

    public SaslOutcomeExpectation withCode(byte code) {
        return this.withCode(CoreMatchers.equalTo((Object)UnsignedByte.valueOf(code)));
    }

    public SaslOutcomeExpectation withCode(SaslCode code) {
        return this.withCode(CoreMatchers.equalTo((Object)code.getValue()));
    }

    public SaslOutcomeExpectation withAdditionalData(byte[] additionalData) {
        return this.withAdditionalData(CoreMatchers.equalTo((Object)new Binary(additionalData)));
    }

    public SaslOutcomeExpectation withAdditionalData(Binary additionalData) {
        return this.withAdditionalData(CoreMatchers.equalTo((Object)additionalData));
    }

    public SaslOutcomeExpectation withCode(Matcher<?> m) {
        this.matcher.addFieldMatcher(SaslOutcome.Field.CODE, m);
        return this;
    }

    public SaslOutcomeExpectation withAdditionalData(Matcher<?> m) {
        this.matcher.addFieldMatcher(SaslOutcome.Field.ADDITIONAL_DATA, m);
        return this;
    }

    @Override
    protected Matcher<ListDescribedType> getExpectationMatcher() {
        return this.matcher;
    }

    @Override
    protected Class<SaslOutcome> getExpectedTypeClass() {
        return SaslOutcome.class;
    }
}

