/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.test.driver.expectations;

import java.nio.ByteBuffer;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.apache.qpid.protonj2.test.driver.AMQPTestDriver;
import org.apache.qpid.protonj2.test.driver.LinkTracker;
import org.apache.qpid.protonj2.test.driver.SessionTracker;
import org.apache.qpid.protonj2.test.driver.actions.DispositionInjectAction;
import org.apache.qpid.protonj2.test.driver.codec.ListDescribedType;
import org.apache.qpid.protonj2.test.driver.codec.messaging.Accepted;
import org.apache.qpid.protonj2.test.driver.codec.messaging.Modified;
import org.apache.qpid.protonj2.test.driver.codec.messaging.Rejected;
import org.apache.qpid.protonj2.test.driver.codec.messaging.Released;
import org.apache.qpid.protonj2.test.driver.codec.primitives.Binary;
import org.apache.qpid.protonj2.test.driver.codec.primitives.Symbol;
import org.apache.qpid.protonj2.test.driver.codec.primitives.UnsignedInteger;
import org.apache.qpid.protonj2.test.driver.codec.primitives.UnsignedShort;
import org.apache.qpid.protonj2.test.driver.codec.transport.DeliveryState;
import org.apache.qpid.protonj2.test.driver.codec.transport.ErrorCondition;
import org.apache.qpid.protonj2.test.driver.codec.transport.ReceiverSettleMode;
import org.apache.qpid.protonj2.test.driver.codec.transport.Transfer;
import org.apache.qpid.protonj2.test.driver.codec.util.TypeMapper;
import org.apache.qpid.protonj2.test.driver.expectations.AbstractExpectation;
import org.apache.qpid.protonj2.test.driver.matchers.messaging.AcceptedMatcher;
import org.apache.qpid.protonj2.test.driver.matchers.messaging.ModifiedMatcher;
import org.apache.qpid.protonj2.test.driver.matchers.messaging.RejectedMatcher;
import org.apache.qpid.protonj2.test.driver.matchers.messaging.ReleasedMatcher;
import org.apache.qpid.protonj2.test.driver.matchers.transactions.TransactionalStateMatcher;
import org.apache.qpid.protonj2.test.driver.matchers.transport.ErrorConditionMatcher;
import org.apache.qpid.protonj2.test.driver.matchers.transport.TransferMatcher;
import org.apache.qpid.protonj2.test.driver.matchers.transport.TransferMessageMatcher;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

public class TransferExpectation
extends AbstractExpectation<Transfer> {
    private final TransferMatcher matcher = new TransferMatcher();
    private final DeliveryStateBuilder stateBuilder = new DeliveryStateBuilder();
    private Matcher<ByteBuffer> payloadMatcher = Matchers.any(ByteBuffer.class);
    protected DispositionInjectAction response;

    public TransferExpectation(AMQPTestDriver driver) {
        super(driver);
        this.withHandle(CoreMatchers.notNullValue());
    }

    public TransferExpectation optional() {
        return (TransferExpectation)super.optional();
    }

    public TransferExpectation withPredicate(Predicate<Transfer> predicate) {
        super.withPredicate(predicate);
        return this;
    }

    public TransferExpectation withCapture(Consumer<Transfer> capture) {
        super.withCapture(capture);
        return this;
    }

    public DispositionInjectAction respond() {
        this.response = new DispositionInjectAction(this.driver);
        this.driver.addScriptedElement(this.response);
        return this.response;
    }

    public DispositionInjectAction accept() {
        this.response = new DispositionInjectAction(this.driver);
        this.response.withSettled(true);
        this.response.withState(Accepted.getInstance());
        this.driver.addScriptedElement(this.response);
        return this.response;
    }

    public DispositionInjectAction release() {
        this.response = new DispositionInjectAction(this.driver);
        this.response.withSettled(true);
        this.response.withState(Released.getInstance());
        this.driver.addScriptedElement(this.response);
        return this.response;
    }

    public DispositionInjectAction reject() {
        return this.reject(null);
    }

    public DispositionInjectAction reject(String condition, String description) {
        return this.reject(new ErrorCondition(Symbol.valueOf(condition), description));
    }

    public DispositionInjectAction reject(Symbol condition, String description) {
        return this.reject(new ErrorCondition(condition, description));
    }

    public DispositionInjectAction reject(String condition, String description, Map<String, Object> info) {
        return this.reject(new ErrorCondition(Symbol.valueOf(condition), description, TypeMapper.toSymbolKeyedMap(info)));
    }

    public DispositionInjectAction reject(Symbol condition, String description, Map<Symbol, Object> info) {
        return this.reject(new ErrorCondition(condition, description, info));
    }

    public DispositionInjectAction reject(ErrorCondition error) {
        this.response = new DispositionInjectAction(this.driver);
        this.response.withSettled(true);
        this.response.withState(new Rejected().setError(error));
        this.driver.addScriptedElement(this.response);
        return this.response;
    }

    public DispositionInjectAction modify(boolean failed) {
        return this.modify(failed, false);
    }

    public DispositionInjectAction modify(boolean failed, boolean undeliverable) {
        return this.modify(failed, undeliverable, null);
    }

    public DispositionInjectAction modify(boolean failed, boolean undeliverable, Map<String, Object> annotations) {
        Modified modified = new Modified();
        modified.setDeliveryFailed(failed);
        modified.setUndeliverableHere(undeliverable);
        if (annotations != null) {
            modified.setMessageAnnotations(TypeMapper.toSymbolKeyedMap(annotations));
        }
        this.response = new DispositionInjectAction(this.driver);
        this.response.withSettled(true);
        this.response.withState(modified);
        this.driver.addScriptedElement(this.response);
        return this.response;
    }

    public TransferExpectation onChannel(int channel) {
        super.onChannel(channel);
        return this;
    }

    @Override
    public void handleTransfer(int frameSize, Transfer transfer, ByteBuffer payload, int channel, AMQPTestDriver driver) {
        super.handleTransfer(frameSize, transfer, payload, channel, driver);
        UnsignedShort remoteChannel = UnsignedShort.valueOf(channel);
        SessionTracker session = driver.sessions().getSessionFromRemoteChannel(remoteChannel);
        if (session == null) {
            throw new AssertionError((Object)String.format("Received Transfer on channel [%s] that has no matching Session for that remote channel. ", remoteChannel));
        }
        LinkTracker link = session.handleTransfer(transfer, payload);
        if (this.response != null) {
            if (this.response.onChannel() == -1) {
                this.response.onChannel(link.getSession().getLocalChannel());
            }
            if (this.response.getPerformative().getFirst() == null) {
                this.response.withFirst(transfer.getDeliveryId());
            }
            if (this.response.getPerformative().getRole() == null) {
                this.response.withRole(link.getRole());
            }
        }
    }

    public TransferExpectation withHandle(int handle) {
        return this.withHandle(CoreMatchers.equalTo((Object)UnsignedInteger.valueOf(handle)));
    }

    public TransferExpectation withHandle(long handle) {
        return this.withHandle(CoreMatchers.equalTo((Object)UnsignedInteger.valueOf(handle)));
    }

    public TransferExpectation withHandle(UnsignedInteger handle) {
        return this.withHandle(CoreMatchers.equalTo((Object)handle));
    }

    public TransferExpectation withDeliveryId(int deliveryId) {
        return this.withDeliveryId(CoreMatchers.equalTo((Object)UnsignedInteger.valueOf(deliveryId)));
    }

    public TransferExpectation withDeliveryId(long deliveryId) {
        return this.withDeliveryId(CoreMatchers.equalTo((Object)UnsignedInteger.valueOf(deliveryId)));
    }

    public TransferExpectation withDeliveryId(UnsignedInteger deliveryId) {
        return this.withDeliveryId(CoreMatchers.equalTo((Object)deliveryId));
    }

    public TransferExpectation withDeliveryTag(byte[] tag) {
        return this.withDeliveryTag(new Binary(tag));
    }

    public TransferExpectation withDeliveryTag(Binary deliveryTag) {
        return this.withDeliveryTag(CoreMatchers.equalTo((Object)deliveryTag));
    }

    public TransferExpectation withNonNullDeliveryTag() {
        return this.withDeliveryTag(CoreMatchers.notNullValue());
    }

    public TransferExpectation withNullDeliveryTag() {
        return this.withDeliveryTag(CoreMatchers.nullValue());
    }

    public TransferExpectation withMessageFormat(int messageFormat) {
        return this.withMessageFormat(CoreMatchers.equalTo((Object)UnsignedInteger.valueOf(messageFormat)));
    }

    public TransferExpectation withMessageFormat(long messageFormat) {
        return this.withMessageFormat(CoreMatchers.equalTo((Object)UnsignedInteger.valueOf(messageFormat)));
    }

    public TransferExpectation withMessageFormat(UnsignedInteger messageFormat) {
        return this.withMessageFormat(CoreMatchers.equalTo((Object)messageFormat));
    }

    public TransferExpectation withSettled(boolean settled) {
        return this.withSettled(CoreMatchers.equalTo((Object)settled));
    }

    public TransferExpectation withMore(boolean more) {
        return this.withMore(CoreMatchers.equalTo((Object)more));
    }

    public TransferExpectation withRcvSettleMode(ReceiverSettleMode rcvSettleMode) {
        return this.withRcvSettleMode(CoreMatchers.equalTo((Object)rcvSettleMode.getValue()));
    }

    public TransferExpectation withState(DeliveryState state) {
        return this.withState(CoreMatchers.equalTo((Object)state));
    }

    public DeliveryStateBuilder withState() {
        return this.stateBuilder;
    }

    public TransferExpectation withNullState() {
        return this.withState(CoreMatchers.nullValue());
    }

    public TransferExpectation withResume(boolean resume) {
        return this.withResume(CoreMatchers.equalTo((Object)resume));
    }

    public TransferExpectation withAborted(boolean aborted) {
        return this.withAborted(CoreMatchers.equalTo((Object)aborted));
    }

    public TransferExpectation withBatchable(boolean batchable) {
        return this.withBatchable(CoreMatchers.equalTo((Object)batchable));
    }

    public TransferExpectation withNonNullPayload() {
        this.payloadMatcher = CoreMatchers.notNullValue(ByteBuffer.class);
        return this;
    }

    public TransferExpectation withNullPayload() {
        this.payloadMatcher = CoreMatchers.nullValue(ByteBuffer.class);
        return this;
    }

    public TransferExpectation withPayload(byte[] buffer) {
        ByteBuffer copy = ByteBuffer.allocate(buffer.length);
        copy.put(buffer).flip();
        this.payloadMatcher = Matchers.equalTo((Object)copy.asReadOnlyBuffer());
        return this;
    }

    public TransferMessageMatcher withMessage() {
        this.payloadMatcher = new TransferMessageMatcher(this);
        return this.payloadMatcher;
    }

    public TransferExpectation withHandle(Matcher<?> m) {
        this.matcher.addFieldMatcher(Transfer.Field.HANDLE, m);
        return this;
    }

    public TransferExpectation withDeliveryId(Matcher<?> m) {
        this.matcher.addFieldMatcher(Transfer.Field.DELIVERY_ID, m);
        return this;
    }

    public TransferExpectation withDeliveryTag(Matcher<?> m) {
        this.matcher.addFieldMatcher(Transfer.Field.DELIVERY_TAG, m);
        return this;
    }

    public TransferExpectation withMessageFormat(Matcher<?> m) {
        this.matcher.addFieldMatcher(Transfer.Field.MESSAGE_FORMAT, m);
        return this;
    }

    public TransferExpectation withSettled(Matcher<?> m) {
        this.matcher.addFieldMatcher(Transfer.Field.SETTLED, m);
        return this;
    }

    public TransferExpectation withMore(Matcher<?> m) {
        this.matcher.addFieldMatcher(Transfer.Field.MORE, m);
        return this;
    }

    public TransferExpectation withRcvSettleMode(Matcher<?> m) {
        this.matcher.addFieldMatcher(Transfer.Field.RCV_SETTLE_MODE, m);
        return this;
    }

    public TransferExpectation withState(Matcher<?> m) {
        this.matcher.addFieldMatcher(Transfer.Field.STATE, m);
        return this;
    }

    public TransferExpectation withResume(Matcher<?> m) {
        this.matcher.addFieldMatcher(Transfer.Field.RESUME, m);
        return this;
    }

    public TransferExpectation withAborted(Matcher<?> m) {
        this.matcher.addFieldMatcher(Transfer.Field.ABORTED, m);
        return this;
    }

    public TransferExpectation withBatchable(Matcher<?> m) {
        this.matcher.addFieldMatcher(Transfer.Field.BATCHABLE, m);
        return this;
    }

    public TransferExpectation withPayload(Matcher<ByteBuffer> payloadMatcher) {
        this.payloadMatcher = payloadMatcher;
        return this;
    }

    @Override
    protected Matcher<ListDescribedType> getExpectationMatcher() {
        return this.matcher;
    }

    @Override
    protected Matcher<ByteBuffer> getPayloadMatcher() {
        return this.payloadMatcher;
    }

    @Override
    protected Class<Transfer> getExpectedTypeClass() {
        return Transfer.class;
    }

    public final class DeliveryStateBuilder {
        public TransferExpectation accepted() {
            TransferExpectation.this.withState((Matcher<?>)new AcceptedMatcher());
            return TransferExpectation.this;
        }

        public TransferExpectation released() {
            TransferExpectation.this.withState((Matcher<?>)new ReleasedMatcher());
            return TransferExpectation.this;
        }

        public TransferExpectation rejected() {
            TransferExpectation.this.withState((Matcher<?>)new RejectedMatcher());
            return TransferExpectation.this;
        }

        public TransferExpectation rejected(String condition, String description) {
            TransferExpectation.this.withState((Matcher<?>)new RejectedMatcher().withError((Matcher<?>)new ErrorConditionMatcher().withCondition(condition).withDescription(description)));
            return TransferExpectation.this;
        }

        public TransferExpectation rejected(Symbol condition, String description) {
            TransferExpectation.this.withState((Matcher<?>)new RejectedMatcher().withError((Matcher<?>)new ErrorConditionMatcher().withCondition(condition).withDescription(description)));
            return TransferExpectation.this;
        }

        public TransferExpectation rejected(String condition, Matcher<?> description) {
            TransferExpectation.this.withState((Matcher<?>)new RejectedMatcher().withError((Matcher<?>)new ErrorConditionMatcher().withCondition(condition).withDescription(description)));
            return TransferExpectation.this;
        }

        public TransferExpectation rejected(Symbol condition, Matcher<?> description) {
            TransferExpectation.this.withState((Matcher<?>)new RejectedMatcher().withError((Matcher<?>)new ErrorConditionMatcher().withCondition(condition).withDescription(description)));
            return TransferExpectation.this;
        }

        public TransferExpectation rejected(String condition, String description, Map<String, Object> info) {
            TransferExpectation.this.withState((Matcher<?>)new RejectedMatcher().withError((Matcher<?>)new ErrorConditionMatcher().withCondition(condition).withDescription(description).withInfo(info)));
            return TransferExpectation.this;
        }

        public TransferExpectation rejected(Symbol condition, String description, Map<Symbol, Object> info) {
            TransferExpectation.this.withState((Matcher<?>)new RejectedMatcher().withError((Matcher<?>)new ErrorConditionMatcher().withCondition(condition).withDescription(description).withInfoMap(info)));
            return TransferExpectation.this;
        }

        public TransferExpectation rejected(Symbol condition, String description, Matcher<?> info) {
            TransferExpectation.this.withState((Matcher<?>)new RejectedMatcher().withError((Matcher<?>)new ErrorConditionMatcher().withCondition(condition).withDescription(description).withInfo(info)));
            return TransferExpectation.this;
        }

        public TransferExpectation rejected(Symbol condition, Matcher<?> description, Map<Symbol, Object> info) {
            TransferExpectation.this.withState((Matcher<?>)new RejectedMatcher().withError((Matcher<?>)new ErrorConditionMatcher().withCondition(condition).withDescription(description).withInfoMap(info)));
            return TransferExpectation.this;
        }

        public TransferExpectation rejected(Symbol condition, Matcher<?> description, Matcher<?> info) {
            TransferExpectation.this.withState((Matcher<?>)new RejectedMatcher().withError((Matcher<?>)new ErrorConditionMatcher().withCondition(condition).withDescription(description).withInfo(info)));
            return TransferExpectation.this;
        }

        public TransferExpectation modified() {
            TransferExpectation.this.withState((Matcher<?>)new ModifiedMatcher());
            return TransferExpectation.this;
        }

        public TransferExpectation modified(boolean failed) {
            TransferExpectation.this.withState((Matcher<?>)new ModifiedMatcher().withDeliveryFailed(failed));
            return TransferExpectation.this;
        }

        public TransferExpectation modified(boolean failed, boolean undeliverableHere) {
            TransferExpectation.this.withState((Matcher<?>)new ModifiedMatcher().withDeliveryFailed(failed).withUndeliverableHere(undeliverableHere));
            return TransferExpectation.this;
        }

        public TransferExpectation modified(boolean failed, boolean undeliverableHere, Map<String, Object> annotations) {
            TransferExpectation.this.withState((Matcher<?>)new ModifiedMatcher().withDeliveryFailed(failed).withUndeliverableHere(undeliverableHere).withMessageAnnotations(annotations));
            return TransferExpectation.this;
        }

        public TransferExpectation modified(boolean failed, boolean undeliverableHere, Matcher<?> annotations) {
            TransferExpectation.this.withState((Matcher<?>)new ModifiedMatcher().withDeliveryFailed(failed).withUndeliverableHere(undeliverableHere).withMessageAnnotations(annotations));
            return TransferExpectation.this;
        }

        public TransferTransactionalStateMatcher transactional() {
            TransferTransactionalStateMatcher matcher = new TransferTransactionalStateMatcher(TransferExpectation.this);
            TransferExpectation.this.withState((Matcher<?>)matcher);
            return matcher;
        }
    }

    public static class TransferTransactionalStateMatcher
    extends TransactionalStateMatcher {
        private final TransferExpectation expectation;

        public TransferTransactionalStateMatcher(TransferExpectation expectation) {
            this.expectation = expectation;
        }

        public TransferExpectation also() {
            return this.expectation;
        }

        public TransferExpectation and() {
            return this.expectation;
        }

        @Override
        public TransferTransactionalStateMatcher withTxnId(byte[] txnId) {
            super.withTxnId(CoreMatchers.equalTo((Object)new Binary(txnId)));
            return this;
        }

        @Override
        public TransferTransactionalStateMatcher withTxnId(Binary txnId) {
            super.withTxnId(CoreMatchers.equalTo((Object)txnId));
            return this;
        }

        @Override
        public TransferTransactionalStateMatcher withOutcome(DeliveryState outcome) {
            super.withOutcome(CoreMatchers.equalTo((Object)outcome));
            return this;
        }

        @Override
        public TransferTransactionalStateMatcher withTxnId(Matcher<?> m) {
            super.withOutcome(m);
            return this;
        }

        @Override
        public TransferTransactionalStateMatcher withOutcome(Matcher<?> m) {
            super.withOutcome(m);
            return this;
        }

        public TransferTransactionalStateMatcher withAccepted() {
            super.withOutcome((Matcher<?>)new AcceptedMatcher());
            return this;
        }

        public TransferTransactionalStateMatcher withReleased() {
            super.withOutcome((Matcher<?>)new ReleasedMatcher());
            return this;
        }

        public TransferTransactionalStateMatcher withRejected() {
            super.withOutcome((Matcher<?>)new RejectedMatcher());
            return this;
        }

        public TransferTransactionalStateMatcher withRejected(String condition, String description) {
            super.withOutcome((Matcher<?>)new RejectedMatcher().withError((Matcher<?>)new ErrorConditionMatcher().withCondition(condition).withDescription(description)));
            return this;
        }

        public TransferTransactionalStateMatcher withRejected(Symbol condition, String description) {
            super.withOutcome((Matcher<?>)new RejectedMatcher().withError((Matcher<?>)new ErrorConditionMatcher().withCondition(condition).withDescription(description)));
            return this;
        }

        public TransferTransactionalStateMatcher withRejected(String condition, Matcher<?> description) {
            super.withOutcome((Matcher<?>)new RejectedMatcher().withError((Matcher<?>)new ErrorConditionMatcher().withCondition(condition).withDescription(description)));
            return this;
        }

        public TransferTransactionalStateMatcher withRejected(Symbol condition, Matcher<?> description) {
            super.withOutcome((Matcher<?>)new RejectedMatcher().withError((Matcher<?>)new ErrorConditionMatcher().withCondition(condition).withDescription(description)));
            return this;
        }

        public TransferTransactionalStateMatcher withRejected(String condition, String description, Map<String, Object> info) {
            super.withOutcome((Matcher<?>)new RejectedMatcher().withError((Matcher<?>)new ErrorConditionMatcher().withCondition(condition).withDescription(description).withInfo(info)));
            return this;
        }

        public TransferTransactionalStateMatcher withRejected(Symbol condition, String description, Map<Symbol, Object> info) {
            super.withOutcome((Matcher<?>)new RejectedMatcher().withError((Matcher<?>)new ErrorConditionMatcher().withCondition(condition).withDescription(description).withInfoMap(info)));
            return this;
        }

        public TransferTransactionalStateMatcher withRejected(String condition, String description, Matcher<?> info) {
            super.withOutcome((Matcher<?>)new RejectedMatcher().withError((Matcher<?>)new ErrorConditionMatcher().withCondition(condition).withDescription(description).withInfo(info)));
            return this;
        }

        public TransferTransactionalStateMatcher withRejected(Symbol condition, String description, Matcher<?> info) {
            super.withOutcome((Matcher<?>)new RejectedMatcher().withError((Matcher<?>)new ErrorConditionMatcher().withCondition(condition).withDescription(description).withInfo(info)));
            return this;
        }

        public TransferTransactionalStateMatcher withRejected(String condition, Matcher<?> description, Matcher<?> info) {
            super.withOutcome((Matcher<?>)new RejectedMatcher().withError((Matcher<?>)new ErrorConditionMatcher().withCondition(condition).withDescription(description).withInfo(info)));
            return this;
        }

        public TransferTransactionalStateMatcher withRejected(Symbol condition, Matcher<?> description, Matcher<?> info) {
            super.withOutcome((Matcher<?>)new RejectedMatcher().withError((Matcher<?>)new ErrorConditionMatcher().withCondition(condition).withDescription(description).withInfo(info)));
            return this;
        }

        public TransferTransactionalStateMatcher withModified() {
            super.withOutcome((Matcher<?>)new ModifiedMatcher());
            return this;
        }

        public TransferTransactionalStateMatcher withModified(boolean failed) {
            super.withOutcome((Matcher<?>)new ModifiedMatcher().withDeliveryFailed(failed));
            return this;
        }

        public TransferTransactionalStateMatcher withModified(boolean failed, boolean undeliverableHere) {
            super.withOutcome((Matcher<?>)new ModifiedMatcher().withDeliveryFailed(failed).withUndeliverableHere(undeliverableHere));
            return this;
        }

        public TransferTransactionalStateMatcher withModified(boolean failed, boolean undeliverableHere, Map<String, Object> annotations) {
            super.withOutcome((Matcher<?>)new ModifiedMatcher().withDeliveryFailed(failed).withUndeliverableHere(undeliverableHere).withMessageAnnotations(annotations));
            return this;
        }

        public TransferTransactionalStateMatcher withModified(boolean failed, boolean undeliverableHere, Matcher<?> annotations) {
            super.withOutcome((Matcher<?>)new ModifiedMatcher().withDeliveryFailed(failed).withUndeliverableHere(undeliverableHere).withMessageAnnotations(annotations));
            return this;
        }
    }
}

