/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.test.driver.matchers;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;

public class MapContentsMatcher<K, V>
extends TypeSafeMatcher<Map<K, V>> {
    private final Map<K, V> expectedContents = new LinkedHashMap();
    private MatcherMode mode;
    private String mismatchDescription;

    public MapContentsMatcher() {
        this(MatcherMode.PARTIAL_MATCH);
    }

    public MapContentsMatcher(Map<K, V> entries) {
        this(MatcherMode.CONTENTS_MATCH);
        entries.forEach((k, v) -> this.addExpectedEntry(k, v));
    }

    public MapContentsMatcher(Map<K, V> entries, boolean strictOrder) {
        this(strictOrder ? MatcherMode.EXACT_MATCH : MatcherMode.CONTENTS_MATCH);
        entries.forEach((k, v) -> this.addExpectedEntry(k, v));
    }

    public MapContentsMatcher(MatcherMode mode) {
        this.mode = mode;
    }

    public void describeTo(Description description) {
        description.appendText(this.mismatchDescription);
    }

    protected boolean matchesSafely(Map<K, V> item) {
        switch (this.mode.ordinal()) {
            case 1: {
                return this.performContentsOnlyMatch(item);
            }
            case 2: {
                return this.performInOrderContentsMatch(item);
            }
        }
        return this.performPartialMatch(item);
    }

    private boolean performMapInvariantsCheck(Map<K, V> map) {
        if (map.isEmpty() && !this.expectedContents.isEmpty()) {
            this.mismatchDescription = String.format("Expecting an empty map but got a map of size %s instead", this.expectedContents.size());
            return false;
        }
        if (!map.isEmpty() && this.expectedContents.isEmpty()) {
            this.mismatchDescription = String.format("Expecting map of size %s but got an empty map instead", this.expectedContents.size());
            return false;
        }
        if (map.size() != this.expectedContents.size()) {
            this.mismatchDescription = String.format("Expecting map with %s items but got a map of size %s instead", this.expectedContents.size(), map.size());
            return false;
        }
        return true;
    }

    private boolean performInOrderContentsMatch(Map<K, V> map) {
        if (!this.performMapInvariantsCheck(map)) {
            return false;
        }
        Iterator<Map.Entry<K, V>> mapIterator = map.entrySet().iterator();
        for (Map.Entry<K, V> entry : this.expectedContents.entrySet()) {
            Map.Entry<K, V> mapEntry = mapIterator.next();
            if (!entry.getKey().equals(mapEntry.getKey())) {
                this.mismatchDescription = String.format("Expected to find a key matching %s but got %s", entry.getKey(), mapEntry.getKey());
                return false;
            }
            if (entry.getValue() == null && mapEntry.getValue() == null || entry.getValue().equals(mapEntry.getValue())) continue;
            this.mismatchDescription = String.format("Expected to find a value matching %s for key %s but got %s", entry.getKey(), entry.getValue(), mapEntry.getKey());
            return false;
        }
        return true;
    }

    private boolean performContentsOnlyMatch(Map<K, V> map) {
        if (!this.performMapInvariantsCheck(map)) {
            return false;
        }
        for (Map.Entry<K, V> entry : this.expectedContents.entrySet()) {
            if (!map.containsKey(entry.getKey())) {
                this.mismatchDescription = String.format("Expected to find a key matching %s but it wasn't found in the Map", entry.getKey());
                return false;
            }
            if (Objects.equals(entry.getValue(), map.get(entry.getKey()))) continue;
            this.mismatchDescription = String.format("Expected to find a value matching %s for key %s but got %s", entry.getKey(), entry.getValue(), map.get(entry.getKey()));
            return false;
        }
        return true;
    }

    private boolean performPartialMatch(Map<K, V> map) {
        for (Map.Entry<K, V> entry : this.expectedContents.entrySet()) {
            if (!map.containsKey(entry.getKey())) {
                this.mismatchDescription = String.format("Expected to find a key matching %s but it wasn't found in the Map", entry.getKey());
                return false;
            }
            if (Objects.equals(entry.getValue(), map.get(entry.getKey()))) continue;
            this.mismatchDescription = String.format("Expected to find a value matching %s for key %s but got %s", entry.getKey(), entry.getValue(), map.get(entry.getKey()));
            return false;
        }
        return true;
    }

    public void addExpectedEntry(K key, V value) {
        this.expectedContents.put(key, value);
    }

    public boolean isStrictEaulityMatching() {
        return this.mode.ordinal() > MatcherMode.PARTIAL_MATCH.ordinal();
    }

    public static enum MatcherMode {
        PARTIAL_MATCH,
        CONTENTS_MATCH,
        EXACT_MATCH;

    }
}

