/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.test.driver.matchers.messaging;

import java.nio.ByteBuffer;
import java.util.Map;
import org.apache.qpid.protonj2.test.driver.codec.Codec;
import org.apache.qpid.protonj2.test.driver.codec.primitives.DescribedType;
import org.apache.qpid.protonj2.test.driver.codec.primitives.Symbol;
import org.apache.qpid.protonj2.test.driver.codec.primitives.UnsignedLong;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMessageSectionMatcher<T extends AbstractMessageSectionMatcher<T>> {
    private final Logger LOG = LoggerFactory.getLogger(this.getClass());
    private final UnsignedLong numericDescriptor;
    private final Symbol symbolicDescriptor;
    private final Map<Object, Matcher<?>> fieldMatchers;
    private Map<Object, Object> receivedFields;
    private boolean allowTrailingBytes;

    protected AbstractMessageSectionMatcher(UnsignedLong numericDescriptor, Symbol symbolicDescriptor, Map<Object, Matcher<?>> fieldMatchers, boolean expectTrailingBytes) {
        this.numericDescriptor = numericDescriptor;
        this.symbolicDescriptor = symbolicDescriptor;
        this.fieldMatchers = fieldMatchers;
        this.allowTrailingBytes = expectTrailingBytes;
    }

    public void setAllowTrailingBytes(boolean allowTrailingBytes) {
        this.allowTrailingBytes = allowTrailingBytes;
    }

    public boolean isAllowTrailngBytes() {
        return this.allowTrailingBytes;
    }

    protected Map<Object, Matcher<?>> getMatchers() {
        return this.fieldMatchers;
    }

    protected Map<Object, Object> getReceivedFields() {
        return this.receivedFields;
    }

    public int verify(ByteBuffer receivedBinary) throws RuntimeException {
        int length = receivedBinary.remaining();
        Codec data = Codec.Factory.create();
        long decoded = data.decode(receivedBinary);
        if (decoded > Integer.MAX_VALUE) {
            throw new IllegalStateException("Decoded more bytes than Binary supports holding");
        }
        if (decoded < (long)length && !this.allowTrailingBytes) {
            throw new IllegalArgumentException("Expected to consume all bytes, but trailing bytes remain: Got " + length + ", consumed " + decoded);
        }
        DescribedType decodedDescribedType = data.getDescribedType();
        this.verifyReceivedDescribedType(decodedDescribedType);
        return (int)decoded;
    }

    private void verifyReceivedDescribedType(DescribedType decodedDescribedType) {
        Object descriptor = decodedDescribedType.getDescriptor();
        if (!this.symbolicDescriptor.equals(descriptor) && !this.numericDescriptor.equals(descriptor)) {
            throw new IllegalArgumentException("Unexpected section type descriptor. Expected " + String.valueOf(this.symbolicDescriptor) + " or " + String.valueOf(this.numericDescriptor) + ", but got: " + String.valueOf(descriptor));
        }
        this.verifyReceivedDescribedObject(decodedDescribedType.getDescribed());
    }

    protected abstract void verifyReceivedDescribedObject(Object var1);

    protected void verifyReceivedFields(Map<Object, Object> valueMap) {
        this.receivedFields = valueMap;
        this.LOG.debug("About to check the fields of the section.\n  Received:" + String.valueOf(valueMap) + "\n  Expectations: " + String.valueOf(this.fieldMatchers));
        for (Map.Entry<Object, Matcher<?>> entry : this.fieldMatchers.entrySet()) {
            Matcher<?> matcher = entry.getValue();
            Object field = entry.getKey();
            MatcherAssert.assertThat((String)("Field " + String.valueOf(field) + " value should match"), (Object)valueMap.get(field), matcher);
        }
    }

    protected Enum<?> getField(int fieldIndex) {
        throw new UnsupportedOperationException("getFieldName is expected to be overridden by subclass if it is required");
    }
}

