/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.test.driver.matchers.transport;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.qpid.protonj2.test.driver.codec.primitives.Binary;
import org.apache.qpid.protonj2.test.driver.codec.primitives.Symbol;
import org.apache.qpid.protonj2.test.driver.codec.primitives.UnsignedByte;
import org.apache.qpid.protonj2.test.driver.codec.primitives.UnsignedInteger;
import org.apache.qpid.protonj2.test.driver.expectations.TransferExpectation;
import org.apache.qpid.protonj2.test.driver.matchers.types.EncodedAmqpSequenceMatcher;
import org.apache.qpid.protonj2.test.driver.matchers.types.EncodedAmqpValueMatcher;
import org.apache.qpid.protonj2.test.driver.matchers.types.EncodedAnyBodySectionMatcher;
import org.apache.qpid.protonj2.test.driver.matchers.types.EncodedBodySectionMatcher;
import org.apache.qpid.protonj2.test.driver.matchers.types.EncodedDataMatcher;
import org.apache.qpid.protonj2.test.driver.util.StringUtils;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.StringDescription;
import org.hamcrest.TypeSafeMatcher;

public class TransferMessageMatcher
extends TypeSafeMatcher<ByteBuffer> {
    private final TransferExpectation expectation;
    private HeaderMatcher headersMatcher;
    private DeliveryAnnotationsMatcher deliveryAnnotationsMatcher;
    private MessageAnnotationsMatcher messageAnnotationsMatcher;
    private PropertiesMatcher propertiesMatcher;
    private ApplicationPropertiesMatcher applicationPropertiesMatcher;
    private List<EncodedBodySectionMatcher> bodySectionMatchers = new ArrayList<EncodedBodySectionMatcher>();
    private FooterMatcher footersMatcher;
    private String headerMatcherFailureDescription;
    private String deliveryAnnotationsMatcherFailureDescription;
    private String messageAnnotationsMatcherFailureDescription;
    private String propertiesMatcherFailureDescription;
    private String applicationPropertiesMatcherFailureDescription;
    private String msgContentMatcherFailureDescription;
    private String footerMatcherFailureDescription;

    public TransferMessageMatcher(TransferExpectation expectation) {
        this.expectation = expectation;
    }

    public TransferExpectation also() {
        return this.expectation;
    }

    public TransferExpectation and() {
        return this.expectation;
    }

    protected boolean matchesSafely(ByteBuffer receivedBinary) {
        ByteBuffer receivedSlice = receivedBinary.slice().asReadOnlyBuffer();
        int bytesConsumed = 0;
        if (this.headersMatcher != null) {
            try {
                receivedSlice.position(bytesConsumed += this.headersMatcher.getInnerMatcher().verify(receivedSlice.slice()));
            }
            catch (Throwable t) {
                this.headerMatcherFailureDescription = "\nBuffer of bytes passed to Header Matcher: " + String.valueOf(receivedSlice);
                this.headerMatcherFailureDescription = this.headerMatcherFailureDescription + "\nActual encoded form of remaining bytes passed: " + StringUtils.toQuotedString(receivedSlice);
                this.headerMatcherFailureDescription = this.headerMatcherFailureDescription + "\nHeader Matcher generated throwable: " + t.getMessage();
                return false;
            }
        }
        if (this.deliveryAnnotationsMatcher != null) {
            try {
                receivedSlice.position(bytesConsumed += this.deliveryAnnotationsMatcher.getInnerMatcher().verify(receivedSlice.slice()));
            }
            catch (Throwable t) {
                this.deliveryAnnotationsMatcherFailureDescription = "\nBuffer of bytes passed to Delivery Annotations Matcher: " + String.valueOf(receivedSlice);
                this.deliveryAnnotationsMatcherFailureDescription = this.deliveryAnnotationsMatcherFailureDescription + "\nActual encoded form of remaining bytes passed: " + StringUtils.toQuotedString(receivedSlice);
                this.deliveryAnnotationsMatcherFailureDescription = this.deliveryAnnotationsMatcherFailureDescription + "\nDelivery Annotations Matcher generated throwable: " + t.getMessage();
                return false;
            }
        }
        if (this.messageAnnotationsMatcher != null) {
            try {
                receivedSlice.position(bytesConsumed += this.messageAnnotationsMatcher.getInnerMatcher().verify(receivedSlice.slice()));
            }
            catch (Throwable t) {
                this.messageAnnotationsMatcherFailureDescription = "\nBuffer of bytes passed to Message Annotations Matcher: " + String.valueOf(receivedSlice);
                this.messageAnnotationsMatcherFailureDescription = this.messageAnnotationsMatcherFailureDescription + "\nActual encoded form of remaining bytes passed: " + StringUtils.toQuotedString(receivedSlice);
                this.messageAnnotationsMatcherFailureDescription = this.messageAnnotationsMatcherFailureDescription + "\nMessage Annotations Matcher generated throwable: " + t.getMessage();
                return false;
            }
        }
        if (this.propertiesMatcher != null) {
            try {
                receivedSlice.position(bytesConsumed += this.propertiesMatcher.getInnerMatcher().verify(receivedSlice.slice()));
            }
            catch (Throwable t) {
                this.propertiesMatcherFailureDescription = "\nBuffer of bytes passed to Properties Matcher: " + String.valueOf(receivedSlice);
                this.propertiesMatcherFailureDescription = this.propertiesMatcherFailureDescription + "\nActual encoded form of remaining bytes passed: " + StringUtils.toQuotedString(receivedSlice);
                this.propertiesMatcherFailureDescription = this.propertiesMatcherFailureDescription + "\nProperties Matcher generated throwable: " + t.getMessage();
                return false;
            }
        }
        if (this.applicationPropertiesMatcher != null) {
            try {
                receivedSlice.position(bytesConsumed += this.applicationPropertiesMatcher.getInnerMatcher().verify(receivedSlice.slice()));
            }
            catch (Throwable t) {
                this.applicationPropertiesMatcherFailureDescription = "\nBuffer of bytes passed to Application Properties Matcher: " + String.valueOf(receivedSlice);
                this.applicationPropertiesMatcherFailureDescription = this.applicationPropertiesMatcherFailureDescription + "\nActual encoded form of remaining bytes passed: " + StringUtils.toQuotedString(receivedSlice);
                this.applicationPropertiesMatcherFailureDescription = this.applicationPropertiesMatcherFailureDescription + "\nApplication Properties Matcher generated throwable: " + t.getMessage();
                return false;
            }
        }
        if (!this.bodySectionMatchers.isEmpty()) {
            ByteBuffer slicedMsgContext = receivedSlice.slice();
            for (Matcher matcher : this.bodySectionMatchers) {
                int originalReadableBytes = slicedMsgContext.remaining();
                boolean contentMatches = matcher.matches((Object)slicedMsgContext);
                if (!contentMatches) {
                    StringDescription desc = new StringDescription();
                    matcher.describeTo((Description)desc);
                    matcher.describeMismatch((Object)slicedMsgContext, (Description)desc);
                    this.msgContentMatcherFailureDescription = "\nBuffer of bytes passed to message contents Matcher: " + String.valueOf(slicedMsgContext);
                    this.msgContentMatcherFailureDescription = this.msgContentMatcherFailureDescription + "\nActual encoded form of remaining bytes passed: " + StringUtils.toQuotedString(receivedSlice);
                    this.msgContentMatcherFailureDescription = this.msgContentMatcherFailureDescription + "\nMessageContentMatcher mismatch Description:";
                    this.msgContentMatcherFailureDescription = this.msgContentMatcherFailureDescription + desc.toString();
                    return false;
                }
                receivedSlice.position(bytesConsumed += originalReadableBytes - slicedMsgContext.remaining());
            }
        }
        if (this.footersMatcher != null) {
            try {
                bytesConsumed += this.footersMatcher.getInnerMatcher().verify(receivedSlice.slice());
            }
            catch (Throwable t) {
                this.footerMatcherFailureDescription = "\nActual encoded form of remaining bytes passed to FooterMatcher: " + String.valueOf(receivedSlice);
                this.footerMatcherFailureDescription = this.footerMatcherFailureDescription + "\nFooterMatcher generated throwable: " + t.getMessage();
                return false;
            }
        }
        return true;
    }

    public TransferMessageMatcher withMessageFormat(int format) {
        this.expectation.withMessageFormat(format);
        return this;
    }

    public HeaderMatcher withHeader() {
        if (this.headersMatcher == null) {
            this.headersMatcher = new HeaderMatcher(this);
        }
        if (this.deliveryAnnotationsMatcher != null || this.messageAnnotationsMatcher != null || this.propertiesMatcher != null || this.applicationPropertiesMatcher != null || !this.bodySectionMatchers.isEmpty() || this.footersMatcher != null) {
            this.headersMatcher.getInnerMatcher().setAllowTrailingBytes(true);
        } else {
            this.headersMatcher.getInnerMatcher().setAllowTrailingBytes(false);
        }
        return this.headersMatcher;
    }

    public DeliveryAnnotationsMatcher withDeliveryAnnotations() {
        if (this.deliveryAnnotationsMatcher == null) {
            this.deliveryAnnotationsMatcher = new DeliveryAnnotationsMatcher(this);
        }
        if (this.headersMatcher != null) {
            this.headersMatcher.getInnerMatcher().setAllowTrailingBytes(true);
        }
        if (this.messageAnnotationsMatcher != null || this.propertiesMatcher != null || this.applicationPropertiesMatcher != null || !this.bodySectionMatchers.isEmpty() || this.footersMatcher != null) {
            this.deliveryAnnotationsMatcher.getInnerMatcher().setAllowTrailingBytes(true);
        } else {
            this.deliveryAnnotationsMatcher.getInnerMatcher().setAllowTrailingBytes(false);
        }
        return this.deliveryAnnotationsMatcher;
    }

    public MessageAnnotationsMatcher withMessageAnnotations() {
        if (this.messageAnnotationsMatcher == null) {
            this.messageAnnotationsMatcher = new MessageAnnotationsMatcher(this);
        }
        if (this.headersMatcher != null) {
            this.headersMatcher.getInnerMatcher().setAllowTrailingBytes(true);
        }
        if (this.deliveryAnnotationsMatcher != null) {
            this.deliveryAnnotationsMatcher.getInnerMatcher().setAllowTrailingBytes(true);
        }
        if (this.propertiesMatcher != null || this.applicationPropertiesMatcher != null || !this.bodySectionMatchers.isEmpty() || this.footersMatcher != null) {
            this.messageAnnotationsMatcher.getInnerMatcher().setAllowTrailingBytes(true);
        } else {
            this.messageAnnotationsMatcher.getInnerMatcher().setAllowTrailingBytes(false);
        }
        return this.messageAnnotationsMatcher;
    }

    public PropertiesMatcher withProperties() {
        if (this.propertiesMatcher == null) {
            this.propertiesMatcher = new PropertiesMatcher(this);
        }
        if (this.headersMatcher != null) {
            this.headersMatcher.getInnerMatcher().setAllowTrailingBytes(true);
        }
        if (this.deliveryAnnotationsMatcher != null) {
            this.deliveryAnnotationsMatcher.getInnerMatcher().setAllowTrailingBytes(true);
        }
        if (this.messageAnnotationsMatcher != null) {
            this.messageAnnotationsMatcher.getInnerMatcher().setAllowTrailingBytes(true);
        }
        if (this.applicationPropertiesMatcher != null || !this.bodySectionMatchers.isEmpty() || this.footersMatcher != null) {
            this.propertiesMatcher.getInnerMatcher().setAllowTrailingBytes(true);
        } else {
            this.propertiesMatcher.getInnerMatcher().setAllowTrailingBytes(false);
        }
        return this.propertiesMatcher;
    }

    public ApplicationPropertiesMatcher withApplicationProperties() {
        if (this.applicationPropertiesMatcher == null) {
            this.applicationPropertiesMatcher = new ApplicationPropertiesMatcher(this);
        }
        if (this.headersMatcher != null) {
            this.headersMatcher.getInnerMatcher().setAllowTrailingBytes(true);
        }
        if (this.deliveryAnnotationsMatcher != null) {
            this.deliveryAnnotationsMatcher.getInnerMatcher().setAllowTrailingBytes(true);
        }
        if (this.messageAnnotationsMatcher != null) {
            this.messageAnnotationsMatcher.getInnerMatcher().setAllowTrailingBytes(true);
        }
        if (this.propertiesMatcher != null) {
            this.propertiesMatcher.getInnerMatcher().setAllowTrailingBytes(true);
        }
        if (!this.bodySectionMatchers.isEmpty() || this.footersMatcher != null) {
            this.applicationPropertiesMatcher.getInnerMatcher().setAllowTrailingBytes(true);
        } else {
            this.applicationPropertiesMatcher.getInnerMatcher().setAllowTrailingBytes(false);
        }
        return this.applicationPropertiesMatcher;
    }

    public TransferMessageMatcher withSequence(List<?> sequence) {
        return this.withBodySection(new EncodedAmqpSequenceMatcher(sequence, this.footersMatcher != null));
    }

    public TransferMessageMatcher withSequence(Matcher<?> sequenceMatcher) {
        return this.withBodySection(new EncodedAmqpSequenceMatcher(sequenceMatcher, this.footersMatcher != null));
    }

    public TransferMessageMatcher withData(byte[] payload) {
        return this.withBodySection(new EncodedDataMatcher(payload, this.footersMatcher != null));
    }

    public TransferMessageMatcher withData(Matcher<?> payloadMatcher) {
        return this.withBodySection(new EncodedDataMatcher(payloadMatcher, this.footersMatcher != null));
    }

    public TransferMessageMatcher withValue(Object value) {
        return this.withBodySection(new EncodedAmqpValueMatcher(value, this.footersMatcher != null));
    }

    public TransferMessageMatcher withValue(Matcher<?> valueMatcher) {
        return this.withBodySection(new EncodedAmqpValueMatcher(valueMatcher, this.footersMatcher != null));
    }

    public TransferMessageMatcher withValidBodySection() {
        return this.withBodySection(new EncodedAnyBodySectionMatcher(this.footersMatcher != null));
    }

    protected TransferMessageMatcher withBodySection(EncodedBodySectionMatcher matcher) {
        Objects.requireNonNull(matcher, "Body section matcher cannot be null");
        if (this.headersMatcher != null) {
            this.headersMatcher.getInnerMatcher().setAllowTrailingBytes(true);
        }
        if (this.deliveryAnnotationsMatcher != null) {
            this.deliveryAnnotationsMatcher.getInnerMatcher().setAllowTrailingBytes(true);
        }
        if (this.messageAnnotationsMatcher != null) {
            this.messageAnnotationsMatcher.getInnerMatcher().setAllowTrailingBytes(true);
        }
        if (this.propertiesMatcher != null) {
            this.propertiesMatcher.getInnerMatcher().setAllowTrailingBytes(true);
        }
        if (this.applicationPropertiesMatcher != null) {
            this.applicationPropertiesMatcher.getInnerMatcher().setAllowTrailingBytes(true);
        }
        if (!this.bodySectionMatchers.isEmpty()) {
            this.bodySectionMatchers.get(this.bodySectionMatchers.size() - 1).setAllowTrailingBytes(true);
        }
        this.bodySectionMatchers.add(matcher);
        return this;
    }

    public FooterMatcher withFooters() {
        if (this.footersMatcher == null) {
            this.footersMatcher = new FooterMatcher(this);
        }
        if (this.headersMatcher != null) {
            this.headersMatcher.getInnerMatcher().setAllowTrailingBytes(true);
        }
        if (this.deliveryAnnotationsMatcher != null) {
            this.deliveryAnnotationsMatcher.getInnerMatcher().setAllowTrailingBytes(true);
        }
        if (this.messageAnnotationsMatcher != null) {
            this.messageAnnotationsMatcher.getInnerMatcher().setAllowTrailingBytes(true);
        }
        if (this.propertiesMatcher != null) {
            this.propertiesMatcher.getInnerMatcher().setAllowTrailingBytes(true);
        }
        if (this.applicationPropertiesMatcher != null) {
            this.applicationPropertiesMatcher.getInnerMatcher().setAllowTrailingBytes(true);
        }
        if (!this.bodySectionMatchers.isEmpty()) {
            this.bodySectionMatchers.get(this.bodySectionMatchers.size() - 1).setAllowTrailingBytes(true);
        }
        return this.footersMatcher;
    }

    public void describeTo(Description description) {
        description.appendText("a Binary encoding of a Transfer frames payload, containing an AMQP message");
    }

    protected void describeMismatchSafely(ByteBuffer item, Description mismatchDescription) {
        mismatchDescription.appendText("\nActual encoded form of the full Transfer frame payload: ").appendValue((Object)item);
        if (this.headerMatcherFailureDescription != null) {
            mismatchDescription.appendText("\nMessageHeadersMatcherFailed!");
            mismatchDescription.appendText(this.headerMatcherFailureDescription);
            return;
        }
        if (this.deliveryAnnotationsMatcherFailureDescription != null) {
            mismatchDescription.appendText("\nDeliveryAnnotationsMatcherFailed!");
            mismatchDescription.appendText(this.deliveryAnnotationsMatcherFailureDescription);
            return;
        }
        if (this.messageAnnotationsMatcherFailureDescription != null) {
            mismatchDescription.appendText("\nMessageAnnotationsMatcherFailed!");
            mismatchDescription.appendText(this.messageAnnotationsMatcherFailureDescription);
            return;
        }
        if (this.propertiesMatcherFailureDescription != null) {
            mismatchDescription.appendText("\nPropertiesMatcherFailed!");
            mismatchDescription.appendText(this.propertiesMatcherFailureDescription);
            return;
        }
        if (this.applicationPropertiesMatcherFailureDescription != null) {
            mismatchDescription.appendText("\nApplicationPropertiesMatcherFailed!");
            mismatchDescription.appendText(this.applicationPropertiesMatcherFailureDescription);
            return;
        }
        if (this.msgContentMatcherFailureDescription != null) {
            mismatchDescription.appendText("\nContentMatcherFailed!");
            mismatchDescription.appendText(this.msgContentMatcherFailureDescription);
            return;
        }
        if (this.footerMatcherFailureDescription != null) {
            mismatchDescription.appendText("\nContentMatcherFailed!");
            mismatchDescription.appendText(this.footerMatcherFailureDescription);
        }
    }

    public static final class HeaderMatcher {
        private final org.apache.qpid.protonj2.test.driver.matchers.messaging.HeaderMatcher matcher = new org.apache.qpid.protonj2.test.driver.matchers.messaging.HeaderMatcher(false);
        private final TransferMessageMatcher transferMatcher;

        public HeaderMatcher(TransferMessageMatcher transferMatcher) {
            this.transferMatcher = transferMatcher;
        }

        public TransferMessageMatcher also() {
            return this.transferMatcher;
        }

        public TransferMessageMatcher and() {
            return this.transferMatcher;
        }

        public HeaderMatcher withDurability(boolean durable) {
            this.matcher.withDurable(CoreMatchers.equalTo((Object)durable));
            return this;
        }

        public HeaderMatcher withDurability(Boolean durable) {
            this.matcher.withDurable(CoreMatchers.equalTo((Object)durable));
            return this;
        }

        public HeaderMatcher withPriority(byte priority) {
            this.matcher.withPriority(CoreMatchers.equalTo((Object)UnsignedByte.valueOf(priority)));
            return this;
        }

        public HeaderMatcher withPriority(UnsignedByte priority) {
            this.matcher.withPriority(CoreMatchers.equalTo((Object)priority));
            return this;
        }

        public HeaderMatcher withTimeToLive(int timeToLive) {
            this.matcher.withTtl(CoreMatchers.equalTo((Object)UnsignedInteger.valueOf(timeToLive)));
            return this;
        }

        public HeaderMatcher withTimeToLive(long timeToLive) {
            this.matcher.withTtl(CoreMatchers.equalTo((Object)UnsignedInteger.valueOf(timeToLive)));
            return this;
        }

        public HeaderMatcher withTimeToLive(UnsignedInteger timeToLive) {
            this.matcher.withTtl(CoreMatchers.equalTo((Object)timeToLive));
            return this;
        }

        public HeaderMatcher withFirstAcquirer(boolean durable) {
            this.matcher.withFirstAcquirer(CoreMatchers.equalTo((Object)durable));
            return this;
        }

        public HeaderMatcher withFirstAcquirer(Boolean durable) {
            this.matcher.withFirstAcquirer(CoreMatchers.equalTo((Object)durable));
            return this;
        }

        public HeaderMatcher withDeliveryCount(int deliveryCount) {
            this.matcher.withDeliveryCount(CoreMatchers.equalTo((Object)UnsignedInteger.valueOf(deliveryCount)));
            return this;
        }

        public HeaderMatcher withDeliveryCount(long deliveryCount) {
            this.matcher.withDeliveryCount(CoreMatchers.equalTo((Object)UnsignedInteger.valueOf(deliveryCount)));
            return this;
        }

        public HeaderMatcher withDeliveryCount(UnsignedInteger deliveryCount) {
            this.matcher.withDeliveryCount(CoreMatchers.equalTo((Object)deliveryCount));
            return this;
        }

        org.apache.qpid.protonj2.test.driver.matchers.messaging.HeaderMatcher getInnerMatcher() {
            return this.matcher;
        }
    }

    public static final class DeliveryAnnotationsMatcher {
        private final org.apache.qpid.protonj2.test.driver.matchers.messaging.DeliveryAnnotationsMatcher matcher = new org.apache.qpid.protonj2.test.driver.matchers.messaging.DeliveryAnnotationsMatcher(false);
        private final TransferMessageMatcher transferMatcher;

        public DeliveryAnnotationsMatcher(TransferMessageMatcher transferMatcher) {
            this.transferMatcher = transferMatcher;
        }

        public TransferMessageMatcher also() {
            return this.transferMatcher;
        }

        public TransferMessageMatcher and() {
            return this.transferMatcher;
        }

        public DeliveryAnnotationsMatcher withAnnotation(String key, Object value) {
            this.matcher.withEntry(Symbol.valueOf(key), value);
            return this;
        }

        public DeliveryAnnotationsMatcher withAnnotation(Symbol key, Object value) {
            this.matcher.withEntry(key, value);
            return this;
        }

        org.apache.qpid.protonj2.test.driver.matchers.messaging.DeliveryAnnotationsMatcher getInnerMatcher() {
            return this.matcher;
        }
    }

    public static final class MessageAnnotationsMatcher {
        private final org.apache.qpid.protonj2.test.driver.matchers.messaging.MessageAnnotationsMatcher matcher = new org.apache.qpid.protonj2.test.driver.matchers.messaging.MessageAnnotationsMatcher(false);
        private final TransferMessageMatcher transferMatcher;

        public MessageAnnotationsMatcher(TransferMessageMatcher transferMatcher) {
            this.transferMatcher = transferMatcher;
        }

        public TransferMessageMatcher also() {
            return this.transferMatcher;
        }

        public TransferMessageMatcher and() {
            return this.transferMatcher;
        }

        public MessageAnnotationsMatcher withAnnotation(String key, Object value) {
            this.matcher.withEntry(Symbol.valueOf(key), value);
            return this;
        }

        public MessageAnnotationsMatcher withAnnotation(Symbol key, Object value) {
            this.matcher.withEntry(key, value);
            return this;
        }

        org.apache.qpid.protonj2.test.driver.matchers.messaging.MessageAnnotationsMatcher getInnerMatcher() {
            return this.matcher;
        }
    }

    public static final class PropertiesMatcher {
        private final org.apache.qpid.protonj2.test.driver.matchers.messaging.PropertiesMatcher matcher = new org.apache.qpid.protonj2.test.driver.matchers.messaging.PropertiesMatcher(false);
        private final TransferMessageMatcher transferMatcher;

        public PropertiesMatcher(TransferMessageMatcher transferMatcher) {
            this.transferMatcher = transferMatcher;
        }

        public TransferMessageMatcher also() {
            return this.transferMatcher;
        }

        public TransferMessageMatcher and() {
            return this.transferMatcher;
        }

        public PropertiesMatcher withMessageId(Object messageId) {
            this.matcher.withMessageId(messageId);
            return this;
        }

        public PropertiesMatcher withUserId(byte[] userId) {
            this.matcher.withUserId(userId);
            return this;
        }

        public PropertiesMatcher withUserId(Binary userId) {
            this.matcher.withUserId(userId);
            return this;
        }

        public PropertiesMatcher withTo(String to) {
            this.matcher.withTo(to);
            return this;
        }

        public PropertiesMatcher withSubject(String subject) {
            this.matcher.withSubject(subject);
            return this;
        }

        public PropertiesMatcher withReplyTo(String replyTo) {
            this.matcher.withReplyTo(replyTo);
            return this;
        }

        public PropertiesMatcher withCorrelationId(Object correlationId) {
            this.matcher.withCorrelationId(correlationId);
            return this;
        }

        public PropertiesMatcher withContentType(String contentType) {
            this.matcher.withContentType(contentType);
            return this;
        }

        public PropertiesMatcher withContentType(Symbol contentType) {
            this.matcher.withContentType(contentType);
            return this;
        }

        public PropertiesMatcher withContentEncoding(String contentEncoding) {
            this.matcher.withContentEncoding(contentEncoding);
            return this;
        }

        public PropertiesMatcher withContentEncoding(Symbol contentEncoding) {
            this.matcher.withContentEncoding(contentEncoding);
            return this;
        }

        public PropertiesMatcher withAbsoluteExpiryTime(int absoluteExpiryTime) {
            this.matcher.withAbsoluteExpiryTime(absoluteExpiryTime);
            return this;
        }

        public PropertiesMatcher withAbsoluteExpiryTime(long absoluteExpiryTime) {
            this.matcher.withAbsoluteExpiryTime(absoluteExpiryTime);
            return this;
        }

        public PropertiesMatcher withAbsoluteExpiryTime(Long absoluteExpiryTime) {
            this.matcher.withAbsoluteExpiryTime(absoluteExpiryTime);
            return this;
        }

        public PropertiesMatcher withCreationTime(int creationTime) {
            this.matcher.withCreationTime(creationTime);
            return this;
        }

        public PropertiesMatcher withCreationTime(long creationTime) {
            this.matcher.withCreationTime(creationTime);
            return this;
        }

        public PropertiesMatcher withCreationTime(Long creationTime) {
            this.matcher.withCreationTime(creationTime);
            return this;
        }

        public PropertiesMatcher withGroupId(String groupId) {
            this.matcher.withGroupId(groupId);
            return this;
        }

        public PropertiesMatcher withGroupSequence(int groupSequence) {
            this.matcher.withGroupSequence(groupSequence);
            return this;
        }

        public PropertiesMatcher withGroupSequence(long groupSequence) {
            this.matcher.withGroupSequence(groupSequence);
            return this;
        }

        public PropertiesMatcher withGroupSequence(Long groupSequence) {
            this.matcher.withGroupSequence(groupSequence);
            return this;
        }

        public PropertiesMatcher withReplyToGroupId(String replyToGroupId) {
            this.matcher.withReplyToGroupId(replyToGroupId);
            return this;
        }

        org.apache.qpid.protonj2.test.driver.matchers.messaging.PropertiesMatcher getInnerMatcher() {
            return this.matcher;
        }
    }

    public static final class ApplicationPropertiesMatcher {
        private final org.apache.qpid.protonj2.test.driver.matchers.messaging.ApplicationPropertiesMatcher matcher = new org.apache.qpid.protonj2.test.driver.matchers.messaging.ApplicationPropertiesMatcher(false);
        private final TransferMessageMatcher transferMatcher;

        public ApplicationPropertiesMatcher(TransferMessageMatcher transferMatcher) {
            this.transferMatcher = transferMatcher;
        }

        public TransferMessageMatcher also() {
            return this.transferMatcher;
        }

        public TransferMessageMatcher and() {
            return this.transferMatcher;
        }

        public ApplicationPropertiesMatcher withProperty(String key, Object value) {
            this.matcher.withEntry(key, value);
            return this;
        }

        org.apache.qpid.protonj2.test.driver.matchers.messaging.ApplicationPropertiesMatcher getInnerMatcher() {
            return this.matcher;
        }
    }

    public static final class FooterMatcher {
        private final org.apache.qpid.protonj2.test.driver.matchers.messaging.FooterMatcher matcher = new org.apache.qpid.protonj2.test.driver.matchers.messaging.FooterMatcher(false);
        private final TransferMessageMatcher transferMatcher;

        public FooterMatcher(TransferMessageMatcher transferMatcher) {
            this.transferMatcher = transferMatcher;
        }

        public TransferMessageMatcher also() {
            return this.transferMatcher;
        }

        public TransferMessageMatcher and() {
            return this.transferMatcher;
        }

        public FooterMatcher withFooter(String key, Object value) {
            this.matcher.withEntry(Symbol.valueOf(key), value);
            return this;
        }

        public FooterMatcher withFooter(Symbol key, Object value) {
            this.matcher.withEntry(key, value);
            return this;
        }

        org.apache.qpid.protonj2.test.driver.matchers.messaging.FooterMatcher getInnerMatcher() {
            return this.matcher;
        }
    }
}

