/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.test.driver;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.qpid.protonj2.test.driver.AMQPTestDriver;
import org.apache.qpid.protonj2.test.driver.ProtonTestClientOptions;
import org.apache.qpid.protonj2.test.driver.ProtonTestPeer;
import org.apache.qpid.protonj2.test.driver.codec.primitives.DescribedType;
import org.apache.qpid.protonj2.test.driver.codec.transport.AMQPHeader;
import org.apache.qpid.protonj2.test.driver.netty.NettyClient;
import org.apache.qpid.protonj2.test.driver.netty.NettyEventLoop;
import org.apache.qpid.protonj2.test.driver.netty.NettyIOBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProtonTestClient
extends ProtonTestPeer
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(ProtonTestClient.class);
    private final AMQPTestDriver driver = new NettyAwareAMQPTestDriver(this::processDriverOutput, this::processDriverAssertion, this::eventLoop);
    private final NettyClient client;

    public ProtonTestClient() {
        this(new ProtonTestClientOptions());
    }

    @Override
    public String getPeerName() {
        return "Client";
    }

    public ProtonTestClient(ProtonTestClientOptions options) {
        this.client = NettyIOBuilder.createClient(options, this::processConnectionEstablished, this::processChannelInput);
    }

    public void connect(String hostname, int port) throws IOException {
        this.client.connect(hostname, port);
    }

    @Override
    public AMQPTestDriver getDriver() {
        return this.driver;
    }

    public boolean isWSCompressionActive() {
        return this.client.isWSCompressionActive();
    }

    @Override
    protected void processConnectionEstablished() {
        LOG.trace("AMQP Client connected to remote.");
        this.driver.handleConnectedEstablished();
    }

    @Override
    protected void processConnectionDropped() {
        LOG.trace("AMQP Client connection to remote dropped.");
        this.driver.handleConnectedDropped();
    }

    @Override
    protected void processCloseConnectionRequest() {
        try {
            this.client.close();
        }
        catch (Throwable e) {
            LOG.info("Error suppressed on client stop: ", e);
        }
    }

    @Override
    protected void processPeerShutdownRequest() {
        this.processCloseConnectionRequest();
    }

    @Override
    protected void processDriverOutput(ByteBuffer frame) {
        LOG.trace("AMQP Client Channel writing: {}", (Object)frame);
        this.client.write(frame);
    }

    protected void processChannelInput(ByteBuffer input) {
        LOG.trace("AMQP Test Client Channel processing: {}", (Object)input);
        this.driver.accept(input);
    }

    protected void processDriverAssertion(AssertionError error) {
        LOG.trace("AMQP Test Client Closing due to error: {}", (Object)((Throwable)((Object)error)).getMessage());
        this.close();
    }

    protected NettyEventLoop eventLoop() {
        return this.client.eventLoop();
    }

    private final class NettyAwareAMQPTestDriver
    extends AMQPTestDriver {
        public NettyAwareAMQPTestDriver(Consumer<ByteBuffer> frameConsumer, Consumer<AssertionError> assertionConsumer, Supplier<NettyEventLoop> scheduler) {
            super(ProtonTestClient.this.getPeerName(), frameConsumer, assertionConsumer, scheduler);
        }

        @Override
        public void deferAMQPFrame(int channel, DescribedType performative, ByteBuffer payload, boolean splitWrite) {
            NettyEventLoop loop = ProtonTestClient.this.client.eventLoop();
            if (loop.inEventLoop()) {
                super.deferAMQPFrame(channel, performative, payload, splitWrite);
            } else {
                loop.execute(() -> super.deferAMQPFrame(channel, performative, payload, splitWrite));
            }
        }

        @Override
        public void deferSaslFrame(int channel, DescribedType performative) {
            NettyEventLoop loop = ProtonTestClient.this.client.eventLoop();
            if (loop.inEventLoop()) {
                super.deferSaslFrame(channel, performative);
            } else {
                loop.execute(() -> super.deferSaslFrame(channel, performative));
            }
        }

        @Override
        public void deferHeader(AMQPHeader header) {
            NettyEventLoop loop = ProtonTestClient.this.client.eventLoop();
            if (loop.inEventLoop()) {
                super.deferHeader(header);
            } else {
                loop.execute(() -> super.deferHeader(header));
            }
        }

        @Override
        public void sendAMQPFrame(int channel, DescribedType performative, ByteBuffer payload, boolean splitWrite) {
            NettyEventLoop loop = ProtonTestClient.this.client.eventLoop();
            if (loop.inEventLoop()) {
                super.sendAMQPFrame(channel, performative, payload, splitWrite);
            } else {
                loop.execute(() -> super.sendAMQPFrame(channel, performative, payload, splitWrite));
            }
        }

        @Override
        public void sendSaslFrame(int channel, DescribedType performative) {
            NettyEventLoop loop = ProtonTestClient.this.client.eventLoop();
            if (loop.inEventLoop()) {
                super.sendSaslFrame(channel, performative);
            } else {
                loop.execute(() -> super.sendSaslFrame(channel, performative));
            }
        }

        @Override
        public void sendHeader(AMQPHeader header) {
            NettyEventLoop loop = ProtonTestClient.this.client.eventLoop();
            if (loop.inEventLoop()) {
                super.sendHeader(header);
            } else {
                loop.execute(() -> super.sendHeader(header));
            }
        }

        @Override
        public void sendEmptyFrame(int channel) {
            NettyEventLoop loop = ProtonTestClient.this.client.eventLoop();
            if (loop.inEventLoop()) {
                super.sendEmptyFrame(channel);
            } else {
                loop.execute(() -> super.sendEmptyFrame(channel));
            }
        }
    }
}

