/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.test.driver.actions;

import org.apache.qpid.protonj2.test.driver.AMQPTestDriver;
import org.apache.qpid.protonj2.test.driver.LinkTracker;
import org.apache.qpid.protonj2.test.driver.actions.AttachInjectAction;
import org.apache.qpid.protonj2.test.driver.actions.DetachInjectAction;
import org.apache.qpid.protonj2.test.driver.codec.transport.Role;

public class DetachLastCoordinatorInjectAction
extends DetachInjectAction {
    public DetachLastCoordinatorInjectAction(AMQPTestDriver driver) {
        super(driver);
    }

    @Override
    protected void beforeActionPerformed(AMQPTestDriver driver) {
        LinkTracker tracker = driver.sessions().getLastOpenedCoordinator();
        if (tracker == null) {
            throw new AssertionError((Object)"Cannot send coordinator detach as scripted, no active coordinator found.");
        }
        this.onChannel(tracker.getSession().getLocalChannel().intValue());
        if (!tracker.isLocallyAttached()) {
            AttachInjectAction attach = new AttachInjectAction(driver);
            attach.onChannel(this.onChannel());
            attach.withName(tracker.getName());
            attach.withSource(tracker.getRemoteSource());
            if (tracker.getRemoteTarget() != null) {
                attach.withTarget(tracker.getRemoteTarget());
            } else {
                attach.withTarget(tracker.getRemoteCoordinator());
            }
            if (tracker.isSender()) {
                attach.withRole(Role.SENDER);
                if (this.getPerformative().getError() != null) {
                    attach.withNullSource();
                }
            } else {
                attach.withRole(Role.RECEIVER);
                if (this.getPerformative().getError() != null && this.getPerformative().getError() != null) {
                    attach.withNullTarget();
                }
            }
            attach.perform(driver);
        }
        this.getPerformative().setHandle(tracker.getHandle());
    }
}

