/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.test.driver.actions;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.qpid.protonj2.test.driver.AMQPTestDriver;
import org.apache.qpid.protonj2.test.driver.actions.AbstractPerformativeInjectAction;
import org.apache.qpid.protonj2.test.driver.codec.primitives.Symbol;
import org.apache.qpid.protonj2.test.driver.codec.primitives.UnsignedInteger;
import org.apache.qpid.protonj2.test.driver.codec.primitives.UnsignedShort;
import org.apache.qpid.protonj2.test.driver.codec.transport.Open;
import org.apache.qpid.protonj2.test.driver.codec.util.TypeMapper;

public class OpenInjectAction
extends AbstractPerformativeInjectAction<Open> {
    private final Open open = new Open();

    public OpenInjectAction(AMQPTestDriver driver) {
        super(driver);
    }

    @Override
    public Open getPerformative() {
        return this.open;
    }

    @Override
    protected void beforeActionPerformed(AMQPTestDriver driver) {
        if (this.getPerformative().getContainerId() == null) {
            this.getPerformative().setContainerId("driver");
        }
        if (this.onChannel() == -1) {
            this.onChannel(0);
        }
    }

    public OpenInjectAction withContainerId(String containerId) {
        this.open.setContainerId(containerId);
        return this;
    }

    public OpenInjectAction withHostname(String hostname) {
        this.open.setHostname(hostname);
        return this;
    }

    public OpenInjectAction withMaxFrameSize(int maxFrameSize) {
        this.open.setMaxFrameSize(UnsignedInteger.valueOf(maxFrameSize));
        return this;
    }

    public OpenInjectAction withMaxFrameSize(long maxFrameSize) {
        this.open.setMaxFrameSize(UnsignedInteger.valueOf(maxFrameSize));
        return this;
    }

    public OpenInjectAction withMaxFrameSize(UnsignedInteger maxFrameSize) {
        this.open.setMaxFrameSize(maxFrameSize);
        return this;
    }

    public OpenInjectAction withChannelMax(int channelMax) {
        this.open.setChannelMax(UnsignedShort.valueOf(channelMax));
        return this;
    }

    public OpenInjectAction withChannelMax(short channelMax) {
        this.open.setChannelMax(UnsignedShort.valueOf(channelMax));
        return this;
    }

    public OpenInjectAction withChannelMax(UnsignedShort channelMax) {
        this.open.setChannelMax(channelMax);
        return this;
    }

    public OpenInjectAction withIdleTimeOut(int idleTimeout) {
        this.open.setIdleTimeOut(UnsignedInteger.valueOf(idleTimeout));
        return this;
    }

    public OpenInjectAction withIdleTimeOut(long idleTimeout) {
        this.open.setIdleTimeOut(UnsignedInteger.valueOf(idleTimeout));
        return this;
    }

    public OpenInjectAction withIdleTimeOut(UnsignedInteger idleTimeout) {
        this.open.setIdleTimeOut(idleTimeout);
        return this;
    }

    public OpenInjectAction withOutgoingLocales(String ... outgoingLocales) {
        this.open.setOutgoingLocales(TypeMapper.toSymbolArray(outgoingLocales));
        return this;
    }

    public OpenInjectAction withOutgoingLocales(Symbol ... outgoingLocales) {
        this.open.setOutgoingLocales(outgoingLocales);
        return this;
    }

    public OpenInjectAction withIncomingLocales(String ... incomingLocales) {
        this.open.setIncomingLocales(TypeMapper.toSymbolArray(incomingLocales));
        return this;
    }

    public OpenInjectAction withIncomingLocales(Symbol ... incomingLocales) {
        this.open.setIncomingLocales(incomingLocales);
        return this;
    }

    public OpenInjectAction withOfferedCapabilities(String ... offeredCapabilities) {
        this.open.setOfferedCapabilities(TypeMapper.toSymbolArray(offeredCapabilities));
        return this;
    }

    public OpenInjectAction withOfferedCapabilities(Symbol ... offeredCapabilities) {
        this.open.setOfferedCapabilities(offeredCapabilities);
        return this;
    }

    public OpenInjectAction withDesiredCapabilities(String ... desiredCapabilities) {
        this.open.setDesiredCapabilities(TypeMapper.toSymbolArray(desiredCapabilities));
        return this;
    }

    public OpenInjectAction withDesiredCapabilities(Symbol ... desiredCapabilities) {
        this.open.setDesiredCapabilities(desiredCapabilities);
        return this;
    }

    public OpenInjectAction withProperties(Map<String, Object> properties) {
        this.open.setProperties(TypeMapper.toSymbolKeyedMap(properties));
        return this;
    }

    public OpenInjectAction withPropertiesMap(Map<Symbol, Object> properties) {
        this.open.setProperties(properties);
        return this;
    }

    public OpenInjectAction withProperty(Symbol key, Object value) {
        if (this.open.getProperties() == null) {
            this.open.setProperties(new LinkedHashMap<Symbol, Object>());
        }
        this.open.getProperties().put(key, value);
        return this;
    }

    public OpenInjectAction withProperty(String key, Object value) {
        return this.withProperty(Symbol.valueOf(key), value);
    }
}

