/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.test.driver.actions;

import org.apache.qpid.protonj2.test.driver.AMQPTestDriver;
import org.apache.qpid.protonj2.test.driver.ProtonTestPeer;
import org.apache.qpid.protonj2.test.driver.ScriptedAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PeerShutdownAction
implements ScriptedAction {
    private static final Logger LOG = LoggerFactory.getLogger(PeerShutdownAction.class);
    private final ProtonTestPeer peer;
    private int delay = -1;

    public PeerShutdownAction(ProtonTestPeer peer) {
        this.peer = peer;
    }

    @Override
    public ScriptedAction now() {
        LOG.info("Peer Shutdown Action closing test peer as scripted");
        this.peer.close();
        return this;
    }

    @Override
    public ScriptedAction later(int waitTime) {
        this.peer.getDriver().afterDelay(this.delay, this);
        return this;
    }

    @Override
    public ScriptedAction queue() {
        this.peer.getDriver().addScriptedElement(this);
        return this;
    }

    @Override
    public ScriptedAction perform(AMQPTestDriver driver) {
        if (this.afterDelay() > 0) {
            driver.afterDelay(this.afterDelay(), new ScriptedAction(){

                @Override
                public ScriptedAction queue() {
                    return this;
                }

                @Override
                public ScriptedAction perform(AMQPTestDriver driver) {
                    return PeerShutdownAction.this.now();
                }

                @Override
                public ScriptedAction now() {
                    return this;
                }

                @Override
                public ScriptedAction later(int waitTime) {
                    return this;
                }
            });
        } else {
            this.now();
        }
        return this;
    }

    public int afterDelay() {
        return this.delay;
    }

    public PeerShutdownAction afterDelay(int delay) {
        this.delay = delay;
        return this;
    }
}

