/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.test.driver.codec;

import java.io.DataOutput;
import java.io.IOException;
import java.io.UncheckedIOException;
import org.apache.qpid.protonj2.test.driver.codec.AbstractElement;
import org.apache.qpid.protonj2.test.driver.codec.ByteElement;
import org.apache.qpid.protonj2.test.driver.codec.Codec;
import org.apache.qpid.protonj2.test.driver.codec.DescribedTypeImpl;
import org.apache.qpid.protonj2.test.driver.codec.Element;
import org.apache.qpid.protonj2.test.driver.codec.IntegerElement;
import org.apache.qpid.protonj2.test.driver.codec.LongElement;
import org.apache.qpid.protonj2.test.driver.codec.ShortElement;
import org.apache.qpid.protonj2.test.driver.codec.SymbolElement;
import org.apache.qpid.protonj2.test.driver.codec.primitives.DescribedType;
import org.apache.qpid.protonj2.test.driver.codec.primitives.Symbol;

class ArrayElement
extends AbstractElement<Object[]> {
    private final boolean described;
    private final Codec.DataType arrayType;
    private ConstructorType constructorType;
    private Element<?> first;
    static ConstructorType TINY = ConstructorType.TINY;
    static ConstructorType SMALL = ConstructorType.SMALL;
    static ConstructorType LARGE = ConstructorType.LARGE;

    ArrayElement(Element<?> parent, Element<?> prev, boolean described, Codec.DataType type) {
        super(parent, prev);
        this.described = described;
        this.arrayType = type;
        if (this.arrayType == null) {
            throw new NullPointerException("Array type cannot be null");
        }
        if (this.arrayType == Codec.DataType.DESCRIBED) {
            throw new IllegalArgumentException("Array type cannot be DESCRIBED");
        }
        switch (this.arrayType) {
            case UINT: 
            case ULONG: 
            case LIST: {
                this.setConstructorType(TINY);
                break;
            }
            default: {
                this.setConstructorType(SMALL);
            }
        }
    }

    ConstructorType constructorType() {
        return this.constructorType;
    }

    void setConstructorType(ConstructorType type) {
        this.constructorType = type;
    }

    @Override
    public int size() {
        int bodySize;
        ConstructorType oldConstructorType;
        int count = 0;
        do {
            bodySize = 1;
            oldConstructorType = this.constructorType;
            for (Element<?> element = this.first; element != null; element = element.next()) {
                ++count;
                bodySize += element.size();
            }
        } while (oldConstructorType != this.constructorType());
        if (this.isDescribed()) {
            ++bodySize;
            if (count != 0) {
                --count;
            }
        }
        if (this.isElementOfArray()) {
            ArrayElement parent = (ArrayElement)this.parent();
            if (parent.constructorType() == SMALL) {
                if (count <= 255 && bodySize <= 254) {
                    bodySize += 2;
                } else {
                    parent.setConstructorType(LARGE);
                    bodySize += 8;
                }
            } else {
                bodySize += 8;
            }
        } else {
            bodySize = count <= 255 && bodySize <= 254 ? (bodySize += 3) : (bodySize += 9);
        }
        return bodySize;
    }

    @Override
    public Object[] getValue() {
        if (this.isDescribed()) {
            Object[] rVal = new DescribedType[(int)this.count()];
            Object descriptor = this.first == null ? null : this.first.getValue();
            int i = 0;
            for (Element<?> element = this.first == null ? null : this.first.next(); element != null; element = element.next()) {
                rVal[i++] = new DescribedTypeImpl(descriptor, element.getValue());
            }
            return rVal;
        }
        if (this.arrayType == Codec.DataType.SYMBOL) {
            Object[] rVal = new Symbol[(int)this.count()];
            int i = 0;
            for (SymbolElement element = (SymbolElement)this.first; element != null; element = (SymbolElement)element.next()) {
                rVal[i++] = element.getValue();
            }
            return rVal;
        }
        Object[] rVal = new Object[(int)this.count()];
        int i = 0;
        for (Element<?> element = this.first; element != null; element = element.next()) {
            rVal[i++] = element.getValue();
        }
        return rVal;
    }

    @Override
    public Codec.DataType getDataType() {
        return Codec.DataType.ARRAY;
    }

    @Override
    public int encode(DataOutput output) {
        int size = this.size();
        int count = (int)this.count();
        try {
            if (!this.isElementOfArray()) {
                if (size > 257 || count > 255) {
                    output.writeByte(-16);
                    output.writeInt(size - 5);
                    output.writeInt(count);
                } else {
                    output.writeByte(-32);
                    output.writeByte((byte)(size - 2));
                    output.writeByte((byte)count);
                }
            } else {
                ArrayElement parent = (ArrayElement)this.parent();
                if (parent.constructorType() == SMALL) {
                    output.writeByte((byte)(size - 1));
                    output.writeByte((byte)count);
                } else {
                    output.writeInt(size - 4);
                    output.writeInt(count);
                }
            }
            Element<?> element = this.first;
            if (this.isDescribed()) {
                output.writeByte(0);
                if (element == null) {
                    output.writeByte(64);
                } else {
                    element.encode(output);
                    element = element.next();
                }
            }
            switch (this.arrayType) {
                case NULL: {
                    output.writeByte(64);
                    break;
                }
                case BOOL: {
                    output.writeByte(86);
                    break;
                }
                case UBYTE: {
                    output.writeByte(80);
                    break;
                }
                case BYTE: {
                    output.writeByte(81);
                    break;
                }
                case USHORT: {
                    output.writeByte(96);
                    break;
                }
                case SHORT: {
                    output.writeByte(97);
                    break;
                }
                case UINT: {
                    switch (this.constructorType().ordinal()) {
                        case 0: {
                            output.writeByte(67);
                            break;
                        }
                        case 1: {
                            output.writeByte(82);
                            break;
                        }
                        case 2: {
                            output.writeByte(112);
                        }
                    }
                    break;
                }
                case INT: {
                    output.writeByte(this.constructorType == SMALL ? 84 : 113);
                    break;
                }
                case CHAR: {
                    output.writeByte(115);
                    break;
                }
                case ULONG: {
                    switch (this.constructorType().ordinal()) {
                        case 0: {
                            output.writeByte(68);
                            break;
                        }
                        case 1: {
                            output.writeByte(83);
                            break;
                        }
                        case 2: {
                            output.writeByte(-128);
                        }
                    }
                    break;
                }
                case LONG: {
                    output.writeByte(this.constructorType == SMALL ? 85 : -127);
                    break;
                }
                case TIMESTAMP: {
                    output.writeByte(-125);
                    break;
                }
                case FLOAT: {
                    output.writeByte(114);
                    break;
                }
                case DOUBLE: {
                    output.writeByte(-126);
                    break;
                }
                case DECIMAL32: {
                    output.writeByte(116);
                    break;
                }
                case DECIMAL64: {
                    output.writeByte(-124);
                    break;
                }
                case DECIMAL128: {
                    output.writeByte(-108);
                    break;
                }
                case UUID: {
                    output.writeByte(-104);
                    break;
                }
                case BINARY: {
                    output.writeByte(this.constructorType == SMALL ? -96 : -80);
                    break;
                }
                case STRING: {
                    output.writeByte(this.constructorType == SMALL ? -95 : -79);
                    break;
                }
                case SYMBOL: {
                    output.writeByte(this.constructorType == SMALL ? -93 : -77);
                    break;
                }
                case ARRAY: {
                    output.writeByte(this.constructorType == SMALL ? -32 : -16);
                    break;
                }
                case LIST: {
                    output.writeByte(this.constructorType == TINY ? 69 : (this.constructorType == SMALL ? -64 : -48));
                    break;
                }
                case MAP: {
                    output.writeByte(this.constructorType == SMALL ? -63 : -47);
                    break;
                }
                case DESCRIBED: {
                    break;
                }
            }
            while (element != null) {
                element.encode(output);
                element = element.next();
            }
            return size;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public boolean canEnter() {
        return true;
    }

    @Override
    public Element<?> child() {
        return this.first;
    }

    @Override
    public void setChild(Element<?> elt) {
        this.first = elt;
    }

    @Override
    public Element<?> addChild(Element<?> element) {
        if (this.isDescribed() || element.getDataType() == this.arrayType) {
            this.first = element;
            return element;
        }
        Element<?> replacement = this.coerce(element);
        if (replacement != null) {
            this.first = replacement;
            return replacement;
        }
        throw new IllegalArgumentException("Attempting to add instance of " + String.valueOf((Object)element.getDataType()) + " to array of " + String.valueOf((Object)this.arrayType));
    }

    private Element<?> coerce(Element<?> element) {
        switch (this.arrayType) {
            case INT: {
                int i;
                switch (element.getDataType()) {
                    case BYTE: {
                        i = ((ByteElement)element).getValue().intValue();
                        break;
                    }
                    case SHORT: {
                        i = ((ShortElement)element).getValue().intValue();
                        break;
                    }
                    case LONG: {
                        i = ((LongElement)element).getValue().intValue();
                        break;
                    }
                    default: {
                        return null;
                    }
                }
                return new IntegerElement(element.parent(), element.prev(), i);
            }
            case LONG: {
                long l;
                switch (element.getDataType()) {
                    case BYTE: {
                        l = ((ByteElement)element).getValue().longValue();
                        break;
                    }
                    case SHORT: {
                        l = ((ShortElement)element).getValue().longValue();
                        break;
                    }
                    case INT: {
                        l = ((IntegerElement)element).getValue().longValue();
                        break;
                    }
                    default: {
                        return null;
                    }
                }
                return new LongElement(element.parent(), element.prev(), l);
            }
            case ARRAY: {
                break;
            }
            case BINARY: {
                break;
            }
            case BOOL: {
                break;
            }
            case BYTE: {
                break;
            }
            case CHAR: {
                break;
            }
            case DECIMAL128: {
                break;
            }
            case DECIMAL32: {
                break;
            }
            case DECIMAL64: {
                break;
            }
            case DESCRIBED: {
                break;
            }
            case DOUBLE: {
                break;
            }
            case FLOAT: {
                break;
            }
            case LIST: {
                break;
            }
            case MAP: {
                break;
            }
            case NULL: {
                break;
            }
            case SHORT: {
                break;
            }
            case STRING: {
                break;
            }
            case SYMBOL: {
                break;
            }
            case TIMESTAMP: {
                break;
            }
            case UBYTE: {
                break;
            }
            case UINT: {
                break;
            }
            case ULONG: {
                break;
            }
            case USHORT: {
                break;
            }
            case UUID: {
                break;
            }
        }
        return null;
    }

    @Override
    public Element<?> checkChild(Element<?> element) {
        if (element.getDataType() != this.arrayType) {
            Element<?> replacement = this.coerce(element);
            if (replacement != null) {
                return replacement;
            }
            throw new IllegalArgumentException("Attempting to add instance of " + String.valueOf((Object)element.getDataType()) + " to array of " + String.valueOf((Object)this.arrayType));
        }
        return element;
    }

    public long count() {
        int count = 0;
        for (Element<?> elt = this.first; elt != null; elt = elt.next()) {
            ++count;
        }
        if (this.isDescribed() && count != 0) {
            --count;
        }
        return count;
    }

    public boolean isDescribed() {
        return this.described;
    }

    public Codec.DataType getArrayDataType() {
        return this.arrayType;
    }

    @Override
    String startSymbol() {
        return String.format("%s%s[", new Object[]{this.isDescribed() ? "D" : "", this.getArrayDataType()});
    }

    @Override
    String stopSymbol() {
        return "]";
    }

    static enum ConstructorType {
        TINY,
        SMALL,
        LARGE;

    }
}

