/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.test.driver.codec;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.qpid.protonj2.test.driver.codec.ArrayElement;
import org.apache.qpid.protonj2.test.driver.codec.BinaryElement;
import org.apache.qpid.protonj2.test.driver.codec.BooleanElement;
import org.apache.qpid.protonj2.test.driver.codec.ByteElement;
import org.apache.qpid.protonj2.test.driver.codec.CharElement;
import org.apache.qpid.protonj2.test.driver.codec.Codec;
import org.apache.qpid.protonj2.test.driver.codec.Decimal128Element;
import org.apache.qpid.protonj2.test.driver.codec.Decimal32Element;
import org.apache.qpid.protonj2.test.driver.codec.Decimal64Element;
import org.apache.qpid.protonj2.test.driver.codec.DescribedTypeElement;
import org.apache.qpid.protonj2.test.driver.codec.DoubleElement;
import org.apache.qpid.protonj2.test.driver.codec.Element;
import org.apache.qpid.protonj2.test.driver.codec.FloatElement;
import org.apache.qpid.protonj2.test.driver.codec.IntegerElement;
import org.apache.qpid.protonj2.test.driver.codec.ListElement;
import org.apache.qpid.protonj2.test.driver.codec.LongElement;
import org.apache.qpid.protonj2.test.driver.codec.MapElement;
import org.apache.qpid.protonj2.test.driver.codec.NullElement;
import org.apache.qpid.protonj2.test.driver.codec.ShortElement;
import org.apache.qpid.protonj2.test.driver.codec.StringElement;
import org.apache.qpid.protonj2.test.driver.codec.SymbolElement;
import org.apache.qpid.protonj2.test.driver.codec.TimestampElement;
import org.apache.qpid.protonj2.test.driver.codec.TypeDecoder;
import org.apache.qpid.protonj2.test.driver.codec.UUIDElement;
import org.apache.qpid.protonj2.test.driver.codec.UnsignedByteElement;
import org.apache.qpid.protonj2.test.driver.codec.UnsignedIntegerElement;
import org.apache.qpid.protonj2.test.driver.codec.UnsignedLongElement;
import org.apache.qpid.protonj2.test.driver.codec.UnsignedShortElement;
import org.apache.qpid.protonj2.test.driver.codec.primitives.Binary;
import org.apache.qpid.protonj2.test.driver.codec.primitives.Decimal128;
import org.apache.qpid.protonj2.test.driver.codec.primitives.Decimal32;
import org.apache.qpid.protonj2.test.driver.codec.primitives.Decimal64;
import org.apache.qpid.protonj2.test.driver.codec.primitives.DescribedType;
import org.apache.qpid.protonj2.test.driver.codec.primitives.Symbol;
import org.apache.qpid.protonj2.test.driver.codec.primitives.UnsignedByte;
import org.apache.qpid.protonj2.test.driver.codec.primitives.UnsignedInteger;
import org.apache.qpid.protonj2.test.driver.codec.primitives.UnsignedLong;
import org.apache.qpid.protonj2.test.driver.codec.primitives.UnsignedShort;

public class CodecImpl
implements Codec {
    private Element<?> first;
    private Element<?> current;
    private Element<?> parent;

    @Override
    public void free() {
        this.first = null;
        this.current = null;
    }

    @Override
    public void clear() {
        this.first = null;
        this.current = null;
        this.parent = null;
    }

    @Override
    public long size() {
        return this.first == null ? 0L : (long)this.first.size();
    }

    @Override
    public void rewind() {
        this.current = null;
        this.parent = null;
    }

    @Override
    public Codec.DataType next() {
        Element<?> next;
        Element<?> element = this.current == null ? (this.parent == null ? this.first : this.parent.child()) : (next = this.current.next());
        if (next != null) {
            this.current = next;
        }
        return next == null ? null : next.getDataType();
    }

    @Override
    public Codec.DataType prev() {
        Element<?> prev = this.current == null ? null : this.current.prev();
        this.current = prev;
        return prev == null ? null : prev.getDataType();
    }

    @Override
    public boolean enter() {
        if (this.current != null && this.current.canEnter()) {
            this.parent = this.current;
            this.current = null;
            return true;
        }
        return false;
    }

    @Override
    public boolean exit() {
        if (this.parent != null) {
            Element<?> oldParent = this.parent;
            this.current = oldParent;
            this.parent = this.current.parent();
            return true;
        }
        return false;
    }

    @Override
    public Codec.DataType type() {
        return this.current == null ? null : this.current.getDataType();
    }

    @Override
    public long encodedSize() {
        int size = 0;
        for (Element<?> elt = this.first; elt != null; elt = elt.next()) {
            size += elt.size();
        }
        return size;
    }

    @Override
    public long encode(OutputStream output) {
        long l;
        DataOutputStream daos = new DataOutputStream(output);
        try {
            int size = 0;
            for (Element<?> element = this.first; element != null; element = element.next()) {
                size += element.encode(daos);
            }
            l = size;
        }
        catch (Throwable throwable) {
            try {
                try {
                    daos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
        daos.close();
        return l;
    }

    @Override
    public long decode(ByteBuffer input) {
        return TypeDecoder.decode(input, this);
    }

    private void putElement(Element<?> element) {
        if (this.first == null) {
            this.first = element;
        } else if (this.current == null) {
            if (this.parent == null) {
                this.first = this.first.replaceWith(element);
                element = this.first;
            } else {
                element = this.parent.addChild(element);
            }
        } else {
            if (this.parent != null) {
                element = this.parent.checkChild(element);
            }
            this.current.setNext(element);
        }
        this.current = element;
    }

    @Override
    public void putList() {
        this.putElement(new ListElement(this.parent, this.current));
    }

    @Override
    public void putMap() {
        this.putElement(new MapElement(this.parent, this.current));
    }

    @Override
    public void putArray(boolean described, Codec.DataType type) {
        this.putElement(new ArrayElement(this.parent, this.current, described, type));
    }

    @Override
    public void putDescribed() {
        this.putElement(new DescribedTypeElement(this.parent, this.current));
    }

    @Override
    public void putNull() {
        this.putElement(new NullElement(this.parent, this.current));
    }

    @Override
    public void putBoolean(boolean b) {
        this.putElement(new BooleanElement(this.parent, this.current, b));
    }

    @Override
    public void putUnsignedByte(UnsignedByte ub) {
        this.putElement(new UnsignedByteElement(this.parent, this.current, ub));
    }

    @Override
    public void putByte(byte b) {
        this.putElement(new ByteElement(this.parent, this.current, b));
    }

    @Override
    public void putUnsignedShort(UnsignedShort us) {
        this.putElement(new UnsignedShortElement(this.parent, this.current, us));
    }

    @Override
    public void putShort(short s) {
        this.putElement(new ShortElement(this.parent, this.current, s));
    }

    @Override
    public void putUnsignedInteger(UnsignedInteger ui) {
        this.putElement(new UnsignedIntegerElement(this.parent, this.current, ui));
    }

    @Override
    public void putInt(int i) {
        this.putElement(new IntegerElement(this.parent, this.current, i));
    }

    @Override
    public void putChar(int c) {
        this.putElement(new CharElement(this.parent, this.current, c));
    }

    @Override
    public void putUnsignedLong(UnsignedLong ul) {
        this.putElement(new UnsignedLongElement(this.parent, this.current, ul));
    }

    @Override
    public void putLong(long l) {
        this.putElement(new LongElement(this.parent, this.current, l));
    }

    @Override
    public void putTimestamp(Date t) {
        this.putElement(new TimestampElement(this.parent, this.current, t));
    }

    @Override
    public void putFloat(float f) {
        this.putElement(new FloatElement(this.parent, this.current, f));
    }

    @Override
    public void putDouble(double d) {
        this.putElement(new DoubleElement(this.parent, this.current, d));
    }

    @Override
    public void putDecimal32(Decimal32 d) {
        this.putElement(new Decimal32Element(this.parent, this.current, d));
    }

    @Override
    public void putDecimal64(Decimal64 d) {
        this.putElement(new Decimal64Element(this.parent, this.current, d));
    }

    @Override
    public void putDecimal128(Decimal128 d) {
        this.putElement(new Decimal128Element(this.parent, this.current, d));
    }

    @Override
    public void putUUID(UUID u) {
        this.putElement(new UUIDElement(this.parent, this.current, u));
    }

    @Override
    public void putBinary(Binary bytes) {
        this.putElement(new BinaryElement(this.parent, this.current, bytes));
    }

    @Override
    public void putBinary(byte[] bytes) {
        this.putBinary(new Binary(bytes));
    }

    @Override
    public void putString(String string) {
        this.putElement(new StringElement(this.parent, this.current, string));
    }

    @Override
    public void putSymbol(Symbol symbol) {
        this.putElement(new SymbolElement(this.parent, this.current, symbol));
    }

    @Override
    public void putObject(Object o) {
        if (o == null) {
            this.putNull();
        } else if (o instanceof Boolean) {
            this.putBoolean((Boolean)o);
        } else if (o instanceof UnsignedByte) {
            this.putUnsignedByte((UnsignedByte)o);
        } else if (o instanceof Byte) {
            this.putByte((Byte)o);
        } else if (o instanceof UnsignedShort) {
            this.putUnsignedShort((UnsignedShort)o);
        } else if (o instanceof Short) {
            this.putShort((Short)o);
        } else if (o instanceof UnsignedInteger) {
            this.putUnsignedInteger((UnsignedInteger)o);
        } else if (o instanceof Integer) {
            this.putInt((Integer)o);
        } else if (o instanceof Character) {
            this.putChar(((Character)o).charValue());
        } else if (o instanceof UnsignedLong) {
            this.putUnsignedLong((UnsignedLong)o);
        } else if (o instanceof Long) {
            this.putLong((Long)o);
        } else if (o instanceof Date) {
            this.putTimestamp((Date)o);
        } else if (o instanceof Float) {
            this.putFloat(((Float)o).floatValue());
        } else if (o instanceof Double) {
            this.putDouble((Double)o);
        } else if (o instanceof Decimal32) {
            this.putDecimal32((Decimal32)o);
        } else if (o instanceof Decimal64) {
            this.putDecimal64((Decimal64)o);
        } else if (o instanceof Decimal128) {
            this.putDecimal128((Decimal128)o);
        } else if (o instanceof UUID) {
            this.putUUID((UUID)o);
        } else if (o instanceof Binary) {
            this.putBinary((Binary)o);
        } else if (o instanceof String) {
            this.putString((String)o);
        } else if (o instanceof Symbol) {
            this.putSymbol((Symbol)o);
        } else if (o instanceof DescribedType) {
            this.putDescribedType((DescribedType)o);
        } else if (o instanceof Symbol[]) {
            this.putArray(false, Codec.DataType.SYMBOL);
            this.enter();
            for (Symbol s : (Symbol[])o) {
                this.putSymbol(s);
            }
            this.exit();
        } else {
            if (o instanceof Object[]) {
                throw new IllegalArgumentException("Unsupported array type");
            }
            if (o instanceof List) {
                this.putJavaList((List)o);
            } else if (o instanceof Map) {
                this.putJavaMap((Map)o);
            } else {
                throw new IllegalArgumentException("Unknown type " + o.getClass().getSimpleName());
            }
        }
    }

    @Override
    public void putJavaMap(Map<Object, Object> map) {
        this.putMap();
        this.enter();
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            this.putObject(entry.getKey());
            this.putObject(entry.getValue());
        }
        this.exit();
    }

    @Override
    public void putJavaList(List<Object> list) {
        this.putList();
        this.enter();
        for (Object o : list) {
            this.putObject(o);
        }
        this.exit();
    }

    @Override
    public void putDescribedType(DescribedType dt) {
        this.putElement(new DescribedTypeElement(this.parent, this.current));
        this.enter();
        this.putObject(dt.getDescriptor());
        this.putObject(dt.getDescribed());
        this.exit();
    }

    @Override
    public long getList() {
        if (this.current instanceof ListElement) {
            return ((ListElement)this.current).count();
        }
        throw new IllegalStateException("Current value not list");
    }

    @Override
    public long getMap() {
        if (this.current instanceof MapElement) {
            return ((MapElement)this.current).count();
        }
        throw new IllegalStateException("Current value not map");
    }

    @Override
    public long getArray() {
        if (this.current instanceof ArrayElement) {
            return ((ArrayElement)this.current).count();
        }
        throw new IllegalStateException("Current value not array");
    }

    @Override
    public boolean isArrayDescribed() {
        if (this.current instanceof ArrayElement) {
            return ((ArrayElement)this.current).isDescribed();
        }
        throw new IllegalStateException("Current value not array");
    }

    @Override
    public Codec.DataType getArrayType() {
        if (this.current instanceof ArrayElement) {
            return ((ArrayElement)this.current).getArrayDataType();
        }
        throw new IllegalStateException("Current value not array");
    }

    @Override
    public boolean isDescribed() {
        return this.current != null && this.current.getDataType() == Codec.DataType.DESCRIBED;
    }

    @Override
    public boolean isNull() {
        return this.current != null && this.current.getDataType() == Codec.DataType.NULL;
    }

    @Override
    public boolean getBoolean() {
        if (this.current instanceof BooleanElement) {
            return ((BooleanElement)this.current).getValue();
        }
        throw new IllegalStateException("Current value not boolean");
    }

    @Override
    public UnsignedByte getUnsignedByte() {
        if (this.current instanceof UnsignedByteElement) {
            return ((UnsignedByteElement)this.current).getValue();
        }
        throw new IllegalStateException("Current value not unsigned byte");
    }

    @Override
    public byte getByte() {
        if (this.current instanceof ByteElement) {
            return ((ByteElement)this.current).getValue();
        }
        throw new IllegalStateException("Current value not byte");
    }

    @Override
    public UnsignedShort getUnsignedShort() {
        if (this.current instanceof UnsignedShortElement) {
            return ((UnsignedShortElement)this.current).getValue();
        }
        throw new IllegalStateException("Current value not unsigned short");
    }

    @Override
    public short getShort() {
        if (this.current instanceof ShortElement) {
            return ((ShortElement)this.current).getValue();
        }
        throw new IllegalStateException("Current value not short");
    }

    @Override
    public UnsignedInteger getUnsignedInteger() {
        if (this.current instanceof UnsignedIntegerElement) {
            return ((UnsignedIntegerElement)this.current).getValue();
        }
        throw new IllegalStateException("Current value not unsigned integer");
    }

    @Override
    public int getInt() {
        if (this.current instanceof IntegerElement) {
            return ((IntegerElement)this.current).getValue();
        }
        throw new IllegalStateException("Current value not integer");
    }

    @Override
    public int getChar() {
        if (this.current instanceof CharElement) {
            return ((CharElement)this.current).getValue();
        }
        throw new IllegalStateException("Current value not char");
    }

    @Override
    public UnsignedLong getUnsignedLong() {
        if (this.current instanceof UnsignedLongElement) {
            return ((UnsignedLongElement)this.current).getValue();
        }
        throw new IllegalStateException("Current value not unsigned long");
    }

    @Override
    public long getLong() {
        if (this.current instanceof LongElement) {
            return ((LongElement)this.current).getValue();
        }
        throw new IllegalStateException("Current value not long");
    }

    @Override
    public Date getTimestamp() {
        if (this.current instanceof TimestampElement) {
            return ((TimestampElement)this.current).getValue();
        }
        throw new IllegalStateException("Current value not timestamp");
    }

    @Override
    public float getFloat() {
        if (this.current instanceof FloatElement) {
            return ((FloatElement)this.current).getValue().floatValue();
        }
        throw new IllegalStateException("Current value not float");
    }

    @Override
    public double getDouble() {
        if (this.current instanceof DoubleElement) {
            return ((DoubleElement)this.current).getValue();
        }
        throw new IllegalStateException("Current value not double");
    }

    @Override
    public Decimal32 getDecimal32() {
        if (this.current instanceof Decimal32Element) {
            return ((Decimal32Element)this.current).getValue();
        }
        throw new IllegalStateException("Current value not decimal32");
    }

    @Override
    public Decimal64 getDecimal64() {
        if (this.current instanceof Decimal64Element) {
            return ((Decimal64Element)this.current).getValue();
        }
        throw new IllegalStateException("Current value not decimal32");
    }

    @Override
    public Decimal128 getDecimal128() {
        if (this.current instanceof Decimal128Element) {
            return ((Decimal128Element)this.current).getValue();
        }
        throw new IllegalStateException("Current value not decimal32");
    }

    @Override
    public UUID getUUID() {
        if (this.current instanceof UUIDElement) {
            return ((UUIDElement)this.current).getValue();
        }
        throw new IllegalStateException("Current value not uuid");
    }

    @Override
    public Binary getBinary() {
        if (this.current instanceof BinaryElement) {
            return ((BinaryElement)this.current).getValue();
        }
        throw new IllegalStateException("Current value not binary");
    }

    @Override
    public String getString() {
        if (this.current instanceof StringElement) {
            return ((StringElement)this.current).getValue();
        }
        throw new IllegalStateException("Current value not string");
    }

    @Override
    public Symbol getSymbol() {
        if (this.current instanceof SymbolElement) {
            return ((SymbolElement)this.current).getValue();
        }
        throw new IllegalStateException("Current value not symbol");
    }

    @Override
    public Object getObject() {
        return this.current == null ? null : this.current.getValue();
    }

    @Override
    public Map<Object, Object> getJavaMap() {
        if (this.current instanceof MapElement) {
            return ((MapElement)this.current).getValue();
        }
        throw new IllegalStateException("Current value not map");
    }

    @Override
    public List<Object> getJavaList() {
        if (this.current instanceof ListElement) {
            return ((ListElement)this.current).getValue();
        }
        throw new IllegalStateException("Current value not list");
    }

    @Override
    public Object[] getJavaArray() {
        if (this.current instanceof ArrayElement) {
            return ((ArrayElement)this.current).getValue();
        }
        throw new IllegalStateException("Current value not array");
    }

    @Override
    public DescribedType getDescribedType() {
        if (this.current instanceof DescribedTypeElement) {
            return ((DescribedTypeElement)this.current).getValue();
        }
        throw new IllegalStateException("Current value not described type");
    }

    @Override
    public String format() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Element<?> el = this.first; el != null; el = el.next()) {
            if (first) {
                first = false;
            } else {
                sb.append(", ");
            }
            el.render(sb);
        }
        return sb.toString();
    }

    private void render(StringBuilder sb, Element<?> el) {
        if (el == null) {
            return;
        }
        sb.append("    ").append(el).append("\n");
        if (el.canEnter()) {
            this.render(sb, el.child());
        }
        this.render(sb, el.next());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.render(sb, this.first);
        return String.format("Data[current=%h, parent=%h]{%n%s}", System.identityHashCode(this.current), System.identityHashCode(this.parent), sb);
    }
}

