/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.test.driver.codec;

import java.io.DataOutput;
import java.io.IOException;
import java.io.UncheckedIOException;
import org.apache.qpid.protonj2.test.driver.codec.AbstractElement;
import org.apache.qpid.protonj2.test.driver.codec.Codec;
import org.apache.qpid.protonj2.test.driver.codec.DescribedTypeRegistry;
import org.apache.qpid.protonj2.test.driver.codec.Element;
import org.apache.qpid.protonj2.test.driver.codec.primitives.DescribedType;

class DescribedTypeElement
extends AbstractElement<DescribedType> {
    private Element<?> first;

    DescribedTypeElement(Element<?> parent, Element<?> prev) {
        super(parent, prev);
    }

    @Override
    public int size() {
        int count = 0;
        int size = 0;
        for (Element<?> elt = this.first; elt != null; elt = elt.next()) {
            ++count;
            size += elt.size();
        }
        if (this.isElementOfArray()) {
            throw new IllegalArgumentException("Cannot add described type members to an array");
        }
        if (count > 2) {
            throw new IllegalArgumentException("Too many elements in described type");
        }
        size = count == 0 ? 3 : (count == 1 ? (size += 2) : ++size);
        return size;
    }

    @Override
    public DescribedType getValue() {
        Object descriptor = this.first == null ? null : this.first.getValue();
        Element<?> second = this.first == null ? null : this.first.next();
        Object described = second == null ? null : second.getValue();
        return DescribedTypeRegistry.lookupDescribedType(descriptor, described);
    }

    @Override
    public Codec.DataType getDataType() {
        return Codec.DataType.DESCRIBED;
    }

    @Override
    public int encode(DataOutput output) {
        int encodedSize = this.size();
        try {
            output.writeByte(0);
            if (this.first == null) {
                output.writeByte(64);
                output.writeByte(64);
            } else {
                this.first.encode(output);
                if (this.first.next() == null) {
                    output.writeByte(64);
                } else {
                    this.first.next().encode(output);
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return encodedSize;
    }

    @Override
    public boolean canEnter() {
        return true;
    }

    @Override
    public Element<?> child() {
        return this.first;
    }

    @Override
    public void setChild(Element<?> elt) {
        this.first = elt;
    }

    @Override
    public Element<?> checkChild(Element<?> element) {
        if (element.prev() != this.first) {
            throw new IllegalArgumentException("Described Type may only have two elements");
        }
        return element;
    }

    @Override
    public Element<?> addChild(Element<?> element) {
        this.first = element;
        return element;
    }

    @Override
    String startSymbol() {
        return "(";
    }

    @Override
    String stopSymbol() {
        return ")";
    }
}

