/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.test.driver.codec;

import java.io.DataOutput;
import java.io.IOException;
import java.io.UncheckedIOException;
import org.apache.qpid.protonj2.test.driver.codec.AtomicElement;
import org.apache.qpid.protonj2.test.driver.codec.Codec;
import org.apache.qpid.protonj2.test.driver.codec.Element;

class ShortElement
extends AtomicElement<Short> {
    private final short value;

    ShortElement(Element<?> parent, Element<?> prev, short s) {
        super(parent, prev);
        this.value = s;
    }

    @Override
    public int size() {
        return this.isElementOfArray() ? 2 : 3;
    }

    @Override
    public Short getValue() {
        return this.value;
    }

    @Override
    public Codec.DataType getDataType() {
        return Codec.DataType.SHORT;
    }

    @Override
    public int encode(DataOutput output) {
        try {
            if (this.isElementOfArray()) {
                output.writeShort(this.value);
                return 2;
            }
            output.writeByte(97);
            output.writeShort(this.value);
            return 3;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

