/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.test.driver.codec;

import java.io.DataOutput;
import java.io.IOException;
import java.io.UncheckedIOException;
import org.apache.qpid.protonj2.test.driver.codec.AtomicElement;
import org.apache.qpid.protonj2.test.driver.codec.Codec;
import org.apache.qpid.protonj2.test.driver.codec.Element;
import org.apache.qpid.protonj2.test.driver.codec.primitives.UnsignedByte;

class UnsignedByteElement
extends AtomicElement<UnsignedByte> {
    private final UnsignedByte value;

    UnsignedByteElement(Element<?> parent, Element<?> prev, UnsignedByte ub) {
        super(parent, prev);
        this.value = ub;
    }

    @Override
    public int size() {
        return this.isElementOfArray() ? 1 : 2;
    }

    @Override
    public UnsignedByte getValue() {
        return this.value;
    }

    @Override
    public Codec.DataType getDataType() {
        return Codec.DataType.UBYTE;
    }

    @Override
    public int encode(DataOutput output) {
        try {
            if (this.isElementOfArray()) {
                output.writeByte(this.value.byteValue());
                return 1;
            }
            output.writeByte(80);
            output.writeByte(this.value.byteValue());
            return 2;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

