/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.protonj2.test.driver.matchers.transport;

import java.util.Map;
import org.apache.qpid.protonj2.test.driver.codec.primitives.Symbol;
import org.apache.qpid.protonj2.test.driver.codec.primitives.UnsignedInteger;
import org.apache.qpid.protonj2.test.driver.codec.primitives.UnsignedShort;
import org.apache.qpid.protonj2.test.driver.codec.transport.Open;
import org.apache.qpid.protonj2.test.driver.codec.util.TypeMapper;
import org.apache.qpid.protonj2.test.driver.matchers.ListDescribedTypeMatcher;
import org.apache.qpid.protonj2.test.driver.matchers.MapContentsMatcher;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;

public class OpenMatcher
extends ListDescribedTypeMatcher {
    private MapContentsMatcher<Symbol, Object> propertiesMatcher;

    public OpenMatcher() {
        super(Open.Field.values().length, Open.DESCRIPTOR_CODE, Open.DESCRIPTOR_SYMBOL);
    }

    @Override
    protected Class<?> getDescribedTypeClass() {
        return Open.class;
    }

    public OpenMatcher withContainerId(String container) {
        return this.withContainerId(CoreMatchers.equalTo((Object)container));
    }

    public OpenMatcher withHostname(String hostname) {
        return this.withHostname(CoreMatchers.equalTo((Object)hostname));
    }

    public OpenMatcher withMaxFrameSize(int maxFrameSize) {
        return this.withMaxFrameSize(CoreMatchers.equalTo((Object)UnsignedInteger.valueOf(maxFrameSize)));
    }

    public OpenMatcher withMaxFrameSize(long maxFrameSize) {
        return this.withMaxFrameSize(CoreMatchers.equalTo((Object)UnsignedInteger.valueOf(maxFrameSize)));
    }

    public OpenMatcher withMaxFrameSize(UnsignedInteger maxFrameSize) {
        return this.withMaxFrameSize(CoreMatchers.equalTo((Object)maxFrameSize));
    }

    public OpenMatcher withChannelMax(short channelMax) {
        return this.withChannelMax(CoreMatchers.equalTo((Object)UnsignedShort.valueOf(channelMax)));
    }

    public OpenMatcher withChannelMax(int channelMax) {
        return this.withChannelMax(CoreMatchers.equalTo((Object)UnsignedShort.valueOf(channelMax)));
    }

    public OpenMatcher withChannelMax(UnsignedShort channelMax) {
        return this.withChannelMax(CoreMatchers.equalTo((Object)channelMax));
    }

    public OpenMatcher withIdleTimeOut(int idleTimeout) {
        return this.withIdleTimeOut(CoreMatchers.equalTo((Object)UnsignedInteger.valueOf(idleTimeout)));
    }

    public OpenMatcher withIdleTimeOut(long idleTimeout) {
        return this.withIdleTimeOut(CoreMatchers.equalTo((Object)UnsignedInteger.valueOf(idleTimeout)));
    }

    public OpenMatcher withIdleTimeOut(UnsignedInteger idleTimeout) {
        return this.withIdleTimeOut(CoreMatchers.equalTo((Object)idleTimeout));
    }

    public OpenMatcher withOutgoingLocales(String ... outgoingLocales) {
        return this.withOutgoingLocales(CoreMatchers.equalTo((Object)TypeMapper.toSymbolArray(outgoingLocales)));
    }

    public OpenMatcher withOutgoingLocales(Symbol ... outgoingLocales) {
        return this.withOutgoingLocales(CoreMatchers.equalTo((Object)outgoingLocales));
    }

    public OpenMatcher withIncomingLocales(String ... incomingLocales) {
        return this.withIncomingLocales(CoreMatchers.equalTo((Object)TypeMapper.toSymbolArray(incomingLocales)));
    }

    public OpenMatcher withIncomingLocales(Symbol ... incomingLocales) {
        return this.withIncomingLocales(CoreMatchers.equalTo((Object)incomingLocales));
    }

    public OpenMatcher withOfferedCapabilities(String ... offeredCapabilities) {
        return this.withOfferedCapabilities(CoreMatchers.equalTo((Object)TypeMapper.toSymbolArray(offeredCapabilities)));
    }

    public OpenMatcher withOfferedCapabilities(Symbol ... offeredCapabilities) {
        return this.withOfferedCapabilities(CoreMatchers.equalTo((Object)offeredCapabilities));
    }

    public OpenMatcher withDesiredCapabilities(String ... desiredCapabilities) {
        return this.withDesiredCapabilities(CoreMatchers.equalTo((Object)TypeMapper.toSymbolArray(desiredCapabilities)));
    }

    public OpenMatcher withDesiredCapabilities(Symbol ... desiredCapabilities) {
        return this.withDesiredCapabilities(CoreMatchers.equalTo((Object)desiredCapabilities));
    }

    public OpenMatcher withPropertiesMap(Map<Symbol, Object> properties) {
        this.propertiesMatcher = null;
        return this.withProperties(CoreMatchers.equalTo(properties));
    }

    public OpenMatcher withProperties(Map<String, Object> properties) {
        return this.withPropertiesMap(TypeMapper.toSymbolKeyedMap(properties));
    }

    public OpenMatcher withProperty(String key, Object value) {
        return this.withProperty(Symbol.valueOf(key), value);
    }

    public OpenMatcher withProperty(Symbol key, Object value) {
        if (this.propertiesMatcher == null) {
            this.propertiesMatcher = new MapContentsMatcher();
        }
        this.propertiesMatcher.addExpectedEntry(key, value);
        return this.withProperties((Matcher<?>)this.propertiesMatcher);
    }

    public OpenMatcher withContainerId(Matcher<?> m) {
        this.addFieldMatcher(Open.Field.CONTAINER_ID, m);
        return this;
    }

    public OpenMatcher withHostname(Matcher<?> m) {
        this.addFieldMatcher(Open.Field.HOSTNAME, m);
        return this;
    }

    public OpenMatcher withMaxFrameSize(Matcher<?> m) {
        this.addFieldMatcher(Open.Field.MAX_FRAME_SIZE, m);
        return this;
    }

    public OpenMatcher withChannelMax(Matcher<?> m) {
        this.addFieldMatcher(Open.Field.CHANNEL_MAX, m);
        return this;
    }

    public OpenMatcher withIdleTimeOut(Matcher<?> m) {
        this.addFieldMatcher(Open.Field.IDLE_TIME_OUT, m);
        return this;
    }

    public OpenMatcher withOutgoingLocales(Matcher<?> m) {
        this.addFieldMatcher(Open.Field.OUTGOING_LOCALES, m);
        return this;
    }

    public OpenMatcher withIncomingLocales(Matcher<?> m) {
        this.addFieldMatcher(Open.Field.INCOMING_LOCALES, m);
        return this;
    }

    public OpenMatcher withOfferedCapabilities(Matcher<?> m) {
        this.addFieldMatcher(Open.Field.OFFERED_CAPABILITIES, m);
        return this;
    }

    public OpenMatcher withDesiredCapabilities(Matcher<?> m) {
        this.addFieldMatcher(Open.Field.DESIRED_CAPABILITIES, m);
        return this;
    }

    public OpenMatcher withProperties(Matcher<?> m) {
        this.addFieldMatcher(Open.Field.PROPERTIES, m);
        return this;
    }
}

