/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.converter.v0_10_v1_0;

import java.util.ArrayList;
import org.apache.qpid.amqp_1_0.messaging.SectionEncoder;
import org.apache.qpid.amqp_1_0.type.Binary;
import org.apache.qpid.amqp_1_0.type.Symbol;
import org.apache.qpid.amqp_1_0.type.UnsignedByte;
import org.apache.qpid.amqp_1_0.type.UnsignedInteger;
import org.apache.qpid.amqp_1_0.type.messaging.ApplicationProperties;
import org.apache.qpid.amqp_1_0.type.messaging.Header;
import org.apache.qpid.amqp_1_0.type.messaging.Properties;
import org.apache.qpid.server.protocol.v0_10.MessageTransferMessage;
import org.apache.qpid.server.protocol.v1_0.MessageConverter_to_1_0;
import org.apache.qpid.server.protocol.v1_0.MessageMetaData_1_0;
import org.apache.qpid.transport.DeliveryProperties;
import org.apache.qpid.transport.MessageDeliveryMode;
import org.apache.qpid.transport.MessageProperties;

public class MessageConverter_0_10_to_1_0
extends MessageConverter_to_1_0<MessageTransferMessage> {
    public Class<MessageTransferMessage> getInputClass() {
        return MessageTransferMessage.class;
    }

    protected MessageMetaData_1_0 convertMetaData(MessageTransferMessage serverMessage, SectionEncoder sectionEncoder) {
        ArrayList<Object> sections = new ArrayList<Object>(3);
        MessageProperties msgProps = serverMessage.getHeader().getMessageProperties();
        DeliveryProperties deliveryProps = serverMessage.getHeader().getDeliveryProperties();
        Header header = new Header();
        if (deliveryProps != null) {
            header.setDurable(Boolean.valueOf(deliveryProps.hasDeliveryMode() && deliveryProps.getDeliveryMode() == MessageDeliveryMode.PERSISTENT));
            if (deliveryProps.hasPriority()) {
                header.setPriority(UnsignedByte.valueOf((byte)((byte)deliveryProps.getPriority().getValue())));
            }
            if (deliveryProps.hasTtl()) {
                header.setTtl(UnsignedInteger.valueOf((long)deliveryProps.getTtl()));
            }
            sections.add(header);
        }
        Properties props = new Properties();
        if (msgProps != null) {
            if (msgProps.hasContentEncoding()) {
                props.setContentEncoding(Symbol.valueOf((String)msgProps.getContentEncoding()));
            }
            if (msgProps.hasCorrelationId()) {
                props.setCorrelationId((Object)msgProps.getCorrelationId());
            }
            if (msgProps.hasMessageId()) {
                props.setMessageId((Object)msgProps.getMessageId());
            }
            if (msgProps.hasReplyTo()) {
                props.setReplyTo(msgProps.getReplyTo().getExchange() + "/" + msgProps.getReplyTo().getRoutingKey());
            }
            if (msgProps.hasContentType()) {
                props.setContentType(Symbol.valueOf((String)msgProps.getContentType()));
                if (props.getContentType() == Symbol.valueOf((String)"application/java-object-stream")) {
                    props.setContentType(Symbol.valueOf((String)"application/x-java-serialized-object"));
                }
            }
            props.setSubject(serverMessage.getInitialRoutingAddress());
            if (msgProps.hasUserId()) {
                props.setUserId(new Binary(msgProps.getUserId()));
            }
            sections.add(props);
            if (msgProps.getApplicationHeaders() != null) {
                sections.add(new ApplicationProperties(msgProps.getApplicationHeaders()));
            }
        }
        return new MessageMetaData_1_0(sections, sectionEncoder);
    }

    public String getType() {
        return "v0-10 to v1-0";
    }
}

