/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.protocol.converter.v0_10_v1_0;

import java.nio.ByteBuffer;
import org.apache.qpid.server.plugin.MessageConverter;
import org.apache.qpid.server.protocol.v0_10.MessageMetaData_0_10;
import org.apache.qpid.server.protocol.v0_10.MessageTransferMessage;
import org.apache.qpid.server.protocol.v1_0.MessageConverter_from_1_0;
import org.apache.qpid.server.protocol.v1_0.MessageMetaData_1_0;
import org.apache.qpid.server.protocol.v1_0.Message_1_0;
import org.apache.qpid.server.store.StoreFuture;
import org.apache.qpid.server.store.StoredMessage;
import org.apache.qpid.server.virtualhost.VirtualHost;
import org.apache.qpid.transport.DeliveryProperties;
import org.apache.qpid.transport.Header;
import org.apache.qpid.transport.MessageDeliveryPriority;
import org.apache.qpid.transport.MessageProperties;
import org.apache.qpid.transport.ReplyTo;

public class MessageConverter_1_0_to_v0_10
implements MessageConverter<Message_1_0, MessageTransferMessage> {
    public Class<Message_1_0> getInputClass() {
        return Message_1_0.class;
    }

    public Class<MessageTransferMessage> getOutputClass() {
        return MessageTransferMessage.class;
    }

    public MessageTransferMessage convert(Message_1_0 serverMsg, VirtualHost vhost) {
        return new MessageTransferMessage(this.convertToStoredMessage(serverMsg, vhost), null);
    }

    private StoredMessage<MessageMetaData_0_10> convertToStoredMessage(final Message_1_0 serverMsg, VirtualHost vhost) {
        Object bodyObject = MessageConverter_from_1_0.convertBodyToObject((Message_1_0)serverMsg);
        final byte[] messageContent = MessageConverter_from_1_0.convertToBody((Object)bodyObject);
        final MessageMetaData_0_10 messageMetaData_0_10 = this.convertMetaData(serverMsg, vhost, MessageConverter_from_1_0.getBodyMimeType((Object)bodyObject), messageContent.length);
        return new StoredMessage<MessageMetaData_0_10>(){

            public MessageMetaData_0_10 getMetaData() {
                return messageMetaData_0_10;
            }

            public long getMessageNumber() {
                return serverMsg.getMessageNumber();
            }

            public void addContent(int offsetInMessage, ByteBuffer src) {
                throw new UnsupportedOperationException();
            }

            public int getContent(int offsetInMessage, ByteBuffer dst) {
                int size = messageContent.length - offsetInMessage;
                if (dst.remaining() < size) {
                    size = dst.remaining();
                }
                ByteBuffer buf = ByteBuffer.wrap(messageContent, offsetInMessage, size);
                dst.put(buf);
                return size;
            }

            public ByteBuffer getContent(int offsetInMessage, int size) {
                return ByteBuffer.wrap(messageContent, offsetInMessage, size);
            }

            public StoreFuture flushToStore() {
                return StoreFuture.IMMEDIATE_FUTURE;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private MessageMetaData_0_10 convertMetaData(Message_1_0 serverMsg, VirtualHost vhost, String bodyMimeType, int size) {
        String origReplyTo;
        DeliveryProperties deliveryProps = new DeliveryProperties();
        MessageProperties messageProps = new MessageProperties();
        MessageMetaData_1_0.MessageHeader_1_0 origHeader = serverMsg.getMessageHeader();
        deliveryProps.setExpiration(serverMsg.getExpiration());
        deliveryProps.setPriority(MessageDeliveryPriority.get((short)origHeader.getPriority()));
        deliveryProps.setRoutingKey(serverMsg.getInitialRoutingAddress());
        deliveryProps.setTimestamp(origHeader.getTimestamp());
        messageProps.setContentEncoding(origHeader.getEncoding());
        messageProps.setContentLength((long)size);
        messageProps.setContentType(bodyMimeType);
        if (origHeader.getCorrelationId() != null) {
            messageProps.setCorrelationId(origHeader.getCorrelationId().getBytes());
        }
        if ((origReplyTo = origHeader.getReplyTo()) != null && !origReplyTo.equals("")) {
            ReplyTo replyTo;
            if (origReplyTo.startsWith("/")) {
                replyTo = new ReplyTo("", origReplyTo);
            } else if (origReplyTo.contains("/")) {
                String[] parts = origReplyTo.split("/", 2);
                replyTo = new ReplyTo(parts[0], parts[1]);
            } else {
                replyTo = vhost.getExchange(origReplyTo) != null ? new ReplyTo(origReplyTo, "") : new ReplyTo("", origReplyTo);
            }
            messageProps.setReplyTo(replyTo);
        }
        messageProps.setApplicationHeaders(serverMsg.getMessageHeader().getHeadersAsMap());
        Header header = new Header(deliveryProps, messageProps, null);
        return new MessageMetaData_0_10(header, size, serverMsg.getArrivalTime());
    }

    public String getType() {
        return "v1-0 to v0-10";
    }
}

