/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.services.hive;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ranger.plugin.client.HadoopException;
import org.apache.ranger.plugin.model.RangerService;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.service.RangerBaseService;
import org.apache.ranger.plugin.service.ResourceLookupContext;
import org.apache.ranger.services.hive.client.HiveResourceMgr;

public class RangerServiceHive
extends RangerBaseService {
    private static final Log LOG = LogFactory.getLog(RangerServiceHive.class);

    public void init(RangerServiceDef serviceDef, RangerService service) {
        super.init(serviceDef, service);
    }

    public HashMap<String, Object> validateConfig() throws Exception {
        HashMap<String, Object> ret = new HashMap<String, Object>();
        String serviceName = this.getServiceName();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerServiceHive.validateConfig Service: (" + serviceName + " )"));
        }
        if (this.configs != null) {
            try {
                ret = HiveResourceMgr.connectionTest(serviceName, this.configs);
            }
            catch (HadoopException e) {
                LOG.error((Object)("<== RangerServiceHive.validateConfig Error:" + (Object)((Object)e)));
                throw e;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerServiceHive.validateConfig Response : (" + ret + " )"));
        }
        return ret;
    }

    public List<String> lookupResource(ResourceLookupContext context) throws Exception {
        List<String> ret = new ArrayList<String>();
        String serviceName = this.getServiceName();
        String serviceType = this.getServiceType();
        Map configs = this.getConfigs();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerServiceHive.lookupResource Context: (" + context + ")"));
        }
        if (context != null) {
            try {
                ret = HiveResourceMgr.getHiveResources(serviceName, serviceType, configs, context);
            }
            catch (Exception e) {
                LOG.error((Object)("<==RangerServiceHive.lookupResource Error : " + e));
                throw e;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerServiceHive.lookupResource Response: (" + ret + ")"));
        }
        return ret;
    }
}

