/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.services.hive.client;

import java.io.Closeable;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLTimeoutException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.security.auth.Subject;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ranger.plugin.client.BaseClient;
import org.apache.ranger.plugin.client.HadoopException;

public class HiveClient
extends BaseClient
implements Closeable {
    private static final Log LOG = LogFactory.getLog(HiveClient.class);
    Connection con = null;
    boolean isKerberosAuth = false;

    public HiveClient(String serviceName) throws Exception {
        super(serviceName, null);
        this.initHive();
    }

    public HiveClient(String serviceName, Map<String, String> connectionProp) throws Exception {
        super(serviceName, connectionProp);
        this.initHive();
    }

    public void initHive() throws Exception {
        this.isKerberosAuth = this.getConfigHolder().isKerberosAuthentication();
        if (this.isKerberosAuth) {
            LOG.info((Object)"Secured Mode: JDBC Connection done with preAuthenticated Subject");
            Subject.doAs(this.getLoginSubject(), new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    HiveClient.this.initConnection();
                    return null;
                }
            });
        } else {
            LOG.info((Object)"Since Password is NOT provided, Trying to use UnSecure client with username and password");
            final String userName = this.getConfigHolder().getUserName();
            final String password = this.getConfigHolder().getPassword();
            Subject.doAs(this.getLoginSubject(), new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    HiveClient.this.initConnection(userName, password);
                    return null;
                }
            });
        }
    }

    public List<String> getDatabaseList(String databaseMatching, List<String> databaseList) throws HadoopException {
        final String dbMatching = databaseMatching;
        final List<String> dbList = databaseList;
        List<String> dblist = Subject.doAs(this.getLoginSubject(), new PrivilegedAction<List<String>>(){

            @Override
            public List<String> run() {
                List ret = null;
                try {
                    ret = HiveClient.this.getDBList(dbMatching, dbList);
                }
                catch (HadoopException he) {
                    LOG.error((Object)"<== HiveClient getDatabaseList() :Unable to get the Database List", (Throwable)he);
                    throw he;
                }
                return ret;
            }
        });
        return dblist;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private List<String> getDBList(String databaseMatching, List<String> dbList) throws HadoopException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> HiveClient getDBList databaseMatching : " + databaseMatching + " ExcludedbList :" + dbList));
        }
        ArrayList<String> ret = new ArrayList<String>();
        String errMsg = " You can still save the repository and start creating policies, but you would not be able to use autocomplete for resource names. Check ranger_admin.log for more info.";
        if (this.con != null) {
            Statement stat = null;
            ResultSet rs = null;
            String sql = "show databases";
            if (databaseMatching != null && !databaseMatching.isEmpty()) {
                sql = sql + " like \"" + databaseMatching + "\"";
            }
            try {
                stat = this.con.createStatement();
                rs = stat.executeQuery(sql);
                while (rs.next()) {
                    String dbName = rs.getString(1);
                    if (dbList != null && dbList.contains(dbName)) continue;
                    ret.add(rs.getString(1));
                }
                this.close(rs);
                this.close(stat);
            }
            catch (SQLTimeoutException sqlt) {
                try {
                    String msgDesc = "Time Out, Unable to execute SQL [" + sql + "].";
                    HadoopException hdpException = new HadoopException(msgDesc, (Throwable)sqlt);
                    hdpException.generateResponseDataMap(false, HiveClient.getMessage((Throwable)sqlt), msgDesc + errMsg, null, null);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"<== HiveClient.getDBList() Error : ", (Throwable)sqlt);
                    }
                    throw hdpException;
                    catch (SQLException sqle) {
                        msgDesc = "Unable to execute SQL [" + sql + "].";
                        hdpException = new HadoopException(msgDesc, (Throwable)sqle);
                        hdpException.generateResponseDataMap(false, HiveClient.getMessage((Throwable)sqle), msgDesc + errMsg, null, null);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)"<== HiveClient.getDBList() Error : ", (Throwable)sqle);
                        }
                        throw hdpException;
                    }
                }
                catch (Throwable throwable) {
                    this.close(rs);
                    this.close(stat);
                    throw throwable;
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== HiveClient.getDBList(): " + ret));
        }
        return ret;
    }

    public List<String> getTableList(String tableNameMatching, List<String> databaseList, List<String> tblNameList) throws HadoopException {
        final String tblNameMatching = tableNameMatching;
        final List<String> dbList = databaseList;
        final List<String> tblList = tblNameList;
        List<String> tableList = Subject.doAs(this.getLoginSubject(), new PrivilegedAction<List<String>>(){

            @Override
            public List<String> run() {
                List<String> ret = null;
                try {
                    ret = HiveClient.this.getTblList(tblNameMatching, dbList, tblList);
                }
                catch (HadoopException he) {
                    LOG.error((Object)"<== HiveClient getTblList() :Unable to get the Table List", (Throwable)he);
                    throw he;
                }
                return ret;
            }
        });
        return tableList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<String> getTblList(String tableNameMatching, List<String> dbList, List<String> tblList) throws HadoopException {
        ArrayList<String> ret;
        block16: {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("==> HiveClient getTableList() tableNameMatching : " + tableNameMatching + " ExcludedbList :" + dbList + "ExcludeTableList :" + tblList));
            }
            ret = new ArrayList<String>();
            String errMsg = " You can still save the repository and start creating policies, but you would not be able to use autocomplete for resource names. Check ranger_admin.log for more info.";
            if (this.con != null) {
                Statement stat = null;
                ResultSet rs = null;
                String sql = null;
                try {
                    if (dbList == null || dbList.isEmpty()) break block16;
                    for (String db : dbList) {
                        sql = "use " + db;
                        try {
                            stat = this.con.createStatement();
                            stat.execute(sql);
                        }
                        finally {
                            this.close(stat);
                            stat = null;
                        }
                        sql = "show tables ";
                        if (tableNameMatching != null && !tableNameMatching.isEmpty()) {
                            sql = sql + " like \"" + tableNameMatching + "\"";
                        }
                        try {
                            stat = this.con.createStatement();
                            rs = stat.executeQuery(sql);
                            while (rs.next()) {
                                String tblName = rs.getString(1);
                                if (tblList != null && tblList.contains(tblName)) continue;
                                ret.add(tblName);
                            }
                            this.close(rs);
                            this.close(stat);
                            rs = null;
                            stat = null;
                        }
                        catch (Throwable throwable) {
                            this.close(rs);
                            this.close(stat);
                            rs = null;
                            stat = null;
                            throw throwable;
                        }
                    }
                }
                catch (SQLTimeoutException sqlt) {
                    String msgDesc = "Time Out, Unable to execute SQL [" + sql + "].";
                    HadoopException hdpException = new HadoopException(msgDesc, (Throwable)sqlt);
                    hdpException.generateResponseDataMap(false, HiveClient.getMessage((Throwable)sqlt), msgDesc + errMsg, null, null);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"<== HiveClient.getTblList() Error : ", (Throwable)sqlt);
                    }
                    throw hdpException;
                }
                catch (SQLException sqle) {
                    String msgDesc = "Unable to execute SQL [" + sql + "].";
                    HadoopException hdpException = new HadoopException(msgDesc, (Throwable)sqle);
                    hdpException.generateResponseDataMap(false, HiveClient.getMessage((Throwable)sqle), msgDesc + errMsg, null, null);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)"<== HiveClient.getTblList() Error : ", (Throwable)sqle);
                    }
                    throw hdpException;
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== HiveClient getTableList() " + ret));
        }
        return ret;
    }

    public List<String> getViewList(String database, String viewNameMatching) {
        List<String> ret = null;
        return ret;
    }

    public List<String> getUDFList(String database, String udfMatching) {
        List<String> ret = null;
        return ret;
    }

    public List<String> getColumnList(String columnNameMatching, List<String> dbList, List<String> tblList, List<String> colList) throws HadoopException {
        final String clmNameMatching = columnNameMatching;
        final List<String> databaseList = dbList;
        final List<String> tableList = tblList;
        final List<String> clmList = colList;
        List<String> columnList = Subject.doAs(this.getLoginSubject(), new PrivilegedAction<List<String>>(){

            @Override
            public List<String> run() {
                List<String> ret = null;
                try {
                    ret = HiveClient.this.getClmList(clmNameMatching, databaseList, tableList, clmList);
                }
                catch (HadoopException he) {
                    LOG.error((Object)"<== HiveClient getColumnList() :Unable to get the Column List", (Throwable)he);
                    throw he;
                }
                return ret;
            }
        });
        return columnList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<String> getClmList(String columnNameMatching, List<String> dbList, List<String> tblList, List<String> colList) throws HadoopException {
        if (HiveClient.LOG.isDebugEnabled()) {
            HiveClient.LOG.debug((Object)("<== HiveClient.getClmList() columnNameMatching: " + columnNameMatching + " dbList :" + dbList + " tblList: " + tblList + " colList: " + colList));
        }
        ret = new ArrayList<String>();
        errMsg = " You can still save the repository and start creating policies, but you would not be able to use autocomplete for resource names. Check ranger_admin.log for more info.";
        if (this.con == null) ** GOTO lbl16
        columnNameMatchingRegEx = null;
        if (columnNameMatching != null && !columnNameMatching.isEmpty()) {
            columnNameMatchingRegEx = columnNameMatching;
        }
        stat = null;
        rs = null;
        sql = null;
        if (dbList == null || dbList.isEmpty() || tblList == null || tblList.isEmpty()) ** GOTO lbl16
        var11_11 = dbList.iterator();
        block8: while (true) {
            block21: {
                if (var11_11.hasNext()) break block21;
lbl16:
                // 3 sources

                if (HiveClient.LOG.isDebugEnabled()) {
                    HiveClient.LOG.debug((Object)("<== HiveClient.getClmList() " + ret));
                }
                return ret;
            }
            db = var11_11.next();
            var13_13 = tblList.iterator();
            while (true) {
                if (!var13_13.hasNext()) continue block8;
                tbl = var13_13.next();
                try {
                    sql = "use " + db;
                    try {
                        stat = this.con.createStatement();
                        stat.execute(sql);
                    }
                    finally {
                        this.close(stat);
                    }
                    sql = "describe  " + tbl;
                    stat = this.con.createStatement();
                    rs = stat.executeQuery(sql);
                    while (rs.next()) {
                        columnName = rs.getString(1);
                        if (colList != null && colList.contains(columnName)) continue;
                        if (columnNameMatchingRegEx == null) {
                            ret.add(columnName);
                            continue;
                        }
                        if (!FilenameUtils.wildcardMatch((String)columnName, (String)columnNameMatchingRegEx)) continue;
                        ret.add(columnName);
                    }
                    this.close(rs);
                    this.close(stat);
                }
                catch (SQLTimeoutException sqlt) {
                    try {
                        msgDesc = "Time Out, Unable to execute SQL [" + sql + "].";
                        hdpException = new HadoopException(msgDesc, (Throwable)sqlt);
                        hdpException.generateResponseDataMap(false, HiveClient.getMessage((Throwable)sqlt), msgDesc + errMsg, null, null);
                        if (HiveClient.LOG.isDebugEnabled()) {
                            HiveClient.LOG.debug((Object)"<== HiveClient.getClmList() Error : ", (Throwable)sqlt);
                        }
                        throw hdpException;
                        catch (SQLException sqle) {
                            msgDesc = "Unable to execute SQL [" + sql + "].";
                            hdpException = new HadoopException(msgDesc, (Throwable)sqle);
                            hdpException.generateResponseDataMap(false, HiveClient.getMessage((Throwable)sqle), msgDesc + errMsg, null, null);
                            if (HiveClient.LOG.isDebugEnabled()) {
                                HiveClient.LOG.debug((Object)"<== HiveClient.getClmList() Error : ", (Throwable)sqle);
                            }
                            throw hdpException;
                        }
                    }
                    catch (Throwable var18_23) {
                        this.close(rs);
                        this.close(stat);
                        throw var18_23;
                    }
                }
            }
            break;
        }
    }

    @Override
    public void close() {
        Subject.doAs(this.getLoginSubject(), new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                HiveClient.this.close(HiveClient.this.con);
                return null;
            }
        });
    }

    private void close(Statement aStat) {
        try {
            if (aStat != null) {
                aStat.close();
            }
        }
        catch (SQLException e) {
            LOG.error((Object)"Unable to close SQL statement", (Throwable)e);
        }
    }

    private void close(ResultSet aResultSet) {
        try {
            if (aResultSet != null) {
                aResultSet.close();
            }
        }
        catch (SQLException e) {
            LOG.error((Object)"Unable to close ResultSet", (Throwable)e);
        }
    }

    private void close(Connection aCon) {
        try {
            if (aCon != null) {
                aCon.close();
            }
        }
        catch (SQLException e) {
            LOG.error((Object)"Unable to close SQL Connection", (Throwable)e);
        }
    }

    private void initConnection() throws HadoopException {
        try {
            this.initConnection(null, null);
        }
        catch (HadoopException he) {
            LOG.error((Object)"Unable to Connect to Hive", (Throwable)he);
            throw he;
        }
    }

    private void initConnection(String userName, String password) throws HadoopException {
        Properties prop = this.getConfigHolder().getRangerSection();
        String driverClassName = prop.getProperty("jdbc.driverClassName");
        String url = prop.getProperty("jdbc.url");
        String errMsg = " You can still save the repository and start creating policies, but you would not be able to use autocomplete for resource names. Check ranger_admin.log for more info.";
        if (driverClassName != null) {
            try {
                Driver driver = (Driver)Class.forName(driverClassName).newInstance();
                DriverManager.registerDriver(driver);
            }
            catch (SQLException e) {
                String msgDesc = "initConnection: Caught SQLException while registering Hive driver, so Unable to connect to Hive Thrift Server instance.";
                HadoopException hdpException = new HadoopException(msgDesc, (Throwable)e);
                hdpException.generateResponseDataMap(false, HiveClient.getMessage((Throwable)e), msgDesc + errMsg, null, null);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)msgDesc, (Throwable)hdpException);
                }
                throw hdpException;
            }
            catch (IllegalAccessException ilae) {
                String msgDesc = "initConnection: Class or its nullary constructor might not accessible.So unable to initiate connection to hive thrift server instance.";
                HadoopException hdpException = new HadoopException(msgDesc, (Throwable)ilae);
                hdpException.generateResponseDataMap(false, HiveClient.getMessage((Throwable)ilae), msgDesc + errMsg, null, null);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)msgDesc, (Throwable)hdpException);
                }
                throw hdpException;
            }
            catch (InstantiationException ie) {
                String msgDesc = "initConnection: Class may not have its nullary constructor or may be the instantiation fails for some other reason.So unable to initiate connection to hive thrift server instance.";
                HadoopException hdpException = new HadoopException(msgDesc, (Throwable)ie);
                hdpException.generateResponseDataMap(false, HiveClient.getMessage((Throwable)ie), msgDesc + errMsg, null, null);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)msgDesc, (Throwable)hdpException);
                }
                throw hdpException;
            }
            catch (ExceptionInInitializerError eie) {
                String msgDesc = "initConnection: Got ExceptionInInitializerError, The initialization provoked by this method fails.So unable to initiate connection to hive thrift server instance.";
                HadoopException hdpException = new HadoopException(msgDesc, (Throwable)eie);
                hdpException.generateResponseDataMap(false, HiveClient.getMessage((Throwable)eie), msgDesc + errMsg, null, null);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)msgDesc, (Throwable)hdpException);
                }
                throw hdpException;
            }
            catch (SecurityException se) {
                String msgDesc = "initConnection: unable to initiate connection to hive thrift server instance, The caller's class loader is not the same as or an ancestor of the class loader for the current class and invocation of s.checkPackageAccess() denies access to the package of this class.";
                HadoopException hdpException = new HadoopException(msgDesc, (Throwable)se);
                hdpException.generateResponseDataMap(false, HiveClient.getMessage((Throwable)se), msgDesc + errMsg, null, null);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)msgDesc, (Throwable)hdpException);
                }
                throw hdpException;
            }
            catch (Throwable t) {
                String msgDesc = "initConnection: Unable to connect to Hive Thrift Server instance, please provide valid value of field : {jdbc.driverClassName}.";
                HadoopException hdpException = new HadoopException(msgDesc, t);
                hdpException.generateResponseDataMap(false, HiveClient.getMessage((Throwable)t), msgDesc + errMsg, null, "jdbc.driverClassName");
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)msgDesc, (Throwable)hdpException);
                }
                throw hdpException;
            }
        }
        try {
            this.con = userName == null && password == null ? DriverManager.getConnection(url) : DriverManager.getConnection(url, userName, password);
        }
        catch (SQLException e) {
            String msgDesc = "Unable to connect to Hive Thrift Server instance.";
            HadoopException hdpException = new HadoopException(msgDesc, (Throwable)e);
            hdpException.generateResponseDataMap(false, HiveClient.getMessage((Throwable)e), msgDesc + errMsg, null, null);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)msgDesc, (Throwable)hdpException);
            }
            throw hdpException;
        }
        catch (SecurityException se) {
            String msgDesc = "Unable to connect to Hive Thrift Server instance.";
            HadoopException hdpException = new HadoopException(msgDesc, (Throwable)se);
            hdpException.generateResponseDataMap(false, HiveClient.getMessage((Throwable)se), msgDesc + errMsg, null, null);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)msgDesc, (Throwable)hdpException);
            }
            throw hdpException;
        }
        catch (Throwable t) {
            String msgDesc = "Unable to connect to Hive Thrift Server instance";
            HadoopException hdpException = new HadoopException(msgDesc, t);
            hdpException.generateResponseDataMap(false, HiveClient.getMessage((Throwable)t), msgDesc + errMsg, null, url);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)msgDesc, (Throwable)hdpException);
            }
            throw hdpException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        block23: {
            HiveClient hc = null;
            if (args.length == 0) {
                System.err.println("USAGE: java " + HiveClient.class.getName() + " dataSourceName <databaseName> <tableName> <columnName>");
                System.exit(1);
            }
            try {
                hc = new HiveClient(args[0]);
                if (args.length == 2) {
                    List<String> dbList = null;
                    try {
                        dbList = hc.getDatabaseList(args[1], null);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    if (CollectionUtils.isEmpty(dbList)) {
                        System.out.println("No database found with db filter [" + args[1] + "]");
                    } else if (CollectionUtils.isNotEmpty(dbList)) {
                        for (String str : dbList) {
                            System.out.println("database: " + str);
                        }
                    }
                    break block23;
                }
                if (args.length == 3) {
                    List<String> tableList = hc.getTableList(args[2], null, null);
                    if (tableList.size() == 0) {
                        System.out.println("No tables found under database[" + args[1] + "] with table filter [" + args[2] + "]");
                    } else {
                        for (String str : tableList) {
                            System.out.println("Table: " + str);
                        }
                    }
                } else if (args.length == 4) {
                    List<String> columnList = hc.getColumnList(args[3], null, null, null);
                    if (columnList.size() == 0) {
                        System.out.println("No columns found for db:" + args[1] + ", table: [" + args[2] + "], with column filter [" + args[3] + "]");
                    } else {
                        for (String str : columnList) {
                            System.out.println("Column: " + str);
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            finally {
                if (hc != null) {
                    hc.close();
                }
            }
        }
    }

    public static HashMap<String, Object> connectionTest(String serviceName, Map<String, String> connectionProperties) throws Exception {
        HiveClient connectionObj = null;
        HashMap<String, Object> responseData = new HashMap<String, Object>();
        boolean connectivityStatus = false;
        String errMsg = " You can still save the repository and start creating policies, but you would not be able to use autocomplete for resource names. Check ranger_admin.log for more info.";
        List<String> testResult = null;
        try {
            connectionObj = new HiveClient(serviceName, connectionProperties);
            if (connectionObj != null) {
                testResult = connectionObj.getDatabaseList("*", null);
                if (testResult != null && testResult.size() != 0) {
                    connectivityStatus = true;
                }
                if (connectivityStatus) {
                    String successMsg = "ConnectionTest Successful";
                    HiveClient.generateResponseDataMap((boolean)connectivityStatus, (String)successMsg, (String)successMsg, null, null, responseData);
                } else {
                    String failureMsg = "Unable to retrieve any databases using given parameters.";
                    HiveClient.generateResponseDataMap((boolean)connectivityStatus, (String)failureMsg, (String)(failureMsg + errMsg), null, null, responseData);
                }
            }
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (connectionObj != null) {
                connectionObj.close();
            }
        }
        return responseData;
    }
}

