/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.hive.authorizer;

import com.google.common.collect.Sets;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.security.HiveAuthenticationProvider;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAccessControlException;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthzContext;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthzPluginException;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthzSessionContext;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveMetastoreClientFactory;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveOperationType;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrincipal;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilege;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilegeObject;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.ranger.authorization.hive.authorizer.HiveAccessType;
import org.apache.ranger.authorization.hive.authorizer.HiveObjectType;
import org.apache.ranger.authorization.hive.authorizer.RangerHiveAccessRequest;
import org.apache.ranger.authorization.hive.authorizer.RangerHiveAuditHandler;
import org.apache.ranger.authorization.hive.authorizer.RangerHiveAuthorizerBase;
import org.apache.ranger.authorization.hive.authorizer.RangerHivePlugin;
import org.apache.ranger.authorization.hive.authorizer.RangerHiveResource;
import org.apache.ranger.authorization.utils.StringUtil;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerAccessResource;
import org.apache.ranger.plugin.policyengine.RangerAccessResult;
import org.apache.ranger.plugin.policyengine.RangerAccessResultProcessor;
import org.apache.ranger.plugin.policyengine.RangerDataMaskResult;
import org.apache.ranger.plugin.policyengine.RangerRowFilterResult;
import org.apache.ranger.plugin.util.GrantRevokeRequest;
import org.apache.ranger.plugin.util.RangerAccessRequestUtil;
import org.apache.ranger.plugin.util.RangerRequestedResources;

public class RangerHiveAuthorizer
extends RangerHiveAuthorizerBase {
    private static final Log LOG = LogFactory.getLog(RangerHiveAuthorizer.class);
    private static final char COLUMN_SEP = ',';
    private static volatile RangerHivePlugin hivePlugin = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public RangerHiveAuthorizer(HiveMetastoreClientFactory metastoreClientFactory, HiveConf hiveConf, HiveAuthenticationProvider hiveAuthenticator, HiveAuthzSessionContext sessionContext) {
        super(metastoreClientFactory, hiveConf, hiveAuthenticator, sessionContext);
        LOG.debug((Object)"RangerHiveAuthorizer.RangerHiveAuthorizer()");
        RangerHivePlugin plugin = hivePlugin;
        if (plugin != null) return;
        Class<RangerHiveAuthorizer> clazz = RangerHiveAuthorizer.class;
        synchronized (RangerHiveAuthorizer.class) {
            plugin = hivePlugin;
            if (plugin != null) return;
            String appType = "unknown";
            if (sessionContext != null) {
                switch (sessionContext.getClientType()) {
                    case HIVECLI: {
                        appType = "hiveCLI";
                        break;
                    }
                    case HIVESERVER2: {
                        appType = "hiveServer2";
                    }
                }
            }
            plugin = new RangerHivePlugin(appType);
            plugin.init();
            hivePlugin = plugin;
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return;
        }
    }

    public void grantPrivileges(List<HivePrincipal> hivePrincipals, List<HivePrivilege> hivePrivileges, HivePrivilegeObject hivePrivObject, HivePrincipal grantorPrincipal, boolean grantOption) throws HiveAuthzPluginException, HiveAccessControlException {
        if (!RangerHivePlugin.UpdateXaPoliciesOnGrantRevoke) {
            throw new HiveAuthzPluginException("GRANT/REVOKE not supported in Ranger HiveAuthorizer. Please use Ranger Security Admin to setup access control.");
        }
        RangerHiveAuditHandler auditHandler = new RangerHiveAuditHandler();
        try {
            RangerHiveResource resource = this.getHiveResource(HiveOperationType.GRANT_PRIVILEGE, hivePrivObject);
            GrantRevokeRequest request = this.createGrantRevokeData(resource, hivePrincipals, hivePrivileges, grantorPrincipal, grantOption);
            LOG.info((Object)("grantPrivileges(): " + request));
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("grantPrivileges(): " + request));
            }
            hivePlugin.grantAccess(request, (RangerAccessResultProcessor)auditHandler);
        }
        catch (Exception excp) {
            throw new HiveAccessControlException((Throwable)excp);
        }
        finally {
            auditHandler.flushAudit();
        }
    }

    public void revokePrivileges(List<HivePrincipal> hivePrincipals, List<HivePrivilege> hivePrivileges, HivePrivilegeObject hivePrivObject, HivePrincipal grantorPrincipal, boolean grantOption) throws HiveAuthzPluginException, HiveAccessControlException {
        if (!RangerHivePlugin.UpdateXaPoliciesOnGrantRevoke) {
            throw new HiveAuthzPluginException("GRANT/REVOKE not supported in Ranger HiveAuthorizer. Please use Ranger Security Admin to setup access control.");
        }
        RangerHiveAuditHandler auditHandler = new RangerHiveAuditHandler();
        try {
            RangerHiveResource resource = this.getHiveResource(HiveOperationType.REVOKE_PRIVILEGE, hivePrivObject);
            GrantRevokeRequest request = this.createGrantRevokeData(resource, hivePrincipals, hivePrivileges, grantorPrincipal, grantOption);
            LOG.info((Object)("revokePrivileges(): " + request));
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("revokePrivileges(): " + request));
            }
            hivePlugin.revokeAccess(request, (RangerAccessResultProcessor)auditHandler);
        }
        catch (Exception excp) {
            throw new HiveAccessControlException((Throwable)excp);
        }
        finally {
            auditHandler.flushAudit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkPrivileges(HiveOperationType hiveOpType, List<HivePrivilegeObject> inputHObjs, List<HivePrivilegeObject> outputHObjs, HiveAuthzContext context) throws HiveAuthzPluginException, HiveAccessControlException {
        UserGroupInformation ugi = this.getCurrentUserGroupInfo();
        if (ugi == null) {
            throw new HiveAccessControlException("Permission denied: user information not available");
        }
        RangerHiveAuditHandler auditHandler = new RangerHiveAuditHandler();
        try {
            RangerHiveAccessRequest request;
            HiveAccessType accessType;
            String path;
            FsAction permission;
            RangerHiveResource resource;
            HiveAuthzSessionContext sessionContext = this.getHiveAuthzSessionContext();
            String user = ugi.getShortUserName();
            HashSet groups = Sets.newHashSet((Object[])ugi.getGroupNames());
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)this.toString(hiveOpType, inputHObjs, outputHObjs, context, sessionContext));
            }
            if (hiveOpType == HiveOperationType.DFS) {
                this.handleDfsCommand(hiveOpType, inputHObjs, user, auditHandler);
                return;
            }
            ArrayList<RangerHiveAccessRequest> requests = new ArrayList<RangerHiveAccessRequest>();
            if (!CollectionUtils.isEmpty(inputHObjs)) {
                for (HivePrivilegeObject hiveObj : inputHObjs) {
                    resource = this.getHiveResource(hiveOpType, hiveObj);
                    if (resource == null) continue;
                    if (resource.getObjectType() == HiveObjectType.URI) {
                        permission = FsAction.READ;
                        path = hiveObj.getObjectName();
                        if (this.isURIAccessAllowed(user, permission, path, this.getHiveConf())) continue;
                        throw new HiveAccessControlException(String.format("Permission denied: user [%s] does not have [%s] privilege on [%s]", user, permission.name(), path));
                    }
                    accessType = this.getAccessType(hiveObj, hiveOpType, true);
                    if (accessType == HiveAccessType.NONE || this.existsByResourceAndAccessType(requests, resource, accessType)) continue;
                    request = new RangerHiveAccessRequest(resource, user, (Set<String>)groups, hiveOpType, accessType, context, sessionContext);
                    requests.add(request);
                }
            } else if (hiveOpType == HiveOperationType.SHOWDATABASES) {
                RangerHiveResource resource2 = new RangerHiveResource(HiveObjectType.DATABASE, null);
                RangerHiveAccessRequest request2 = new RangerHiveAccessRequest(resource2, user, (Set<String>)groups, hiveOpType.name(), HiveAccessType.USE, context, sessionContext);
                requests.add(request2);
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("RangerHiveAuthorizer.checkPrivileges: Unexpected operation type[" + hiveOpType + "] received with empty input objects list!"));
            }
            if (!CollectionUtils.isEmpty(outputHObjs)) {
                for (HivePrivilegeObject hiveObj : outputHObjs) {
                    resource = this.getHiveResource(hiveOpType, hiveObj);
                    if (resource == null) continue;
                    if (resource.getObjectType() == HiveObjectType.URI) {
                        permission = FsAction.WRITE;
                        path = hiveObj.getObjectName();
                        if (this.isURIAccessAllowed(user, permission, path, this.getHiveConf())) continue;
                        throw new HiveAccessControlException(String.format("Permission denied: user [%s] does not have [%s] privilege on [%s]", user, permission.name(), path));
                    }
                    accessType = this.getAccessType(hiveObj, hiveOpType, false);
                    if (accessType == HiveAccessType.NONE || this.existsByResourceAndAccessType(requests, resource, accessType)) continue;
                    request = new RangerHiveAccessRequest(resource, user, (Set<String>)groups, hiveOpType, accessType, context, sessionContext);
                    requests.add(request);
                }
            }
            this.buildRequestContextWithAllAccessedResources(requests);
            for (RangerHiveAccessRequest request2 : requests) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("request: " + (Object)((Object)request2)));
                }
                resource = (RangerHiveResource)request2.getResource();
                RangerAccessResult result = null;
                if (resource.getObjectType() == HiveObjectType.COLUMN && StringUtils.contains((String)resource.getColumn(), (char)',')) {
                    ArrayList<RangerHiveAccessRequest> colRequests = new ArrayList<RangerHiveAccessRequest>();
                    String[] columns = StringUtils.split((String)resource.getColumn(), (char)',');
                    resource.setServiceDef(hivePlugin.getServiceDef());
                    for (String column : columns) {
                        if (column != null) {
                            column = column.trim();
                        }
                        if (StringUtils.isBlank((String)column)) continue;
                        RangerHiveResource colResource = new RangerHiveResource(HiveObjectType.COLUMN, resource.getDatabase(), resource.getTable(), column);
                        RangerHiveAccessRequest colRequest = request2.copy();
                        colRequest.setResource((RangerAccessResource)colResource);
                        colRequests.add(colRequest);
                    }
                    Collection colResults = hivePlugin.isAccessAllowed(colRequests, (RangerAccessResultProcessor)auditHandler);
                    if (colResults != null) {
                        RangerAccessResult colResult;
                        Iterator iterator = colResults.iterator();
                        while (iterator.hasNext() && (result = (colResult = (RangerAccessResult)iterator.next())).getIsAllowed()) {
                        }
                    }
                } else {
                    RangerHiveResource res;
                    result = hivePlugin.isAccessAllowed((RangerAccessRequest)request2, (RangerAccessResultProcessor)auditHandler);
                    if (result != null && result.getIsAllowed() && this.blockAccessIfRowfilterColumnMaskSpecified(hiveOpType, request2.getHiveAccessType()) && ((res = (RangerHiveResource)request2.getResource()).getObjectType() == HiveObjectType.TABLE || res.getObjectType() == HiveObjectType.VIEW)) {
                        HiveAccessType savedAccessType = request2.getHiveAccessType();
                        request2.setHiveAccessType(HiveAccessType.SELECT);
                        RangerRowFilterResult rowFilterResult = this.getRowFilterResult(request2);
                        if (this.isRowFilterEnabled(rowFilterResult)) {
                            result.setIsAllowed(false);
                            result.setPolicyId(rowFilterResult.getPolicyId());
                            result.setReason("User does not have acces to all rows of the table");
                        } else {
                            request2.setResourceMatchingScope(RangerAccessRequest.ResourceMatchingScope.SELF_OR_DESCENDANTS);
                            RangerDataMaskResult dataMaskResult = this.getDataMaskResult(request2);
                            if (this.isDataMaskEnabled(dataMaskResult)) {
                                result.setIsAllowed(false);
                                result.setPolicyId(dataMaskResult.getPolicyId());
                                result.setReason("User does not have acces to unmasked column values");
                            }
                        }
                        request2.setHiveAccessType(savedAccessType);
                        if (!result.getIsAllowed()) {
                            auditHandler.processResult(result);
                        }
                    }
                }
                if (result == null || result.getIsAllowed()) continue;
                String path2 = resource.getAsString();
                throw new HiveAccessControlException(String.format("Permission denied: user [%s] does not have [%s] privilege on [%s]", user, request2.getHiveAccessType().name(), path2));
            }
        }
        finally {
            auditHandler.flushAudit();
        }
    }

    public List<HivePrivilegeObject> filterListCmdObjects(List<HivePrivilegeObject> objs, HiveAuthzContext context) throws HiveAuthzPluginException, HiveAccessControlException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("==> filterListCmdObjects(%s, %s)", objs, context));
        }
        List<HivePrivilegeObject> ret = null;
        if (objs == null) {
            LOG.debug((Object)"filterListCmdObjects: meta objects list was null!");
        } else if (objs.isEmpty()) {
            LOG.debug((Object)"filterListCmdObjects: meta objects list was empty!");
            ret = objs;
        } else if (this.getCurrentUserGroupInfo() == null) {
            LOG.warn((Object)"filterListCmdObjects: user information not available");
            ret = objs;
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("filterListCmdObjects: number of input objects[" + objs.size() + "]"));
            }
            UserGroupInformation ugi = this.getCurrentUserGroupInfo();
            HiveAuthzSessionContext sessionContext = this.getHiveAuthzSessionContext();
            String user = ugi.getShortUserName();
            HashSet groups = Sets.newHashSet((Object[])ugi.getGroupNames());
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)String.format("filterListCmdObjects: user[%s], groups%s", user, groups));
            }
            if (ret == null) {
                ret = new ArrayList<HivePrivilegeObject>(objs.size());
            }
            for (HivePrivilegeObject privilegeObject : objs) {
                RangerHiveResource resource;
                if (LOG.isDebugEnabled()) {
                    HivePrivilegeObject.HivePrivObjectActionType actionType = privilegeObject.getActionType();
                    HivePrivilegeObject.HivePrivilegeObjectType objectType = privilegeObject.getType();
                    String objectName = privilegeObject.getObjectName();
                    String dbName = privilegeObject.getDbname();
                    List columns = privilegeObject.getColumns();
                    List partitionKeys = privilegeObject.getPartKeys();
                    String commandString = context == null ? null : context.getCommandString();
                    String ipAddress = context == null ? null : context.getIpAddress();
                    String format = "filterListCmdObjects: actionType[%s], objectType[%s], objectName[%s], dbName[%s], columns[%s], partitionKeys[%s]; context: commandString[%s], ipAddress[%s]";
                    LOG.debug((Object)String.format("filterListCmdObjects: actionType[%s], objectType[%s], objectName[%s], dbName[%s], columns[%s], partitionKeys[%s]; context: commandString[%s], ipAddress[%s]", actionType, objectType, objectName, dbName, columns, partitionKeys, commandString, ipAddress));
                }
                if ((resource = this.createHiveResource(privilegeObject)) == null) {
                    LOG.error((Object)"filterListCmdObjects: RangerHiveResource returned by createHiveResource is null");
                    continue;
                }
                RangerHiveAccessRequest request = new RangerHiveAccessRequest(resource, user, groups, context, sessionContext);
                RangerAccessResult result = hivePlugin.isAccessAllowed((RangerAccessRequest)request);
                if (result == null) {
                    LOG.error((Object)"filterListCmdObjects: Internal error: null RangerAccessResult object received back from isAccessAllowed()!");
                    continue;
                }
                if (!result.getIsAllowed()) {
                    if (LOG.isDebugEnabled()) continue;
                    String path = resource.getAsString();
                    LOG.debug((Object)String.format("filterListCmdObjects: Permission denied: user [%s] does not have [%s] privilege on [%s]. resource[%s], request[%s], result[%s]", new Object[]{user, request.getHiveAccessType().name(), path, resource, request, result}));
                    continue;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)String.format("filterListCmdObjects: access allowed. resource[%s], request[%s], result[%s]", new Object[]{resource, request, result}));
                }
                ret.add(privilegeObject);
            }
        }
        if (LOG.isDebugEnabled()) {
            int count = ret == null ? 0 : ret.size();
            LOG.debug((Object)String.format("<== filterListCmdObjects: count[%d], ret[%s]", count, ret));
        }
        return ret;
    }

    public List<HivePrivilegeObject> applyRowFilterAndColumnMasking(HiveAuthzContext queryContext, List<HivePrivilegeObject> hiveObjs) throws SemanticException {
        ArrayList<HivePrivilegeObject> ret = new ArrayList<HivePrivilegeObject>();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> applyRowFilterAndColumnMasking(" + queryContext + ", objCount=" + hiveObjs.size() + ")"));
        }
        if (CollectionUtils.isNotEmpty(hiveObjs)) {
            for (HivePrivilegeObject hiveObj : hiveObjs) {
                HivePrivilegeObject.HivePrivilegeObjectType hiveObjType = hiveObj.getType();
                if (hiveObjType == null) {
                    hiveObjType = HivePrivilegeObject.HivePrivilegeObjectType.TABLE_OR_VIEW;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("applyRowFilterAndColumnMasking(hiveObjType=" + hiveObjType + ")"));
                }
                if (hiveObjType == HivePrivilegeObject.HivePrivilegeObjectType.TABLE_OR_VIEW) {
                    String table;
                    String database = hiveObj.getDbname();
                    String rowFilterExpr = this.getRowFilterExpression(queryContext, database, table = hiveObj.getObjectName());
                    if (StringUtils.isNotBlank((String)rowFilterExpr)) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("rowFilter(database=" + database + ", table=" + table + "): " + rowFilterExpr));
                        }
                        hiveObj.setRowFilterExpression(rowFilterExpr);
                    }
                    if (CollectionUtils.isNotEmpty((Collection)hiveObj.getColumns())) {
                        ArrayList<String> columnTransformers = new ArrayList<String>();
                        for (String column : hiveObj.getColumns()) {
                            String columnTransformer = this.getCellValueTransformer(queryContext, database, table, column);
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)("columnTransformer(database=" + database + ", table=" + table + ", column=" + column + "): " + columnTransformer));
                            }
                            columnTransformers.add(columnTransformer);
                        }
                        hiveObj.setCellValueTransformers(columnTransformers);
                    }
                }
                ret.add(hiveObj);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== applyRowFilterAndColumnMasking(" + queryContext + ", objCount=" + hiveObjs.size() + "): retCount=" + ret.size()));
        }
        return ret;
    }

    public boolean needTransform() {
        return true;
    }

    private RangerDataMaskResult getDataMaskResult(RangerHiveAccessRequest request) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> getDataMaskResult(request=" + (Object)((Object)request) + ")"));
        }
        RangerDataMaskResult ret = hivePlugin.evalDataMaskPolicies((RangerAccessRequest)request, null);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== getDataMaskResult(request=" + (Object)((Object)request) + "): ret=" + ret));
        }
        return ret;
    }

    private RangerRowFilterResult getRowFilterResult(RangerHiveAccessRequest request) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> getRowFilterResult(request=" + (Object)((Object)request) + ")"));
        }
        RangerRowFilterResult ret = hivePlugin.evalRowFilterPolicies((RangerAccessRequest)request, null);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== getRowFilterResult(request=" + (Object)((Object)request) + "): ret=" + ret));
        }
        return ret;
    }

    private boolean isDataMaskEnabled(RangerDataMaskResult result) {
        return result != null && result.isMaskEnabled() && !StringUtils.equalsIgnoreCase((String)result.getMaskType(), (String)"MASK_NONE");
    }

    private boolean isRowFilterEnabled(RangerRowFilterResult result) {
        return result != null && result.isRowFilterEnabled() && StringUtils.isNotEmpty((String)result.getFilterExpr());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getRowFilterExpression(HiveAuthzContext context, String databaseName, String tableOrViewName) throws SemanticException {
        UserGroupInformation ugi = this.getCurrentUserGroupInfo();
        if (ugi == null) {
            throw new SemanticException("user information not available");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> getRowFilterExpression(" + databaseName + ", " + tableOrViewName + ")"));
        }
        String ret = null;
        RangerHiveAuditHandler auditHandler = new RangerHiveAuditHandler();
        try {
            HiveAuthzSessionContext sessionContext = this.getHiveAuthzSessionContext();
            String user = ugi.getShortUserName();
            HashSet groups = Sets.newHashSet((Object[])ugi.getGroupNames());
            HiveObjectType objectType = HiveObjectType.TABLE;
            RangerHiveResource resource = new RangerHiveResource(objectType, databaseName, tableOrViewName);
            RangerHiveAccessRequest request = new RangerHiveAccessRequest(resource, user, (Set<String>)groups, objectType.name(), HiveAccessType.SELECT, context, sessionContext);
            RangerRowFilterResult result = hivePlugin.evalRowFilterPolicies((RangerAccessRequest)request, (RangerAccessResultProcessor)auditHandler);
            if (this.isRowFilterEnabled(result)) {
                ret = result.getFilterExpr();
            }
        }
        finally {
            auditHandler.flushAudit();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== getRowFilterExpression(" + databaseName + ", " + tableOrViewName + "): " + ret));
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getCellValueTransformer(HiveAuthzContext context, String databaseName, String tableOrViewName, String columnName) throws SemanticException {
        UserGroupInformation ugi = this.getCurrentUserGroupInfo();
        if (ugi == null) {
            throw new SemanticException("user information not available");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> getCellValueTransformer(" + databaseName + ", " + tableOrViewName + ", " + columnName + ")"));
        }
        String ret = columnName;
        RangerHiveAuditHandler auditHandler = new RangerHiveAuditHandler();
        try {
            HiveAuthzSessionContext sessionContext = this.getHiveAuthzSessionContext();
            String user = ugi.getShortUserName();
            HashSet groups = Sets.newHashSet((Object[])ugi.getGroupNames());
            HiveObjectType objectType = HiveObjectType.COLUMN;
            RangerHiveResource resource = new RangerHiveResource(objectType, databaseName, tableOrViewName, columnName);
            RangerHiveAccessRequest request = new RangerHiveAccessRequest(resource, user, (Set<String>)groups, objectType.name(), HiveAccessType.SELECT, context, sessionContext);
            RangerDataMaskResult result = hivePlugin.evalDataMaskPolicies((RangerAccessRequest)request, (RangerAccessResultProcessor)auditHandler);
            if (this.isDataMaskEnabled(result)) {
                String maskType = result.getMaskType();
                RangerServiceDef.RangerDataMaskTypeDef maskTypeDef = result.getMaskTypeDef();
                String transformer = null;
                if (maskTypeDef != null) {
                    transformer = maskTypeDef.getTransformer();
                }
                if (StringUtils.equalsIgnoreCase((String)maskType, (String)"MASK_NULL")) {
                    ret = "NULL";
                } else if (StringUtils.equalsIgnoreCase((String)maskType, (String)"CUSTOM")) {
                    String maskedValue = result.getMaskedValue();
                    ret = maskedValue == null ? "NULL" : maskedValue.replace("{col}", columnName);
                } else if (StringUtils.isNotEmpty((String)transformer)) {
                    ret = transformer.replace("{col}", columnName);
                }
            }
        }
        finally {
            auditHandler.flushAudit();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== getCellValueTransformer(" + databaseName + ", " + tableOrViewName + ", " + columnName + "): " + ret));
        }
        return ret;
    }

    RangerHiveResource createHiveResource(HivePrivilegeObject privilegeObject) {
        RangerHiveResource resource = null;
        HivePrivilegeObject.HivePrivilegeObjectType objectType = privilegeObject.getType();
        String objectName = privilegeObject.getObjectName();
        String dbName = privilegeObject.getDbname();
        switch (objectType) {
            case DATABASE: {
                resource = new RangerHiveResource(HiveObjectType.DATABASE, objectName);
                break;
            }
            case TABLE_OR_VIEW: {
                resource = new RangerHiveResource(HiveObjectType.TABLE, dbName, objectName);
                break;
            }
            default: {
                LOG.warn((Object)("RangerHiveAuthorizer.getHiveResource: unexpected objectType:" + objectType));
            }
        }
        if (resource != null) {
            resource.setServiceDef(hivePlugin == null ? null : hivePlugin.getServiceDef());
        }
        return resource;
    }

    private RangerHiveResource getHiveResource(HiveOperationType hiveOpType, HivePrivilegeObject hiveObj) {
        RangerHiveResource ret = null;
        HiveObjectType objectType = this.getObjectType(hiveObj, hiveOpType);
        switch (objectType) {
            case DATABASE: {
                ret = new RangerHiveResource(objectType, hiveObj.getDbname());
                break;
            }
            case TABLE: 
            case VIEW: 
            case PARTITION: 
            case INDEX: 
            case FUNCTION: {
                ret = new RangerHiveResource(objectType, hiveObj.getDbname(), hiveObj.getObjectName());
                break;
            }
            case COLUMN: {
                ret = new RangerHiveResource(objectType, hiveObj.getDbname(), hiveObj.getObjectName(), StringUtils.join((Collection)hiveObj.getColumns(), (char)','));
                break;
            }
            case URI: {
                ret = new RangerHiveResource(objectType, hiveObj.getObjectName());
                break;
            }
        }
        if (ret != null) {
            ret.setServiceDef(hivePlugin == null ? null : hivePlugin.getServiceDef());
        }
        return ret;
    }

    private HiveObjectType getObjectType(HivePrivilegeObject hiveObj, HiveOperationType hiveOpType) {
        HiveObjectType objType = HiveObjectType.NONE;
        switch (hiveObj.getType()) {
            case DATABASE: {
                objType = HiveObjectType.DATABASE;
                break;
            }
            case PARTITION: {
                objType = HiveObjectType.PARTITION;
                break;
            }
            case TABLE_OR_VIEW: {
                String hiveOpTypeName = hiveOpType.name().toLowerCase();
                if (hiveOpTypeName.contains("index")) {
                    objType = HiveObjectType.INDEX;
                    break;
                }
                if (!StringUtil.isEmpty((Collection)hiveObj.getColumns())) {
                    objType = HiveObjectType.COLUMN;
                    break;
                }
                if (hiveOpTypeName.contains("view")) {
                    objType = HiveObjectType.VIEW;
                    break;
                }
                objType = HiveObjectType.TABLE;
                break;
            }
            case FUNCTION: {
                objType = HiveObjectType.FUNCTION;
                break;
            }
            case DFS_URI: 
            case LOCAL_URI: {
                objType = HiveObjectType.URI;
                break;
            }
            case COMMAND_PARAMS: 
            case GLOBAL: {
                break;
            }
        }
        return objType;
    }

    private HiveAccessType getAccessType(HivePrivilegeObject hiveObj, HiveOperationType hiveOpType, boolean isInput) {
        HiveAccessType accessType;
        block22: {
            accessType = HiveAccessType.NONE;
            HivePrivilegeObject.HivePrivObjectActionType objectActionType = hiveObj.getActionType();
            block0 : switch (objectActionType) {
                case INSERT: 
                case INSERT_OVERWRITE: 
                case UPDATE: 
                case DELETE: {
                    accessType = HiveAccessType.UPDATE;
                    break;
                }
                case OTHER: {
                    switch (hiveOpType) {
                        case CREATEDATABASE: {
                            if (hiveObj.getType() == HivePrivilegeObject.HivePrivilegeObjectType.DATABASE) {
                                accessType = HiveAccessType.CREATE;
                                break block0;
                            }
                            break block22;
                        }
                        case CREATEFUNCTION: {
                            if (hiveObj.getType() == HivePrivilegeObject.HivePrivilegeObjectType.FUNCTION) {
                                accessType = HiveAccessType.CREATE;
                                break block0;
                            }
                            break block22;
                        }
                        case CREATETABLE: 
                        case CREATEVIEW: 
                        case CREATETABLE_AS_SELECT: {
                            if (hiveObj.getType() == HivePrivilegeObject.HivePrivilegeObjectType.TABLE_OR_VIEW) {
                                accessType = isInput ? HiveAccessType.SELECT : HiveAccessType.CREATE;
                                break block0;
                            }
                            break block22;
                        }
                        case ALTERDATABASE: 
                        case ALTERDATABASE_OWNER: 
                        case ALTERINDEX_PROPS: 
                        case ALTERINDEX_REBUILD: 
                        case ALTERPARTITION_BUCKETNUM: 
                        case ALTERPARTITION_FILEFORMAT: 
                        case ALTERPARTITION_LOCATION: 
                        case ALTERPARTITION_MERGEFILES: 
                        case ALTERPARTITION_PROTECTMODE: 
                        case ALTERPARTITION_SERDEPROPERTIES: 
                        case ALTERPARTITION_SERIALIZER: 
                        case ALTERTABLE_ADDCOLS: 
                        case ALTERTABLE_ADDPARTS: 
                        case ALTERTABLE_ARCHIVE: 
                        case ALTERTABLE_BUCKETNUM: 
                        case ALTERTABLE_CLUSTER_SORT: 
                        case ALTERTABLE_COMPACT: 
                        case ALTERTABLE_DROPPARTS: 
                        case ALTERTABLE_FILEFORMAT: 
                        case ALTERTABLE_LOCATION: 
                        case ALTERTABLE_MERGEFILES: 
                        case ALTERTABLE_PARTCOLTYPE: 
                        case ALTERTABLE_PROPERTIES: 
                        case ALTERTABLE_PROTECTMODE: 
                        case ALTERTABLE_RENAME: 
                        case ALTERTABLE_RENAMECOL: 
                        case ALTERTABLE_RENAMEPART: 
                        case ALTERTABLE_REPLACECOLS: 
                        case ALTERTABLE_SERDEPROPERTIES: 
                        case ALTERTABLE_SERIALIZER: 
                        case ALTERTABLE_SKEWED: 
                        case ALTERTABLE_TOUCH: 
                        case ALTERTABLE_UNARCHIVE: 
                        case ALTERTABLE_UPDATEPARTSTATS: 
                        case ALTERTABLE_UPDATETABLESTATS: 
                        case ALTERTBLPART_SKEWED_LOCATION: 
                        case ALTERVIEW_AS: 
                        case ALTERVIEW_PROPERTIES: 
                        case ALTERVIEW_RENAME: 
                        case DROPVIEW_PROPERTIES: {
                            accessType = HiveAccessType.ALTER;
                            break block0;
                        }
                        case DROPFUNCTION: 
                        case DROPINDEX: 
                        case DROPTABLE: 
                        case DROPVIEW: 
                        case DROPDATABASE: {
                            accessType = HiveAccessType.DROP;
                            break block0;
                        }
                        case CREATEINDEX: {
                            accessType = HiveAccessType.INDEX;
                            break block0;
                        }
                        case IMPORT: {
                            accessType = isInput ? HiveAccessType.SELECT : HiveAccessType.CREATE;
                            break block0;
                        }
                        case EXPORT: 
                        case LOAD: {
                            accessType = isInput ? HiveAccessType.SELECT : HiveAccessType.UPDATE;
                            break block0;
                        }
                        case LOCKDB: 
                        case LOCKTABLE: 
                        case UNLOCKDB: 
                        case UNLOCKTABLE: {
                            accessType = HiveAccessType.LOCK;
                            break block0;
                        }
                        case QUERY: 
                        case SHOW_TABLESTATUS: 
                        case SHOW_CREATETABLE: 
                        case SHOWCOLUMNS: 
                        case SHOWINDEXES: 
                        case SHOWPARTITIONS: 
                        case SHOW_TBLPROPERTIES: 
                        case DESCTABLE: 
                        case ANALYZE_TABLE: {
                            accessType = HiveAccessType.SELECT;
                            break block0;
                        }
                        case SHOWDATABASES: 
                        case SWITCHDATABASE: 
                        case DESCDATABASE: 
                        case SHOWTABLES: {
                            accessType = HiveAccessType.USE;
                            break block0;
                        }
                        case TRUNCATETABLE: {
                            accessType = HiveAccessType.UPDATE;
                            break block0;
                        }
                        case GRANT_PRIVILEGE: 
                        case REVOKE_PRIVILEGE: {
                            accessType = HiveAccessType.NONE;
                            break block0;
                        }
                    }
                }
            }
        }
        return accessType;
    }

    private boolean isURIAccessAllowed(String userName, FsAction action, String uri, HiveConf conf) {
        boolean ret = false;
        if (action == FsAction.NONE) {
            ret = true;
        } else {
            try {
                Path filePath = new Path(uri);
                FileSystem fs = FileSystem.get((URI)filePath.toUri(), (Configuration)conf);
                FileStatus[] filestat = fs.globStatus(filePath);
                if (filestat != null && filestat.length > 0) {
                    boolean isDenied = false;
                    for (FileStatus file : filestat) {
                        if (FileUtils.isOwnerOfFileHierarchy((FileSystem)fs, (FileStatus)file, (String)userName) || FileUtils.isActionPermittedForFileHierarchy((FileSystem)fs, (FileStatus)file, (String)userName, (FsAction)action)) continue;
                        isDenied = true;
                        break;
                    }
                    ret = !isDenied;
                } else {
                    FileStatus file = FileUtils.getPathOrParentThatExists((FileSystem)fs, (Path)filePath);
                    FileUtils.checkFileAccessWithImpersonation((FileSystem)fs, (FileStatus)file, (FsAction)action, (String)userName);
                    ret = true;
                }
            }
            catch (Exception excp) {
                ret = false;
                LOG.error((Object)("Error getting permissions for " + uri), (Throwable)excp);
            }
        }
        return ret;
    }

    private void handleDfsCommand(HiveOperationType hiveOpType, List<HivePrivilegeObject> inputHObjs, String user, RangerHiveAuditHandler auditHandler) throws HiveAuthzPluginException, HiveAccessControlException {
        String dfsCommandParams = null;
        if (inputHObjs != null) {
            for (HivePrivilegeObject hiveObj : inputHObjs) {
                if (hiveObj.getType() == HivePrivilegeObject.HivePrivilegeObjectType.COMMAND_PARAMS && !StringUtil.isEmpty((String)(dfsCommandParams = StringUtil.toString((List)hiveObj.getCommandParams())))) break;
            }
        }
        int serviceType = -1;
        String serviceName = null;
        if (hivePlugin != null) {
            serviceType = hivePlugin.getServiceDefId();
            serviceName = hivePlugin.getServiceName();
        }
        auditHandler.logAuditEventForDfs(user, dfsCommandParams, false, serviceType, serviceName);
        throw new HiveAccessControlException(String.format("Permission denied: user [%s] does not have privilege for [%s] command", user, hiveOpType.name()));
    }

    private boolean existsByResourceAndAccessType(Collection<RangerHiveAccessRequest> requests, RangerHiveResource resource, HiveAccessType accessType) {
        boolean ret = false;
        if (requests != null && resource != null) {
            for (RangerHiveAccessRequest request : requests) {
                if (request.getHiveAccessType() != accessType || !request.getResource().equals((Object)resource)) continue;
                ret = true;
                break;
            }
        }
        return ret;
    }

    private String getGrantorUsername(HivePrincipal grantorPrincipal) {
        String grantor;
        String string = grantor = grantorPrincipal != null ? grantorPrincipal.getName() : null;
        if (StringUtil.isEmpty((String)grantor)) {
            UserGroupInformation ugi = this.getCurrentUserGroupInfo();
            grantor = ugi != null ? ugi.getShortUserName() : null;
        }
        return grantor;
    }

    private GrantRevokeRequest createGrantRevokeData(RangerHiveResource resource, List<HivePrincipal> hivePrincipals, List<HivePrivilege> hivePrivileges, HivePrincipal grantorPrincipal, boolean grantOption) throws HiveAccessControlException {
        HiveAuthzSessionContext sessionContext;
        if (resource == null || resource.getObjectType() != HiveObjectType.DATABASE && resource.getObjectType() != HiveObjectType.TABLE && resource.getObjectType() != HiveObjectType.VIEW && resource.getObjectType() != HiveObjectType.COLUMN) {
            throw new HiveAccessControlException("grant/revoke: unexpected object type '" + (resource == null ? null : resource.getObjectType().name()));
        }
        GrantRevokeRequest ret = new GrantRevokeRequest();
        ret.setGrantor(this.getGrantorUsername(grantorPrincipal));
        ret.setDelegateAdmin(grantOption ? Boolean.TRUE : Boolean.FALSE);
        ret.setEnableAudit(Boolean.TRUE);
        ret.setReplaceExistingPermissions(Boolean.FALSE);
        String database = StringUtils.isEmpty((String)resource.getDatabase()) ? "*" : resource.getDatabase();
        String table = StringUtils.isEmpty((String)resource.getTable()) ? "*" : resource.getTable();
        String column = StringUtils.isEmpty((String)resource.getColumn()) ? "*" : resource.getColumn();
        HashMap<String, String> mapResource = new HashMap<String, String>();
        mapResource.put("database", database);
        mapResource.put("table", table);
        mapResource.put("column", column);
        ret.setResource(mapResource);
        SessionState ss = SessionState.get();
        if (ss != null) {
            ret.setClientIPAddress(ss.getUserIpAddress());
            ret.setSessionId(ss.getSessionId());
            ret.setRequestData(ss.getConf().getQueryString());
        }
        if ((sessionContext = this.getHiveAuthzSessionContext()) != null) {
            ret.setClientType(sessionContext.getClientType() == null ? null : sessionContext.getClientType().toString());
        }
        for (HivePrincipal principal : hivePrincipals) {
            switch (principal.getType()) {
                case USER: {
                    ret.getUsers().add(principal.getName());
                    break;
                }
                case GROUP: 
                case ROLE: {
                    ret.getGroups().add(principal.getName());
                    break;
                }
            }
        }
        for (HivePrivilege privilege : hivePrivileges) {
            String privName = privilege.getName();
            if (StringUtils.equalsIgnoreCase((String)privName, (String)HiveAccessType.ALL.name()) || StringUtils.equalsIgnoreCase((String)privName, (String)HiveAccessType.ALTER.name()) || StringUtils.equalsIgnoreCase((String)privName, (String)HiveAccessType.CREATE.name()) || StringUtils.equalsIgnoreCase((String)privName, (String)HiveAccessType.DROP.name()) || StringUtils.equalsIgnoreCase((String)privName, (String)HiveAccessType.INDEX.name()) || StringUtils.equalsIgnoreCase((String)privName, (String)HiveAccessType.LOCK.name()) || StringUtils.equalsIgnoreCase((String)privName, (String)HiveAccessType.SELECT.name()) || StringUtils.equalsIgnoreCase((String)privName, (String)HiveAccessType.UPDATE.name())) {
                ret.getAccessTypes().add(privName.toLowerCase());
                continue;
            }
            LOG.warn((Object)("grant/revoke: unexpected privilege type '" + privName + "'. Ignored"));
        }
        return ret;
    }

    private RangerRequestedResources buildRequestContextWithAllAccessedResources(List<RangerHiveAccessRequest> requests) {
        RangerRequestedResources requestedResources = new RangerRequestedResources();
        for (RangerHiveAccessRequest request : requests) {
            RangerAccessRequestUtil.setRequestedResourcesInContext((Map)request.getContext(), (RangerRequestedResources)requestedResources);
            RangerHiveResource resource = (RangerHiveResource)request.getResource();
            if (resource.getObjectType() == HiveObjectType.COLUMN && StringUtils.contains((String)resource.getColumn(), (char)',')) {
                String[] columns = StringUtils.split((String)resource.getColumn(), (char)',');
                resource.setServiceDef(hivePlugin.getServiceDef());
                for (String column : columns) {
                    if (column != null) {
                        column = column.trim();
                    }
                    if (StringUtils.isBlank((String)column)) continue;
                    RangerHiveResource colResource = new RangerHiveResource(HiveObjectType.COLUMN, resource.getDatabase(), resource.getTable(), column);
                    colResource.setServiceDef(hivePlugin.getServiceDef());
                    requestedResources.addRequestedResource((RangerAccessResource)colResource);
                }
                continue;
            }
            resource.setServiceDef(hivePlugin.getServiceDef());
            requestedResources.addRequestedResource((RangerAccessResource)resource);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("RangerHiveAuthorizer.buildRequestContextWithAllAccessedResources() - " + requestedResources));
        }
        return requestedResources;
    }

    private boolean blockAccessIfRowfilterColumnMaskSpecified(HiveOperationType hiveOpType, HiveAccessType accessType) {
        boolean ret;
        boolean bl = ret = hiveOpType == HiveOperationType.EXPORT;
        if (!ret && accessType == HiveAccessType.UPDATE) {
            if (RangerHivePlugin.BlockUpdateIfRowfilterColumnMaskSpecified) {
                ret = true;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("blockAccessIfRowfilterColumnMaskSpecified(" + hiveOpType + ", " + (Object)((Object)accessType) + "): " + ret));
        }
        return ret;
    }

    private String toString(HiveOperationType hiveOpType, List<HivePrivilegeObject> inputHObjs, List<HivePrivilegeObject> outputHObjs, HiveAuthzContext context, HiveAuthzSessionContext sessionContext) {
        StringBuilder sb = new StringBuilder();
        sb.append("'checkPrivileges':{");
        sb.append("'hiveOpType':").append(hiveOpType);
        sb.append(", 'inputHObjs':[");
        this.toString(inputHObjs, sb);
        sb.append("]");
        sb.append(", 'outputHObjs':[");
        this.toString(outputHObjs, sb);
        sb.append("]");
        sb.append(", 'context':{");
        sb.append("'clientType':").append(sessionContext == null ? null : sessionContext.getClientType());
        sb.append(", 'commandString':").append(context == null ? "null" : context.getCommandString());
        sb.append(", 'ipAddress':").append(context == null ? "null" : context.getIpAddress());
        sb.append(", 'forwardedAddresses':").append(context == null ? "null" : StringUtils.join((Collection)context.getForwardedAddresses(), (String)", "));
        sb.append(", 'sessionString':").append(sessionContext == null ? "null" : sessionContext.getSessionString());
        sb.append("}");
        sb.append(", 'user':").append(this.getCurrentUserGroupInfo().getUserName());
        sb.append(", 'groups':[").append(StringUtil.toString((String[])this.getCurrentUserGroupInfo().getGroupNames())).append("]");
        sb.append("}");
        return sb.toString();
    }

    private StringBuilder toString(List<HivePrivilegeObject> privObjs, StringBuilder sb) {
        if (privObjs != null && privObjs.size() > 0) {
            this.toString(privObjs.get(0), sb);
            for (int i = 1; i < privObjs.size(); ++i) {
                sb.append(",");
                this.toString(privObjs.get(i), sb);
            }
        }
        return sb;
    }

    private StringBuilder toString(HivePrivilegeObject privObj, StringBuilder sb) {
        sb.append("'HivePrivilegeObject':{");
        sb.append("'type':").append(privObj.getType().toString());
        sb.append(", 'dbName':").append(privObj.getDbname());
        sb.append(", 'objectType':").append(privObj.getType());
        sb.append(", 'objectName':").append(privObj.getObjectName());
        sb.append(", 'columns':[").append(StringUtil.toString((List)privObj.getColumns())).append("]");
        sb.append(", 'partKeys':[").append(StringUtil.toString((List)privObj.getPartKeys())).append("]");
        sb.append(", 'commandParams':[").append(StringUtil.toString((List)privObj.getCommandParams())).append("]");
        sb.append(", 'actionType':").append(privObj.getActionType().toString());
        sb.append("}");
        return sb;
    }
}

