/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.hive.authorizer;

import org.apache.ranger.authorization.hive.authorizer.HiveObjectType;
import org.apache.ranger.plugin.policyengine.RangerAccessResourceImpl;

public class RangerHiveResource
extends RangerAccessResourceImpl {
    public static final String KEY_DATABASE = "database";
    public static final String KEY_TABLE = "table";
    public static final String KEY_UDF = "udf";
    public static final String KEY_COLUMN = "column";
    public static final String KEY_URL = "url";
    private HiveObjectType objectType = null;

    public RangerHiveResource(HiveObjectType objectType, String databaseorUrl) {
        this(objectType, databaseorUrl, null, null);
    }

    public RangerHiveResource(HiveObjectType objectType, String databaseorUrl, String tableOrUdf) {
        this(objectType, databaseorUrl, tableOrUdf, null);
    }

    public RangerHiveResource(HiveObjectType objectType, String databaseorUrl, String tableOrUdf, String column) {
        this.objectType = objectType;
        switch (objectType) {
            case DATABASE: {
                if (databaseorUrl == null) {
                    databaseorUrl = "*";
                }
                this.setValue(KEY_DATABASE, databaseorUrl);
                break;
            }
            case FUNCTION: {
                if (databaseorUrl == null) {
                    databaseorUrl = "";
                }
                this.setValue(KEY_DATABASE, databaseorUrl);
                this.setValue(KEY_UDF, tableOrUdf);
                break;
            }
            case COLUMN: {
                this.setValue(KEY_DATABASE, databaseorUrl);
                this.setValue(KEY_TABLE, tableOrUdf);
                this.setValue(KEY_COLUMN, column);
                break;
            }
            case TABLE: 
            case VIEW: 
            case INDEX: 
            case PARTITION: {
                this.setValue(KEY_DATABASE, databaseorUrl);
                this.setValue(KEY_TABLE, tableOrUdf);
                break;
            }
            case URI: {
                this.setValue(KEY_URL, databaseorUrl);
                break;
            }
        }
    }

    public HiveObjectType getObjectType() {
        return this.objectType;
    }

    public String getDatabase() {
        return (String)this.getValue(KEY_DATABASE);
    }

    public String getTable() {
        return (String)this.getValue(KEY_TABLE);
    }

    public String getUdf() {
        return (String)this.getValue(KEY_UDF);
    }

    public String getColumn() {
        return (String)this.getValue(KEY_COLUMN);
    }

    public String getUrl() {
        return (String)this.getValue(KEY_URL);
    }
}

