/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.hive.authorizer;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveOperationType;
import org.apache.ranger.audit.model.AuthzAuditEvent;
import org.apache.ranger.authorization.hive.authorizer.HiveAccessType;
import org.apache.ranger.authorization.hive.authorizer.HiveObjectType;
import org.apache.ranger.authorization.hive.authorizer.RangerHiveAccessRequest;
import org.apache.ranger.authorization.hive.authorizer.RangerHiveResource;
import org.apache.ranger.plugin.audit.RangerDefaultAuditHandler;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerAccessResource;
import org.apache.ranger.plugin.policyengine.RangerAccessResult;

public class RangerHiveAuditHandler
extends RangerDefaultAuditHandler {
    private static final Log LOG = LogFactory.getLog(RangerDefaultAuditHandler.class);
    public static final String ACCESS_TYPE_ROWFILTER = "ROW_FILTER";
    Collection<AuthzAuditEvent> auditEvents = null;
    boolean deniedExists = false;

    AuthzAuditEvent createAuditEvent(RangerAccessResult result, String accessType, String resourcePath) {
        RangerAccessRequest request = result.getAccessRequest();
        RangerAccessResource resource = request.getResource();
        String resourceType = resource != null ? resource.getLeafName() : null;
        AuthzAuditEvent auditEvent = super.getAuthzEvents(result);
        auditEvent.setAccessType(accessType);
        auditEvent.setResourcePath(resourcePath);
        auditEvent.setResourceType("@" + resourceType);
        if (request instanceof RangerHiveAccessRequest && resource instanceof RangerHiveResource) {
            RangerHiveAccessRequest hiveAccessRequest = (RangerHiveAccessRequest)request;
            RangerHiveResource hiveResource = (RangerHiveResource)resource;
            HiveAccessType hiveAccessType = hiveAccessRequest.getHiveAccessType();
            if (hiveAccessType == HiveAccessType.USE && hiveResource.getObjectType() == HiveObjectType.DATABASE && StringUtils.isBlank((String)hiveResource.getDatabase())) {
                auditEvent.setTags(null);
            }
            if (hiveAccessType == HiveAccessType.REPLADMIN) {
                String context = request.getRequestData();
                String replAccessType = this.getReplCmd(context);
                auditEvent.setAccessType(replAccessType);
            }
            if (hiveAccessType == HiveAccessType.SERVICEADMIN) {
                String hiveOperationType = request.getAction();
                String commandStr = request.getRequestData();
                if (HiveOperationType.KILL_QUERY.name().equalsIgnoreCase(hiveOperationType)) {
                    String queryId = this.getServiceAdminQueryId(commandStr);
                    if (!StringUtils.isEmpty((String)queryId)) {
                        auditEvent.setRequestData(queryId);
                    }
                    if (StringUtils.isEmpty((String)(commandStr = this.getServiceAdminCmd(commandStr)))) {
                        commandStr = hiveAccessType.name();
                    }
                }
                auditEvent.setAccessType(commandStr);
            }
        }
        return auditEvent;
    }

    AuthzAuditEvent createAuditEvent(RangerAccessResult result) {
        AuthzAuditEvent ret = null;
        RangerAccessRequest request = result.getAccessRequest();
        RangerAccessResource resource = request.getResource();
        String resourcePath = resource != null ? resource.getAsString() : null;
        int policyType = result.getPolicyType();
        if (policyType == 1 && result.isMaskEnabled()) {
            ret = this.createAuditEvent(result, result.getMaskType(), resourcePath);
        } else if (policyType == 2) {
            ret = this.createAuditEvent(result, ACCESS_TYPE_ROWFILTER, resourcePath);
        } else {
            String accessType = null;
            if (request instanceof RangerHiveAccessRequest) {
                RangerHiveAccessRequest hiveRequest = (RangerHiveAccessRequest)request;
                accessType = hiveRequest.getHiveAccessType().toString();
            }
            if (StringUtils.isEmpty(accessType)) {
                accessType = request.getAccessType();
            }
            ret = this.createAuditEvent(result, accessType, resourcePath);
        }
        return ret;
    }

    List<AuthzAuditEvent> createAuditEvents(Collection<RangerAccessResult> results) {
        Object result;
        HashMap<Long, AuthzAuditEvent> auditEvents = new HashMap<Long, AuthzAuditEvent>();
        Iterator<RangerAccessResult> iterator = results.iterator();
        AuthzAuditEvent deniedAuditEvent = null;
        while (iterator.hasNext() && deniedAuditEvent == null) {
            AuthzAuditEvent auditEvent;
            result = iterator.next();
            if (!result.getIsAudited()) continue;
            if (!result.getIsAllowed()) {
                deniedAuditEvent = this.createAuditEvent((RangerAccessResult)result);
                continue;
            }
            long policyId = result.getPolicyId();
            if (auditEvents.containsKey(policyId)) {
                auditEvent = (AuthzAuditEvent)auditEvents.get(policyId);
                RangerHiveAccessRequest request = (RangerHiveAccessRequest)result.getAccessRequest();
                RangerHiveResource resource = (RangerHiveResource)request.getResource();
                String resourcePath = auditEvent.getResourcePath() + "," + resource.getColumn();
                auditEvent.setResourcePath(resourcePath);
                Set tags = this.getTags((RangerAccessRequest)request);
                if (tags == null) continue;
                auditEvent.getTags().addAll(tags);
                continue;
            }
            auditEvent = this.createAuditEvent((RangerAccessResult)result);
            if (auditEvent == null) continue;
            auditEvents.put(policyId, auditEvent);
        }
        result = deniedAuditEvent == null ? new ArrayList(auditEvents.values()) : Lists.newArrayList((Object[])new AuthzAuditEvent[]{deniedAuditEvent});
        return result;
    }

    public void processResult(RangerAccessResult result) {
        if (!result.getIsAudited()) {
            return;
        }
        AuthzAuditEvent auditEvent = this.createAuditEvent(result);
        if (auditEvent != null) {
            this.addAuthzAuditEvent(auditEvent);
        }
    }

    public void processResults(Collection<RangerAccessResult> results) {
        List<AuthzAuditEvent> auditEvents = this.createAuditEvents(results);
        for (AuthzAuditEvent auditEvent : auditEvents) {
            this.addAuthzAuditEvent(auditEvent);
        }
    }

    public void logAuditEventForDfs(String userName, String dfsCommand, boolean accessGranted, int repositoryType, String repositoryName) {
        AuthzAuditEvent auditEvent = new AuthzAuditEvent();
        auditEvent.setAclEnforcer(RangerDefaultAuditHandler.RangerModuleName);
        auditEvent.setResourceType("@dfs");
        auditEvent.setAccessType("DFS");
        auditEvent.setAction("DFS");
        auditEvent.setUser(userName);
        auditEvent.setAccessResult((short)(accessGranted ? 1 : 0));
        auditEvent.setEventTime(new Date());
        auditEvent.setRepositoryType(repositoryType);
        auditEvent.setRepositoryName(repositoryName);
        auditEvent.setRequestData(dfsCommand);
        auditEvent.setResourcePath(dfsCommand);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Logging DFS event " + auditEvent.toString()));
        }
        this.addAuthzAuditEvent(auditEvent);
    }

    public void flushAudit() {
        if (this.auditEvents == null) {
            return;
        }
        for (AuthzAuditEvent auditEvent : this.auditEvents) {
            if (this.deniedExists && auditEvent.getAccessResult() != 0) continue;
            super.logAuthzAudit(auditEvent);
        }
    }

    private void addAuthzAuditEvent(AuthzAuditEvent auditEvent) {
        if (auditEvent != null) {
            if (this.auditEvents == null) {
                this.auditEvents = new ArrayList<AuthzAuditEvent>();
            }
            this.auditEvents.add(auditEvent);
            if (auditEvent.getAccessResult() == 0) {
                this.deniedExists = true;
            }
        }
    }

    private String getReplCmd(String cmdString) {
        Object[] cmd;
        String ret = "REPL";
        if (cmdString != null && !ArrayUtils.isEmpty((Object[])(cmd = cmdString.trim().split("\\s+"))) && cmd.length > 2) {
            ret = (String)cmd[0] + " " + (String)cmd[1];
        }
        return ret;
    }

    private String getServiceAdminCmd(String cmdString) {
        Object[] cmd;
        String ret = "SERVICE ADMIN";
        if (cmdString != null && !ArrayUtils.isEmpty((Object[])(cmd = cmdString.trim().split("\\s+"))) && cmd.length > 1) {
            ret = (String)cmd[0] + " " + (String)cmd[1];
        }
        return ret;
    }

    private String getServiceAdminQueryId(String cmdString) {
        Object[] cmd;
        String ret = "QUERY ID = ";
        if (cmdString != null && !ArrayUtils.isEmpty((Object[])(cmd = cmdString.trim().split("\\s+"))) && cmd.length > 2) {
            ret = ret + (String)cmd[2];
        }
        return ret;
    }
}

