/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.hive.authorizer;

import com.google.common.collect.Sets;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.permission.FsAction;
import org.apache.hadoop.hive.common.FileUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.HiveObjectRef;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.security.HiveAuthenticationProvider;
import org.apache.hadoop.hive.ql.security.authorization.AuthorizationUtils;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAccessControlException;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthzContext;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthzPluginException;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveAuthzSessionContext;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveMetastoreClientFactory;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveOperationType;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePolicyProvider;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrincipal;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilege;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilegeInfo;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HivePrivilegeObject;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveResourceACLs;
import org.apache.hadoop.hive.ql.security.authorization.plugin.HiveRoleGrant;
import org.apache.hadoop.hive.ql.session.SessionState;
import org.apache.hadoop.ipc.Server;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.ranger.authorization.hive.authorizer.HiveAccessType;
import org.apache.ranger.authorization.hive.authorizer.HiveObj;
import org.apache.ranger.authorization.hive.authorizer.HiveObjectType;
import org.apache.ranger.authorization.hive.authorizer.RangerHiveAccessRequest;
import org.apache.ranger.authorization.hive.authorizer.RangerHiveAuditHandler;
import org.apache.ranger.authorization.hive.authorizer.RangerHiveAuthorizerBase;
import org.apache.ranger.authorization.hive.authorizer.RangerHivePlugin;
import org.apache.ranger.authorization.hive.authorizer.RangerHivePolicyProvider;
import org.apache.ranger.authorization.hive.authorizer.RangerHiveResource;
import org.apache.ranger.authorization.utils.StringUtil;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerRole;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerAccessRequestImpl;
import org.apache.ranger.plugin.policyengine.RangerAccessResource;
import org.apache.ranger.plugin.policyengine.RangerAccessResult;
import org.apache.ranger.plugin.policyengine.RangerAccessResultProcessor;
import org.apache.ranger.plugin.policyengine.RangerResourceACLs;
import org.apache.ranger.plugin.policyevaluator.RangerPolicyEvaluator;
import org.apache.ranger.plugin.util.GrantRevokeRequest;
import org.apache.ranger.plugin.util.GrantRevokeRoleRequest;
import org.apache.ranger.plugin.util.RangerAccessRequestUtil;
import org.apache.ranger.plugin.util.RangerPerfTracer;
import org.apache.ranger.plugin.util.RangerRequestedResources;
import org.apache.ranger.plugin.util.RangerRoles;

public class RangerHiveAuthorizer
extends RangerHiveAuthorizerBase {
    private static final Log LOG = LogFactory.getLog(RangerHiveAuthorizer.class);
    private static final Log PERF_HIVEAUTH_REQUEST_LOG = RangerPerfTracer.getPerfLogger((String)"hiveauth.request");
    private static final char COLUMN_SEP = ',';
    private static final String HIVE_CONF_VAR_QUERY_STRING = "hive.query.string";
    private static final String DEFAULT_RANGER_POLICY_GRANTOR = "ranger";
    private static volatile RangerHivePlugin hivePlugin = null;
    private static final String ROLE_ALL = "ALL";
    private static final String ROLE_DEFAULT = "DEFAULT";
    private static final String ROLE_NONE = "NONE";
    private static final String ROLE_ADMIN = "admin";
    private static final String CMD_CREATE_ROLE = "create role %s";
    private static final String CMD_DROP_ROLE = "drop role %s";
    private static final String CMD_SHOW_ROLES = "show roles";
    private static final String CMD_SHOW_ROLE_GRANT = "show role grant %s";
    private static final String CMD_SHOW_PRINCIPALS = "show principals %s";
    private static final String CMD_GRANT_ROLE = "grant %s to %s ";
    private static final String CMD_REVOKE_ROLE = "revoke %s from %s";
    private static final Set<String> RESERVED_ROLE_NAMES;
    private String currentUserName;
    private Set<String> currentRoles;
    private String adminRole;
    private boolean isCurrentRoleSet = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public RangerHiveAuthorizer(HiveMetastoreClientFactory metastoreClientFactory, HiveConf hiveConf, HiveAuthenticationProvider hiveAuthenticator, HiveAuthzSessionContext sessionContext) {
        super(metastoreClientFactory, hiveConf, hiveAuthenticator, sessionContext);
        LOG.debug((Object)"RangerHiveAuthorizer.RangerHiveAuthorizer()");
        RangerHivePlugin plugin = hivePlugin;
        if (plugin != null) return;
        Class<RangerHiveAuthorizer> clazz = RangerHiveAuthorizer.class;
        synchronized (RangerHiveAuthorizer.class) {
            plugin = hivePlugin;
            if (plugin != null) return;
            String appType = "unknown";
            if (sessionContext != null) {
                switch (sessionContext.getClientType()) {
                    case HIVECLI: {
                        appType = "hiveCLI";
                        break;
                    }
                    case HIVESERVER2: {
                        appType = "hiveServer2";
                    }
                }
            }
            plugin = new RangerHivePlugin(appType);
            plugin.init();
            hivePlugin = plugin;
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return;
        }
    }

    @Override
    public HivePolicyProvider getHivePolicyProvider() throws HiveAuthzPluginException {
        if (hivePlugin == null) {
            throw new HiveAuthzPluginException();
        }
        RangerHivePolicyProvider policyProvider = new RangerHivePolicyProvider(hivePlugin);
        return policyProvider;
    }

    public void createRole(String roleName, HivePrincipal adminGrantor) throws HiveAuthzPluginException, HiveAccessControlException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)" ==> RangerHiveAuthorizer.createRole()");
        }
        RangerHiveAuditHandler auditHandler = new RangerHiveAuditHandler();
        String currentUserName = this.getGrantorUsername(adminGrantor);
        List<String> roleNames = Arrays.asList(roleName);
        List<String> userNames = Arrays.asList(currentUserName);
        boolean result = false;
        if (RESERVED_ROLE_NAMES.contains(roleName.trim().toUpperCase())) {
            throw new HiveAuthzPluginException("Role name cannot be one of the reserved roles: " + RESERVED_ROLE_NAMES);
        }
        try {
            RangerRole role = new RangerRole();
            role.setName(roleName);
            role.setCreatedByUser(currentUserName);
            role.setCreatedBy(currentUserName);
            role.setUpdatedBy(currentUserName);
            RangerRole.RoleMember userMember = new RangerRole.RoleMember(currentUserName, true);
            ArrayList<RangerRole.RoleMember> userMemberList = new ArrayList<RangerRole.RoleMember>();
            userMemberList.add(userMember);
            role.setUsers(userMemberList);
            RangerRole ret = hivePlugin.createRole(role, (RangerAccessResultProcessor)auditHandler);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("<== createRole(): " + ret));
            }
            result = true;
        }
        catch (Exception excp) {
            throw new HiveAccessControlException((Throwable)excp);
        }
        finally {
            RangerAccessResult accessResult = this.createAuditEvent(hivePlugin, currentUserName, userNames, HiveOperationType.CREATEROLE, HiveAccessType.CREATE, roleNames, result);
            auditHandler.processResult(accessResult);
            auditHandler.flushAudit();
        }
    }

    public void dropRole(String roleName) throws HiveAuthzPluginException, HiveAccessControlException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"RangerHiveAuthorizer.dropRole()");
        }
        RangerHiveAuditHandler auditHandler = new RangerHiveAuditHandler();
        UserGroupInformation ugi = this.getCurrentUserGroupInfo();
        boolean result = false;
        List<String> roleNames = Arrays.asList(roleName);
        if (ugi == null) {
            throw new HiveAccessControlException("Permission denied: user information not available");
        }
        if (RESERVED_ROLE_NAMES.contains(roleName.trim().toUpperCase())) {
            throw new HiveAuthzPluginException("Role name cannot be one of the reserved roles: " + RESERVED_ROLE_NAMES);
        }
        String currentUserName = ugi.getShortUserName();
        List<String> userNames = Arrays.asList(currentUserName);
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("<== dropRole(): " + roleName));
            }
            hivePlugin.dropRole(currentUserName, roleName, (RangerAccessResultProcessor)auditHandler);
            result = true;
        }
        catch (Exception excp) {
            throw new HiveAccessControlException((Throwable)excp);
        }
        finally {
            RangerAccessResult accessResult = this.createAuditEvent(hivePlugin, currentUserName, userNames, HiveOperationType.DROPROLE, HiveAccessType.DROP, roleNames, result);
            auditHandler.processResult(accessResult);
            auditHandler.flushAudit();
        }
    }

    public List<String> getCurrentRoleNames() throws HiveAuthzPluginException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"RangerHiveAuthorizer.getCurrentRoleNames()");
        }
        UserGroupInformation ugi = this.getCurrentUserGroupInfo();
        boolean result = false;
        if (ugi == null) {
            throw new HiveAuthzPluginException("User information not available");
        }
        ArrayList<String> ret = new ArrayList<String>();
        String user = ugi.getShortUserName();
        List<String> userNames = Arrays.asList(user);
        RangerHiveAuditHandler auditHandler = new RangerHiveAuditHandler();
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("<== getCurrentRoleNames() for user " + user));
            }
            for (String role : this.getCurrentRoles()) {
                ret.add(role);
            }
            result = true;
        }
        catch (Exception excp) {
            throw new HiveAuthzPluginException((Throwable)excp);
        }
        finally {
            RangerAccessResult accessResult = this.createAuditEvent(hivePlugin, user, userNames, HiveOperationType.SHOW_ROLES, HiveAccessType.SELECT, ret, result);
            auditHandler.processResult(accessResult);
            auditHandler.flushAudit();
        }
        return ret;
    }

    public void setCurrentRole(String roleName) throws HiveAccessControlException, HiveAuthzPluginException {
        this.initUserRoles();
        if (ROLE_NONE.equalsIgnoreCase(roleName)) {
            this.currentRoles.clear();
            this.isCurrentRoleSet = true;
            return;
        }
        if (ROLE_ALL.equalsIgnoreCase(roleName)) {
            this.currentRoles.clear();
            this.currentRoles.addAll(this.getCurrentRoleNamesFromRanger());
            this.isCurrentRoleSet = true;
            return;
        }
        for (String role : this.getCurrentRoleNamesFromRanger()) {
            if (!role.equalsIgnoreCase(roleName)) continue;
            this.currentRoles.clear();
            this.currentRoles.add(role);
            this.isCurrentRoleSet = true;
            return;
        }
        if (ROLE_ADMIN.equalsIgnoreCase(roleName) && null != this.adminRole) {
            this.currentRoles.clear();
            this.currentRoles.add(this.adminRole);
            this.isCurrentRoleSet = true;
            return;
        }
        LOG.info((Object)("Current user : " + this.currentUserName + ", Current Roles : " + this.currentRoles));
        throw new HiveAccessControlException(this.currentUserName + " doesn't belong to role " + roleName);
    }

    public List<String> getAllRoles() throws HiveAuthzPluginException, HiveAccessControlException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerHiveAuthorizer.getAllRoles()");
        }
        ArrayList<String> ret = new ArrayList<String>();
        RangerHiveAuditHandler auditHandler = new RangerHiveAuditHandler();
        List<String> userNames = null;
        boolean result = false;
        if (hivePlugin == null) {
            throw new HiveAuthzPluginException("RangerHiveAuthorizer.getAllRoles(): HivePlugin initialization failed...");
        }
        UserGroupInformation ugi = this.getCurrentUserGroupInfo();
        if (ugi == null) {
            throw new HiveAccessControlException("RangerHiveAuthorizer.getAllRoles(): User information not available...");
        }
        String currentUserName = ugi.getShortUserName();
        try {
            Set roles;
            if (!hivePlugin.isServiceAdmin(currentUserName)) {
                throw new HiveAccessControlException("RangerHiveAuthorizer.getAllRoles(): User not authorized to run show roles...");
            }
            userNames = Arrays.asList(currentUserName);
            RangerRoles rangerRoles = hivePlugin.getRangerRoles();
            if (rangerRoles != null && CollectionUtils.isNotEmpty((Collection)(roles = rangerRoles.getRangerRoles()))) {
                for (RangerRole rangerRole : roles) {
                    ret.add(rangerRole.getName());
                }
            }
            result = true;
        }
        catch (Exception excp) {
            throw new HiveAuthzPluginException((Throwable)excp);
        }
        finally {
            RangerAccessResult accessResult = this.createAuditEvent(hivePlugin, currentUserName, userNames, HiveOperationType.SHOW_ROLES, HiveAccessType.SELECT, null, result);
            hivePlugin.evalAuditPolicies(accessResult);
            auditHandler.processResult(accessResult);
            auditHandler.flushAudit();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerHiveAuthorizer.getAllRoles() roles: " + ret));
        }
        return ret;
    }

    public List<HiveRoleGrant> getPrincipalGrantInfoForRole(String roleName) throws HiveAuthzPluginException, HiveAccessControlException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerHiveAuthorizer.getPrincipalGrantInfoForRole() for RoleName: " + roleName));
        }
        ArrayList<HiveRoleGrant> ret = new ArrayList<HiveRoleGrant>();
        List<String> roleNames = Arrays.asList(roleName);
        List<String> userNames = null;
        RangerHiveAuditHandler auditHandler = new RangerHiveAuditHandler();
        boolean result = false;
        if (hivePlugin == null) {
            throw new HiveAuthzPluginException("RangerHiveAuthorizer.getPrincipalGrantInfoForRole(): HivePlugin initialization failed...");
        }
        UserGroupInformation ugi = this.getCurrentUserGroupInfo();
        if (ugi == null) {
            throw new HiveAccessControlException("RangerHiveAuthorizer.getPrincipalGrantInfoForRole(): User information not available...");
        }
        String currentUserName = ugi.getShortUserName();
        try {
            RangerRole rangerRole;
            if (!hivePlugin.isServiceAdmin(currentUserName)) {
                throw new HiveAccessControlException("Permission denied: User not authorized to perform this operation!");
            }
            userNames = Arrays.asList(currentUserName);
            if (StringUtils.isNotEmpty((String)roleName) && (rangerRole = this.getRangerRoleForRoleName(roleName)) != null) {
                HiveRoleGrant hiveRoleGrant;
                for (RangerRole.RoleMember roleMember : rangerRole.getRoles()) {
                    hiveRoleGrant = this.getHiveRoleGrant(rangerRole, roleMember, HivePrincipal.HivePrincipalType.ROLE.name());
                    ret.add(hiveRoleGrant);
                }
                for (RangerRole.RoleMember group : rangerRole.getGroups()) {
                    hiveRoleGrant = this.getHiveRoleGrant(rangerRole, group, HivePrincipal.HivePrincipalType.GROUP.name());
                    ret.add(hiveRoleGrant);
                }
                for (RangerRole.RoleMember user : rangerRole.getUsers()) {
                    hiveRoleGrant = this.getHiveRoleGrant(rangerRole, user, HivePrincipal.HivePrincipalType.USER.name());
                    ret.add(hiveRoleGrant);
                }
                result = true;
            }
        }
        catch (Exception excp) {
            throw new HiveAuthzPluginException((Throwable)excp);
        }
        finally {
            RangerAccessResult accessResult = this.createAuditEvent(hivePlugin, currentUserName, userNames, HiveOperationType.SHOW_ROLE_PRINCIPALS, HiveAccessType.SELECT, roleNames, result);
            hivePlugin.evalAuditPolicies(accessResult);
            auditHandler.processResult(accessResult);
            auditHandler.flushAudit();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerHiveAuthorizer.getPrincipalGrantInfoForRole() for Rolename: " + roleName + " Roles: " + ret));
        }
        return ret;
    }

    public List<HiveRoleGrant> getRoleGrantInfoForPrincipal(HivePrincipal principal) throws HiveAuthzPluginException, HiveAccessControlException {
        LOG.debug((Object)("==> RangerHiveAuthorizer.getRoleGrantInfoForPrincipal() for Principal: " + principal));
        ArrayList<HiveRoleGrant> ret = new ArrayList<HiveRoleGrant>();
        List<String> principalInfo = null;
        List<String> userNames = null;
        RangerHiveAuditHandler auditHandler = new RangerHiveAuditHandler();
        boolean result = false;
        if (hivePlugin == null) {
            throw new HiveAuthzPluginException("RangerHiveAuthorizer.getRoleGrantInfoForPrincipal(): HivePlugin initialization failed...");
        }
        UserGroupInformation ugi = this.getCurrentUserGroupInfo();
        if (ugi == null) {
            throw new HiveAccessControlException("RangerHiveAuthorizer.getRoleGrantInfoForPrincipal(): User information not available...");
        }
        String currentUserName = ugi.getShortUserName();
        try {
            String principalName = principal.getName();
            String type = principal.getType().name();
            userNames = Arrays.asList(currentUserName);
            principalInfo = Collections.singletonList(principal.getType() + " " + principalName);
            if (!hivePlugin.isServiceAdmin(currentUserName) && !principalName.equals(currentUserName)) {
                throw new HiveAccessControlException("Permission denied: user information not available");
            }
            Set roles = hivePlugin.getRangerRoleForPrincipal(principalName, type);
            if (CollectionUtils.isNotEmpty((Collection)roles)) {
                for (RangerRole rangerRole : roles) {
                    switch (type) {
                        case "USER": {
                            RangerRole.RoleMember userRoleMember = new RangerRole.RoleMember(principalName, false);
                            ret.add(this.getHiveRoleGrant(rangerRole, userRoleMember, type));
                            break;
                        }
                        case "GROUP": {
                            RangerRole.RoleMember groupRoleMember = new RangerRole.RoleMember(principalName, false);
                            ret.add(this.getHiveRoleGrant(rangerRole, groupRoleMember, type));
                            break;
                        }
                        case "ROLE": {
                            RangerRole.RoleMember roleRoleMember = new RangerRole.RoleMember(principalName, false);
                            ret.add(this.getHiveRoleGrant(rangerRole, roleRoleMember, type));
                        }
                    }
                }
                result = true;
            }
        }
        catch (Exception excp) {
            throw new HiveAuthzPluginException((Throwable)excp);
        }
        finally {
            RangerAccessResult accessResult = this.createAuditEvent(hivePlugin, currentUserName, userNames, HiveOperationType.SHOW_ROLE_GRANT, HiveAccessType.SELECT, principalInfo, result);
            hivePlugin.evalAuditPolicies(accessResult);
            auditHandler.processResult(accessResult);
            auditHandler.flushAudit();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== getRoleGrantInfoForPrincipal(): Principal: " + principal + " Roles: " + ret));
        }
        return ret;
    }

    public void grantRole(List<HivePrincipal> hivePrincipals, List<String> roles, boolean grantOption, HivePrincipal grantorPrinc) throws HiveAuthzPluginException, HiveAccessControlException {
        LOG.debug((Object)"RangerHiveAuthorizerBase.grantRole()");
        boolean result = false;
        RangerHiveAuditHandler auditHandler = new RangerHiveAuditHandler();
        String username = this.getGrantorUsername(grantorPrinc);
        ArrayList<String> principals = new ArrayList<String>();
        try {
            HiveAuthzSessionContext sessionContext;
            GrantRevokeRoleRequest request = new GrantRevokeRoleRequest();
            request.setGrantor(username);
            request.setGrantorGroups(this.getGrantorGroupNames(grantorPrinc));
            HashSet<String> userList = new HashSet<String>();
            HashSet<String> roleList = new HashSet<String>();
            HashSet<String> groupList = new HashSet<String>();
            for (HivePrincipal principal : hivePrincipals) {
                String name = null;
                switch (principal.getType()) {
                    case USER: {
                        name = principal.getName();
                        userList.add(name);
                        principals.add("USER " + name);
                        break;
                    }
                    case GROUP: {
                        name = principal.getName();
                        groupList.add(name);
                        principals.add("GROUP " + name);
                        break;
                    }
                    case ROLE: {
                        name = principal.getName();
                        roleList.add(name);
                        principals.add("ROLE " + name);
                        break;
                    }
                }
            }
            request.setUsers(userList);
            request.setGroups(groupList);
            request.setRoles(roleList);
            request.setGrantOption(Boolean.valueOf(grantOption));
            request.setTargetRoles(new HashSet<String>(roles));
            SessionState ss = SessionState.get();
            if (ss != null) {
                request.setClientIPAddress(ss.getUserIpAddress());
                request.setSessionId(ss.getSessionId());
                HiveConf hiveConf = ss.getConf();
                if (hiveConf != null) {
                    request.setRequestData(hiveConf.get(HIVE_CONF_VAR_QUERY_STRING));
                }
            }
            if ((sessionContext = this.getHiveAuthzSessionContext()) != null) {
                request.setClientType(sessionContext.getClientType() == null ? null : sessionContext.getClientType().toString());
            }
            hivePlugin.grantRole(request, (RangerAccessResultProcessor)auditHandler);
            result = true;
        }
        catch (Exception excp) {
            throw new HiveAccessControlException((Throwable)excp);
        }
        finally {
            RangerAccessResult accessResult = this.createAuditEvent(hivePlugin, username, principals, HiveOperationType.GRANT_ROLE, HiveAccessType.ALTER, roles, result);
            auditHandler.processResult(accessResult);
            auditHandler.flushAudit();
        }
    }

    public void revokeRole(List<HivePrincipal> hivePrincipals, List<String> roles, boolean grantOption, HivePrincipal grantorPrinc) throws HiveAuthzPluginException, HiveAccessControlException {
        LOG.debug((Object)"RangerHiveAuthorizerBase.revokeRole()");
        boolean result = false;
        RangerHiveAuditHandler auditHandler = new RangerHiveAuditHandler();
        String grantorUserName = this.getGrantorUsername(grantorPrinc);
        ArrayList<String> principals = new ArrayList<String>();
        try {
            HiveAuthzSessionContext sessionContext;
            GrantRevokeRoleRequest request = new GrantRevokeRoleRequest();
            request.setGrantor(grantorUserName);
            request.setGrantorGroups(this.getGrantorGroupNames(grantorPrinc));
            HashSet<String> userList = new HashSet<String>();
            HashSet<String> roleList = new HashSet<String>();
            HashSet<String> groupList = new HashSet<String>();
            for (HivePrincipal principal : hivePrincipals) {
                String principalName = null;
                switch (principal.getType()) {
                    case USER: {
                        principalName = principal.getName();
                        userList.add(principalName);
                        principals.add("USER " + principalName);
                        break;
                    }
                    case GROUP: {
                        principalName = principal.getName();
                        groupList.add(principalName);
                        principals.add("GROUP " + principalName);
                        break;
                    }
                    case ROLE: {
                        principalName = principal.getName();
                        roleList.add(principalName);
                        principals.add("ROLE " + principalName);
                        break;
                    }
                }
            }
            request.setUsers(userList);
            request.setGroups(groupList);
            request.setRoles(roleList);
            request.setGrantOption(Boolean.valueOf(grantOption));
            request.setTargetRoles(new HashSet<String>(roles));
            SessionState ss = SessionState.get();
            if (ss != null) {
                request.setClientIPAddress(ss.getUserIpAddress());
                request.setSessionId(ss.getSessionId());
                HiveConf hiveConf = ss.getConf();
                if (hiveConf != null) {
                    request.setRequestData(hiveConf.get(HIVE_CONF_VAR_QUERY_STRING));
                }
            }
            if ((sessionContext = this.getHiveAuthzSessionContext()) != null) {
                request.setClientType(sessionContext.getClientType() == null ? null : sessionContext.getClientType().toString());
            }
            LOG.info((Object)("revokeRole(): " + request));
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("revokeRole(): " + request));
            }
            hivePlugin.revokeRole(request, (RangerAccessResultProcessor)auditHandler);
            result = true;
        }
        catch (Exception excp) {
            throw new HiveAccessControlException((Throwable)excp);
        }
        finally {
            RangerAccessResult accessResult = this.createAuditEvent(hivePlugin, grantorUserName, principals, HiveOperationType.REVOKE_ROLE, HiveAccessType.ALTER, roles, result);
            auditHandler.processResult(accessResult);
            auditHandler.flushAudit();
        }
    }

    public void grantPrivileges(List<HivePrincipal> hivePrincipals, List<HivePrivilege> hivePrivileges, HivePrivilegeObject hivePrivObject, HivePrincipal grantorPrincipal, boolean grantOption) throws HiveAuthzPluginException, HiveAccessControlException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("grantPrivileges() => HivePrivilegeObject:" + this.toString(hivePrivObject, new StringBuilder()) + "grantorPrincipal: " + grantorPrincipal + "hivePrincipals" + hivePrincipals + "hivePrivileges" + hivePrivileges));
        }
        if (!RangerHivePlugin.UpdateXaPoliciesOnGrantRevoke) {
            throw new HiveAuthzPluginException("GRANT/REVOKE not supported in Ranger HiveAuthorizer. Please use Ranger Security Admin to setup access control.");
        }
        RangerHiveAuditHandler auditHandler = new RangerHiveAuditHandler();
        try {
            ArrayList<HivePrivilegeObject> outputs = new ArrayList<HivePrivilegeObject>(Arrays.asList(hivePrivObject));
            RangerHiveResource resource = this.getHiveResource(HiveOperationType.GRANT_PRIVILEGE, hivePrivObject, null, outputs);
            GrantRevokeRequest request = this.createGrantRevokeData(resource, hivePrincipals, hivePrivileges, grantorPrincipal, grantOption);
            LOG.info((Object)("grantPrivileges(): " + request));
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("grantPrivileges(): " + request));
            }
            hivePlugin.grantAccess(request, (RangerAccessResultProcessor)auditHandler);
        }
        catch (Exception excp) {
            throw new HiveAccessControlException((Throwable)excp);
        }
        finally {
            auditHandler.flushAudit();
        }
    }

    public void revokePrivileges(List<HivePrincipal> hivePrincipals, List<HivePrivilege> hivePrivileges, HivePrivilegeObject hivePrivObject, HivePrincipal grantorPrincipal, boolean grantOption) throws HiveAuthzPluginException, HiveAccessControlException {
        if (!RangerHivePlugin.UpdateXaPoliciesOnGrantRevoke) {
            throw new HiveAuthzPluginException("GRANT/REVOKE not supported in Ranger HiveAuthorizer. Please use Ranger Security Admin to setup access control.");
        }
        RangerHiveAuditHandler auditHandler = new RangerHiveAuditHandler();
        try {
            ArrayList<HivePrivilegeObject> outputs = new ArrayList<HivePrivilegeObject>(Arrays.asList(hivePrivObject));
            RangerHiveResource resource = this.getHiveResource(HiveOperationType.REVOKE_PRIVILEGE, hivePrivObject, null, outputs);
            GrantRevokeRequest request = this.createGrantRevokeData(resource, hivePrincipals, hivePrivileges, grantorPrincipal, grantOption);
            LOG.info((Object)("revokePrivileges(): " + request));
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("revokePrivileges(): " + request));
            }
            hivePlugin.revokeAccess(request, (RangerAccessResultProcessor)auditHandler);
        }
        catch (Exception excp) {
            throw new HiveAccessControlException((Throwable)excp);
        }
        finally {
            auditHandler.flushAudit();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void checkPrivileges(HiveOperationType hiveOpType, List<HivePrivilegeObject> inputHObjs, List<HivePrivilegeObject> outputHObjs, HiveAuthzContext context) throws HiveAuthzPluginException, HiveAccessControlException {
        Set<String> roles;
        HashSet groups;
        String user;
        HiveAuthzSessionContext sessionContext;
        RangerPerfTracer perf;
        RangerHiveAuditHandler auditHandler;
        block49: {
            UserGroupInformation ugi = this.getCurrentUserGroupInfo();
            if (ugi == null) {
                throw new HiveAccessControlException("Permission denied: user information not available");
            }
            auditHandler = new RangerHiveAuditHandler();
            perf = null;
            sessionContext = this.getHiveAuthzSessionContext();
            user = ugi.getShortUserName();
            groups = Sets.newHashSet((Object[])ugi.getGroupNames());
            roles = this.getCurrentRolesForUser(user, groups);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)this.toString(hiveOpType, inputHObjs, outputHObjs, context, sessionContext));
            }
            if (hiveOpType != HiveOperationType.DFS) break block49;
            this.handleDfsCommand(hiveOpType, inputHObjs, user, auditHandler);
            auditHandler.flushAudit();
            RangerPerfTracer.log(perf);
            return;
        }
        try {
            RangerHiveAccessRequest request;
            String tableName;
            String dbName;
            HiveAccessType accessType;
            Path resolvedPath;
            boolean shouldCheckAccess;
            FileSystem fs;
            FsAction permission;
            HiveObjectType hiveObjType;
            String pathStr;
            RangerHiveResource resource;
            if (RangerPerfTracer.isPerfTraceEnabled((Log)PERF_HIVEAUTH_REQUEST_LOG)) {
                perf = RangerPerfTracer.getPerfTracer((Log)PERF_HIVEAUTH_REQUEST_LOG, (String)("RangerHiveAuthorizer.checkPrivileges(hiveOpType=" + hiveOpType + ")"));
            }
            ArrayList<RangerHiveAccessRequest> requests = new ArrayList<RangerHiveAccessRequest>();
            if (!CollectionUtils.isEmpty(inputHObjs)) {
                for (HivePrivilegeObject hivePrivilegeObject : inputHObjs) {
                    resource = this.getHiveResource(hiveOpType, hivePrivilegeObject, inputHObjs, outputHObjs);
                    if (resource == null) continue;
                    pathStr = hivePrivilegeObject.getObjectName();
                    hiveObjType = resource.getObjectType();
                    if (hiveObjType == HiveObjectType.URI && this.isPathInFSScheme(pathStr)) {
                        permission = this.getURIAccessType(hiveOpType);
                        Path path = new Path(pathStr);
                        fs = null;
                        try {
                            fs = FileSystem.get((URI)path.toUri(), (Configuration)this.getHiveConf());
                        }
                        catch (IOException e) {
                            LOG.error((Object)("Error getting permissions for " + path), (Throwable)e);
                            throw new HiveAccessControlException(String.format("Permission denied: user [%s] does not have [%s] privilege on [%s]", user, permission.name(), path), (Throwable)e);
                        }
                        shouldCheckAccess = true;
                        if (this.isMountedFs(fs) && (resolvedPath = this.resolvePath(path, fs)) != null) {
                            shouldCheckAccess = this.isPathInFSScheme(resolvedPath.toUri().toString());
                        }
                        if (shouldCheckAccess) {
                            if (this.isURIAccessAllowed(user, permission, path, fs)) continue;
                            throw new HiveAccessControlException(String.format("Permission denied: user [%s] does not have [%s] privilege on [%s]", user, permission.name(), path));
                        }
                    }
                    if ((accessType = this.getAccessType(hivePrivilegeObject, hiveOpType, hiveObjType, true)) == HiveAccessType.NONE || this.existsByResourceAndAccessType(requests, resource, accessType)) continue;
                    RangerHiveAccessRequest rangerHiveAccessRequest = new RangerHiveAccessRequest(resource, user, (Set<String>)groups, roles, hiveOpType, accessType, context, sessionContext);
                    requests.add(rangerHiveAccessRequest);
                }
            } else if (hiveOpType == HiveOperationType.SHOWDATABASES) {
                RangerHiveResource rangerHiveResource = new RangerHiveResource(HiveObjectType.DATABASE, null);
                RangerHiveAccessRequest rangerHiveAccessRequest = new RangerHiveAccessRequest(rangerHiveResource, user, (Set<String>)groups, roles, hiveOpType.name(), HiveAccessType.USE, context, sessionContext);
                requests.add(rangerHiveAccessRequest);
            } else if (hiveOpType == HiveOperationType.REPLDUMP) {
                void var13_18;
                Object var13_15 = null;
                HiveObj hiveObj = new HiveObj(context);
                dbName = hiveObj.getDatabaseName();
                tableName = hiveObj.getTableName();
                LOG.debug((Object)("Database: " + dbName + " Table: " + tableName));
                if (!StringUtil.isEmpty((String)tableName)) {
                    RangerHiveResource rangerHiveResource = new RangerHiveResource(HiveObjectType.TABLE, dbName, tableName);
                } else {
                    RangerHiveResource rangerHiveResource = new RangerHiveResource(HiveObjectType.DATABASE, dbName, null);
                }
                request = new RangerHiveAccessRequest((RangerHiveResource)var13_18, user, (Set<String>)groups, roles, hiveOpType.name(), HiveAccessType.REPLADMIN, context, sessionContext);
                requests.add(request);
            } else if (hiveOpType.equals((Object)HiveOperationType.ALTERTABLE_OWNER)) {
                RangerHiveAccessRequest rangerHiveAccessRequest = this.buildRequestForAlterTableSetOwnerFromCommandString(user, groups, roles, hiveOpType.name(), context, sessionContext);
                if (rangerHiveAccessRequest == null) throw new HiveAccessControlException(String.format("Permission denied: user [%s] does not have privilege for [%s] command", user, hiveOpType.name()));
                requests.add(rangerHiveAccessRequest);
            } else if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("RangerHiveAuthorizer.checkPrivileges: Unexpected operation type[" + hiveOpType + "] received with empty input objects list!"));
            }
            if (!CollectionUtils.isEmpty(outputHObjs)) {
                for (HivePrivilegeObject hivePrivilegeObject : outputHObjs) {
                    resource = this.getHiveResource(hiveOpType, hivePrivilegeObject, inputHObjs, outputHObjs);
                    if (resource == null) continue;
                    pathStr = hivePrivilegeObject.getObjectName();
                    hiveObjType = resource.getObjectType();
                    if (hiveObjType == HiveObjectType.URI && this.isPathInFSScheme(pathStr)) {
                        permission = this.getURIAccessType(hiveOpType);
                        Path path = new Path(pathStr);
                        fs = null;
                        try {
                            fs = FileSystem.get((URI)path.toUri(), (Configuration)this.getHiveConf());
                        }
                        catch (IOException e) {
                            LOG.error((Object)("Error getting permissions for " + path), (Throwable)e);
                            throw new HiveAccessControlException(String.format("Permission denied: user [%s] does not have [%s] privilege on [%s]", user, permission.name(), path), (Throwable)e);
                        }
                        shouldCheckAccess = true;
                        if (this.isMountedFs(fs) && (resolvedPath = this.resolvePath(path, fs)) != null) {
                            shouldCheckAccess = this.isPathInFSScheme(resolvedPath.toUri().toString());
                        }
                        if (shouldCheckAccess) {
                            if (this.isURIAccessAllowed(user, permission, path, fs)) continue;
                            throw new HiveAccessControlException(String.format("Permission denied: user [%s] does not have [%s] privilege on [%s]", user, permission.name(), path));
                        }
                    }
                    if ((accessType = this.getAccessType(hivePrivilegeObject, hiveOpType, hiveObjType, false)) == HiveAccessType.NONE || this.existsByResourceAndAccessType(requests, resource, accessType)) continue;
                    RangerHiveAccessRequest rangerHiveAccessRequest = new RangerHiveAccessRequest(resource, user, (Set<String>)groups, roles, hiveOpType, accessType, context, sessionContext);
                    requests.add(rangerHiveAccessRequest);
                }
            } else if (hiveOpType == HiveOperationType.REPLLOAD) {
                void var13_25;
                Object var13_22 = null;
                HiveObj hiveObj = new HiveObj(context);
                dbName = hiveObj.getDatabaseName();
                tableName = hiveObj.getTableName();
                LOG.debug((Object)("Database: " + dbName + " Table: " + tableName));
                if (!StringUtil.isEmpty((String)tableName)) {
                    RangerHiveResource rangerHiveResource = new RangerHiveResource(HiveObjectType.TABLE, dbName, tableName);
                } else {
                    RangerHiveResource rangerHiveResource = new RangerHiveResource(HiveObjectType.DATABASE, dbName, null);
                }
                request = new RangerHiveAccessRequest((RangerHiveResource)var13_25, user, (Set<String>)groups, roles, hiveOpType.name(), HiveAccessType.REPLADMIN, context, sessionContext);
                requests.add(request);
            }
            this.buildRequestContextWithAllAccessedResources(requests);
            for (RangerHiveAccessRequest rangerHiveAccessRequest : requests) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("request: " + (Object)((Object)rangerHiveAccessRequest)));
                }
                resource = (RangerHiveResource)rangerHiveAccessRequest.getResource();
                RangerAccessResult result = null;
                if (resource.getObjectType() == HiveObjectType.COLUMN && StringUtils.contains((String)resource.getColumn(), (char)',')) {
                    ArrayList<RangerHiveAccessRequest> colRequests = new ArrayList<RangerHiveAccessRequest>();
                    String[] columns = StringUtils.split((String)resource.getColumn(), (char)',');
                    resource.setServiceDef(hivePlugin.getServiceDef());
                    for (String column : columns) {
                        if (column != null) {
                            column = column.trim();
                        }
                        if (StringUtils.isBlank((String)column)) continue;
                        RangerHiveResource colResource = new RangerHiveResource(HiveObjectType.COLUMN, resource.getDatabase(), resource.getTable(), column);
                        colResource.setOwnerUser(resource.getOwnerUser());
                        RangerHiveAccessRequest colRequest = rangerHiveAccessRequest.copy();
                        colRequest.setResource((RangerAccessResource)colResource);
                        colRequests.add(colRequest);
                    }
                    Collection collection = hivePlugin.isAccessAllowed(colRequests, (RangerAccessResultProcessor)auditHandler);
                    if (collection != null) {
                        RangerAccessResult colResult;
                        Iterator fs2 = collection.iterator();
                        while (fs2.hasNext() && ((result = (colResult = (RangerAccessResult)fs2.next())) == null || result.getIsAllowed())) {
                        }
                    }
                } else {
                    result = hivePlugin.isAccessAllowed((RangerAccessRequest)rangerHiveAccessRequest, (RangerAccessResultProcessor)auditHandler);
                }
                if ((result == null || result.getIsAllowed()) && this.isBlockAccessIfRowfilterColumnMaskSpecified(hiveOpType, rangerHiveAccessRequest)) {
                    HiveAccessType savedAccessType = rangerHiveAccessRequest.getHiveAccessType();
                    RangerHiveResource tblResource = new RangerHiveResource(HiveObjectType.TABLE, resource.getDatabase(), resource.getTable());
                    rangerHiveAccessRequest.setHiveAccessType(HiveAccessType.SELECT);
                    rangerHiveAccessRequest.setResource((RangerAccessResource)tblResource);
                    RangerAccessResult rangerAccessResult = this.getRowFilterResult(rangerHiveAccessRequest);
                    if (this.isRowFilterEnabled(rangerAccessResult)) {
                        if (result == null) {
                            result = new RangerAccessResult(0, rangerAccessResult.getServiceName(), rangerAccessResult.getServiceDef(), (RangerAccessRequest)rangerHiveAccessRequest);
                        }
                        result.setIsAllowed(false);
                        result.setPolicyId(rangerAccessResult.getPolicyId());
                        result.setReason("User does not have access to all rows of the table");
                    } else {
                        rangerHiveAccessRequest.setResourceMatchingScope(RangerAccessRequest.ResourceMatchingScope.SELF_OR_DESCENDANTS);
                        RangerAccessResult dataMaskResult = this.getDataMaskResult(rangerHiveAccessRequest);
                        if (this.isDataMaskEnabled(dataMaskResult)) {
                            if (result == null) {
                                result = new RangerAccessResult(0, dataMaskResult.getServiceName(), dataMaskResult.getServiceDef(), (RangerAccessRequest)rangerHiveAccessRequest);
                            }
                            result.setIsAllowed(false);
                            result.setPolicyId(dataMaskResult.getPolicyId());
                            result.setReason("User does not have access to unmasked column values");
                        }
                    }
                    rangerHiveAccessRequest.setHiveAccessType(savedAccessType);
                    rangerHiveAccessRequest.setResource((RangerAccessResource)resource);
                    if (result != null && !result.getIsAllowed()) {
                        auditHandler.processResult(result);
                    }
                }
                if (result != null && result.getIsAllowed()) continue;
                String path = resource.getAsString();
                path = path == null ? "Unknown resource!!" : this.buildPathForException(path, hiveOpType);
                throw new HiveAccessControlException(String.format("Permission denied: user [%s] does not have [%s] privilege on [%s]", user, rangerHiveAccessRequest.getHiveAccessType().name(), path));
            }
            auditHandler.flushAudit();
        }
        catch (Throwable throwable) {
            auditHandler.flushAudit();
            RangerPerfTracer.log(perf);
            throw throwable;
        }
        RangerPerfTracer.log((RangerPerfTracer)perf);
    }

    public List<HivePrivilegeObject> filterListCmdObjects(List<HivePrivilegeObject> objs, HiveAuthzContext context) throws HiveAuthzPluginException, HiveAccessControlException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("==> filterListCmdObjects(%s, %s)", objs, context));
        }
        RangerPerfTracer perf = null;
        RangerHiveAuditHandler auditHandler = new RangerHiveAuditHandler();
        if (RangerPerfTracer.isPerfTraceEnabled((Log)PERF_HIVEAUTH_REQUEST_LOG)) {
            perf = RangerPerfTracer.getPerfTracer((Log)PERF_HIVEAUTH_REQUEST_LOG, (String)"RangerHiveAuthorizer.filterListCmdObjects()");
        }
        List<HivePrivilegeObject> ret = null;
        if (objs == null) {
            LOG.debug((Object)"filterListCmdObjects: meta objects list was null!");
        } else if (objs.isEmpty()) {
            LOG.debug((Object)"filterListCmdObjects: meta objects list was empty!");
            ret = objs;
        } else if (this.getCurrentUserGroupInfo() == null) {
            LOG.warn((Object)"filterListCmdObjects: user information not available");
            ret = objs;
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("filterListCmdObjects: number of input objects[" + objs.size() + "]"));
            }
            UserGroupInformation ugi = this.getCurrentUserGroupInfo();
            HiveAuthzSessionContext sessionContext = this.getHiveAuthzSessionContext();
            String user = ugi.getShortUserName();
            HashSet groups = Sets.newHashSet((Object[])ugi.getGroupNames());
            Set<String> roles = this.getCurrentRolesForUser(user, groups);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)String.format("filterListCmdObjects: user[%s], groups[%s], roles[%s] ", user, groups, roles));
            }
            if (ret == null) {
                ret = new ArrayList<HivePrivilegeObject>(objs.size());
            }
            for (HivePrivilegeObject privilegeObject : objs) {
                RangerHiveResource resource;
                if (LOG.isDebugEnabled()) {
                    HivePrivilegeObject.HivePrivObjectActionType actionType = privilegeObject.getActionType();
                    HivePrivilegeObject.HivePrivilegeObjectType objectType = privilegeObject.getType();
                    String objectName = privilegeObject.getObjectName();
                    String dbName = privilegeObject.getDbname();
                    List columns = privilegeObject.getColumns();
                    List partitionKeys = privilegeObject.getPartKeys();
                    String commandString = context == null ? null : context.getCommandString();
                    String ipAddress = context == null ? null : context.getIpAddress();
                    String format = "filterListCmdObjects: actionType[%s], objectType[%s], objectName[%s], dbName[%s], columns[%s], partitionKeys[%s]; context: commandString[%s], ipAddress[%s]";
                    LOG.debug((Object)String.format("filterListCmdObjects: actionType[%s], objectType[%s], objectName[%s], dbName[%s], columns[%s], partitionKeys[%s]; context: commandString[%s], ipAddress[%s]", actionType, objectType, objectName, dbName, columns, partitionKeys, commandString, ipAddress));
                }
                if ((resource = RangerHiveAuthorizer.createHiveResourceForFiltering(privilegeObject)) == null) {
                    LOG.error((Object)"filterListCmdObjects: RangerHiveResource returned by createHiveResource is null");
                    continue;
                }
                RangerHiveAccessRequest request = new RangerHiveAccessRequest(resource, user, groups, roles, context, sessionContext);
                RangerAccessResult result = hivePlugin.isAccessAllowed((RangerAccessRequest)request, (RangerAccessResultProcessor)auditHandler);
                if (result == null) {
                    LOG.error((Object)"filterListCmdObjects: Internal error: null RangerAccessResult object received back from isAccessAllowed()!");
                    continue;
                }
                if (!result.getIsAllowed()) {
                    if (LOG.isDebugEnabled()) continue;
                    String path = resource.getAsString();
                    LOG.debug((Object)String.format("filterListCmdObjects: Permission denied: user [%s] does not have [%s] privilege on [%s]. resource[%s], request[%s], result[%s]", new Object[]{user, request.getHiveAccessType().name(), path, resource, request, result}));
                    continue;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)String.format("filterListCmdObjects: access allowed. resource[%s], request[%s], result[%s]", new Object[]{resource, request, result}));
                }
                ret.add(privilegeObject);
            }
        }
        auditHandler.flushAudit();
        RangerPerfTracer.log((RangerPerfTracer)perf);
        if (LOG.isDebugEnabled()) {
            int count = ret == null ? 0 : ret.size();
            LOG.debug((Object)String.format("<== filterListCmdObjects: count[%d], ret[%s]", count, ret));
        }
        return ret;
    }

    public List<HivePrivilegeObject> applyRowFilterAndColumnMasking(HiveAuthzContext queryContext, List<HivePrivilegeObject> hiveObjs) throws SemanticException {
        ArrayList<HivePrivilegeObject> ret = new ArrayList<HivePrivilegeObject>();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> applyRowFilterAndColumnMasking(" + queryContext + ", objCount=" + hiveObjs.size() + ")"));
        }
        RangerPerfTracer perf = null;
        if (RangerPerfTracer.isPerfTraceEnabled((Log)PERF_HIVEAUTH_REQUEST_LOG)) {
            perf = RangerPerfTracer.getPerfTracer((Log)PERF_HIVEAUTH_REQUEST_LOG, (String)"RangerHiveAuthorizer.applyRowFilterAndColumnMasking()");
        }
        if (CollectionUtils.isNotEmpty(hiveObjs)) {
            for (HivePrivilegeObject hiveObj : hiveObjs) {
                HivePrivilegeObject.HivePrivilegeObjectType hiveObjType = hiveObj.getType();
                if (hiveObjType == null) {
                    hiveObjType = HivePrivilegeObject.HivePrivilegeObjectType.TABLE_OR_VIEW;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("applyRowFilterAndColumnMasking(hiveObjType=" + hiveObjType + ")"));
                }
                boolean needToTransform = false;
                if (hiveObjType == HivePrivilegeObject.HivePrivilegeObjectType.TABLE_OR_VIEW) {
                    String table;
                    String database = hiveObj.getDbname();
                    String rowFilterExpr = this.getRowFilterExpression(queryContext, database, table = hiveObj.getObjectName());
                    if (StringUtils.isNotBlank((String)rowFilterExpr)) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug((Object)("rowFilter(database=" + database + ", table=" + table + "): " + rowFilterExpr));
                        }
                        hiveObj.setRowFilterExpression(rowFilterExpr);
                        needToTransform = true;
                    }
                    if (CollectionUtils.isNotEmpty((Collection)hiveObj.getColumns())) {
                        ArrayList<String> columnTransformers = new ArrayList<String>();
                        for (String column : hiveObj.getColumns()) {
                            boolean isColumnTransformed = this.addCellValueTransformerAndCheckIfTransformed(queryContext, database, table, column, columnTransformers);
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)("addCellValueTransformerAndCheckIfTransformed(database=" + database + ", table=" + table + ", column=" + column + "): " + isColumnTransformed));
                            }
                            needToTransform = needToTransform || isColumnTransformed;
                        }
                        hiveObj.setCellValueTransformers(columnTransformers);
                    }
                }
                if (!needToTransform) continue;
                ret.add(hiveObj);
            }
        }
        RangerPerfTracer.log((RangerPerfTracer)perf);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== applyRowFilterAndColumnMasking(" + queryContext + ", objCount=" + hiveObjs.size() + "): retCount=" + ret.size()));
        }
        return ret;
    }

    public boolean needTransform() {
        return true;
    }

    private RangerAccessResult getDataMaskResult(RangerHiveAccessRequest request) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> getDataMaskResult(request=" + (Object)((Object)request) + ")"));
        }
        RangerAccessResult ret = hivePlugin.evalDataMaskPolicies((RangerAccessRequest)request, null);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== getDataMaskResult(request=" + (Object)((Object)request) + "): ret=" + ret));
        }
        return ret;
    }

    private RangerAccessResult getRowFilterResult(RangerHiveAccessRequest request) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> getRowFilterResult(request=" + (Object)((Object)request) + ")"));
        }
        RangerAccessResult ret = hivePlugin.evalRowFilterPolicies((RangerAccessRequest)request, null);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== getRowFilterResult(request=" + (Object)((Object)request) + "): ret=" + ret));
        }
        return ret;
    }

    private boolean isDataMaskEnabled(RangerAccessResult result) {
        return result != null && result.isMaskEnabled();
    }

    private boolean isRowFilterEnabled(RangerAccessResult result) {
        return result != null && result.isRowFilterEnabled() && StringUtils.isNotEmpty((String)result.getFilterExpr());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getRowFilterExpression(HiveAuthzContext context, String databaseName, String tableOrViewName) throws SemanticException {
        UserGroupInformation ugi = this.getCurrentUserGroupInfo();
        if (ugi == null) {
            throw new SemanticException("user information not available");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> getRowFilterExpression(" + databaseName + ", " + tableOrViewName + ")"));
        }
        String ret = null;
        RangerHiveAuditHandler auditHandler = new RangerHiveAuditHandler();
        try {
            HiveAuthzSessionContext sessionContext = this.getHiveAuthzSessionContext();
            String user = ugi.getShortUserName();
            HashSet groups = Sets.newHashSet((Object[])ugi.getGroupNames());
            Set<String> roles = this.getCurrentRolesForUser(user, groups);
            HiveObjectType objectType = HiveObjectType.TABLE;
            RangerHiveResource resource = new RangerHiveResource(objectType, databaseName, tableOrViewName);
            RangerHiveAccessRequest request = new RangerHiveAccessRequest(resource, user, (Set<String>)groups, roles, objectType.name(), HiveAccessType.SELECT, context, sessionContext);
            RangerAccessResult result = hivePlugin.evalRowFilterPolicies((RangerAccessRequest)request, (RangerAccessResultProcessor)auditHandler);
            if (this.isRowFilterEnabled(result)) {
                ret = result.getFilterExpr();
            }
        }
        finally {
            auditHandler.flushAudit();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== getRowFilterExpression(" + databaseName + ", " + tableOrViewName + "): " + ret));
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addCellValueTransformerAndCheckIfTransformed(HiveAuthzContext context, String databaseName, String tableOrViewName, String columnName, List<String> columnTransformers) throws SemanticException {
        UserGroupInformation ugi = this.getCurrentUserGroupInfo();
        if (ugi == null) {
            throw new SemanticException("user information not available");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> addCellValueTransformerAndCheckIfTransformed(" + databaseName + ", " + tableOrViewName + ", " + columnName + ")"));
        }
        boolean ret = false;
        String columnTransformer = columnName;
        RangerHiveAuditHandler auditHandler = new RangerHiveAuditHandler();
        try {
            HiveAuthzSessionContext sessionContext = this.getHiveAuthzSessionContext();
            String user = ugi.getShortUserName();
            HashSet groups = Sets.newHashSet((Object[])ugi.getGroupNames());
            Set<String> roles = this.getCurrentRolesForUser(user, groups);
            HiveObjectType objectType = HiveObjectType.COLUMN;
            RangerHiveResource resource = new RangerHiveResource(objectType, databaseName, tableOrViewName, columnName);
            RangerHiveAccessRequest request = new RangerHiveAccessRequest(resource, user, (Set<String>)groups, roles, objectType.name(), HiveAccessType.SELECT, context, sessionContext);
            RangerAccessResult result = hivePlugin.evalDataMaskPolicies((RangerAccessRequest)request, (RangerAccessResultProcessor)auditHandler);
            ret = this.isDataMaskEnabled(result);
            if (ret) {
                String maskType = result.getMaskType();
                RangerServiceDef.RangerDataMaskTypeDef maskTypeDef = result.getMaskTypeDef();
                String transformer = null;
                if (maskTypeDef != null) {
                    transformer = maskTypeDef.getTransformer();
                }
                if (StringUtils.equalsIgnoreCase((String)maskType, (String)"MASK_NULL")) {
                    columnTransformer = "NULL";
                } else if (StringUtils.equalsIgnoreCase((String)maskType, (String)"CUSTOM")) {
                    String maskedValue = result.getMaskedValue();
                    columnTransformer = maskedValue == null ? "NULL" : maskedValue.replace("{col}", columnName);
                } else if (StringUtils.isNotEmpty((String)transformer)) {
                    columnTransformer = transformer.replace("{col}", columnName);
                }
            }
        }
        finally {
            auditHandler.flushAudit();
        }
        columnTransformers.add(columnTransformer);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== addCellValueTransformerAndCheckIfTransformed(" + databaseName + ", " + tableOrViewName + ", " + columnName + "): " + ret));
        }
        return ret;
    }

    static RangerHiveResource createHiveResourceForFiltering(HivePrivilegeObject privilegeObject) {
        RangerHiveResource resource = null;
        HivePrivilegeObject.HivePrivilegeObjectType objectType = privilegeObject.getType();
        switch (objectType) {
            case DATABASE: 
            case TABLE_OR_VIEW: {
                resource = RangerHiveAuthorizer.createHiveResource(privilegeObject);
                break;
            }
            default: {
                LOG.warn((Object)("RangerHiveAuthorizer.getHiveResourceForFiltering: unexpected objectType:" + objectType));
            }
        }
        return resource;
    }

    static RangerHiveResource createHiveResource(HivePrivilegeObject privilegeObject) {
        RangerHiveResource resource = null;
        HivePrivilegeObject.HivePrivilegeObjectType objectType = privilegeObject.getType();
        String objectName = privilegeObject.getObjectName();
        String dbName = privilegeObject.getDbname();
        switch (objectType) {
            case DATABASE: {
                resource = new RangerHiveResource(HiveObjectType.DATABASE, dbName);
                break;
            }
            case TABLE_OR_VIEW: {
                resource = new RangerHiveResource(HiveObjectType.TABLE, dbName, objectName);
                break;
            }
            case COLUMN: {
                int numOfColumns;
                List columns = privilegeObject.getColumns();
                int n = numOfColumns = columns == null ? 0 : columns.size();
                if (numOfColumns == 1) {
                    resource = new RangerHiveResource(HiveObjectType.COLUMN, dbName, objectName, (String)columns.get(0));
                    break;
                }
                LOG.warn((Object)("RangerHiveAuthorizer.getHiveResource: unexpected number of columns requested:" + numOfColumns + ", objectType:" + objectType));
                break;
            }
            default: {
                LOG.warn((Object)("RangerHiveAuthorizer.getHiveResource: unexpected objectType:" + objectType));
            }
        }
        if (resource != null) {
            resource.setServiceDef(hivePlugin == null ? null : hivePlugin.getServiceDef());
        }
        return resource;
    }

    private RangerHiveResource getHiveResource(HiveOperationType hiveOpType, HivePrivilegeObject hiveObj, List<HivePrivilegeObject> inputs, List<HivePrivilegeObject> outputs) {
        RangerHiveResource ret = null;
        HiveObjectType objectType = this.getObjectType(hiveObj, hiveOpType);
        switch (objectType) {
            case DATABASE: {
                ret = new RangerHiveResource(objectType, hiveObj.getDbname());
                break;
            }
            case TABLE: 
            case VIEW: 
            case FUNCTION: {
                ret = new RangerHiveResource(objectType, hiveObj.getDbname(), hiveObj.getObjectName());
                if (!LOG.isDebugEnabled()) break;
                LOG.debug((Object)("Size of inputs = [" + (CollectionUtils.isNotEmpty(inputs) ? inputs.size() : 0) + ", Size of outputs = [" + (CollectionUtils.isNotEmpty(outputs) ? outputs.size() : 0) + "]"));
                break;
            }
            case PARTITION: 
            case INDEX: {
                ret = new RangerHiveResource(objectType, hiveObj.getDbname(), hiveObj.getObjectName());
                break;
            }
            case COLUMN: {
                ret = new RangerHiveResource(objectType, hiveObj.getDbname(), hiveObj.getObjectName(), StringUtils.join((Collection)hiveObj.getColumns(), (char)','));
                break;
            }
            case URI: 
            case SERVICE_NAME: {
                ret = new RangerHiveResource(objectType, hiveObj.getObjectName());
                break;
            }
            case GLOBAL: {
                ret = new RangerHiveResource(objectType, hiveObj.getObjectName());
                break;
            }
        }
        if (ret != null) {
            ret.setServiceDef(hivePlugin == null ? null : hivePlugin.getServiceDef());
        }
        return ret;
    }

    private HiveObjectType getObjectType(HivePrivilegeObject hiveObj, HiveOperationType hiveOpType) {
        HiveObjectType objType = HiveObjectType.NONE;
        String hiveOpTypeName = hiveOpType.name().toLowerCase();
        if (hiveObj.getType() == null) {
            return HiveObjectType.DATABASE;
        }
        switch (hiveObj.getType()) {
            case DATABASE: {
                objType = HiveObjectType.DATABASE;
                break;
            }
            case PARTITION: {
                objType = HiveObjectType.PARTITION;
                break;
            }
            case TABLE_OR_VIEW: {
                if (hiveOpTypeName.contains("index")) {
                    objType = HiveObjectType.INDEX;
                    break;
                }
                if (!StringUtil.isEmpty((Collection)hiveObj.getColumns())) {
                    objType = HiveObjectType.COLUMN;
                    break;
                }
                if (hiveOpTypeName.contains("view")) {
                    objType = HiveObjectType.VIEW;
                    break;
                }
                objType = HiveObjectType.TABLE;
                break;
            }
            case FUNCTION: {
                objType = HiveObjectType.FUNCTION;
                if (!this.isTempUDFOperation(hiveOpTypeName, hiveObj)) break;
                objType = HiveObjectType.GLOBAL;
                break;
            }
            case DFS_URI: 
            case LOCAL_URI: {
                objType = HiveObjectType.URI;
                break;
            }
            case COMMAND_PARAMS: 
            case GLOBAL: {
                if (!"add".equals(hiveOpTypeName) && !"compile".equals(hiveOpTypeName)) break;
                objType = HiveObjectType.GLOBAL;
                break;
            }
            case SERVICE_NAME: {
                objType = HiveObjectType.SERVICE_NAME;
                break;
            }
        }
        return objType;
    }

    private HiveAccessType getAccessType(HivePrivilegeObject hiveObj, HiveOperationType hiveOpType, HiveObjectType hiveObjectType, boolean isInput) {
        HiveAccessType accessType;
        block39: {
            accessType = HiveAccessType.NONE;
            HivePrivilegeObject.HivePrivObjectActionType objectActionType = hiveObj.getActionType();
            if (hiveObjectType == HiveObjectType.URI && isInput) {
                accessType = HiveAccessType.READ;
                return accessType;
            }
            if (hiveObjectType == HiveObjectType.URI && !isInput) {
                accessType = HiveAccessType.WRITE;
                return accessType;
            }
            block0 : switch (objectActionType) {
                case INSERT: 
                case INSERT_OVERWRITE: 
                case UPDATE: 
                case DELETE: {
                    accessType = HiveAccessType.UPDATE;
                    break;
                }
                case OTHER: {
                    switch (hiveOpType) {
                        case CREATEDATABASE: {
                            if (hiveObj.getType() == HivePrivilegeObject.HivePrivilegeObjectType.DATABASE) {
                                accessType = HiveAccessType.CREATE;
                                break block0;
                            }
                            break block39;
                        }
                        case CREATEFUNCTION: {
                            if (hiveObj.getType() == HivePrivilegeObject.HivePrivilegeObjectType.FUNCTION) {
                                accessType = HiveAccessType.CREATE;
                            }
                            if (hiveObjectType == HiveObjectType.GLOBAL) {
                                accessType = HiveAccessType.TEMPUDFADMIN;
                                break block0;
                            }
                            break block39;
                        }
                        case CREATETABLE: 
                        case CREATEVIEW: 
                        case CREATETABLE_AS_SELECT: 
                        case CREATE_MATERIALIZED_VIEW: {
                            if (hiveObj.getType() == HivePrivilegeObject.HivePrivilegeObjectType.TABLE_OR_VIEW) {
                                accessType = isInput ? HiveAccessType.SELECT : HiveAccessType.CREATE;
                                break block0;
                            }
                            break block39;
                        }
                        case ALTERDATABASE: 
                        case ALTERDATABASE_LOCATION: 
                        case ALTERDATABASE_OWNER: 
                        case ALTERINDEX_PROPS: 
                        case ALTERINDEX_REBUILD: 
                        case ALTERPARTITION_BUCKETNUM: 
                        case ALTERPARTITION_FILEFORMAT: 
                        case ALTERPARTITION_LOCATION: 
                        case ALTERPARTITION_MERGEFILES: 
                        case ALTERPARTITION_PROTECTMODE: 
                        case ALTERPARTITION_SERDEPROPERTIES: 
                        case ALTERPARTITION_SERIALIZER: 
                        case ALTERTABLE_ADDCOLS: 
                        case ALTERTABLE_ADDPARTS: 
                        case ALTERTABLE_ARCHIVE: 
                        case ALTERTABLE_BUCKETNUM: 
                        case ALTERTABLE_CLUSTER_SORT: 
                        case ALTERTABLE_COMPACT: 
                        case ALTERTABLE_DROPPARTS: 
                        case ALTERTABLE_DROPCONSTRAINT: 
                        case ALTERTABLE_ADDCONSTRAINT: 
                        case ALTERTABLE_FILEFORMAT: 
                        case ALTERTABLE_LOCATION: 
                        case ALTERTABLE_MERGEFILES: 
                        case ALTERTABLE_PARTCOLTYPE: 
                        case ALTERTABLE_PROPERTIES: 
                        case ALTERTABLE_PROTECTMODE: 
                        case ALTERTABLE_RENAME: 
                        case ALTERTABLE_RENAMECOL: 
                        case ALTERTABLE_RENAMEPART: 
                        case ALTERTABLE_REPLACECOLS: 
                        case ALTERTABLE_SERDEPROPERTIES: 
                        case ALTERTABLE_SERIALIZER: 
                        case ALTERTABLE_SKEWED: 
                        case ALTERTABLE_TOUCH: 
                        case ALTERTABLE_UNARCHIVE: 
                        case ALTERTABLE_UPDATEPARTSTATS: 
                        case ALTERTABLE_UPDATETABLESTATS: 
                        case ALTERTABLE_UPDATECOLUMNS: 
                        case ALTERTBLPART_SKEWED_LOCATION: 
                        case ALTERVIEW_AS: 
                        case ALTERVIEW_PROPERTIES: 
                        case ALTERVIEW_RENAME: 
                        case ALTER_MATERIALIZED_VIEW_REWRITE: 
                        case DROPVIEW_PROPERTIES: 
                        case MSCK: {
                            accessType = HiveAccessType.ALTER;
                            break block0;
                        }
                        case DROPFUNCTION: 
                        case DROPINDEX: 
                        case DROPTABLE: 
                        case DROPVIEW: 
                        case DROP_MATERIALIZED_VIEW: 
                        case DROPDATABASE: {
                            accessType = HiveAccessType.DROP;
                            break block0;
                        }
                        case CREATEINDEX: {
                            accessType = HiveAccessType.INDEX;
                            break block0;
                        }
                        case IMPORT: {
                            accessType = isInput ? HiveAccessType.SELECT : HiveAccessType.CREATE;
                            break block0;
                        }
                        case EXPORT: 
                        case LOAD: {
                            accessType = isInput ? HiveAccessType.SELECT : HiveAccessType.UPDATE;
                            break block0;
                        }
                        case LOCKDB: 
                        case LOCKTABLE: 
                        case UNLOCKDB: 
                        case UNLOCKTABLE: {
                            accessType = HiveAccessType.LOCK;
                            break block0;
                        }
                        case QUERY: 
                        case SHOW_TABLESTATUS: 
                        case SHOW_CREATETABLE: 
                        case SHOWINDEXES: 
                        case SHOWPARTITIONS: 
                        case SHOW_TBLPROPERTIES: 
                        case ANALYZE_TABLE: {
                            accessType = HiveAccessType.SELECT;
                            break block0;
                        }
                        case SHOWCOLUMNS: 
                        case DESCTABLE: {
                            switch (StringUtil.toLower((String)RangerHivePlugin.DescribeShowTableAuth)) {
                                case "show-allowed": 
                                case "none": 
                                case "": {
                                    accessType = HiveAccessType.SELECT;
                                    break block0;
                                }
                                case "show-all": {
                                    accessType = HiveAccessType.USE;
                                }
                            }
                            break block0;
                        }
                        case SHOWDATABASES: 
                        case SWITCHDATABASE: 
                        case DESCDATABASE: 
                        case SHOWTABLES: 
                        case SHOWVIEWS: {
                            accessType = HiveAccessType.USE;
                            break block0;
                        }
                        case TRUNCATETABLE: {
                            accessType = HiveAccessType.UPDATE;
                            break block0;
                        }
                        case GRANT_PRIVILEGE: 
                        case REVOKE_PRIVILEGE: {
                            accessType = HiveAccessType.NONE;
                            break block0;
                        }
                        case REPLDUMP: 
                        case REPLLOAD: 
                        case REPLSTATUS: {
                            accessType = HiveAccessType.REPLADMIN;
                            break block0;
                        }
                        case KILL_QUERY: 
                        case CREATE_RESOURCEPLAN: 
                        case SHOW_RESOURCEPLAN: 
                        case ALTER_RESOURCEPLAN: 
                        case DROP_RESOURCEPLAN: 
                        case CREATE_TRIGGER: 
                        case ALTER_TRIGGER: 
                        case DROP_TRIGGER: 
                        case CREATE_POOL: 
                        case ALTER_POOL: 
                        case DROP_POOL: 
                        case CREATE_MAPPING: 
                        case ALTER_MAPPING: 
                        case DROP_MAPPING: 
                        case LLAP_CACHE_PURGE: 
                        case LLAP_CLUSTER_INFO: {
                            accessType = HiveAccessType.SERVICEADMIN;
                            break block0;
                        }
                        case ADD: 
                        case COMPILE: {
                            accessType = HiveAccessType.TEMPUDFADMIN;
                            break block0;
                        }
                    }
                }
            }
        }
        return accessType;
    }

    private FsAction getURIAccessType(HiveOperationType hiveOpType) {
        FsAction ret = FsAction.NONE;
        switch (hiveOpType) {
            case IMPORT: 
            case LOAD: {
                ret = FsAction.READ;
                break;
            }
            case EXPORT: {
                ret = FsAction.WRITE;
                break;
            }
            case CREATEDATABASE: 
            case CREATEFUNCTION: 
            case CREATETABLE: 
            case CREATETABLE_AS_SELECT: 
            case ALTERDATABASE: 
            case ALTERDATABASE_LOCATION: 
            case ALTERDATABASE_OWNER: 
            case ALTERINDEX_PROPS: 
            case ALTERPARTITION_BUCKETNUM: 
            case ALTERPARTITION_FILEFORMAT: 
            case ALTERPARTITION_LOCATION: 
            case ALTERPARTITION_MERGEFILES: 
            case ALTERPARTITION_PROTECTMODE: 
            case ALTERPARTITION_SERDEPROPERTIES: 
            case ALTERPARTITION_SERIALIZER: 
            case ALTERTABLE_ADDCOLS: 
            case ALTERTABLE_ADDPARTS: 
            case ALTERTABLE_ARCHIVE: 
            case ALTERTABLE_BUCKETNUM: 
            case ALTERTABLE_CLUSTER_SORT: 
            case ALTERTABLE_COMPACT: 
            case ALTERTABLE_DROPPARTS: 
            case ALTERTABLE_DROPCONSTRAINT: 
            case ALTERTABLE_ADDCONSTRAINT: 
            case ALTERTABLE_FILEFORMAT: 
            case ALTERTABLE_LOCATION: 
            case ALTERTABLE_MERGEFILES: 
            case ALTERTABLE_PARTCOLTYPE: 
            case ALTERTABLE_PROPERTIES: 
            case ALTERTABLE_PROTECTMODE: 
            case ALTERTABLE_RENAME: 
            case ALTERTABLE_RENAMECOL: 
            case ALTERTABLE_RENAMEPART: 
            case ALTERTABLE_REPLACECOLS: 
            case ALTERTABLE_SERDEPROPERTIES: 
            case ALTERTABLE_SERIALIZER: 
            case ALTERTABLE_SKEWED: 
            case ALTERTABLE_TOUCH: 
            case ALTERTABLE_UNARCHIVE: 
            case ALTERTABLE_UPDATEPARTSTATS: 
            case ALTERTABLE_UPDATETABLESTATS: 
            case ALTERTABLE_UPDATECOLUMNS: 
            case ALTERTBLPART_SKEWED_LOCATION: 
            case DROPFUNCTION: 
            case QUERY: 
            case ADD: 
            case DELETE: 
            case RELOADFUNCTION: 
            case ALTERTABLE_EXCHANGEPARTITION: 
            case ALTERTABLE_OWNER: {
                ret = FsAction.ALL;
                break;
            }
        }
        return ret;
    }

    private String buildPathForException(String path, HiveOperationType hiveOpType) {
        String ret = path;
        int endIndex = 0;
        switch (hiveOpType) {
            case DESCTABLE: {
                ret = path + "/*";
                break;
            }
            case QUERY: {
                try {
                    endIndex = StringUtils.ordinalIndexOf((String)path, (String)"/", (int)2);
                    ret = path.substring(0, endIndex) + "/*";
                    break;
                }
                catch (Exception e) {
                    if (!LOG.isDebugEnabled()) break;
                    LOG.debug((Object)"RangerHiveAuthorizer.buildPathForException(): Error while creating exception message ", (Throwable)e);
                }
            }
        }
        return ret;
    }

    private boolean isURIAccessAllowed(String userName, FsAction action, Path filePath, FileSystem fs) {
        boolean ret = false;
        if (action == FsAction.NONE) {
            ret = true;
        } else {
            try {
                FileStatus[] filestat = fs.globStatus(filePath);
                if (filestat != null && filestat.length > 0) {
                    boolean isDenied = false;
                    for (FileStatus file : filestat) {
                        if (FileUtils.isOwnerOfFileHierarchy((FileSystem)fs, (FileStatus)file, (String)userName) || FileUtils.isActionPermittedForFileHierarchy((FileSystem)fs, (FileStatus)file, (String)userName, (FsAction)action)) continue;
                        isDenied = true;
                        break;
                    }
                    ret = !isDenied;
                } else {
                    FileStatus file = FileUtils.getPathOrParentThatExists((FileSystem)fs, (Path)filePath);
                    FileUtils.checkFileAccessWithImpersonation((FileSystem)fs, (FileStatus)file, (FsAction)action, (String)userName);
                    ret = true;
                }
            }
            catch (Exception excp) {
                ret = false;
                LOG.error((Object)("Error getting permissions for " + filePath), (Throwable)excp);
            }
        }
        return ret;
    }

    private boolean isPathInFSScheme(String uri) {
        boolean ret = false;
        String[] fsScheme = hivePlugin.getFSScheme();
        if (fsScheme != null) {
            for (String scheme : fsScheme) {
                if (uri.isEmpty() || !uri.startsWith(scheme)) continue;
                ret = true;
                break;
            }
        }
        return ret;
    }

    private Path resolvePath(Path path, FileSystem fs) {
        try {
            return fs.resolvePath(path);
        }
        catch (IOException e) {
            return null;
        }
    }

    private boolean isMountedFs(FileSystem fs) {
        return fs.getChildFileSystems() != null;
    }

    private void handleDfsCommand(HiveOperationType hiveOpType, List<HivePrivilegeObject> inputHObjs, String user, RangerHiveAuditHandler auditHandler) throws HiveAuthzPluginException, HiveAccessControlException {
        String dfsCommandParams = null;
        if (inputHObjs != null) {
            for (HivePrivilegeObject hiveObj : inputHObjs) {
                if (hiveObj.getType() == HivePrivilegeObject.HivePrivilegeObjectType.COMMAND_PARAMS && !StringUtil.isEmpty((String)(dfsCommandParams = StringUtil.toString((List)hiveObj.getCommandParams())))) break;
            }
        }
        int serviceType = -1;
        String serviceName = null;
        if (hivePlugin != null) {
            serviceType = hivePlugin.getServiceDefId();
            serviceName = hivePlugin.getServiceName();
        }
        auditHandler.logAuditEventForDfs(user, dfsCommandParams, false, serviceType, serviceName);
        throw new HiveAccessControlException(String.format("Permission denied: user [%s] does not have privilege for [%s] command", user, hiveOpType.name()));
    }

    private boolean existsByResourceAndAccessType(Collection<RangerHiveAccessRequest> requests, RangerHiveResource resource, HiveAccessType accessType) {
        boolean ret = false;
        if (requests != null && resource != null) {
            for (RangerHiveAccessRequest request : requests) {
                if (request.getHiveAccessType() != accessType || !request.getResource().equals((Object)resource)) continue;
                ret = true;
                break;
            }
        }
        return ret;
    }

    private String getGrantorUsername(HivePrincipal grantorPrincipal) {
        String grantor;
        String string = grantor = grantorPrincipal != null ? grantorPrincipal.getName() : null;
        if (StringUtil.isEmpty((String)grantor)) {
            UserGroupInformation ugi = this.getCurrentUserGroupInfo();
            grantor = ugi != null ? ugi.getShortUserName() : null;
        }
        return grantor;
    }

    private Set<String> getGrantorGroupNames(HivePrincipal grantorPrincipal) {
        String[] groups;
        HashSet<String> ret = null;
        String grantor = grantorPrincipal != null ? grantorPrincipal.getName() : null;
        UserGroupInformation ugi = StringUtil.isEmpty((String)grantor) ? this.getCurrentUserGroupInfo() : UserGroupInformation.createRemoteUser((String)grantor);
        String[] stringArray = groups = ugi != null ? ugi.getGroupNames() : null;
        if (groups != null && groups.length > 0) {
            ret = new HashSet<String>(Arrays.asList(groups));
        }
        return ret;
    }

    private GrantRevokeRequest createGrantRevokeData(RangerHiveResource resource, List<HivePrincipal> hivePrincipals, List<HivePrivilege> hivePrivileges, HivePrincipal grantorPrincipal, boolean grantOption) throws HiveAccessControlException {
        HiveAuthzSessionContext sessionContext;
        if (resource == null || resource.getObjectType() != HiveObjectType.DATABASE && resource.getObjectType() != HiveObjectType.TABLE && resource.getObjectType() != HiveObjectType.VIEW && resource.getObjectType() != HiveObjectType.COLUMN) {
            throw new HiveAccessControlException("grant/revoke: unexpected object type '" + (resource == null ? null : resource.getObjectType().name()));
        }
        GrantRevokeRequest ret = new GrantRevokeRequest();
        ret.setGrantor(this.getGrantorUsername(grantorPrincipal));
        ret.setGrantorGroups(this.getGrantorGroupNames(grantorPrincipal));
        ret.setDelegateAdmin(grantOption ? Boolean.TRUE : Boolean.FALSE);
        ret.setEnableAudit(Boolean.TRUE);
        ret.setReplaceExistingPermissions(Boolean.FALSE);
        String database = StringUtils.isEmpty((String)resource.getDatabase()) ? "*" : resource.getDatabase();
        String table = StringUtils.isEmpty((String)resource.getTable()) ? "*" : resource.getTable();
        String column = StringUtils.isEmpty((String)resource.getColumn()) ? "*" : resource.getColumn();
        HashMap<String, String> mapResource = new HashMap<String, String>();
        mapResource.put("database", database);
        mapResource.put("table", table);
        mapResource.put("column", column);
        ret.setOwnerUser(resource.getOwnerUser());
        ret.setResource(mapResource);
        SessionState ss = SessionState.get();
        if (ss != null) {
            ret.setClientIPAddress(ss.getUserIpAddress());
            ret.setSessionId(ss.getSessionId());
            HiveConf hiveConf = ss.getConf();
            if (hiveConf != null) {
                ret.setRequestData(hiveConf.get(HIVE_CONF_VAR_QUERY_STRING));
            }
        }
        if ((sessionContext = this.getHiveAuthzSessionContext()) != null) {
            ret.setClientType(sessionContext.getClientType() == null ? null : sessionContext.getClientType().toString());
        }
        for (HivePrincipal principal : hivePrincipals) {
            switch (principal.getType()) {
                case USER: {
                    ret.getUsers().add(principal.getName());
                    break;
                }
                case GROUP: {
                    ret.getGroups().add(principal.getName());
                    break;
                }
                case ROLE: {
                    ret.getRoles().add(principal.getName());
                    break;
                }
            }
        }
        for (HivePrivilege privilege : hivePrivileges) {
            String privName = privilege.getName();
            if (StringUtils.equalsIgnoreCase((String)privName, (String)HiveAccessType.ALL.name()) || StringUtils.equalsIgnoreCase((String)privName, (String)HiveAccessType.ALTER.name()) || StringUtils.equalsIgnoreCase((String)privName, (String)HiveAccessType.CREATE.name()) || StringUtils.equalsIgnoreCase((String)privName, (String)HiveAccessType.DROP.name()) || StringUtils.equalsIgnoreCase((String)privName, (String)HiveAccessType.INDEX.name()) || StringUtils.equalsIgnoreCase((String)privName, (String)HiveAccessType.LOCK.name()) || StringUtils.equalsIgnoreCase((String)privName, (String)HiveAccessType.SELECT.name()) || StringUtils.equalsIgnoreCase((String)privName, (String)HiveAccessType.UPDATE.name())) {
                ret.getAccessTypes().add(privName.toLowerCase());
                continue;
            }
            if (StringUtils.equalsIgnoreCase((String)privName, (String)"Insert") || StringUtils.equalsIgnoreCase((String)privName, (String)"Delete")) {
                ret.getAccessTypes().add(HiveAccessType.UPDATE.name().toLowerCase());
                continue;
            }
            LOG.warn((Object)("grant/revoke: unexpected privilege type '" + privName + "'. Ignored"));
        }
        return ret;
    }

    @Override
    public List<HivePrivilegeInfo> showPrivileges(HivePrincipal principal, HivePrivilegeObject privObj) throws HiveAuthzPluginException {
        List<HivePrivilegeInfo> ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerHiveAuthorizer.showPrivileges ==>  principal: " + principal + "HivePrivilegeObject : " + privObj.getObjectName()));
        }
        if (hivePlugin == null) {
            new HiveAuthzPluginException("RangerHiveAuthorizer.showPrivileges error: hivePlugin is null");
        }
        try {
            HiveObjectRef msObjRef = AuthorizationUtils.getThriftHiveObjectRef((HivePrivilegeObject)privObj);
            if (msObjRef.getDbName() == null) {
                throw new HiveAuthzPluginException("RangerHiveAuthorizer.showPrivileges() only supports SHOW PRIVILEGES for Hive resources and not user level");
            }
            ret = this.getHivePrivilegeInfos(principal, privObj);
        }
        catch (Exception e) {
            LOG.error((Object)"RangerHiveAuthorizer.showPrivileges() error", (Throwable)e);
            throw new HiveAuthzPluginException("RangerHiveAuthorizer.showPrivileges() error: " + e.getMessage(), (Throwable)e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerHiveAuthorizer.showPrivileges() Result: " + ret));
        }
        return ret;
    }

    private HivePrivilegeObject.HivePrivilegeObjectType getPluginPrivilegeObjType(org.apache.hadoop.hive.metastore.api.HiveObjectType objectType) {
        switch (objectType) {
            case DATABASE: {
                return HivePrivilegeObject.HivePrivilegeObjectType.DATABASE;
            }
            case TABLE: {
                return HivePrivilegeObject.HivePrivilegeObjectType.TABLE_OR_VIEW;
            }
        }
        throw new AssertionError((Object)("Unexpected object type " + objectType));
    }

    private RangerRequestedResources buildRequestContextWithAllAccessedResources(List<RangerHiveAccessRequest> requests) {
        RangerRequestedResources requestedResources = new RangerRequestedResources();
        for (RangerHiveAccessRequest request : requests) {
            RangerAccessRequestUtil.setRequestedResourcesInContext((Map)request.getContext(), (RangerRequestedResources)requestedResources);
            RangerHiveResource resource = (RangerHiveResource)request.getResource();
            if (resource.getObjectType() == HiveObjectType.COLUMN && StringUtils.contains((String)resource.getColumn(), (char)',')) {
                String[] columns = StringUtils.split((String)resource.getColumn(), (char)',');
                resource.setServiceDef(hivePlugin.getServiceDef());
                for (String column : columns) {
                    if (column != null) {
                        column = column.trim();
                    }
                    if (StringUtils.isBlank((String)column)) continue;
                    RangerHiveResource colResource = new RangerHiveResource(HiveObjectType.COLUMN, resource.getDatabase(), resource.getTable(), column);
                    colResource.setOwnerUser(resource.getOwnerUser());
                    colResource.setServiceDef(hivePlugin.getServiceDef());
                    requestedResources.addRequestedResource((RangerAccessResource)colResource);
                }
                continue;
            }
            resource.setServiceDef(hivePlugin.getServiceDef());
            requestedResources.addRequestedResource((RangerAccessResource)resource);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("RangerHiveAuthorizer.buildRequestContextWithAllAccessedResources() - " + requestedResources));
        }
        return requestedResources;
    }

    private boolean isBlockAccessIfRowfilterColumnMaskSpecified(HiveOperationType hiveOpType, RangerHiveAccessRequest request) {
        boolean ret = false;
        RangerHiveResource resource = (RangerHiveResource)request.getResource();
        HiveObjectType objType = resource.getObjectType();
        if (objType == HiveObjectType.TABLE || objType == HiveObjectType.VIEW || objType == HiveObjectType.COLUMN) {
            boolean bl = ret = hiveOpType == HiveOperationType.EXPORT;
            if (!ret && request.getHiveAccessType() == HiveAccessType.UPDATE) {
                if (RangerHivePlugin.BlockUpdateIfRowfilterColumnMaskSpecified) {
                    ret = true;
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("isBlockAccessIfRowfilterColumnMaskSpecified(" + hiveOpType + ", " + (Object)((Object)request) + "): " + ret));
        }
        return ret;
    }

    private boolean isTempUDFOperation(String hiveOpTypeName, HivePrivilegeObject hiveObj) {
        boolean ret = false;
        if ((hiveOpTypeName.contains("createfunction") || hiveOpTypeName.contains("dropfunction")) && StringUtils.isEmpty((String)hiveObj.getDbname())) {
            ret = true;
        }
        return ret;
    }

    private List<HivePrivilegeInfo> getHivePrivilegeInfos(HivePrincipal principal, HivePrivilegeObject privObj) throws HiveAuthzPluginException {
        ArrayList<HivePrivilegeInfo> ret = new ArrayList<HivePrivilegeInfo>();
        HivePrivilegeObject.HivePrivilegeObjectType objectType = null;
        Map<String, Map<HiveResourceACLs.Privilege, HiveResourceACLs.AccessResult>> userPermissions = null;
        Map<String, Map<HiveResourceACLs.Privilege, HiveResourceACLs.AccessResult>> groupPermissions = null;
        Map<String, Map<HiveResourceACLs.Privilege, HiveResourceACLs.AccessResult>> rolePermissions = null;
        String dbName = null;
        String objectName = null;
        String columnName = null;
        ArrayList<String> partValues = null;
        try {
            HiveObjectRef msObjRef = AuthorizationUtils.getThriftHiveObjectRef((HivePrivilegeObject)privObj);
            if (msObjRef != null) {
                HivePrivilegeObject hivePrivilegeObject = null;
                if (msObjRef.getDbName() != null) {
                    objectType = this.getPluginPrivilegeObjType(msObjRef.getObjectType());
                    dbName = msObjRef.getDbName();
                    objectName = msObjRef.getObjectName();
                    columnName = msObjRef.getColumnName() == null ? new String() : msObjRef.getColumnName();
                    partValues = msObjRef.getPartValues() == null ? new ArrayList() : msObjRef.getPartValues();
                    hivePrivilegeObject = new HivePrivilegeObject(objectType, dbName, objectName);
                    RangerResourceACLs rangerResourceACLs = this.getRangerResourceACLs(hivePrivilegeObject);
                    if (rangerResourceACLs != null) {
                        Map userRangerACLs = rangerResourceACLs.getUserACLs();
                        Map groupRangerACLs = rangerResourceACLs.getGroupACLs();
                        Map roleRangerACLs = rangerResourceACLs.getRoleACLs();
                        userPermissions = this.convertRangerACLsToHiveACLs(userRangerACLs);
                        groupPermissions = this.convertRangerACLsToHiveACLs(groupRangerACLs);
                        rolePermissions = this.convertRangerACLsToHiveACLs(roleRangerACLs);
                        if (principal != null) {
                            String role;
                            Map<HiveResourceACLs.Privilege, HiveResourceACLs.AccessResult> roleACLs;
                            if (principal.getType() == HivePrincipal.HivePrincipalType.USER) {
                                String user = principal.getName();
                                Map<HiveResourceACLs.Privilege, HiveResourceACLs.AccessResult> userACLs = userPermissions.get(user);
                                if (userACLs != null) {
                                    Map userAccessResult = (Map)userRangerACLs.get(user);
                                    for (HiveResourceACLs.Privilege userACL : userACLs.keySet()) {
                                        RangerPolicy policy = this.getRangerPolicy(userAccessResult, userACL.name());
                                        if (policy == null) continue;
                                        String aclname = this.getPermission(userACL, userAccessResult, policy);
                                        HivePrivilegeInfo privilegeInfo = this.createHivePrivilegeInfo(principal, objectType, dbName, objectName, columnName, partValues, aclname, policy);
                                        ret.add(privilegeInfo);
                                    }
                                }
                                Set<String> groups = this.getPrincipalGroup(user);
                                for (String group : groups) {
                                    Map<HiveResourceACLs.Privilege, HiveResourceACLs.AccessResult> groupACLs = groupPermissions.get(group);
                                    if (groupACLs == null) continue;
                                    Map groupAccessResult = (Map)groupRangerACLs.get(group);
                                    for (HiveResourceACLs.Privilege groupACL : groupACLs.keySet()) {
                                        RangerPolicy policy = this.getRangerPolicy(groupAccessResult, groupACL.name());
                                        if (policy == null) continue;
                                        String aclname = this.getPermission(groupACL, groupAccessResult, policy);
                                        HivePrivilegeInfo privilegeInfo = this.createHivePrivilegeInfo(principal, objectType, dbName, objectName, columnName, partValues, aclname, policy);
                                        ret.add(privilegeInfo);
                                    }
                                }
                            } else if (principal.getType() == HivePrincipal.HivePrincipalType.ROLE && (roleACLs = rolePermissions.get(role = principal.getName())) != null) {
                                Map roleAccessResult = (Map)roleRangerACLs.get(role);
                                for (HiveResourceACLs.Privilege roleACL : roleACLs.keySet()) {
                                    RangerPolicy policy = this.getRangerPolicy(roleAccessResult, roleACL.name());
                                    if (policy == null) continue;
                                    String aclname = this.getPermission(roleACL, roleAccessResult, policy);
                                    HivePrivilegeInfo privilegeInfo = this.createHivePrivilegeInfo(principal, objectType, dbName, objectName, columnName, partValues, aclname, policy);
                                    ret.add(privilegeInfo);
                                }
                            }
                        } else {
                            HivePrivilegeInfo privilegeInfo;
                            String aclname;
                            RangerPolicy policy;
                            HivePrincipal hivePrincipal;
                            for (String user : userRangerACLs.keySet()) {
                                hivePrincipal = new HivePrincipal(user, HivePrincipal.HivePrincipalType.USER);
                                Map<HiveResourceACLs.Privilege, HiveResourceACLs.AccessResult> userACLs = userPermissions.get(user);
                                if (userACLs == null) continue;
                                Map userAccessResult = (Map)userRangerACLs.get(user);
                                for (HiveResourceACLs.Privilege userACL : userACLs.keySet()) {
                                    policy = this.getRangerPolicy(userAccessResult, userACL.name());
                                    if (policy == null) continue;
                                    aclname = this.getPermission(userACL, userAccessResult, policy);
                                    privilegeInfo = this.createHivePrivilegeInfo(hivePrincipal, objectType, dbName, objectName, columnName, partValues, aclname, policy);
                                    ret.add(privilegeInfo);
                                }
                            }
                            for (String group : groupRangerACLs.keySet()) {
                                hivePrincipal = new HivePrincipal(group, HivePrincipal.HivePrincipalType.GROUP);
                                Map<HiveResourceACLs.Privilege, HiveResourceACLs.AccessResult> groupACLs = groupPermissions.get(group);
                                if (groupACLs == null) continue;
                                Map groupAccessResult = (Map)groupRangerACLs.get(group);
                                for (HiveResourceACLs.Privilege groupACL : groupACLs.keySet()) {
                                    policy = this.getRangerPolicy(groupAccessResult, groupACL.name());
                                    if (policy == null) continue;
                                    aclname = this.getPermission(groupACL, groupAccessResult, policy);
                                    privilegeInfo = this.createHivePrivilegeInfo(hivePrincipal, objectType, dbName, objectName, columnName, partValues, aclname, policy);
                                    ret.add(privilegeInfo);
                                }
                            }
                            for (String role : roleRangerACLs.keySet()) {
                                hivePrincipal = new HivePrincipal(role, HivePrincipal.HivePrincipalType.ROLE);
                                Map<HiveResourceACLs.Privilege, HiveResourceACLs.AccessResult> roleACLs = rolePermissions.get(role);
                                if (roleACLs == null) continue;
                                Map roleAccessResult = (Map)roleRangerACLs.get(role);
                                for (HiveResourceACLs.Privilege roleACL : roleACLs.keySet()) {
                                    policy = this.getRangerPolicy(roleAccessResult, roleACL.name());
                                    if (policy == null) continue;
                                    aclname = this.getPermission(roleACL, roleAccessResult, policy);
                                    privilegeInfo = this.createHivePrivilegeInfo(hivePrincipal, objectType, dbName, objectName, columnName, partValues, aclname, policy);
                                    ret.add(privilegeInfo);
                                }
                            }
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            throw new HiveAuthzPluginException("hive showPrivileges: " + e.getMessage(), (Throwable)e);
        }
        return ret;
    }

    private RangerPolicy getRangerPolicy(Map<String, RangerResourceACLs.AccessResult> accessResults, String rangerACL) {
        RangerResourceACLs.AccessResult accessResult;
        RangerPolicy ret = null;
        if (MapUtils.isNotEmpty(accessResults) && (accessResult = accessResults.get(rangerACL.toLowerCase())) != null) {
            ret = accessResult.getPolicy();
        }
        return ret;
    }

    private HivePrivilegeInfo createHivePrivilegeInfo(HivePrincipal hivePrincipal, HivePrivilegeObject.HivePrivilegeObjectType objectType, String dbName, String objectName, String columnName, List<String> partValues, String aclName, RangerPolicy policy) {
        HivePrivilegeInfo ret = null;
        int creationDate = 0;
        boolean delegateAdmin = false;
        for (RangerPolicy.RangerPolicyItem policyItem : policy.getPolicyItems()) {
            List policyItemAccesses = policyItem.getAccesses();
            List users = policyItem.getUsers();
            List groups = policyItem.getGroups();
            ArrayList<String> accessTypes = new ArrayList<String>();
            for (RangerPolicy.RangerPolicyItemAccess policyItemAccess : policyItemAccesses) {
                accessTypes.add(policyItemAccess.getType());
            }
            if (!accessTypes.contains(aclName.toLowerCase()) || !users.contains(hivePrincipal.getName()) && !groups.contains(hivePrincipal.getName())) continue;
            creationDate = policy.getCreateTime() == null ? creationDate : (int)(policy.getCreateTime().getTime() / 1000L);
            delegateAdmin = policyItem.getDelegateAdmin() == null ? delegateAdmin : policyItem.getDelegateAdmin();
        }
        HivePrincipal grantorPrincipal = new HivePrincipal(DEFAULT_RANGER_POLICY_GRANTOR, HivePrincipal.HivePrincipalType.USER);
        HivePrivilegeObject privilegeObject = new HivePrivilegeObject(objectType, dbName, objectName, partValues, columnName);
        HivePrivilege privilege = new HivePrivilege(aclName, null);
        ret = new HivePrivilegeInfo(hivePrincipal, privilege, privilegeObject, grantorPrincipal, delegateAdmin, creationDate);
        return ret;
    }

    private Set<String> getPrincipalGroup(String user) {
        HashSet groups = null;
        UserGroupInformation ugi = UserGroupInformation.createRemoteUser((String)user);
        groups = Sets.newHashSet((Object[])ugi.getGroupNames());
        return groups;
    }

    private RangerResourceACLs getRangerResourceACLs(HivePrivilegeObject hiveObject) {
        RangerResourceACLs ret = null;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerHivePolicyProvider.getRangerResourceACLs:[" + hiveObject + "]"));
        }
        RangerHiveResource hiveResource = RangerHiveAuthorizer.createHiveResource(hiveObject);
        RangerAccessRequestImpl request = new RangerAccessRequestImpl((RangerAccessResource)hiveResource, "_any", null, null, null);
        ret = hivePlugin.getResourceACLs((RangerAccessRequest)request);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerHivePolicyProvider.getRangerResourceACLs:[" + hiveObject + "], Computed ACLS:[" + ret + "]"));
        }
        return ret;
    }

    private Map<String, Map<HiveResourceACLs.Privilege, HiveResourceACLs.AccessResult>> convertRangerACLsToHiveACLs(Map<String, Map<String, RangerResourceACLs.AccessResult>> rangerACLs) {
        HashMap<String, Map<HiveResourceACLs.Privilege, HiveResourceACLs.AccessResult>> ret = new HashMap<String, Map<HiveResourceACLs.Privilege, HiveResourceACLs.AccessResult>>();
        if (MapUtils.isNotEmpty(rangerACLs)) {
            HashSet<String> hivePrivileges = new HashSet<String>();
            for (HiveResourceACLs.Privilege privilege : HiveResourceACLs.Privilege.values()) {
                hivePrivileges.add(privilege.name().toLowerCase());
            }
            for (Map.Entry entry : rangerACLs.entrySet()) {
                HashMap<HiveResourceACLs.Privilege, HiveResourceACLs.AccessResult> permissions = new HashMap<HiveResourceACLs.Privilege, HiveResourceACLs.AccessResult>();
                ret.put((String)entry.getKey(), (Map<HiveResourceACLs.Privilege, HiveResourceACLs.AccessResult>)permissions);
                for (Map.Entry permission : ((Map)entry.getValue()).entrySet()) {
                    if (!hivePrivileges.contains(permission.getKey())) continue;
                    HiveResourceACLs.Privilege privilege = HiveResourceACLs.Privilege.valueOf((String)StringUtils.upperCase((String)((String)permission.getKey())));
                    int rangerResultValue = ((RangerResourceACLs.AccessResult)permission.getValue()).getResult();
                    HiveResourceACLs.AccessResult accessResult = rangerResultValue == RangerPolicyEvaluator.ACCESS_ALLOWED ? HiveResourceACLs.AccessResult.ALLOWED : (rangerResultValue == RangerPolicyEvaluator.ACCESS_DENIED ? HiveResourceACLs.AccessResult.NOT_ALLOWED : (rangerResultValue == RangerPolicyEvaluator.ACCESS_CONDITIONAL ? HiveResourceACLs.AccessResult.CONDITIONAL_ALLOWED : HiveResourceACLs.AccessResult.NOT_ALLOWED));
                    permissions.put(privilege, accessResult);
                }
            }
        }
        return ret;
    }

    private String getPermission(HiveResourceACLs.Privilege acl, Map<String, RangerResourceACLs.AccessResult> accessResultMap, RangerPolicy policy) {
        String aclname = acl.name();
        int aclResult = this.checkACLIsAllowed(acl, accessResultMap);
        if (aclResult > RangerPolicyEvaluator.ACCESS_DENIED && policy != null) {
            if (aclResult == RangerPolicyEvaluator.ACCESS_UNDETERMINED) {
                aclname = aclname + " (ACCESS_UNDETERMINED)";
            } else if (aclResult == RangerPolicyEvaluator.ACCESS_CONDITIONAL) {
                aclname = aclname + " (ACCESS_CONDITIONAL)";
            }
        }
        return aclname;
    }

    private int checkACLIsAllowed(HiveResourceACLs.Privilege acl, Map<String, RangerResourceACLs.AccessResult> accessResultMap) {
        int result = -1;
        String aclName = acl.name().toLowerCase();
        RangerResourceACLs.AccessResult accessResult = accessResultMap.get(aclName);
        if (accessResult != null) {
            result = accessResult.getResult();
        }
        return result;
    }

    private String toString(HiveOperationType hiveOpType, List<HivePrivilegeObject> inputHObjs, List<HivePrivilegeObject> outputHObjs, HiveAuthzContext context, HiveAuthzSessionContext sessionContext) {
        StringBuilder sb = new StringBuilder();
        sb.append("'checkPrivileges':{");
        sb.append("'hiveOpType':").append(hiveOpType);
        sb.append(", 'inputHObjs':[");
        this.toString(inputHObjs, sb);
        sb.append("]");
        sb.append(", 'outputHObjs':[");
        this.toString(outputHObjs, sb);
        sb.append("]");
        sb.append(", 'context':{");
        sb.append("'clientType':").append(sessionContext == null ? null : sessionContext.getClientType());
        sb.append(", 'commandString':").append(context == null ? "null" : context.getCommandString());
        sb.append(", 'ipAddress':").append(context == null ? "null" : context.getIpAddress());
        sb.append(", 'forwardedAddresses':").append(context == null ? "null" : StringUtils.join((Collection)context.getForwardedAddresses(), (String)", "));
        sb.append(", 'sessionString':").append(sessionContext == null ? "null" : sessionContext.getSessionString());
        sb.append("}");
        sb.append(", 'user':").append(this.getCurrentUserGroupInfo().getUserName());
        sb.append(", 'groups':[").append(StringUtil.toString((String[])this.getCurrentUserGroupInfo().getGroupNames())).append("]");
        sb.append("}");
        return sb.toString();
    }

    private StringBuilder toString(List<HivePrivilegeObject> privObjs, StringBuilder sb) {
        if (privObjs != null && privObjs.size() > 0) {
            this.toString(privObjs.get(0), sb);
            for (int i = 1; i < privObjs.size(); ++i) {
                sb.append(",");
                this.toString(privObjs.get(i), sb);
            }
        }
        return sb;
    }

    private StringBuilder toString(HivePrivilegeObject privObj, StringBuilder sb) {
        sb.append("'HivePrivilegeObject':{");
        sb.append("'type':").append(privObj.getType().toString());
        sb.append(", 'dbName':").append(privObj.getDbname());
        sb.append(", 'objectType':").append(privObj.getType());
        sb.append(", 'objectName':").append(privObj.getObjectName());
        sb.append(", 'columns':[").append(StringUtil.toString((List)privObj.getColumns())).append("]");
        sb.append(", 'partKeys':[").append(StringUtil.toString((List)privObj.getPartKeys())).append("]");
        sb.append(", 'commandParams':[").append(StringUtil.toString((List)privObj.getCommandParams())).append("]");
        sb.append(", 'actionType':").append(privObj.getActionType().toString());
        sb.append("}");
        return sb;
    }

    private RangerAccessResult createAuditEvent(RangerHivePlugin hivePlugin, String userOrGrantor, List<String> roleUsers, HiveOperationType hiveOperationType, HiveAccessType accessType, List<String> roleNames, boolean result) {
        RangerHiveAccessRequest rangerHiveAccessRequest = this.createRangerHiveAccessRequest(userOrGrantor, roleUsers, hiveOperationType, accessType, roleNames);
        RangerAccessResult accessResult = this.createRangerHiveAccessResult(hivePlugin, userOrGrantor, rangerHiveAccessRequest, result);
        return accessResult;
    }

    private RangerHiveAccessRequest createRangerHiveAccessRequest(String userOrGrantor, List<String> roleUsers, HiveOperationType hiveOperationType, HiveAccessType accessType, List<String> roleNames) {
        RangerHiveAccessRequest ret = null;
        HiveAuthzContext.Builder builder = new HiveAuthzContext.Builder();
        String roleNameStr = this.createRoleString(roleNames);
        String userNameStr = this.createUserString(roleUsers);
        String commandString = this.getCommandString(hiveOperationType, userNameStr, roleNameStr);
        String cmdStr = commandString != null ? commandString : "";
        builder.setCommandString(cmdStr);
        HiveAuthzContext hiveAuthzContext = builder.build();
        RangerHiveResource rangerHiveResource = new RangerHiveResource(HiveObjectType.GLOBAL, "*");
        ret = new RangerHiveAccessRequest(rangerHiveResource, userOrGrantor, null, null, hiveOperationType, accessType, hiveAuthzContext, null);
        ret.setClusterName(hivePlugin.getClusterName());
        ret.setAction(hiveOperationType.name());
        ret.setClientIPAddress(RangerHiveAuthorizer.getRemoteIp());
        ret.setRemoteIPAddress(RangerHiveAuthorizer.getRemoteIp());
        return ret;
    }

    private RangerAccessResult createRangerHiveAccessResult(RangerHivePlugin hivePlugin, String userOrGrantor, RangerHiveAccessRequest rangerHiveAccessRequest, boolean result) {
        RangerAccessResult ret = null;
        String serviceName = hivePlugin.getServiceName();
        RangerServiceDef serviceDef = hivePlugin.getServiceDef();
        String reason = String.format("%s is not an Admin", userOrGrantor);
        if (result) {
            reason = String.format("%s is Admin", userOrGrantor);
        }
        ret = new RangerAccessResult(0, serviceName, serviceDef, (RangerAccessRequest)rangerHiveAccessRequest);
        ret.setIsAccessDetermined(true);
        ret.setIsAudited(true);
        ret.setIsAllowed(result);
        ret.setAuditPolicyId(-1L);
        ret.setPolicyId(-1L);
        ret.setPolicyPriority(0);
        ret.setZoneName(null);
        ret.setPolicyVersion(null);
        ret.setReason(reason);
        ret.setAdditionalInfo(MapUtils.EMPTY_MAP);
        return ret;
    }

    private String getCommandString(HiveOperationType hiveOperationType, String user, String roleName) {
        String ret = "";
        switch (hiveOperationType) {
            case CREATEROLE: {
                ret = String.format(CMD_CREATE_ROLE, roleName);
                break;
            }
            case DROPROLE: {
                ret = String.format(CMD_DROP_ROLE, roleName);
                break;
            }
            case SHOW_ROLES: {
                ret = CMD_SHOW_ROLES;
                break;
            }
            case SHOW_ROLE_GRANT: {
                ret = String.format(CMD_SHOW_ROLE_GRANT, roleName);
                break;
            }
            case SHOW_ROLE_PRINCIPALS: {
                ret = String.format(CMD_SHOW_PRINCIPALS, roleName);
                break;
            }
            case GRANT_ROLE: {
                ret = String.format(CMD_GRANT_ROLE, roleName, user);
                break;
            }
            case REVOKE_ROLE: {
                ret = String.format(CMD_REVOKE_ROLE, roleName, user);
            }
        }
        return ret;
    }

    private String createRoleString(List<String> roleNames) {
        String ret = null;
        ret = CollectionUtils.isEmpty(roleNames) ? "" : (roleNames.size() > 1 ? StringUtils.join(roleNames, (String)",") : roleNames.get(0));
        return ret;
    }

    private String createUserString(List<String> userNames) {
        String ret = null;
        ret = CollectionUtils.isEmpty(userNames) ? "" : (userNames.size() > 1 ? StringUtils.join(userNames, (String)",") : userNames.get(0));
        return ret;
    }

    private static String getRemoteIp() {
        String ret = null;
        InetAddress ip = Server.getRemoteIp();
        if (ip != null) {
            ret = ip.getHostAddress();
        }
        return ret;
    }

    private Set<String> getCurrentRoles() {
        this.getCurrentRoleForCurrentUser();
        return this.currentRoles;
    }

    private void initUserRoles() {
        String newUserName;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)" ==> RangerHiveAuthorizer.initUserRoles()");
        }
        if (Objects.equals(this.currentUserName, newUserName = this.getHiveAuthenticator().getUserName())) {
            return;
        }
        this.currentUserName = newUserName;
        try {
            this.currentRoles = this.getCurrentRoleNamesFromRanger();
        }
        catch (HiveAuthzPluginException e) {
            LOG.error((Object)("Error while fetching roles from ranger for user : " + this.currentUserName), (Throwable)e);
        }
        LOG.info((Object)("Current user : " + this.currentUserName + ", Current Roles : " + this.currentRoles));
    }

    private void getCurrentRoleForCurrentUser() {
        String newUserName;
        if (this.isCurrentRoleSet) {
            return;
        }
        this.currentUserName = newUserName = this.getHiveAuthenticator().getUserName();
        try {
            this.currentRoles = this.getCurrentRoleNamesFromRanger();
        }
        catch (HiveAuthzPluginException e) {
            LOG.error((Object)("Error while fetching roles from ranger for user : " + this.currentUserName), (Throwable)e);
        }
        LOG.info((Object)("Current user : " + this.currentUserName + ", Current Roles : " + this.currentRoles));
    }

    private Set<String> getCurrentRolesForUser(String user, Set<String> groups) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerHiveAuthorizer.getCurrentRolesForUser()");
        }
        Set<String> ret = hivePlugin.getRolesFromUserAndGroups(user, groups);
        Set<String> set = ret = this.isCurrentRoleSet ? this.currentRoles : ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerHiveAuthorizer.getCurrentRolesForUser() User: " + this.currentUserName + ", User Roles: " + ret));
        }
        return ret;
    }

    private Set<String> getCurrentRoleNamesFromRanger() throws HiveAuthzPluginException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerHiveAuthorizer.getCurrentRoleNamesFromRanger()");
        }
        boolean result = false;
        UserGroupInformation ugi = this.getCurrentUserGroupInfo();
        if (ugi == null) {
            throw new HiveAuthzPluginException("User information not available");
        }
        HashSet<String> ret = new HashSet<String>();
        String user = ugi.getShortUserName();
        HashSet groups = Sets.newHashSet((Object[])ugi.getGroupNames());
        RangerHiveAuditHandler auditHandler = new RangerHiveAuditHandler();
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("==> RangerHiveAuthorizer.getCurrentRoleNamesFromRanger() for user " + user + ", userGroups: " + groups));
            }
            HashSet<String> userRoles = new HashSet<String>(this.getRolesforUserAndGroups(user, groups));
            for (String role : userRoles) {
                if (!ROLE_ADMIN.equalsIgnoreCase(role)) {
                    ret.add(role);
                    continue;
                }
                this.adminRole = role;
            }
            result = true;
        }
        catch (Exception excp) {
            throw new HiveAuthzPluginException((Throwable)excp);
        }
        finally {
            ArrayList<String> roleNames = new ArrayList<String>(ret);
            RangerAccessResult accessResult = this.createAuditEvent(hivePlugin, this.currentUserName, roleNames, HiveOperationType.SHOW_ROLES, HiveAccessType.SELECT, null, result);
            auditHandler.processResult(accessResult);
            auditHandler.flushAudit();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerHiveAuthorizer.getCurrentRoleNamesFromRanger() for user: " + user + ", userGroups: " + groups + ", roleNames: " + ret));
        }
        return ret;
    }

    private Set<String> getRolesforUserAndGroups(String user, Set<String> groups) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerHiveAuthorizer.getRolesforUserAndGroups()");
        }
        Set<String> ret = null;
        if (hivePlugin != null) {
            ret = hivePlugin.getRolesFromUserAndGroups(user, groups);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerHiveAuthorizer.getRolesforUserAndGroups(), user: " + user + ", groups: " + groups + ", roles: " + ret));
        }
        return ret != null ? ret : Collections.emptySet();
    }

    private HiveRoleGrant getHiveRoleGrant(RangerRole role, RangerRole.RoleMember roleMember, String type) {
        HiveRoleGrant ret = new HiveRoleGrant();
        ret.setRoleName(role.getName());
        ret.setGrantOption(roleMember.getIsAdmin());
        ret.setGrantor(role.getCreatedByUser());
        ret.setGrantorType(HivePrincipal.HivePrincipalType.USER.name());
        ret.setPrincipalName(roleMember.getName());
        ret.setPrincipalType(type);
        if (role.getUpdateTime() != null) {
            ret.setGrantTime((int)(role.getUpdateTime().getTime() / 1000L));
        }
        return ret;
    }

    private RangerRole getRangerRoleForRoleName(String roleName) {
        RangerRole ret = null;
        RangerRoles rangerRoles = hivePlugin.getRangerRoles();
        if (rangerRoles != null) {
            Set roles = rangerRoles.getRangerRoles();
            for (RangerRole role : roles) {
                if (!roleName.equals(role.getName())) continue;
                ret = role;
                break;
            }
        }
        return ret;
    }

    private RangerHiveAccessRequest buildRequestForAlterTableSetOwnerFromCommandString(String user, Set<String> userGroups, Set<String> userRoles, String hiveOpTypeName, HiveAuthzContext context, HiveAuthzSessionContext sessionContext) {
        RangerHiveResource resource = null;
        RangerHiveAccessRequest request = null;
        HiveObj hiveObj = new HiveObj();
        hiveObj.fetchHiveObjForAlterTable(context);
        String dbName = hiveObj.getDatabaseName();
        String tableName = hiveObj.getTableName();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Database: " + dbName + " Table: " + tableName));
        }
        if (dbName != null && tableName != null) {
            resource = new RangerHiveResource(HiveObjectType.TABLE, dbName, tableName);
            request = new RangerHiveAccessRequest(resource, user, userGroups, userRoles, hiveOpTypeName, HiveAccessType.ALTER, context, sessionContext);
        }
        return request;
    }

    static {
        HashSet<String> roleNames = new HashSet<String>();
        roleNames.add(ROLE_ALL);
        roleNames.add(ROLE_DEFAULT);
        roleNames.add(ROLE_NONE);
        RESERVED_ROLE_NAMES = Collections.unmodifiableSet(roleNames);
    }
}

