/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.audit.model;

import com.google.gson.annotations.SerializedName;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.ranger.audit.dao.DaoManager;
import org.apache.ranger.audit.entity.AuthzAuditEventDbObj;
import org.apache.ranger.audit.model.AuditEventBase;

public class AuthzAuditEvent
extends AuditEventBase {
    protected static String FIELD_SEPARATOR = ";";
    protected static final int MAX_ACTION_FIELD_SIZE = 1800;
    protected static final int MAX_REQUEST_DATA_FIELD_SIZE = 1800;
    @SerializedName(value="repoType")
    protected int repositoryType = 0;
    @SerializedName(value="repo")
    protected String repositoryName = null;
    @SerializedName(value="reqUser")
    protected String user = null;
    @SerializedName(value="evtTime")
    protected Date eventTime = new Date();
    @SerializedName(value="access")
    protected String accessType = null;
    @SerializedName(value="resource")
    protected String resourcePath = null;
    @SerializedName(value="resType")
    protected String resourceType = null;
    @SerializedName(value="action")
    protected String action = null;
    @SerializedName(value="result")
    protected short accessResult = 0;
    @SerializedName(value="agent")
    protected String agentId = null;
    @SerializedName(value="policy")
    protected long policyId = 0L;
    @SerializedName(value="reason")
    protected String resultReason = null;
    @SerializedName(value="enforcer")
    protected String aclEnforcer = null;
    @SerializedName(value="sess")
    protected String sessionId = null;
    @SerializedName(value="cliType")
    protected String clientType = null;
    @SerializedName(value="cliIP")
    protected String clientIP = null;
    @SerializedName(value="reqData")
    protected String requestData = null;
    @SerializedName(value="agentHost")
    protected String agentHostname = null;
    @SerializedName(value="logType")
    protected String logType = null;
    @SerializedName(value="id")
    protected String eventId = null;
    @SerializedName(value="seq_num")
    protected long seqNum = 0L;
    @SerializedName(value="event_count")
    protected long eventCount = 1L;
    @SerializedName(value="event_dur_ms")
    protected long eventDurationMS = 0L;
    @SerializedName(value="tags")
    protected Set<String> tags = new HashSet<String>();
    @SerializedName(value="additional_info")
    protected String additionalInfo;

    public AuthzAuditEvent() {
        this.repositoryType = 0;
    }

    public AuthzAuditEvent(int repositoryType, String repositoryName, String user, Date eventTime, String accessType, String resourcePath, String resourceType, String action, short accessResult, String agentId, long policyId, String resultReason, String aclEnforcer, String sessionId, String clientType, String clientIP, String requestData) {
        this.repositoryType = repositoryType;
        this.repositoryName = repositoryName;
        this.user = user;
        this.eventTime = eventTime;
        this.accessType = accessType;
        this.resourcePath = resourcePath;
        this.resourceType = resourceType;
        this.action = action;
        this.accessResult = accessResult;
        this.agentId = agentId;
        this.policyId = policyId;
        this.resultReason = resultReason;
        this.aclEnforcer = aclEnforcer;
        this.sessionId = sessionId;
        this.clientType = clientType;
        this.clientIP = clientIP;
        this.requestData = requestData;
    }

    public int getRepositoryType() {
        return this.repositoryType;
    }

    public void setRepositoryType(int repositoryType) {
        this.repositoryType = repositoryType;
    }

    public String getRepositoryName() {
        return this.repositoryName;
    }

    public void setRepositoryName(String repositoryName) {
        this.repositoryName = repositoryName;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    @Override
    public Date getEventTime() {
        return this.eventTime;
    }

    public void setEventTime(Date eventTime) {
        this.eventTime = eventTime;
    }

    public String getAccessType() {
        return this.accessType;
    }

    public void setAccessType(String accessType) {
        this.accessType = accessType;
    }

    public String getResourcePath() {
        return this.resourcePath;
    }

    public void setResourcePath(String resourcePath) {
        this.resourcePath = resourcePath;
    }

    public String getResourceType() {
        return this.resourceType;
    }

    public void setResourceType(String resourceType) {
        this.resourceType = resourceType;
    }

    public String getAction() {
        return this.action;
    }

    public void setAction(String action) {
        this.action = action;
    }

    public short getAccessResult() {
        return this.accessResult;
    }

    public void setAccessResult(short accessResult) {
        this.accessResult = accessResult;
    }

    public String getAgentId() {
        return this.agentId;
    }

    public void setAgentId(String agentId) {
        this.agentId = agentId;
    }

    public long getPolicyId() {
        return this.policyId;
    }

    public void setPolicyId(long policyId) {
        this.policyId = policyId;
    }

    public String getResultReason() {
        return this.resultReason;
    }

    public void setResultReason(String resultReason) {
        this.resultReason = resultReason;
    }

    public String getAclEnforcer() {
        return this.aclEnforcer;
    }

    public void setAclEnforcer(String aclEnforcer) {
        this.aclEnforcer = aclEnforcer;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public String getClientType() {
        return this.clientType;
    }

    public void setClientType(String clientType) {
        this.clientType = clientType;
    }

    public String getClientIP() {
        return this.clientIP;
    }

    public void setClientIP(String clientIP) {
        this.clientIP = clientIP;
    }

    public String getRequestData() {
        return this.requestData;
    }

    public void setRequestData(String requestData) {
        this.requestData = requestData;
    }

    public String getAgentHostname() {
        return this.agentHostname;
    }

    public void setAgentHostname(String agentHostname) {
        this.agentHostname = agentHostname;
    }

    public String getLogType() {
        return this.logType;
    }

    public void setLogType(String logType) {
        this.logType = logType;
    }

    public String getEventId() {
        return this.eventId;
    }

    public void setEventId(String eventId) {
        this.eventId = eventId;
    }

    public long getSeqNum() {
        return this.seqNum;
    }

    public void setSeqNum(long seqNum) {
        this.seqNum = seqNum;
    }

    public long getEventCount() {
        return this.eventCount;
    }

    @Override
    public void setEventCount(long frequencyCount) {
        this.eventCount = frequencyCount;
    }

    public long getEventDurationMS() {
        return this.eventDurationMS;
    }

    public Set<String> getTags() {
        return this.tags;
    }

    @Override
    public void setEventDurationMS(long frequencyDurationMS) {
        this.eventDurationMS = frequencyDurationMS;
    }

    public void setTags(Set<String> tags) {
        this.tags = tags;
    }

    public String getAdditionalInfo() {
        return this.additionalInfo;
    }

    public void setAdditionalInfo(String additionalInfo) {
        this.additionalInfo = additionalInfo;
    }

    @Override
    public String getEventKey() {
        String key = this.user + "^" + this.accessType + "^" + this.resourcePath + "^" + this.resourceType + "^" + this.action + "^" + this.accessResult + "^" + this.sessionId + "^" + this.clientIP;
        return key;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("AuthzAuditEvent{");
        this.toString(sb);
        sb.append("}");
        return sb.toString();
    }

    protected StringBuilder toString(StringBuilder sb) {
        sb.append("repositoryType=").append(this.repositoryType).append(FIELD_SEPARATOR).append("repositoryName=").append(this.repositoryName).append(FIELD_SEPARATOR).append("user=").append(this.user).append(FIELD_SEPARATOR).append("eventTime=").append(this.eventTime).append(FIELD_SEPARATOR).append("accessType=").append(this.accessType).append(FIELD_SEPARATOR).append("resourcePath=").append(this.resourcePath).append(FIELD_SEPARATOR).append("resourceType=").append(this.resourceType).append(FIELD_SEPARATOR).append("action=").append(this.action).append(FIELD_SEPARATOR).append("accessResult=").append(this.accessResult).append(FIELD_SEPARATOR).append("agentId=").append(this.agentId).append(FIELD_SEPARATOR).append("policyId=").append(this.policyId).append(FIELD_SEPARATOR).append("resultReason=").append(this.resultReason).append(FIELD_SEPARATOR).append("aclEnforcer=").append(this.aclEnforcer).append(FIELD_SEPARATOR).append("sessionId=").append(this.sessionId).append(FIELD_SEPARATOR).append("clientType=").append(this.clientType).append(FIELD_SEPARATOR).append("clientIP=").append(this.clientIP).append(FIELD_SEPARATOR).append("requestData=").append(this.requestData).append(FIELD_SEPARATOR).append("agentHostname=").append(this.agentHostname).append(FIELD_SEPARATOR).append("logType=").append(this.logType).append(FIELD_SEPARATOR).append("eventId=").append(this.eventId).append(FIELD_SEPARATOR).append("seq_num=").append(this.seqNum).append(FIELD_SEPARATOR).append("event_count=").append(this.eventCount).append(FIELD_SEPARATOR).append("event_dur_ms=").append(this.eventDurationMS).append(FIELD_SEPARATOR).append("tags=").append("[").append(StringUtils.join(this.tags, (String)", ")).append("]").append(FIELD_SEPARATOR).append("additionalInfo=").append(this.additionalInfo);
        return sb;
    }

    @Override
    public void persist(DaoManager daoManager) {
        daoManager.getAuthzAuditEventDao().create(new AuthzAuditEventDbObj(this));
    }
}

