/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.audit.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;
import javax.security.auth.login.AppConfigurationEntry;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.lang.ArrayUtils;
import org.apache.hadoop.security.SecurityUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InMemoryJAASConfiguration
extends javax.security.auth.login.Configuration {
    private static final Logger LOG = LoggerFactory.getLogger(InMemoryJAASConfiguration.class);
    private static final String JAAS_CONFIG_PREFIX_PARAM = "xasecure.audit.jaas.";
    private static final String JAAS_CONFIG_LOGIN_MODULE_NAME_PARAM = "loginModuleName";
    private static final String JAAS_CONFIG_LOGIN_MODULE_CONTROL_FLAG_PARAM = "loginModuleControlFlag";
    private static final String JAAS_CONFIG_LOGIN_OPTIONS_PREFIX = "option";
    private static final String JAAS_PRINCIPAL_PROP = "principal";
    private javax.security.auth.login.Configuration parent = null;
    private Map<String, List<AppConfigurationEntry>> applicationConfigEntryMap = new HashMap<String, List<AppConfigurationEntry>>();

    public static void init(String propFile) throws Exception {
        LOG.debug("==> InMemoryJAASConfiguration.init( {} ) ", (Object)propFile);
        InputStream in = null;
        try {
            Properties properties = new Properties();
            in = ClassLoader.getSystemResourceAsStream(propFile);
            if (in == null) {
                if (!propFile.startsWith("/")) {
                    in = ClassLoader.getSystemResourceAsStream("/" + propFile);
                }
                if (in == null) {
                    in = new FileInputStream(new File(propFile));
                }
            }
            properties.load(in);
            InMemoryJAASConfiguration.init(properties);
        }
        catch (IOException e) {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            throw new Exception("Failed to load JAAS application properties", e);
        }
        LOG.debug("<== InMemoryJAASConfiguration.init( {} ) ", (Object)propFile);
    }

    public static void init(Configuration configuration) throws Exception {
        Properties properties;
        LOG.debug("==> InMemoryJAASConfiguration.init()");
        if (configuration != null && !configuration.isEmpty()) {
            properties = new Properties();
            Iterator iterator = configuration.getKeys();
            while (iterator.hasNext()) {
                String key = (String)iterator.next();
                properties.put(key, configuration.getProperty(key));
            }
        } else {
            throw new Exception("Failed to load JAAS application properties: configuration NULL or empty!");
        }
        InMemoryJAASConfiguration.init(properties);
        LOG.debug("<== InMemoryJAASConfiguration.init()");
    }

    public static void init(Properties properties) throws Exception {
        LOG.debug("==> InMemoryJAASConfiguration.init()");
        if (properties == null || !MapUtils.isNotEmpty((Map)properties)) {
            throw new Exception("Failed to load JAAS application properties: properties NULL or empty!");
        }
        InMemoryJAASConfiguration conf = new InMemoryJAASConfiguration(properties);
        javax.security.auth.login.Configuration.setConfiguration(conf);
        LOG.debug("<== InMemoryJAASConfiguration.init()");
    }

    @Override
    public AppConfigurationEntry[] getAppConfigurationEntry(String name) {
        LOG.trace("==> InMemoryJAASConfiguration.getAppConfigurationEntry( {} )", (Object)name);
        AppConfigurationEntry[] ret = null;
        List<AppConfigurationEntry> retList = this.applicationConfigEntryMap.get(name);
        if (retList == null || retList.size() == 0) {
            if (this.parent != null) {
                ret = this.parent.getAppConfigurationEntry(name);
            }
        } else {
            int sz = retList.size();
            ret = new AppConfigurationEntry[sz];
            ret = retList.toArray(ret);
        }
        LOG.trace("<== InMemoryJAASConfiguration.getAppConfigurationEntry( {} ) : {}", (Object)name, (Object)ArrayUtils.toString((Object)ret));
        return ret;
    }

    private InMemoryJAASConfiguration(Properties prop) {
        this.parent = javax.security.auth.login.Configuration.getConfiguration();
        this.initialize(prop);
    }

    private void initialize(Properties properties) {
        LOG.debug("==> InMemoryJAASConfiguration.initialize()");
        int prefixLen = JAAS_CONFIG_PREFIX_PARAM.length();
        HashMap jaasClients = new HashMap();
        for (String key : properties.stringPropertyNames()) {
            String indexStr;
            int indexId;
            Integer clientIdIndex;
            String jaasKey;
            StringTokenizer tokenizer;
            int tokenCount;
            if (!key.startsWith(JAAS_CONFIG_PREFIX_PARAM) || (tokenCount = (tokenizer = new StringTokenizer(jaasKey = key.substring(prefixLen), ".")).countTokens()) <= 0) continue;
            String clientId = tokenizer.nextToken();
            TreeSet<Integer> indexList = (TreeSet<Integer>)jaasClients.get(clientId);
            if (indexList == null) {
                indexList = new TreeSet<Integer>();
                jaasClients.put(clientId, indexList);
            }
            if (indexList.contains(clientIdIndex = Integer.valueOf(indexId = InMemoryJAASConfiguration.isNumeric(indexStr = tokenizer.nextToken()) ? Integer.parseInt(indexStr) : -1))) continue;
            indexList.add(clientIdIndex);
        }
        for (String jaasClient : jaasClients.keySet()) {
            for (Integer index : (SortedSet)jaasClients.get(jaasClient)) {
                List<AppConfigurationEntry> retList;
                String keyParam;
                String loginModuleName;
                String keyPrefix = JAAS_CONFIG_PREFIX_PARAM + jaasClient + ".";
                if (index > -1) {
                    keyPrefix = keyPrefix + String.valueOf(index) + ".";
                }
                if ((loginModuleName = properties.getProperty(keyParam = keyPrefix + JAAS_CONFIG_LOGIN_MODULE_NAME_PARAM)) == null) {
                    LOG.error("Unable to add JAAS configuration for client [" + jaasClient + "] as it is missing param [" + keyParam + "]." + " Skipping JAAS config for [" + jaasClient + "]");
                    continue;
                }
                loginModuleName = loginModuleName.trim();
                keyParam = keyPrefix + JAAS_CONFIG_LOGIN_MODULE_CONTROL_FLAG_PARAM;
                String controlFlag = properties.getProperty(keyParam);
                AppConfigurationEntry.LoginModuleControlFlag loginControlFlag = null;
                if (controlFlag != null) {
                    if ((controlFlag = controlFlag.trim().toLowerCase()).equals("optional")) {
                        loginControlFlag = AppConfigurationEntry.LoginModuleControlFlag.OPTIONAL;
                    } else if (controlFlag.equals("requisite")) {
                        loginControlFlag = AppConfigurationEntry.LoginModuleControlFlag.REQUISITE;
                    } else if (controlFlag.equals("sufficient")) {
                        loginControlFlag = AppConfigurationEntry.LoginModuleControlFlag.SUFFICIENT;
                    } else if (controlFlag.equals("required")) {
                        loginControlFlag = AppConfigurationEntry.LoginModuleControlFlag.REQUIRED;
                    } else {
                        String validValues = "optional|requisite|sufficient|required";
                        LOG.warn("Unknown JAAS configuration value for (" + keyParam + ") = [" + controlFlag + "], valid value are [" + validValues + "] using the default value, REQUIRED");
                        loginControlFlag = AppConfigurationEntry.LoginModuleControlFlag.REQUIRED;
                    }
                } else {
                    LOG.warn("Unable to find JAAS configuration (" + keyParam + "); using the default value, REQUIRED");
                    loginControlFlag = AppConfigurationEntry.LoginModuleControlFlag.REQUIRED;
                }
                HashMap<String, String> options = new HashMap<String, String>();
                String optionPrefix = keyPrefix + JAAS_CONFIG_LOGIN_OPTIONS_PREFIX + ".";
                int optionPrefixLen = optionPrefix.length();
                for (String key : properties.stringPropertyNames()) {
                    if (!key.startsWith(optionPrefix)) continue;
                    String optionKey = key.substring(optionPrefixLen);
                    String optionVal = properties.getProperty(key);
                    if (optionVal != null) {
                        optionVal = optionVal.trim();
                        try {
                            if (optionKey.equalsIgnoreCase(JAAS_PRINCIPAL_PROP)) {
                                optionVal = SecurityUtil.getServerPrincipal((String)optionVal, (String)null);
                            }
                        }
                        catch (IOException e) {
                            LOG.warn("Failed to build serverPrincipal. Using provided value:[" + optionVal + "]");
                        }
                    }
                    options.put(optionKey, optionVal);
                }
                AppConfigurationEntry entry = new AppConfigurationEntry(loginModuleName, loginControlFlag, options);
                if (LOG.isDebugEnabled()) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("Adding client: [").append(jaasClient).append("{").append(index).append("}]\n");
                    sb.append("\tloginModule: [").append(loginModuleName).append("]\n");
                    sb.append("\tcontrolFlag: [").append(loginControlFlag).append("]\n");
                    for (String key : options.keySet()) {
                        String val = (String)options.get(key);
                        sb.append("\tOptions:  [").append(key).append("] => [").append(val).append("]\n");
                    }
                    LOG.debug(sb.toString());
                }
                if ((retList = this.applicationConfigEntryMap.get(jaasClient)) == null) {
                    retList = new ArrayList<AppConfigurationEntry>();
                    this.applicationConfigEntryMap.put(jaasClient, retList);
                }
                retList.add(entry);
            }
        }
        LOG.debug("<== InMemoryJAASConfiguration.initialize()");
    }

    private static boolean isNumeric(String str) {
        return str.matches("-?\\d+(\\.\\d+)?");
    }
}

