/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.authorization.hadoop.config;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.log4j.Logger;
import org.apache.ranger.audit.provider.AuditProviderFactory;
import org.apache.ranger.authorization.hadoop.config.RangerLegacyConfigBuilder;

public class RangerConfiguration
extends Configuration {
    private static final Logger LOG = Logger.getLogger(RangerConfiguration.class);
    private static volatile RangerConfiguration config = null;

    private RangerConfiguration() {
        super(false);
    }

    public void addResourcesForServiceType(String serviceType) {
        String auditCfg = "ranger-" + serviceType + "-audit.xml";
        String securityCfg = "ranger-" + serviceType + "-security.xml";
        if (!this.addResourceIfReadable(auditCfg)) {
            this.addAuditResource(serviceType);
        }
        if (!this.addResourceIfReadable(securityCfg)) {
            this.addSecurityResource(serviceType);
        }
    }

    public boolean addAdminResources() {
        String defaultCfg = "ranger-admin-default-site.xml";
        String addlCfg = "ranger-admin-site.xml";
        String coreCfg = "core-site.xml";
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> addAdminResources()");
        }
        boolean ret = true;
        if (!this.addResourceIfReadable(defaultCfg)) {
            ret = false;
        }
        if (!this.addResourceIfReadable(addlCfg)) {
            ret = false;
        }
        if (!this.addResourceIfReadable(coreCfg)) {
            ret = false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== addAdminResources(), result=" + ret));
        }
        return ret;
    }

    private boolean addResourceIfReadable(String aResourceName) {
        String fName;
        boolean ret = false;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> addResourceIfReadable(" + aResourceName + ")"));
        }
        if ((fName = this.getFileLocation(aResourceName)) != null) {
            File f;
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("addResourceIfReadable(" + aResourceName + "): resource file is " + fName));
            }
            if ((f = new File(fName)).exists() && f.canRead()) {
                URL fUrl = null;
                try {
                    fUrl = f.toURI().toURL();
                    this.addResource(fUrl);
                    ret = true;
                }
                catch (MalformedURLException e) {
                    LOG.error((Object)("Unable to find URL for the resource name [" + aResourceName + "]. Ignoring the resource:" + aResourceName));
                }
            } else {
                LOG.error((Object)("addResourceIfReadable(" + aResourceName + "): resource not readable"));
            }
        } else {
            LOG.error((Object)("addResourceIfReadable(" + aResourceName + "): couldn't find resource file location"));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== addResourceIfReadable(" + aResourceName + "), result=" + ret));
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RangerConfiguration getInstance() {
        RangerConfiguration result = config;
        if (result != null) return result;
        Class<RangerConfiguration> clazz = RangerConfiguration.class;
        synchronized (RangerConfiguration.class) {
            result = config;
            if (result != null) return result;
            config = result = new RangerConfiguration();
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return result;
        }
    }

    public void initAudit(String appType) {
        AuditProviderFactory auditFactory = AuditProviderFactory.getInstance();
        if (auditFactory == null) {
            LOG.error((Object)"Unable to find the AuditProviderFactory. (null) found");
            return;
        }
        Properties props = this.getProps();
        if (props == null) {
            return;
        }
        if (!auditFactory.isInitDone()) {
            auditFactory.init(props, appType);
        }
    }

    public boolean isAuditInitDone() {
        AuditProviderFactory auditFactory = AuditProviderFactory.getInstance();
        return auditFactory != null && auditFactory.isInitDone();
    }

    private String getFileLocation(String fileName) {
        String ret = null;
        URL lurl = RangerConfiguration.class.getClassLoader().getResource(fileName);
        if (lurl == null) {
            lurl = RangerConfiguration.class.getClassLoader().getResource("/" + fileName);
        }
        if (lurl != null) {
            ret = lurl.getFile();
        }
        return ret;
    }

    private void addSecurityResource(String serviceType) {
        Configuration rangerConf;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> addSecurityResource(Service Type: " + serviceType));
        }
        if ((rangerConf = RangerLegacyConfigBuilder.getSecurityConfig(serviceType)) != null) {
            this.addResource(rangerConf);
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Unable to add the Security Config for" + serviceType + "Pluing won't be enabled!"));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<= addSecurityResource(Service Type: " + serviceType));
        }
    }

    private void addAuditResource(String serviceType) {
        block6: {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("==> addAuditResource(Service Type: " + serviceType));
            }
            URL url = null;
            try {
                url = RangerLegacyConfigBuilder.getAuditConfig(serviceType);
                if (url != null) {
                    this.addResource(url);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug((Object)("==> addAuditResource() URL" + url.getPath()));
                    }
                }
            }
            catch (Throwable t) {
                LOG.warn((Object)(" Unable to find Audit Config for " + serviceType + " Auditing not enabled !"));
                if (!LOG.isDebugEnabled()) break block6;
                LOG.debug((Object)(" Unable to find Audit Config for " + serviceType + " Auditing not enabled !" + t));
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== addAuditResource(Service Type: " + serviceType + ")"));
        }
    }
}

