/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.conditionevaluator;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ranger.plugin.conditionevaluator.RangerAbstractConditionEvaluator;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;

public class RangerTimeOfDayMatcher
extends RangerAbstractConditionEvaluator {
    private static final Log LOG = LogFactory.getLog(RangerTimeOfDayMatcher.class);
    boolean _allowAny = false;
    List<int[]> _durations = new ArrayList<int[]>();
    static final Pattern _Pattern = Pattern.compile(" *(\\d{1,2})(:(\\d{1,2}))? *([aApP])\\.?[mM]\\.? *- *(\\d{1,2})(:(\\d{1,2}))? *([aApP])\\.?[mM]\\.? *");

    @Override
    public void init() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerTimeOfDayMatcher.init(" + this.condition + ")"));
        }
        super.init();
        if (this.condition == null) {
            LOG.debug((Object)"init: null policy condition! Will match always!");
            this._allowAny = true;
        } else if (CollectionUtils.isEmpty(this.condition.getValues())) {
            LOG.debug((Object)"init: empty conditions collection on policy condition!  Will match always!");
            this._allowAny = true;
        } else {
            for (String value : this.condition.getValues()) {
                if (StringUtils.isEmpty((String)value)) {
                    LOG.warn((Object)"init: Unexpected: one of the value in condition is null or empty!");
                    continue;
                }
                int[] aDuration = this.extractDuration(value);
                if (aDuration == null) continue;
                this._durations.add(aDuration);
            }
        }
        if (this._durations.isEmpty()) {
            LOG.debug((Object)"No valid durations found.  Will always match!");
            this._allowAny = true;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerTimeOfDayMatcher.init(" + this.condition + "): durations[" + this.toString() + "]"));
        }
    }

    int[] extractDuration(String value) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerTimeOfDayMatcher.extractDuration(" + value + ")"));
        }
        int[] result = null;
        if (value == null) {
            LOG.warn((Object)"extractDuration: null input value!");
        } else {
            Matcher m = _Pattern.matcher(value);
            if (!m.matches()) {
                LOG.warn((Object)("extractDuration: input[" + value + "] did not match pattern!"));
            } else {
                int startHour = Integer.parseInt(m.group(1));
                int startMin = 0;
                if (m.group(3) != null) {
                    startMin = Integer.parseInt(m.group(3));
                }
                String startType = m.group(4).toUpperCase();
                int endHour = Integer.parseInt(m.group(5));
                int endMinute = 0;
                if (m.group(7) != null) {
                    endMinute = Integer.parseInt(m.group(7));
                }
                String endType = m.group(8).toUpperCase();
                if (startHour == 12) {
                    if (startType.equals("A")) {
                        startHour = 0;
                    }
                } else if (startType.equals("P")) {
                    startHour += 12;
                }
                if (endHour == 12) {
                    if (endType.equals("A")) {
                        endHour = 0;
                    }
                } else if (endType.equals("P")) {
                    endHour += 12;
                }
                result = new int[]{startHour * 60 + startMin, endHour * 60 + endMinute};
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerTimeOfDayMatcher.extractDuration(" + value + "): duration[" + result + "]"));
        }
        return result;
    }

    @Override
    public boolean isMatched(RangerAccessRequest request) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerTimeOfDayMatcher.isMatched(" + request + ")"));
        }
        boolean matched = true;
        if (this._allowAny) {
            LOG.debug((Object)"isMatched: allowAny flag is true.  Matched!");
        } else if (request == null) {
            LOG.warn((Object)"isMatched: Unexpected: Request is null!  Implicitly matched!");
        } else if (request.getAccessTime() == null) {
            LOG.warn((Object)"isMatched: Unexpected: Accesstime on the request is null!  Implicitly matched!");
        } else {
            Date date = request.getAccessTime();
            Calendar calendar = GregorianCalendar.getInstance();
            calendar.setTime(date);
            int hourOfDay = calendar.get(11);
            int minutes = calendar.get(12);
            if (!this.durationMatched(this._durations, hourOfDay, minutes)) {
                matched = false;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("isMatched: None of the durations contains this hour of day[" + hourOfDay + "] and minutes[" + minutes + "]"));
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerTimeOfDayMatcher.isMatched(" + request + "): " + matched));
        }
        return matched;
    }

    boolean durationMatched(List<int[]> durations, int hourOfDay, int minutes) {
        for (int[] aDuration : durations) {
            int start = aDuration[0];
            int end = aDuration[1];
            int minutesOfDay = hourOfDay * 60 + minutes;
            if (!(start < end ? start <= minutesOfDay && minutesOfDay <= end : start <= minutesOfDay || minutesOfDay <= end)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("RangerTimeOfDayMatcher {");
        sb.append("_allowAny=" + this._allowAny).append(" ");
        sb.append("_durations=[");
        for (int[] duration : this._durations) {
            sb.append("{start=" + duration[0] + "; end=" + duration[1] + "} ");
        }
        sb.append("]");
        sb.append("}");
        return sb.toString();
    }
}

