/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.model.validation;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ranger.plugin.errors.ValidationErrorCode;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerPolicyResourceSignature;
import org.apache.ranger.plugin.model.RangerService;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.model.validation.RangerServiceDefHelper;
import org.apache.ranger.plugin.model.validation.RangerValidator;
import org.apache.ranger.plugin.model.validation.ValidationFailureDetails;
import org.apache.ranger.plugin.model.validation.ValidationFailureDetailsBuilder;
import org.apache.ranger.plugin.store.ServiceStore;

public class RangerPolicyValidator
extends RangerValidator {
    private static final Log LOG = LogFactory.getLog(RangerPolicyValidator.class);

    public RangerPolicyValidator(ServiceStore store) {
        super(store);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validate(RangerPolicy policy, RangerValidator.Action action, boolean isAdmin) throws Exception {
        String message;
        boolean valid;
        block5: {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)String.format("==> RangerPolicyValidator.validate(%s, %s, %s)", new Object[]{policy, action, isAdmin}));
            }
            ArrayList<ValidationFailureDetails> failures = new ArrayList<ValidationFailureDetails>();
            valid = this.isValid(policy, action, isAdmin, failures);
            message = "";
            try {
                if (valid) break block5;
                message = this.serializeFailures(failures);
                throw new Exception(message);
            }
            catch (Throwable throwable) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)String.format("<== RangerPolicyValidator.validate(%s, %s, %s): %s, reason[%s]", new Object[]{policy, action, isAdmin, valid, message}));
                }
                throw throwable;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("<== RangerPolicyValidator.validate(%s, %s, %s): %s, reason[%s]", new Object[]{policy, action, isAdmin, valid, message}));
        }
    }

    @Override
    boolean isValid(Long id, RangerValidator.Action action, List<ValidationFailureDetails> failures) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("==> RangerPolicyValidator.isValid(%s, %s, %s)", new Object[]{id, action, failures}));
        }
        boolean valid = true;
        if (action != RangerValidator.Action.DELETE) {
            ValidationErrorCode error = ValidationErrorCode.POLICY_VALIDATION_ERR_UNSUPPORTED_ACTION;
            failures.add(new ValidationFailureDetailsBuilder().isAnInternalError().becauseOf(error.getMessage(new Object[0])).errorCode(error.getErrorCode()).build());
            valid = false;
        } else if (id == null) {
            ValidationErrorCode error = ValidationErrorCode.POLICY_VALIDATION_ERR_MISSING_FIELD;
            failures.add(new ValidationFailureDetailsBuilder().becauseOf("policy id was null/missing").field("id").isMissing().errorCode(error.getErrorCode()).becauseOf(error.getMessage("id")).build());
            valid = false;
        } else if (this.getPolicy(id) == null && LOG.isDebugEnabled()) {
            LOG.debug((Object)("No policy found for id[" + id + "]! ok!"));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("<== RangerPolicyValidator.isValid(%s, %s, %s): %s", new Object[]{id, action, failures, valid}));
        }
        return valid;
    }

    boolean isValid(RangerPolicy policy, RangerValidator.Action action, boolean isAdmin, List<ValidationFailureDetails> failures) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("==> RangerPolicyValidator.isValid(%s, %s, %s, %s)", new Object[]{policy, action, isAdmin, failures}));
        }
        if (action != RangerValidator.Action.CREATE && action != RangerValidator.Action.UPDATE) {
            throw new IllegalArgumentException("isValid(RangerPolicy, ...) is only supported for create/update");
        }
        boolean valid = true;
        if (policy == null) {
            ValidationErrorCode error = ValidationErrorCode.POLICY_VALIDATION_ERR_NULL_POLICY_OBJECT;
            failures.add(new ValidationFailureDetailsBuilder().field("policy").isMissing().becauseOf(error.getMessage(new Object[0])).errorCode(error.getErrorCode()).build());
            valid = false;
        } else {
            ValidationErrorCode error;
            Long id = policy.getId();
            RangerPolicy existingPolicy = null;
            if (action == RangerValidator.Action.UPDATE) {
                ValidationErrorCode error2;
                if (id == null) {
                    error2 = ValidationErrorCode.POLICY_VALIDATION_ERR_MISSING_FIELD;
                    failures.add(new ValidationFailureDetailsBuilder().field("id").isMissing().becauseOf(error2.getMessage("id")).errorCode(error2.getErrorCode()).build());
                    valid = false;
                }
                if ((existingPolicy = this.getPolicy(id)) == null) {
                    error2 = ValidationErrorCode.POLICY_VALIDATION_ERR_INVALID_POLICY_ID;
                    failures.add(new ValidationFailureDetailsBuilder().field("id").isSemanticallyIncorrect().becauseOf(error2.getMessage(id)).errorCode(error2.getErrorCode()).build());
                    valid = false;
                }
            }
            String policyName = policy.getName();
            String serviceName = policy.getService();
            if (StringUtils.isBlank((String)policyName)) {
                ValidationErrorCode error3 = ValidationErrorCode.POLICY_VALIDATION_ERR_MISSING_FIELD;
                failures.add(new ValidationFailureDetailsBuilder().field("name").isMissing().becauseOf(error3.getMessage("name")).errorCode(error3.getErrorCode()).build());
                valid = false;
            } else {
                List<RangerPolicy> policies = this.getPolicies(serviceName, policyName);
                if (CollectionUtils.isNotEmpty(policies)) {
                    ValidationErrorCode error4;
                    if (policies.size() > 1) {
                        error4 = ValidationErrorCode.POLICY_VALIDATION_ERR_POLICY_NAME_MULTIPLE_POLICIES_WITH_SAME_NAME;
                        failures.add(new ValidationFailureDetailsBuilder().field("name").isAnInternalError().becauseOf(error4.getMessage(policyName)).errorCode(error4.getErrorCode()).build());
                        valid = false;
                    } else if (action == RangerValidator.Action.CREATE) {
                        error4 = ValidationErrorCode.POLICY_VALIDATION_ERR_POLICY_NAME_CONFLICT;
                        failures.add(new ValidationFailureDetailsBuilder().field("policy name").isSemanticallyIncorrect().becauseOf(error4.getMessage(policies.iterator().next().getId(), serviceName)).errorCode(error4.getErrorCode()).build());
                        valid = false;
                    } else if (!policies.iterator().next().getId().equals(id)) {
                        error4 = ValidationErrorCode.POLICY_VALIDATION_ERR_POLICY_NAME_CONFLICT;
                        failures.add(new ValidationFailureDetailsBuilder().field("id/name").isSemanticallyIncorrect().becauseOf(error4.getMessage(policies.iterator().next().getId(), serviceName)).errorCode(error4.getErrorCode()).build());
                        valid = false;
                    }
                }
            }
            RangerService service = null;
            boolean serviceNameValid = false;
            if (StringUtils.isBlank((String)serviceName)) {
                error = ValidationErrorCode.POLICY_VALIDATION_ERR_MISSING_FIELD;
                failures.add(new ValidationFailureDetailsBuilder().field("service name").isMissing().becauseOf(error.getMessage("service name")).errorCode(error.getErrorCode()).build());
                valid = false;
            } else {
                service = this.getService(serviceName);
                if (service == null) {
                    error = ValidationErrorCode.POLICY_VALIDATION_ERR_INVALID_SERVICE_NAME;
                    failures.add(new ValidationFailureDetailsBuilder().field("service name").isSemanticallyIncorrect().becauseOf(error.getMessage(serviceName)).errorCode(error.getErrorCode()).build());
                    valid = false;
                } else {
                    serviceNameValid = true;
                }
            }
            if (existingPolicy != null) {
                int policyType;
                if (!StringUtils.equalsIgnoreCase((String)existingPolicy.getService(), (String)policy.getService())) {
                    error = ValidationErrorCode.POLICY_VALIDATION_ERR_POLICY_UPDATE_MOVE_SERVICE_NOT_ALLOWED;
                    failures.add(new ValidationFailureDetailsBuilder().field("service name").isSemanticallyIncorrect().becauseOf(error.getMessage(policy.getId(), existingPolicy.getService(), policy.getService())).errorCode(error.getErrorCode()).build());
                    valid = false;
                }
                int existingPolicyType = existingPolicy.getPolicyType() == null ? 0 : existingPolicy.getPolicyType();
                int n = policyType = policy.getPolicyType() == null ? 0 : policy.getPolicyType();
                if (existingPolicyType != policyType) {
                    ValidationErrorCode error5 = ValidationErrorCode.POLICY_VALIDATION_ERR_POLICY_TYPE_CHANGE_NOT_ALLOWED;
                    failures.add(new ValidationFailureDetailsBuilder().field("policy type").isSemanticallyIncorrect().becauseOf(error5.getMessage(policy.getId(), existingPolicyType, policyType)).errorCode(error5.getErrorCode()).build());
                    valid = false;
                }
            }
            boolean isAuditEnabled = this.getIsAuditEnabled(policy);
            String serviceDefName = null;
            RangerServiceDef serviceDef = null;
            int policyItemsCount = 0;
            int policyType = policy.getPolicyType() == null ? 0 : policy.getPolicyType();
            switch (policyType) {
                case 1: {
                    if (!CollectionUtils.isNotEmpty(policy.getDataMaskPolicyItems())) break;
                    policyItemsCount += policy.getDataMaskPolicyItems().size();
                    break;
                }
                case 2: {
                    if (!CollectionUtils.isNotEmpty(policy.getRowFilterPolicyItems())) break;
                    policyItemsCount += policy.getRowFilterPolicyItems().size();
                    break;
                }
                default: {
                    if (CollectionUtils.isNotEmpty(policy.getPolicyItems())) {
                        policyItemsCount += policy.getPolicyItems().size();
                    }
                    if (!CollectionUtils.isNotEmpty(policy.getDenyPolicyItems())) break;
                    policyItemsCount += policy.getDenyPolicyItems().size();
                }
            }
            if (policyItemsCount == 0 && !isAuditEnabled) {
                ValidationErrorCode error6 = ValidationErrorCode.POLICY_VALIDATION_ERR_MISSING_POLICY_ITEMS;
                failures.add(new ValidationFailureDetailsBuilder().field("policy items").isMissing().becauseOf(error6.getMessage(new Object[0])).errorCode(error6.getErrorCode()).build());
                valid = false;
            } else if (service != null) {
                serviceDefName = service.getType();
                serviceDef = this.getServiceDef(serviceDefName);
                if (serviceDef == null) {
                    ValidationErrorCode error7 = ValidationErrorCode.POLICY_VALIDATION_ERR_MISSING_SERVICE_DEF;
                    failures.add(new ValidationFailureDetailsBuilder().field("policy service def").isAnInternalError().becauseOf(error7.getMessage(serviceDefName, serviceName)).errorCode(error7.getErrorCode()).build());
                    valid = false;
                } else {
                    valid = this.isValidPolicyItems(policy.getPolicyItems(), failures, serviceDef) && valid;
                    valid = this.isValidPolicyItems(policy.getDenyPolicyItems(), failures, serviceDef) && valid;
                    valid = this.isValidPolicyItems(policy.getAllowExceptions(), failures, serviceDef) && valid;
                    boolean bl = valid = this.isValidPolicyItems(policy.getDenyExceptions(), failures, serviceDef) && valid;
                }
            }
            if (serviceNameValid) {
                boolean bl = valid = this.isValidResources(policy, failures, action, isAdmin, serviceDef) && valid;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("<== RangerPolicyValidator.isValid(%s, %s, %s, %s): %s", new Object[]{policy, action, isAdmin, failures, valid}));
        }
        return valid;
    }

    boolean isValidResources(RangerPolicy policy, List<ValidationFailureDetails> failures, RangerValidator.Action action, boolean isAdmin, RangerServiceDef serviceDef) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("==> RangerPolicyValidator.isValidResources(%s, %s, %s, %s, %s)", new Object[]{policy, failures, action, isAdmin, serviceDef}));
        }
        boolean valid = true;
        Map<String, RangerPolicy.RangerPolicyResource> resourceMap = policy.getResources();
        if (resourceMap != null) {
            boolean bl = valid = this.isPolicyResourceUnique(policy, failures, action) && valid;
            if (serviceDef != null) {
                valid = this.isValidResourceNames(policy, failures, serviceDef) && valid;
                valid = this.isValidResourceValues(resourceMap, failures, serviceDef) && valid;
                boolean bl2 = valid = this.isValidResourceFlags(resourceMap, failures, serviceDef.getResources(), serviceDef.getName(), policy.getName(), isAdmin) && valid;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("<== RangerPolicyValidator.isValidResources(%s, %s, %s, %s, %s): %s", new Object[]{policy, failures, action, isAdmin, serviceDef, valid}));
        }
        return valid;
    }

    boolean isPolicyResourceUnique(RangerPolicy policy, List<ValidationFailureDetails> failures, RangerValidator.Action action) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("==> RangerPolicyValidator.isPolicyResourceUnique(%s, %s, %s)", new Object[]{policy, failures, action}));
        }
        boolean valid = true;
        if (!Boolean.TRUE.equals(policy.getIsEnabled())) {
            LOG.debug((Object)"Policy is disabled. Skipping resource uniqueness validation.");
        } else {
            RangerPolicyResourceSignature policySignature = this._factory.createPolicyResourceSignature(policy);
            String signature = policySignature.getSignature();
            List<RangerPolicy> policies = this.getPoliciesForResourceSignature(policy.getService(), signature);
            if (CollectionUtils.isNotEmpty(policies)) {
                ValidationErrorCode error = ValidationErrorCode.POLICY_VALIDATION_ERR_DUPLICATE_POLICY_RESOURCE;
                RangerPolicy matchedPolicy = policies.iterator().next();
                if (action == RangerValidator.Action.CREATE || action == RangerValidator.Action.UPDATE && (policies.size() > 1 || !matchedPolicy.getId().equals(policy.getId()))) {
                    failures.add(new ValidationFailureDetailsBuilder().field("resources").isSemanticallyIncorrect().becauseOf(error.getMessage(matchedPolicy.getName(), policy.getService())).errorCode(error.getErrorCode()).build());
                    valid = false;
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("<== RangerPolicyValidator.isPolicyResourceUnique(%s, %s, %s): %s", new Object[]{policy, failures, action, valid}));
        }
        return valid;
    }

    boolean isValidResourceNames(RangerPolicy policy, List<ValidationFailureDetails> failures, RangerServiceDef serviceDef) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("==> RangerPolicyValidator.isValidResourceNames(%s, %s, %s)", policy, failures, serviceDef));
        }
        boolean valid = true;
        Set<String> policyResources = this.getPolicyResources(policy);
        RangerServiceDefHelper defHelper = new RangerServiceDefHelper(serviceDef);
        Set<List<RangerServiceDef.RangerResourceDef>> hierarchies = defHelper.getResourceHierarchies(policy.getPolicyType());
        if (hierarchies.isEmpty()) {
            LOG.warn((Object)"RangerPolicyValidator.isValidResourceNames: serviceDef does not have any resource hierarchies, possibly due to a old/migrated service def!  Skipping this check!");
        } else {
            Set<List<RangerServiceDef.RangerResourceDef>> candidateHierarchies = this.filterHierarchies_hierarchyHasAllPolicyResources(policyResources, hierarchies, defHelper);
            if (candidateHierarchies.isEmpty()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)String.format("No compatible resource hierarchies found: resource[%s], service-def[%s], valid-resource-hierarchies[%s]", policyResources.toString(), serviceDef.getName(), this.toStringHierarchies_all(hierarchies, defHelper)));
                }
                ValidationErrorCode error = hierarchies.size() == 1 ? ValidationErrorCode.POLICY_VALIDATION_ERR_INVALID_RESOURCE_NO_COMPATIBLE_HIERARCHY_SINGLE : ValidationErrorCode.POLICY_VALIDATION_ERR_INVALID_RESOURCE_NO_COMPATIBLE_HIERARCHY;
                failures.add(new ValidationFailureDetailsBuilder().field("policy resources").subField("incompatible").isSemanticallyIncorrect().becauseOf(error.getMessage(serviceDef.getName(), this.toStringHierarchies_all(hierarchies, defHelper))).errorCode(error.getErrorCode()).build());
                valid = false;
            } else {
                Set<List<RangerServiceDef.RangerResourceDef>> validHierarchies;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("isValidResourceNames: Found [" + candidateHierarchies.size() + "] compatible hierarchies: " + this.toStringHierarchies_all(candidateHierarchies, defHelper)));
                }
                if ((validHierarchies = this.filterHierarchies_mandatoryResourcesSpecifiedInPolicy(policyResources, candidateHierarchies, defHelper)).isEmpty()) {
                    ValidationErrorCode error = candidateHierarchies.size() == 1 ? ValidationErrorCode.POLICY_VALIDATION_ERR_INVALID_RESOURCE_MISSING_MANDATORY_SINGLE : ValidationErrorCode.POLICY_VALIDATION_ERR_INVALID_RESOURCE_MISSING_MANDATORY;
                    failures.add(new ValidationFailureDetailsBuilder().field("policy resources").subField("missing mandatory").isSemanticallyIncorrect().becauseOf(error.getMessage(serviceDef.getName(), this.toStringHierarchies_mandatory(candidateHierarchies, defHelper))).errorCode(error.getErrorCode()).build());
                    valid = false;
                } else if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("isValidResourceNames: Found hierarchies with all mandatory fields specified: " + this.toStringHierarchies_mandatory(validHierarchies, defHelper)));
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("<== RangerPolicyValidator.isValidResourceNames(%s, %s, %s): %s", policy, failures, serviceDef, valid));
        }
        return valid;
    }

    String toStringHierarchies_mandatory(Set<List<RangerServiceDef.RangerResourceDef>> hierarchies, RangerServiceDefHelper defHelper) {
        StringBuilder builder = new StringBuilder();
        for (List<RangerServiceDef.RangerResourceDef> aHierarchy : hierarchies) {
            builder.append(defHelper.getMandatoryResourceNames(aHierarchy));
            builder.append(" ");
        }
        return builder.toString();
    }

    String toStringHierarchies_all(Set<List<RangerServiceDef.RangerResourceDef>> hierarchies, RangerServiceDefHelper defHelper) {
        StringBuilder builder = new StringBuilder();
        for (List<RangerServiceDef.RangerResourceDef> aHierarchy : hierarchies) {
            builder.append(defHelper.getAllResourceNamesOrdered(aHierarchy));
            builder.append(" ");
        }
        return builder.toString();
    }

    Set<List<RangerServiceDef.RangerResourceDef>> filterHierarchies_hierarchyHasAllPolicyResources(Set<String> policyResources, Set<List<RangerServiceDef.RangerResourceDef>> hierarchies, RangerServiceDefHelper defHelper) {
        HashSet<List<RangerServiceDef.RangerResourceDef>> result = new HashSet<List<RangerServiceDef.RangerResourceDef>>(hierarchies.size());
        for (List<RangerServiceDef.RangerResourceDef> aHierarchy : hierarchies) {
            Set<String> hierarchyResources = defHelper.getAllResourceNames(aHierarchy);
            if (!hierarchyResources.containsAll(policyResources)) continue;
            result.add(aHierarchy);
        }
        return result;
    }

    Set<List<RangerServiceDef.RangerResourceDef>> filterHierarchies_mandatoryResourcesSpecifiedInPolicy(Set<String> policyResources, Set<List<RangerServiceDef.RangerResourceDef>> hierarchies, RangerServiceDefHelper defHelper) {
        HashSet<List<RangerServiceDef.RangerResourceDef>> result = new HashSet<List<RangerServiceDef.RangerResourceDef>>(hierarchies.size());
        for (List<RangerServiceDef.RangerResourceDef> aHierarchy : hierarchies) {
            Set<String> mandatoryResources = defHelper.getMandatoryResourceNames(aHierarchy);
            if (!policyResources.containsAll(mandatoryResources)) continue;
            result.add(aHierarchy);
        }
        return result;
    }

    boolean isValidResourceFlags(Map<String, RangerPolicy.RangerPolicyResource> inputPolicyResources, List<ValidationFailureDetails> failures, List<RangerServiceDef.RangerResourceDef> resourceDefs, String serviceDefName, String policyName, boolean isAdmin) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("==> RangerPolicyValidator.isValidResourceFlags(%s, %s, %s, %s, %s, %s)", inputPolicyResources, failures, resourceDefs, serviceDefName, policyName, isAdmin));
        }
        boolean valid = true;
        if (resourceDefs == null) {
            LOG.debug((Object)"isValidResourceFlags: service Def is null");
        } else {
            Map<String, RangerPolicy.RangerPolicyResource> policyResources = this.getPolicyResourceWithLowerCaseKeys(inputPolicyResources);
            for (RangerServiceDef.RangerResourceDef resourceDef : resourceDefs) {
                ValidationErrorCode error;
                ValidationErrorCode error2;
                if (resourceDef == null) {
                    error2 = ValidationErrorCode.POLICY_VALIDATION_ERR_NULL_RESOURCE_DEF;
                    failures.add(new ValidationFailureDetailsBuilder().field("resource-def").isAnInternalError().becauseOf(error2.getMessage(serviceDefName)).errorCode(error2.getErrorCode()).build());
                    valid = false;
                    continue;
                }
                if (StringUtils.isBlank((String)resourceDef.getName())) {
                    error2 = ValidationErrorCode.POLICY_VALIDATION_ERR_MISSING_RESOURCE_DEF_NAME;
                    failures.add(new ValidationFailureDetailsBuilder().field("resource-def-name").isAnInternalError().becauseOf(error2.getMessage(serviceDefName)).errorCode(error2.getErrorCode()).build());
                    valid = false;
                    continue;
                }
                String resourceName = resourceDef.getName().toLowerCase();
                RangerPolicy.RangerPolicyResource policyResource = policyResources.get(resourceName);
                if (policyResource == null) {
                    if (!LOG.isDebugEnabled()) continue;
                    LOG.debug((Object)("a policy-resource object for resource[" + resourceName + "] on policy [" + policyName + "] was null"));
                    continue;
                }
                boolean excludesSupported = Boolean.TRUE.equals(resourceDef.getExcludesSupported());
                boolean policyResourceIsExcludes = Boolean.TRUE.equals(policyResource.getIsExcludes());
                if (policyResourceIsExcludes && !excludesSupported) {
                    error = ValidationErrorCode.POLICY_VALIDATION_ERR_EXCLUDES_NOT_SUPPORTED;
                    failures.add(new ValidationFailureDetailsBuilder().field("isExcludes").subField(resourceName).isSemanticallyIncorrect().becauseOf(error.getMessage(resourceName)).errorCode(error.getErrorCode()).build());
                    valid = false;
                }
                if (policyResourceIsExcludes && !isAdmin) {
                    error = ValidationErrorCode.POLICY_VALIDATION_ERR_EXCLUDES_REQUIRES_ADMIN;
                    failures.add(new ValidationFailureDetailsBuilder().field("isExcludes").subField("isAdmin").isSemanticallyIncorrect().becauseOf(error.getMessage(new Object[0])).errorCode(error.getErrorCode()).build());
                    valid = false;
                }
                boolean recursiveSupported = Boolean.TRUE.equals(resourceDef.getRecursiveSupported());
                boolean policyIsRecursive = Boolean.TRUE.equals(policyResource.getIsRecursive());
                if (!policyIsRecursive || recursiveSupported) continue;
                ValidationErrorCode error3 = ValidationErrorCode.POLICY_VALIDATION_ERR_RECURSIVE_NOT_SUPPORTED;
                failures.add(new ValidationFailureDetailsBuilder().field("isRecursive").subField(resourceName).isSemanticallyIncorrect().becauseOf(error3.getMessage(resourceName)).errorCode(error3.getErrorCode()).build());
                valid = false;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("<== RangerPolicyValidator.isValidResourceFlags(%s, %s, %s, %s, %s, %s): %s", inputPolicyResources, failures, resourceDefs, serviceDefName, policyName, isAdmin, valid));
        }
        return valid;
    }

    boolean isValidResourceValues(Map<String, RangerPolicy.RangerPolicyResource> resourceMap, List<ValidationFailureDetails> failures, RangerServiceDef serviceDef) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("==> RangerPolicyValidator.isValidResourceValues(%s, %s, %s)", resourceMap, failures, serviceDef));
        }
        boolean valid = true;
        Map<String, String> validationRegExMap = this.getValidationRegExes(serviceDef);
        for (Map.Entry<String, RangerPolicy.RangerPolicyResource> entry : resourceMap.entrySet()) {
            String name = entry.getKey();
            RangerPolicy.RangerPolicyResource policyResource = entry.getValue();
            if (policyResource == null) continue;
            if (CollectionUtils.isNotEmpty(policyResource.getValues())) {
                HashSet<String> resources = new HashSet<String>(policyResource.getValues());
                for (String aValue : resources) {
                    if (!StringUtils.isBlank((String)aValue)) continue;
                    policyResource.getValues().remove(aValue);
                }
            }
            if (CollectionUtils.isEmpty(policyResource.getValues())) {
                ValidationErrorCode error = ValidationErrorCode.POLICY_VALIDATION_ERR_MISSING_RESOURCE_LIST;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)String.format("Resource list was empty or contains null: value[%s], resource-name[%s], service-def-name[%s]", policyResource.getValues(), name, serviceDef.getName()));
                }
                failures.add(new ValidationFailureDetailsBuilder().field("resource-values").subField(name).isMissing().becauseOf(error.getMessage(name)).errorCode(error.getErrorCode()).build());
                valid = false;
            }
            if (!validationRegExMap.containsKey(name) || !CollectionUtils.isNotEmpty(policyResource.getValues())) continue;
            String regEx = validationRegExMap.get(name);
            for (String aValue : policyResource.getValues()) {
                if (aValue.matches(regEx)) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)String.format("Resource failed regex check: value[%s], resource-name[%s], regEx[%s], service-def-name[%s]", aValue, name, regEx, serviceDef.getName()));
                }
                ValidationErrorCode error = ValidationErrorCode.POLICY_VALIDATION_ERR_INVALID_RESOURCE_VALUE_REGEX;
                failures.add(new ValidationFailureDetailsBuilder().field("resource-values").subField(name).isSemanticallyIncorrect().becauseOf(error.getMessage(aValue, name)).errorCode(error.getErrorCode()).build());
                valid = false;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("<== RangerPolicyValidator.isValidResourceValues(%s, %s, %s): %s", resourceMap, failures, serviceDef, valid));
        }
        return valid;
    }

    boolean isValidPolicyItems(List<RangerPolicy.RangerPolicyItem> policyItems, List<ValidationFailureDetails> failures, RangerServiceDef serviceDef) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("==> RangerPolicyValidator.isValid(%s, %s, %s)", policyItems, failures, serviceDef));
        }
        boolean valid = true;
        if (CollectionUtils.isEmpty(policyItems)) {
            LOG.debug((Object)"policy items collection was null/empty");
        } else {
            for (RangerPolicy.RangerPolicyItem policyItem : policyItems) {
                if (policyItem == null) {
                    ValidationErrorCode error = ValidationErrorCode.POLICY_VALIDATION_ERR_NULL_POLICY_ITEM;
                    failures.add(new ValidationFailureDetailsBuilder().field("policy item").isMissing().becauseOf(error.getMessage(new Object[0])).errorCode(error.getErrorCode()).build());
                    valid = false;
                    continue;
                }
                valid = this.isValidPolicyItem(policyItem, failures, serviceDef) && valid;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("<== RangerPolicyValidator.isValid(%s, %s, %s): %s", policyItems, failures, serviceDef, valid));
        }
        return valid;
    }

    boolean isValidPolicyItem(RangerPolicy.RangerPolicyItem policyItem, List<ValidationFailureDetails> failures, RangerServiceDef serviceDef) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("==> RangerPolicyValidator.isValid(%s, %s, %s)", policyItem, failures, serviceDef));
        }
        boolean valid = true;
        if (policyItem == null) {
            LOG.debug((Object)"policy item was null!");
        } else {
            ValidationErrorCode error;
            if (CollectionUtils.isEmpty(policyItem.getAccesses())) {
                if (!Boolean.TRUE.equals(policyItem.getDelegateAdmin())) {
                    error = ValidationErrorCode.POLICY_VALIDATION_ERR_MISSING_FIELD;
                    failures.add(new ValidationFailureDetailsBuilder().field("policy item accesses").isMissing().becauseOf(error.getMessage("policy item accesses")).errorCode(error.getErrorCode()).build());
                    valid = false;
                } else {
                    LOG.debug((Object)"policy item collection was null but delegated admin is true. Ok");
                }
            } else {
                boolean bl = valid = this.isValidItemAccesses(policyItem.getAccesses(), failures, serviceDef) && valid;
            }
            if (CollectionUtils.isEmpty(policyItem.getUsers()) && CollectionUtils.isEmpty(policyItem.getGroups())) {
                error = ValidationErrorCode.POLICY_VALIDATION_ERR_MISSING_USER_AND_GROUPS;
                failures.add(new ValidationFailureDetailsBuilder().field("policy item users/user-groups").isMissing().becauseOf(error.getMessage(new Object[0])).errorCode(error.getErrorCode()).build());
                valid = false;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("<== RangerPolicyValidator.isValid(%s, %s, %s): %s", policyItem, failures, serviceDef, valid));
        }
        return valid;
    }

    boolean isValidItemAccesses(List<RangerPolicy.RangerPolicyItemAccess> accesses, List<ValidationFailureDetails> failures, RangerServiceDef serviceDef) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("==> RangerPolicyValidator.isValid(%s, %s, %s)", accesses, failures, serviceDef));
        }
        boolean valid = true;
        if (CollectionUtils.isEmpty(accesses)) {
            LOG.debug((Object)"policy item accesses collection was null/empty!");
        } else {
            Set<String> accessTypes = this.getAccessTypes(serviceDef);
            for (RangerPolicy.RangerPolicyItemAccess access : accesses) {
                if (access == null) {
                    ValidationErrorCode error = ValidationErrorCode.POLICY_VALIDATION_ERR_NULL_POLICY_ITEM_ACCESS;
                    failures.add(new ValidationFailureDetailsBuilder().field("policy item access").isMissing().becauseOf(error.getMessage(new Object[0])).errorCode(error.getErrorCode()).build());
                    valid = false;
                    continue;
                }
                valid = this.isValidPolicyItemAccess(access, failures, accessTypes) && valid;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("<== RangerPolicyValidator.isValid(%s, %s): %s", accesses, failures, serviceDef, valid));
        }
        return valid;
    }

    boolean isValidPolicyItemAccess(RangerPolicy.RangerPolicyItemAccess access, List<ValidationFailureDetails> failures, Set<String> accessTypes) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("==> RangerPolicyValidator.isValidPolicyItemAccess(%s, %s, %s)", access, failures, accessTypes));
        }
        boolean valid = true;
        if (CollectionUtils.isEmpty(accessTypes)) {
            LOG.debug((Object)"isValidPolicyItemAccess: accessTypes was null!");
        } else if (access == null) {
            LOG.debug((Object)"isValidPolicyItemAccess: policy item access was null!");
        } else {
            ValidationErrorCode error;
            String accessType = access.getType();
            if (StringUtils.isBlank((String)accessType)) {
                error = ValidationErrorCode.POLICY_VALIDATION_ERR_MISSING_FIELD;
                failures.add(new ValidationFailureDetailsBuilder().field("policy item access type").isMissing().becauseOf(error.getMessage("policy item access type")).errorCode(error.getErrorCode()).build());
                valid = false;
            } else if (!accessTypes.contains(accessType.toLowerCase())) {
                error = ValidationErrorCode.POLICY_VALIDATION_ERR_POLICY_ITEM_ACCESS_TYPE_INVALID;
                failures.add(new ValidationFailureDetailsBuilder().field("policy item access type").isSemanticallyIncorrect().becauseOf(error.getMessage(accessType, accessTypes)).errorCode(error.getErrorCode()).build());
                valid = false;
            }
            Boolean isAllowed = access.getIsAllowed();
            if (isAllowed != null && !isAllowed.booleanValue()) {
                ValidationErrorCode error2 = ValidationErrorCode.POLICY_VALIDATION_ERR_POLICY_ITEM_ACCESS_TYPE_DENY;
                failures.add(new ValidationFailureDetailsBuilder().field("policy item access type allowed").isSemanticallyIncorrect().becauseOf(error2.getMessage(new Object[0])).errorCode(error2.getErrorCode()).build());
                valid = false;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)String.format("<== RangerPolicyValidator.isValidPolicyItemAccess(%s, %s, %s): %s", access, failures, accessTypes, valid));
        }
        return valid;
    }
}

