/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.policyengine;

import org.apache.commons.lang.StringUtils;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerAccessResult;
import org.apache.ranger.plugin.util.ServiceDefUtil;

public class RangerDataMaskResult
extends RangerAccessResult {
    private String maskType = null;
    private String maskCondition = null;
    private String maskedValue = null;

    public RangerDataMaskResult(String serviceName, RangerServiceDef serviceDef, RangerAccessRequest request) {
        this(serviceName, serviceDef, request, null);
    }

    public RangerDataMaskResult(String serviceName, RangerServiceDef serviceDef, RangerAccessRequest request, RangerPolicy.RangerPolicyItemDataMaskInfo dataMaskInfo) {
        super(serviceName, serviceDef, request);
        if (dataMaskInfo != null) {
            this.setMaskType(dataMaskInfo.getDataMaskType());
            this.setMaskCondition(dataMaskInfo.getConditionExpr());
            this.setMaskedValue(dataMaskInfo.getValueExpr());
        }
    }

    public String getMaskType() {
        return this.maskType;
    }

    public void setMaskType(String maskType) {
        this.maskType = maskType;
    }

    public String getMaskCondition() {
        return this.maskCondition;
    }

    public void setMaskCondition(String maskCondition) {
        this.maskCondition = maskCondition;
    }

    public String getMaskedValue() {
        return this.maskedValue;
    }

    public void setMaskedValue(String maskedValue) {
        this.maskedValue = maskedValue;
    }

    public boolean isMaskEnabled() {
        return StringUtils.isNotEmpty((String)this.getMaskType());
    }

    public RangerServiceDef.RangerDataMaskTypeDef getMaskTypeDef() {
        RangerServiceDef.RangerDataMaskTypeDef ret = null;
        if (StringUtils.isNotEmpty((String)this.maskType)) {
            ret = ServiceDefUtil.getDataMaskType(this.getServiceDef(), this.maskType);
        }
        return ret;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.toString(sb);
        return sb.toString();
    }

    @Override
    public StringBuilder toString(StringBuilder sb) {
        sb.append("RangerDataMaskResult={");
        super.toString(sb);
        sb.append("maskType={").append(this.maskType).append("} ");
        sb.append("maskCondition={").append(this.maskCondition).append("} ");
        sb.append("maskedValue={").append(this.maskedValue).append("} ");
        sb.append("}");
        return sb;
    }
}

