/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.policyengine;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.ranger.plugin.policyengine.RangerAccessResult;

class RangerTagAuditEvent {
    private final String tagType;
    private final RangerAccessResult result;

    RangerTagAuditEvent(String tagType, RangerAccessResult result) {
        this.tagType = tagType;
        this.result = result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.toString(sb);
        return sb.toString();
    }

    public void toString(StringBuilder sb) {
        sb.append("RangerTagAuditEvent={");
        sb.append("tagType={").append(this.tagType).append("} ");
        sb.append("isAccessDetermined={").append(this.result.getIsAccessDetermined()).append("}");
        sb.append("isAllowed={").append(this.result.getIsAllowed()).append("}");
        sb.append("policyId={").append(this.result.getPolicyId()).append("}");
        sb.append("reason={").append(this.result.getReason()).append("}");
        sb.append("}");
    }

    static void processTagEvents(List<RangerTagAuditEvent> tagAuditEvents, boolean deniedAccess) {
        if (CollectionUtils.isEmpty(tagAuditEvents)) {
            return;
        }
        ArrayList<RangerTagAuditEvent> unwantedEvents = new ArrayList<RangerTagAuditEvent>();
        if (deniedAccess) {
            for (RangerTagAuditEvent auditEvent : tagAuditEvents) {
                RangerAccessResult result = auditEvent.result;
                if (!result.getIsAllowed()) continue;
                unwantedEvents.add(auditEvent);
            }
            tagAuditEvents.removeAll(unwantedEvents);
        }
    }
}

