/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.policyevaluator;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.policyengine.RangerAccessResource;
import org.apache.ranger.plugin.policyengine.RangerPolicyEngineOptions;
import org.apache.ranger.plugin.policyevaluator.RangerOptimizedPolicyEvaluator;
import org.apache.ranger.plugin.policyevaluator.RangerResourceAccessCache;
import org.apache.ranger.plugin.policyevaluator.RangerResourceAccessCacheImpl;

public class RangerCachedPolicyEvaluator
extends RangerOptimizedPolicyEvaluator {
    private static final Log LOG = LogFactory.getLog(RangerCachedPolicyEvaluator.class);
    private RangerResourceAccessCache cache = null;

    @Override
    public void init(RangerPolicy policy, RangerServiceDef serviceDef, RangerPolicyEngineOptions options) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerCachedPolicyEvaluator.init()");
        }
        super.init(policy, serviceDef, options);
        this.cache = RangerResourceAccessCacheImpl.getInstance(serviceDef, policy);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerCachedPolicyEvaluator.init()");
        }
    }

    @Override
    public boolean isMatch(RangerAccessResource resource) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerCachedPolicyEvaluator.isMatch(" + resource + ")"));
        }
        boolean result = false;
        RangerResourceAccessCache.LookupResult lookup = this.cache.lookup(resource);
        if (lookup != RangerResourceAccessCache.LookupResult.IN_NOTMATCHED_CACHE) {
            if (lookup != RangerResourceAccessCache.LookupResult.IN_MATCHED_CACHE) {
                result = super.isMatch(resource);
                if (result) {
                    this.cache.add(resource, RangerResourceAccessCache.CacheType.MATCHED_CACHE);
                } else {
                    this.cache.add(resource, RangerResourceAccessCache.CacheType.NOTMATCHED_CACHE);
                }
            } else {
                result = true;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerCachedPolicyEvaluator.isMatch(" + resource + "): " + result));
        }
        return result;
    }
}

