/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.resourcematcher;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ranger.plugin.resourcematcher.RangerAbstractResourceMatcher;

public class RangerPathResourceMatcher
extends RangerAbstractResourceMatcher {
    private static final Log LOG = LogFactory.getLog(RangerPathResourceMatcher.class);
    public static final String OPTION_PATH_SEPERATOR = "pathSeparatorChar";
    public static final char DEFAULT_PATH_SEPERATOR_CHAR = '/';
    private boolean policyIsRecursive = false;
    private char pathSeparatorChar = (char)47;
    private List<String> policyValuesForMatch = null;

    @Override
    public void init() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerPathResourceMatcher.init()");
        }
        super.init();
        this.policyIsRecursive = this.policyResource == null ? false : this.policyResource.getIsRecursive();
        this.pathSeparatorChar = this.getCharOption(OPTION_PATH_SEPERATOR, '/');
        if (this.policyIsRecursive && this.optWildCard && !this.isMatchAny) {
            this.policyValuesForMatch = new ArrayList<String>();
            for (String policyValue : this.policyValues) {
                if (policyValue.charAt(policyValue.length() - 1) == this.pathSeparatorChar) {
                    this.policyValuesForMatch.add(policyValue + "*");
                    continue;
                }
                this.policyValuesForMatch.add(policyValue);
            }
        } else {
            this.policyValuesForMatch = this.policyValues;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerPathResourceMatcher.init()");
        }
    }

    @Override
    public boolean isMatch(String resource) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerPathResourceMatcher.isMatch(" + resource + ")"));
        }
        boolean ret = false;
        boolean allValuesRequested = this.isAllValuesRequested(resource);
        if (allValuesRequested || this.isMatchAny) {
            ret = this.isMatchAny;
        } else {
            IOCase caseSensitivity = this.optIgnoreCase ? IOCase.INSENSITIVE : IOCase.SENSITIVE;
            for (String policyValue : this.policyValuesForMatch) {
                if (this.policyIsRecursive && this.optWildCard) {
                    ret = this.isRecursiveWildCardMatch(resource, policyValue, this.pathSeparatorChar, caseSensitivity);
                } else if (this.policyIsRecursive) {
                    ret = this.optIgnoreCase ? StringUtils.startsWithIgnoreCase((String)resource, (String)policyValue) : StringUtils.startsWith((String)resource, (String)policyValue);
                } else if (this.optWildCard) {
                    ret = FilenameUtils.wildcardMatch((String)resource, (String)policyValue, (IOCase)caseSensitivity);
                } else {
                    boolean bl = ret = this.optIgnoreCase ? StringUtils.equalsIgnoreCase((String)resource, (String)policyValue) : StringUtils.equals((String)resource, (String)policyValue);
                }
                if (!ret) continue;
                break;
            }
        }
        ret = this.applyExcludes(allValuesRequested, ret);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerPathResourceMatcher.isMatch(" + resource + "): " + ret));
        }
        return ret;
    }

    private boolean isRecursiveWildCardMatch(String pathToCheck, String wildcardPath, char pathSeparatorChar, IOCase caseSensitivity) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerPathResourceMatcher.isRecursiveWildCardMatch(" + pathToCheck + ", " + wildcardPath + ", " + pathSeparatorChar + ")"));
        }
        boolean ret = false;
        if (!StringUtils.isEmpty((String)pathToCheck)) {
            Object[] pathElements = StringUtils.split((String)pathToCheck, (char)pathSeparatorChar);
            if (!ArrayUtils.isEmpty((Object[])pathElements)) {
                StringBuilder sb = new StringBuilder();
                if (pathToCheck.charAt(0) == pathSeparatorChar) {
                    sb.append(pathSeparatorChar);
                }
                for (Object p : pathElements) {
                    sb.append((String)p);
                    ret = FilenameUtils.wildcardMatch((String)sb.toString(), (String)wildcardPath, (IOCase)caseSensitivity);
                    if (ret) break;
                    sb.append(pathSeparatorChar);
                }
                sb = null;
            } else {
                ret = FilenameUtils.wildcardMatch((String)pathToCheck, (String)wildcardPath, (IOCase)caseSensitivity);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerPathResourceMatcher.isRecursiveWildCardMatch(" + pathToCheck + ", " + wildcardPath + ", " + pathSeparatorChar + "): " + ret));
        }
        return ret;
    }

    @Override
    public StringBuilder toString(StringBuilder sb) {
        sb.append("RangerPathResourceMatcher={");
        super.toString(sb);
        sb.append("policyIsRecursive={").append(this.policyIsRecursive).append("} ");
        sb.append("}");
        return sb;
    }
}

