/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.store.file;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerService;
import org.apache.ranger.plugin.model.RangerServiceDef;

public class FileStoreUtil {
    private static final Log LOG = LogFactory.getLog(FileStoreUtil.class);
    private Gson gsonBuilder = null;
    private String dataDir = null;
    private static final String FILE_SUFFIX_JSON = ".json";

    public void initStore(String dataDir) {
        this.dataDir = dataDir;
        try {
            this.gsonBuilder = new GsonBuilder().setDateFormat("yyyyMMdd-HH:mm:ss.SSS-Z").setPrettyPrinting().create();
        }
        catch (Throwable excp) {
            LOG.fatal((Object)"FileStoreUtil.init(): failed to create GsonBuilder object", excp);
        }
    }

    public String getDataDir() {
        return this.dataDir;
    }

    public String getDataFile(String filePrefix, Long id) {
        String filePath = this.dataDir + "/" + filePrefix + id + FILE_SUFFIX_JSON;
        return filePath;
    }

    public String getDataFile(String filePrefix, Long parentId, Long objectId) {
        String filePath = this.dataDir + "/" + filePrefix + parentId + "-" + objectId + FILE_SUFFIX_JSON;
        return filePath;
    }

    public <T> T loadFromResource(String resource, Class<T> cls) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> FileStoreUtil.loadFromResource(" + resource + ")"));
        }
        InputStream inStream = this.getClass().getResourceAsStream(resource);
        T ret = this.loadFromStream(inStream, cls);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== FileStoreUtil.loadFromResource(" + resource + "): " + ret));
        }
        return ret;
    }

    public <T> T loadFromStream(InputStream inStream, Class<T> cls) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> FileStoreUtil.loadFromStream()");
        }
        InputStreamReader reader = new InputStreamReader(inStream);
        Object ret = this.gsonBuilder.fromJson((Reader)reader, cls);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== FileStoreUtil.loadFromStream(): " + ret));
        }
        return (T)ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T loadFromFile(Path filePath, Class<T> cls) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> FileStoreUtil.loadFromFile(" + filePath + ")"));
        }
        T ret = null;
        InputStreamReader reader = null;
        try {
            FileSystem fileSystem = this.getFileSystem(filePath);
            FSDataInputStream inStream = fileSystem.open(filePath);
            ret = this.loadFromStream((InputStream)inStream, cls);
        }
        finally {
            this.close(reader);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== FileStoreUtil.loadFromFile(" + filePath + "): " + ret));
        }
        return ret;
    }

    public <T> List<T> loadFromDir(Path dirPath, final String filePrefix, Class<T> cls) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> FileStoreUtil.loadFromDir()");
        }
        ArrayList<T> ret = new ArrayList<T>();
        try {
            FileSystem fileSystem = this.getFileSystem(dirPath);
            if (fileSystem.exists(dirPath) && fileSystem.isDirectory(dirPath)) {
                PathFilter filter = new PathFilter(){

                    public boolean accept(Path path) {
                        return path.getName().startsWith(filePrefix) && path.getName().endsWith(FileStoreUtil.FILE_SUFFIX_JSON);
                    }
                };
                FileStatus[] sdFiles = fileSystem.listStatus(dirPath, filter);
                if (sdFiles != null) {
                    for (FileStatus sdFile : sdFiles) {
                        T obj = this.loadFromFile(sdFile.getPath(), cls);
                        if (obj == null) continue;
                        ret.add(obj);
                    }
                }
            } else {
                LOG.error((Object)(dirPath + ": does not exists or not a directory"));
            }
        }
        catch (IOException excp) {
            LOG.warn((Object)("error loading service-def in directory " + dirPath), (Throwable)excp);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== FileStoreUtil.loadFromDir(): count=" + (ret == null ? 0 : ret.size())));
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T saveToFile(T obj, Path filePath, boolean overWrite) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> FileStoreUtil.saveToFile(" + filePath + ")"));
        }
        OutputStreamWriter writer = null;
        try {
            FileSystem fileSystem = this.getFileSystem(filePath);
            FSDataOutputStream outStream = fileSystem.create(filePath, overWrite);
            writer = new OutputStreamWriter((OutputStream)outStream);
            this.gsonBuilder.toJson(obj, (Appendable)writer);
            this.close(writer);
        }
        catch (Throwable throwable) {
            this.close(writer);
            throw throwable;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== FileStoreUtil.saveToFile(" + filePath + "): " + obj));
        }
        return obj;
    }

    public boolean deleteFile(Path filePath) throws Exception {
        LOG.debug((Object)("==> FileStoreUtil.deleteFile(" + filePath + ")"));
        FileSystem fileSystem = this.getFileSystem(filePath);
        boolean ret = false;
        ret = fileSystem.exists(filePath) ? fileSystem.delete(filePath, false) : true;
        LOG.debug((Object)("<== FileStoreUtil.deleteFile(" + filePath + "): " + ret));
        return ret;
    }

    public boolean renamePath(Path oldPath, Path newPath) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> FileStoreUtil.renamePath(" + oldPath + "," + newPath + ")"));
        }
        FileSystem fileSystem = this.getFileSystem(oldPath);
        boolean ret = false;
        if (fileSystem.exists(oldPath)) {
            if (!fileSystem.exists(newPath)) {
                ret = fileSystem.rename(oldPath, newPath);
            } else {
                LOG.warn((Object)("target of rename '" + newPath + "' already exists"));
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== FileStoreUtil.renamePath(" + oldPath + "," + newPath + "): " + ret));
        }
        return ret;
    }

    public RangerServiceDef saveToFile(RangerServiceDef serviceDef, String filePrefix, boolean overWrite) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> FileStoreUtil.saveToFile(" + serviceDef + "," + overWrite + ")"));
        }
        Path filePath = new Path(this.getDataFile(filePrefix, serviceDef.getId()));
        RangerServiceDef ret = this.saveToFile(serviceDef, filePath, overWrite);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== FileStoreUtil.saveToFile(" + serviceDef + "," + overWrite + "): "));
        }
        return ret;
    }

    public RangerService saveToFile(RangerService service, String filePrefix, boolean overWrite) throws Exception {
        Path filePath = new Path(this.getDataFile(filePrefix, service.getId()));
        RangerService ret = this.saveToFile(service, filePath, overWrite);
        return ret;
    }

    public RangerPolicy saveToFile(RangerPolicy policy, String filePrefix, long serviceId, boolean overWrite) throws Exception {
        Path filePath = new Path(this.getDataFile(filePrefix, serviceId, policy.getId()));
        RangerPolicy ret = this.saveToFile(policy, filePath, overWrite);
        return ret;
    }

    public FileSystem getFileSystem(Path filePath) throws Exception {
        Configuration conf = new Configuration();
        FileSystem fileSystem = filePath.getFileSystem(conf);
        return fileSystem;
    }

    protected void close(FileSystem fs) {
        if (fs != null) {
            try {
                fs.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected void close(InputStreamReader reader) {
        if (reader != null) {
            try {
                reader.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    protected void close(OutputStreamWriter writer) {
        if (writer != null) {
            try {
                writer.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

