/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ranger.plugin.util.RangerPerfTracer;

public class PerfDataRecorder {
    private static final Log LOG = LogFactory.getLog(PerfDataRecorder.class);
    private static final Log PERF = RangerPerfTracer.getPerfLogger(PerfDataRecorder.class);
    private static volatile PerfDataRecorder instance = null;
    private Map<String, PerfStatistic> perfStatistics = new HashMap<String, PerfStatistic>();
    private boolean initPerfStatisticsOnce = true;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void initialize(List<String> names) {
        if (instance != null) return;
        Class<PerfDataRecorder> clazz = PerfDataRecorder.class;
        synchronized (PerfDataRecorder.class) {
            if (instance != null) return;
            instance = new PerfDataRecorder(names);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static boolean collectStatistics() {
        return instance != null;
    }

    public static void printStatistics() {
        if (instance != null) {
            instance.dumpStatistics();
        }
    }

    public static void recordStatistic(String tag, long elapsedTime) {
        if (instance != null) {
            instance.record(tag, elapsedTime);
        }
    }

    private void dumpStatistics() {
        ArrayList<String> tags = new ArrayList<String>(this.perfStatistics.keySet());
        Collections.sort(tags);
        for (String tag : tags) {
            PerfStatistic perfStatistic = this.perfStatistics.get(tag);
            long averageTimeSpent = 0L;
            long minTimeSpent = 0L;
            long maxTimeSpent = 0L;
            if (perfStatistic.numberOfInvocations.get() != 0L) {
                averageTimeSpent = perfStatistic.millisecondsSpent.get() / perfStatistic.numberOfInvocations.get();
                minTimeSpent = perfStatistic.minTimeSpent.get();
                maxTimeSpent = perfStatistic.maxTimeSpent.get();
            }
            String logMsg = "[" + tag + "]" + " execCount:" + perfStatistic.numberOfInvocations + ", totalTimeTaken:" + perfStatistic.millisecondsSpent + ", maxTimeTaken:" + maxTimeSpent + ", minTimeTaken:" + minTimeSpent + ", avgTimeTaken:" + averageTimeSpent;
            LOG.info((Object)logMsg);
            PERF.debug((Object)logMsg);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void record(String tag, long elapsedTime) {
        PerfStatistic perfStatistic = this.perfStatistics.get(tag);
        if (perfStatistic == null && !this.initPerfStatisticsOnce) {
            Class<PerfDataRecorder> clazz = PerfDataRecorder.class;
            // MONITORENTER : org.apache.ranger.plugin.util.PerfDataRecorder.class
            perfStatistic = this.perfStatistics.get(tag);
            if (perfStatistic == null) {
                perfStatistic = new PerfStatistic();
                this.perfStatistics.put(tag, perfStatistic);
            }
            // MONITOREXIT : clazz
        }
        if (perfStatistic == null) return;
        perfStatistic.addPerfDataItem(elapsedTime);
    }

    private PerfDataRecorder(List<String> names) {
        if (CollectionUtils.isNotEmpty(names)) {
            for (String name : names) {
                this.perfStatistics.put(name, new PerfStatistic());
            }
        } else {
            this.initPerfStatisticsOnce = false;
        }
    }

    private static class PerfStatistic {
        private AtomicLong numberOfInvocations = new AtomicLong(0L);
        private AtomicLong millisecondsSpent = new AtomicLong(0L);
        private AtomicLong minTimeSpent = new AtomicLong(Long.MAX_VALUE);
        private AtomicLong maxTimeSpent = new AtomicLong(Long.MIN_VALUE);

        private PerfStatistic() {
        }

        void addPerfDataItem(long timeTaken) {
            long max;
            this.numberOfInvocations.getAndIncrement();
            this.millisecondsSpent.getAndAdd(timeTaken);
            long min = this.minTimeSpent.get();
            if (timeTaken < min) {
                this.minTimeSpent.compareAndSet(min, timeTaken);
            }
            if (timeTaken > (max = this.maxTimeSpent.get())) {
                this.maxTimeSpent.compareAndSet(max, timeTaken);
            }
        }
    }
}

