/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.policyengine;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ranger.plugin.policyengine.RangerPolicyEngine;
import org.apache.ranger.plugin.policyengine.RangerPolicyEngineImpl;
import org.apache.ranger.plugin.policyengine.RangerPolicyEngineOptions;
import org.apache.ranger.plugin.store.ServiceStore;
import org.apache.ranger.plugin.util.ServicePolicies;

public class RangerPolicyEngineCache {
    private static final Log LOG = LogFactory.getLog(RangerPolicyEngineCache.class);
    private static final RangerPolicyEngineCache sInstance = new RangerPolicyEngineCache();
    private final Map<String, RangerPolicyEngine> policyEngineCache = Collections.synchronizedMap(new HashMap());
    private RangerPolicyEngineOptions options = null;

    public static RangerPolicyEngineCache getInstance() {
        return sInstance;
    }

    public RangerPolicyEngine getPolicyEngine(String serviceName, ServiceStore svcStore) {
        RangerPolicyEngine ret = null;
        if (serviceName != null) {
            long policyVersion;
            ret = this.policyEngineCache.get(serviceName);
            long l = policyVersion = ret != null ? ret.getPolicyVersion() : -1L;
            if (svcStore != null) {
                try {
                    ServicePolicies policies = svcStore.getServicePoliciesIfUpdated(serviceName, policyVersion);
                    if (policies != null) {
                        if (ret == null) {
                            ret = this.addPolicyEngine(policies);
                        } else if (policies.getPolicyVersion() != null && !policies.getPolicyVersion().equals(policyVersion)) {
                            ret = this.addPolicyEngine(policies);
                        }
                    }
                }
                catch (Exception excp) {
                    LOG.error((Object)("getPolicyEngine(" + serviceName + "): failed to get latest policies from service-store"), (Throwable)excp);
                }
            }
        }
        return ret;
    }

    public RangerPolicyEngineOptions getPolicyEngineOptions() {
        return this.options;
    }

    public void setPolicyEngineOptions(RangerPolicyEngineOptions options) {
        this.options = options;
    }

    private RangerPolicyEngine addPolicyEngine(ServicePolicies policies) {
        RangerPolicyEngineImpl ret = new RangerPolicyEngineImpl("ranger-admin", policies, this.options);
        this.policyEngineCache.put(policies.getServiceName(), ret);
        return ret;
    }
}

