/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.policyevaluator;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerPolicyEngineOptions;
import org.apache.ranger.plugin.policyevaluator.RangerPolicyEvaluator;

public abstract class RangerAbstractPolicyEvaluator
implements RangerPolicyEvaluator {
    private static final Log LOG = LogFactory.getLog(RangerAbstractPolicyEvaluator.class);
    private RangerPolicy policy = null;
    private RangerServiceDef serviceDef = null;
    private int evalOrder = 0;

    @Override
    public void init(RangerPolicy policy, RangerServiceDef serviceDef, RangerPolicyEngineOptions options) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerAbstractPolicyEvaluator.init(" + policy + ", " + serviceDef + ")"));
        }
        this.policy = policy;
        this.serviceDef = serviceDef;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerAbstractPolicyEvaluator.init(" + policy + ", " + serviceDef + ")"));
        }
    }

    @Override
    public RangerPolicy getPolicy() {
        return this.policy;
    }

    @Override
    public RangerServiceDef getServiceDef() {
        return this.serviceDef;
    }

    @Override
    public boolean hasAllow() {
        return this.policy != null && CollectionUtils.isNotEmpty(this.policy.getPolicyItems());
    }

    protected boolean hasMatchablePolicyItem(RangerAccessRequest request) {
        return this.hasAllow() || this.hasDeny();
    }

    @Override
    public boolean hasDeny() {
        return this.policy != null && CollectionUtils.isNotEmpty(this.policy.getDenyPolicyItems());
    }

    @Override
    public int getEvalOrder() {
        return this.evalOrder;
    }

    @Override
    public boolean isAuditEnabled() {
        return this.policy != null && this.policy.getIsAuditEnabled() != false;
    }

    @Override
    public int compareTo(RangerPolicyEvaluator other) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAbstractPolicyEvaluator.compareTo()");
        }
        int result = Integer.compare(this.getEvalOrder(), other.getEvalOrder());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerAbstractPolicyEvaluator.compareTo(), result:" + result));
        }
        return result;
    }

    public void setEvalOrder(int evalOrder) {
        this.evalOrder = evalOrder;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.toString(sb);
        return sb.toString();
    }

    public StringBuilder toString(StringBuilder sb) {
        sb.append("RangerAbstractPolicyEvaluator={");
        sb.append("policy={").append(this.policy).append("} ");
        sb.append("serviceDef={").append(this.serviceDef).append("} ");
        sb.append("}");
        return sb;
    }
}

