/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.policyevaluator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerAccessResource;
import org.apache.ranger.plugin.policyengine.RangerAccessResult;
import org.apache.ranger.plugin.policyengine.RangerDataMaskResult;
import org.apache.ranger.plugin.policyengine.RangerPolicyEngineOptions;
import org.apache.ranger.plugin.policyengine.RangerResourceAccessInfo;
import org.apache.ranger.plugin.policyengine.RangerRowFilterResult;
import org.apache.ranger.plugin.policyevaluator.RangerAbstractPolicyEvaluator;
import org.apache.ranger.plugin.policyevaluator.RangerDataMaskPolicyItemEvaluator;
import org.apache.ranger.plugin.policyevaluator.RangerDefaultDataMaskPolicyItemEvaluator;
import org.apache.ranger.plugin.policyevaluator.RangerDefaultPolicyItemEvaluator;
import org.apache.ranger.plugin.policyevaluator.RangerDefaultRowFilterPolicyItemEvaluator;
import org.apache.ranger.plugin.policyevaluator.RangerPolicyItemEvaluator;
import org.apache.ranger.plugin.policyevaluator.RangerRowFilterPolicyItemEvaluator;
import org.apache.ranger.plugin.policyresourcematcher.RangerDefaultPolicyResourceMatcher;
import org.apache.ranger.plugin.policyresourcematcher.RangerPolicyResourceMatcher;
import org.apache.ranger.plugin.util.RangerPerfTracer;
import org.apache.ranger.plugin.util.ServiceDefUtil;

public class RangerDefaultPolicyEvaluator
extends RangerAbstractPolicyEvaluator {
    private static final Log LOG = LogFactory.getLog(RangerDefaultPolicyEvaluator.class);
    private static final Log PERF_POLICY_INIT_LOG = RangerPerfTracer.getPerfLogger("policy.init");
    private static final Log PERF_POLICY_REQUEST_LOG = RangerPerfTracer.getPerfLogger("policy.request");
    private RangerPolicyResourceMatcher resourceMatcher = null;
    private List<RangerPolicyItemEvaluator> allowEvaluators = null;
    private List<RangerPolicyItemEvaluator> denyEvaluators = null;
    private List<RangerPolicyItemEvaluator> allowExceptionEvaluators = null;
    private List<RangerPolicyItemEvaluator> denyExceptionEvaluators = null;
    private int customConditionsCount = 0;
    private List<RangerDataMaskPolicyItemEvaluator> dataMaskEvaluators = null;
    private List<RangerRowFilterPolicyItemEvaluator> rowFilterEvaluators = null;
    private String perfTag;

    @Override
    public int getCustomConditionsCount() {
        return this.customConditionsCount;
    }

    @Override
    public void init(RangerPolicy policy, RangerServiceDef serviceDef, RangerPolicyEngineOptions options) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerDefaultPolicyEvaluator.init()");
        }
        StringBuilder perfTagBuffer = new StringBuilder();
        if (policy != null) {
            perfTagBuffer.append("policyId=").append(policy.getId()).append(", policyName=").append(policy.getName());
        }
        this.perfTag = perfTagBuffer.toString();
        RangerPerfTracer perf = null;
        if (RangerPerfTracer.isPerfTraceEnabled(PERF_POLICY_INIT_LOG)) {
            perf = RangerPerfTracer.getPerfTracer(PERF_POLICY_INIT_LOG, "RangerPolicyEvaluator.init(" + this.perfTag + ")");
        }
        super.init(policy, serviceDef, options);
        this.preprocessPolicy(policy, serviceDef);
        this.resourceMatcher = new RangerDefaultPolicyResourceMatcher();
        this.resourceMatcher.setServiceDef(serviceDef);
        this.resourceMatcher.setPolicy(policy);
        this.resourceMatcher.init();
        if (policy != null) {
            this.allowEvaluators = this.createPolicyItemEvaluators(policy, serviceDef, options, 0);
            this.denyEvaluators = this.createPolicyItemEvaluators(policy, serviceDef, options, 1);
            this.allowExceptionEvaluators = this.createPolicyItemEvaluators(policy, serviceDef, options, 2);
            this.denyExceptionEvaluators = this.createPolicyItemEvaluators(policy, serviceDef, options, 3);
            this.dataMaskEvaluators = this.createDataMaskPolicyItemEvaluators(policy, serviceDef, options, policy.getDataMaskPolicyItems());
            this.rowFilterEvaluators = this.createRowFilterPolicyItemEvaluators(policy, serviceDef, options, policy.getRowFilterPolicyItems());
        } else {
            this.allowEvaluators = Collections.emptyList();
            this.denyEvaluators = Collections.emptyList();
            this.allowExceptionEvaluators = Collections.emptyList();
            this.denyExceptionEvaluators = Collections.emptyList();
            this.dataMaskEvaluators = Collections.emptyList();
            this.rowFilterEvaluators = Collections.emptyList();
        }
        Collections.sort(this.allowEvaluators);
        Collections.sort(this.denyEvaluators);
        Collections.sort(this.allowExceptionEvaluators);
        Collections.sort(this.denyExceptionEvaluators);
        RangerPerfTracer.log(perf);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerDefaultPolicyEvaluator.init()");
        }
    }

    @Override
    public void evaluate(RangerAccessRequest request, RangerAccessResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerDefaultPolicyEvaluator.evaluate(" + request + ", " + result + ")"));
        }
        RangerPerfTracer perf = null;
        if (RangerPerfTracer.isPerfTraceEnabled(PERF_POLICY_REQUEST_LOG)) {
            perf = RangerPerfTracer.getPerfTracer(PERF_POLICY_REQUEST_LOG, "RangerPolicyEvaluator.evaluate(requestHashCode=" + Integer.toHexString(System.identityHashCode(request)) + "," + this.perfTag + ")");
        }
        if (request != null && result != null) {
            boolean attemptResourceHeadMatch;
            boolean isResourceMatch = false;
            boolean isResourceHeadMatch = false;
            boolean isResourceMatchAttempted = false;
            boolean isResourceHeadMatchAttempted = false;
            boolean bl = attemptResourceHeadMatch = request.isAccessTypeAny() || request.getResourceMatchingScope() == RangerAccessRequest.ResourceMatchingScope.SELF_OR_DESCENDANTS;
            if (!result.getIsAuditedDetermined()) {
                if (!isResourceMatchAttempted) {
                    isResourceMatch = this.isMatch(request.getResource());
                    isResourceMatchAttempted = true;
                }
                if (!isResourceMatch && attemptResourceHeadMatch && !isResourceHeadMatchAttempted) {
                    isResourceHeadMatch = this.matchResourceHead(request.getResource());
                    isResourceHeadMatchAttempted = true;
                }
                if ((isResourceMatch || isResourceHeadMatch) && this.isAuditEnabled()) {
                    result.setIsAudited(true);
                }
            }
            if (!result.getIsAccessDetermined() && this.hasMatchablePolicyItem(request)) {
                if (!isResourceMatchAttempted) {
                    isResourceMatch = this.isMatch(request.getResource());
                    isResourceMatchAttempted = true;
                }
                if (!isResourceMatch && attemptResourceHeadMatch && !isResourceHeadMatchAttempted) {
                    isResourceHeadMatch = this.matchResourceHead(request.getResource());
                    isResourceHeadMatchAttempted = true;
                }
                if (isResourceMatch || isResourceHeadMatch) {
                    this.evaluatePolicyItems(request, result, isResourceMatch);
                }
            }
        }
        RangerPerfTracer.log(perf);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerDefaultPolicyEvaluator.evaluate(" + request + ", " + result + ")"));
        }
    }

    @Override
    public void evaluate(RangerAccessRequest request, RangerDataMaskResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerDefaultPolicyEvaluator.evaluate(" + request + ", " + result + ")"));
        }
        RangerPerfTracer perf = null;
        if (RangerPerfTracer.isPerfTraceEnabled(PERF_POLICY_REQUEST_LOG)) {
            perf = RangerPerfTracer.getPerfTracer(PERF_POLICY_REQUEST_LOG, "RangerPolicyEvaluator.evaluate(requestHashCode=" + Integer.toHexString(System.identityHashCode(request)) + "," + this.perfTag + ")");
        }
        if (request != null && result != null && CollectionUtils.isNotEmpty(this.dataMaskEvaluators)) {
            boolean attemptResourceHeadMatch;
            boolean isResourceMatchAttempted = false;
            boolean isResourceMatch = false;
            boolean isResourceHeadMatch = false;
            boolean isResourceHeadMatchAttempted = false;
            boolean bl = attemptResourceHeadMatch = request.isAccessTypeAny() || request.getResourceMatchingScope() == RangerAccessRequest.ResourceMatchingScope.SELF_OR_DESCENDANTS;
            if (!result.getIsAuditedDetermined()) {
                if (!isResourceMatchAttempted) {
                    isResourceMatch = this.isMatch(request.getResource());
                    isResourceMatchAttempted = true;
                }
                if (!isResourceMatch && attemptResourceHeadMatch && !isResourceHeadMatchAttempted) {
                    isResourceHeadMatch = this.matchResourceHead(request.getResource());
                    isResourceHeadMatchAttempted = true;
                }
                if ((isResourceMatch || isResourceHeadMatch) && this.isAuditEnabled()) {
                    result.setIsAudited(true);
                }
            }
            if (!result.getIsAccessDetermined()) {
                if (!isResourceMatchAttempted) {
                    isResourceMatch = this.isMatch(request.getResource());
                    isResourceMatchAttempted = true;
                }
                if (!isResourceMatch && attemptResourceHeadMatch && !isResourceHeadMatchAttempted) {
                    isResourceHeadMatch = this.matchResourceHead(request.getResource());
                    isResourceHeadMatchAttempted = true;
                }
                if (isResourceMatch || isResourceHeadMatch) {
                    this.evaluatePolicyItems(request, result);
                }
            }
        }
        RangerPerfTracer.log(perf);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerDefaultPolicyEvaluator.evaluate(" + request + ", " + result + ")"));
        }
    }

    @Override
    public void evaluate(RangerAccessRequest request, RangerRowFilterResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerDefaultPolicyEvaluator.evaluate(" + request + ", " + result + ")"));
        }
        RangerPerfTracer perf = null;
        if (RangerPerfTracer.isPerfTraceEnabled(PERF_POLICY_REQUEST_LOG)) {
            perf = RangerPerfTracer.getPerfTracer(PERF_POLICY_REQUEST_LOG, "RangerPolicyEvaluator.evaluate(requestHashCode=" + Integer.toHexString(System.identityHashCode(request)) + "," + this.perfTag + ")");
        }
        if (request != null && result != null && CollectionUtils.isNotEmpty(this.rowFilterEvaluators)) {
            boolean attemptResourceHeadMatch;
            boolean isResourceMatchAttempted = false;
            boolean isResourceMatch = false;
            boolean isResourceHeadMatch = false;
            boolean isResourceHeadMatchAttempted = false;
            boolean bl = attemptResourceHeadMatch = request.isAccessTypeAny() || request.getResourceMatchingScope() == RangerAccessRequest.ResourceMatchingScope.SELF_OR_DESCENDANTS;
            if (!result.getIsAuditedDetermined()) {
                if (!isResourceMatchAttempted) {
                    isResourceMatch = this.isMatch(request.getResource());
                    isResourceMatchAttempted = true;
                }
                if (!isResourceMatch && attemptResourceHeadMatch && !isResourceHeadMatchAttempted) {
                    isResourceHeadMatch = this.matchResourceHead(request.getResource());
                    isResourceHeadMatchAttempted = true;
                }
                if ((isResourceMatch || isResourceHeadMatch) && this.isAuditEnabled()) {
                    result.setIsAudited(true);
                }
            }
            if (!result.getIsAccessDetermined()) {
                if (!isResourceMatchAttempted) {
                    isResourceMatch = this.isMatch(request.getResource());
                    isResourceMatchAttempted = true;
                }
                if (!isResourceMatch && attemptResourceHeadMatch && !isResourceHeadMatchAttempted) {
                    isResourceHeadMatch = this.matchResourceHead(request.getResource());
                    isResourceHeadMatchAttempted = true;
                }
                if (isResourceMatch || isResourceHeadMatch) {
                    this.evaluatePolicyItems(request, result);
                }
            }
        }
        RangerPerfTracer.log(perf);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerDefaultPolicyEvaluator.evaluate(" + request + ", " + result + ")"));
        }
    }

    @Override
    public boolean isMatch(RangerAccessResource resource) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerDefaultPolicyEvaluator.isMatch(" + resource + ")"));
        }
        boolean ret = false;
        RangerPerfTracer perf = null;
        if (RangerPerfTracer.isPerfTraceEnabled(PERF_POLICY_REQUEST_LOG)) {
            perf = RangerPerfTracer.getPerfTracer(PERF_POLICY_REQUEST_LOG, "RangerPolicyEvaluator.isMatch(resource=" + resource.getAsString() + "," + this.perfTag + ")");
        }
        if (this.resourceMatcher != null) {
            ret = this.resourceMatcher.isMatch(resource);
        }
        RangerPerfTracer.log(perf);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerDefaultPolicyEvaluator.isMatch(" + resource + "): " + ret));
        }
        return ret;
    }

    @Override
    public boolean isCompleteMatch(RangerAccessResource resource) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerDefaultPolicyEvaluator.isCompleteMatch(" + resource + ")"));
        }
        boolean ret = false;
        if (this.resourceMatcher != null) {
            ret = this.resourceMatcher.isCompleteMatch(resource);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerDefaultPolicyEvaluator.isCompleteMatch(" + resource + "): " + ret));
        }
        return ret;
    }

    @Override
    public boolean isCompleteMatch(Map<String, RangerPolicy.RangerPolicyResource> resources) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerDefaultPolicyEvaluator.isCompleteMatch(" + resources + ")"));
        }
        boolean ret = false;
        if (this.resourceMatcher != null) {
            ret = this.resourceMatcher.isCompleteMatch(resources);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerDefaultPolicyEvaluator.isCompleteMatch(" + resources + "): " + ret));
        }
        return ret;
    }

    @Override
    public boolean isAccessAllowed(RangerAccessResource resource, String user, Set<String> userGroups, String accessType) {
        boolean ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerDefaultPolicyEvaluator.isAccessAllowed(" + resource + ", " + user + ", " + userGroups + ", " + accessType + ")"));
        }
        boolean bl = ret = this.isAccessAllowed(user, userGroups, accessType) && this.isMatch(resource);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerDefaultPolicyEvaluator.isAccessAllowed(" + resource + ", " + user + ", " + userGroups + ", " + accessType + "): " + ret));
        }
        return ret;
    }

    @Override
    public boolean isAccessAllowed(Map<String, RangerPolicy.RangerPolicyResource> resources, String user, Set<String> userGroups, String accessType) {
        boolean ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerDefaultPolicyEvaluator.isAccessAllowed(" + resources + ", " + user + ", " + userGroups + ", " + accessType + ")"));
        }
        boolean bl = ret = this.isAccessAllowed(user, userGroups, accessType) && this.isMatch(resources);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerDefaultPolicyEvaluator.isAccessAllowed(" + resources + ", " + user + ", " + userGroups + ", " + accessType + "): " + ret));
        }
        return ret;
    }

    @Override
    public void getResourceAccessInfo(RangerAccessRequest request, RangerResourceAccessInfo result) {
        HashSet<String> exceptionGroups;
        HashSet<String> exceptionUsers;
        HashSet<String> groups;
        HashSet<String> users;
        boolean isResourceHeadMatch;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerDefaultPolicyEvaluator.getResourceAccessInfo(" + request + ", " + result + ")"));
        }
        boolean isResourceMatch = this.isMatch(request.getResource());
        boolean attemptResourceHeadMatch = request.isAccessTypeAny() || request.getResourceMatchingScope() == RangerAccessRequest.ResourceMatchingScope.SELF_OR_DESCENDANTS;
        boolean bl = isResourceHeadMatch = !isResourceMatch && attemptResourceHeadMatch ? this.matchResourceHead(request.getResource()) : false;
        if ((isResourceMatch || isResourceHeadMatch) && CollectionUtils.isNotEmpty(this.allowEvaluators)) {
            users = new HashSet<String>();
            groups = new HashSet<String>();
            this.getResourceAccessInfo(request, this.allowEvaluators, users, groups);
            if (CollectionUtils.isNotEmpty(this.allowExceptionEvaluators)) {
                exceptionUsers = new HashSet<String>();
                exceptionGroups = new HashSet<String>();
                this.getResourceAccessInfo(request, this.allowExceptionEvaluators, exceptionUsers, exceptionGroups);
                users.removeAll(exceptionUsers);
                groups.removeAll(exceptionGroups);
            }
            result.getAllowedUsers().addAll(users);
            result.getAllowedGroups().addAll(groups);
        }
        if (isResourceMatch && CollectionUtils.isNotEmpty(this.denyEvaluators)) {
            users = new HashSet();
            groups = new HashSet();
            this.getResourceAccessInfo(request, this.denyEvaluators, users, groups);
            if (CollectionUtils.isNotEmpty(this.denyExceptionEvaluators)) {
                exceptionUsers = new HashSet();
                exceptionGroups = new HashSet();
                this.getResourceAccessInfo(request, this.denyExceptionEvaluators, exceptionUsers, exceptionGroups);
                users.removeAll(exceptionUsers);
                groups.removeAll(exceptionGroups);
            }
            result.getDeniedUsers().addAll(users);
            result.getDeniedGroups().addAll(groups);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerDefaultPolicyEvaluator.getResourceAccessInfo(" + request + ", " + result + ")"));
        }
    }

    protected void evaluatePolicyItems(RangerAccessRequest request, RangerAccessResult result, boolean isResourceMatch) {
        RangerPolicyItemEvaluator matchedPolicyItem;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerDefaultPolicyEvaluator.evaluatePolicyItems(" + request + ", " + result + ", " + isResourceMatch + ")"));
        }
        if ((matchedPolicyItem = this.getMatchingPolicyItem(request, this.denyEvaluators, this.denyExceptionEvaluators)) == null && !result.getIsAllowed()) {
            matchedPolicyItem = this.getMatchingPolicyItem(request, this.allowEvaluators, this.allowExceptionEvaluators);
        }
        if (matchedPolicyItem != null) {
            RangerPolicy policy = this.getPolicy();
            if (matchedPolicyItem.getPolicyItemType() == 1) {
                if (isResourceMatch) {
                    result.setIsAllowed(false);
                    result.setPolicyId(policy.getId());
                    result.setReason(matchedPolicyItem.getComments());
                }
            } else if (!result.getIsAllowed()) {
                result.setIsAllowed(true);
                result.setPolicyId(policy.getId());
                result.setReason(matchedPolicyItem.getComments());
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerDefaultPolicyEvaluator.evaluatePolicyItems(" + request + ", " + result + ", " + isResourceMatch + ")"));
        }
    }

    protected void evaluatePolicyItems(RangerAccessRequest request, RangerDataMaskResult result) {
        RangerDataMaskPolicyItemEvaluator matchedPolicyItem;
        RangerPolicy.RangerPolicyItemDataMaskInfo dataMaskInfo;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerDefaultPolicyEvaluator.evaluatePolicyItems(" + request + ", " + result + ")"));
        }
        RangerPolicy.RangerPolicyItemDataMaskInfo rangerPolicyItemDataMaskInfo = dataMaskInfo = (matchedPolicyItem = this.getMatchingPolicyItem(request, this.dataMaskEvaluators)) != null ? matchedPolicyItem.getDataMaskInfo() : null;
        if (dataMaskInfo != null) {
            RangerPolicy policy = this.getPolicy();
            result.setIsAllowed(true);
            result.setIsAccessDetermined(true);
            result.setMaskType(dataMaskInfo.getDataMaskType());
            result.setMaskCondition(dataMaskInfo.getConditionExpr());
            result.setMaskedValue(dataMaskInfo.getValueExpr());
            result.setPolicyId(policy.getId());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerDefaultPolicyEvaluator.evaluatePolicyItems(" + request + ", " + result + ", " + ")"));
        }
    }

    protected void evaluatePolicyItems(RangerAccessRequest request, RangerRowFilterResult result) {
        RangerRowFilterPolicyItemEvaluator matchedPolicyItem;
        RangerPolicy.RangerPolicyItemRowFilterInfo rowFilterInfo;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerDefaultPolicyEvaluator.evaluatePolicyItems(" + request + ", " + result + ")"));
        }
        RangerPolicy.RangerPolicyItemRowFilterInfo rangerPolicyItemRowFilterInfo = rowFilterInfo = (matchedPolicyItem = this.getMatchingPolicyItem(request, this.rowFilterEvaluators)) != null ? matchedPolicyItem.getRowFilterInfo() : null;
        if (rowFilterInfo != null) {
            RangerPolicy policy = this.getPolicy();
            result.setIsAllowed(true);
            result.setIsAccessDetermined(true);
            result.setFilterExpr(rowFilterInfo.getFilterExpr());
            result.setPolicyId(policy.getId());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerDefaultPolicyEvaluator.evaluatePolicyItems(" + request + ", " + result + ", " + ")"));
        }
    }

    protected RangerPolicyItemEvaluator getDeterminingPolicyItem(String user, Set<String> userGroups, String accessType) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerDefaultPolicyEvaluator.getDeterminingPolicyItem(" + user + ", " + userGroups + ", " + accessType + ")"));
        }
        RangerPolicyItemEvaluator ret = null;
        ret = this.getMatchingPolicyItem(user, userGroups, accessType, this.denyEvaluators, this.denyExceptionEvaluators);
        if (ret == null) {
            ret = this.getMatchingPolicyItem(user, userGroups, accessType, this.allowEvaluators, this.allowExceptionEvaluators);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerDefaultPolicyEvaluator.getDeterminingPolicyItem(" + user + ", " + userGroups + ", " + accessType + "): " + ret));
        }
        return ret;
    }

    private void getResourceAccessInfo(RangerAccessRequest request, List<? extends RangerPolicyItemEvaluator> policyItems, Set<String> users, Set<String> groups) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerDefaultPolicyEvaluator.getResourceAccessInfo(" + request + ", " + policyItems + ", " + users + ", " + groups + ")"));
        }
        if (CollectionUtils.isNotEmpty(policyItems)) {
            for (RangerPolicyItemEvaluator rangerPolicyItemEvaluator : policyItems) {
                if (!rangerPolicyItemEvaluator.matchAccessType(request.getAccessType()) || !rangerPolicyItemEvaluator.matchCustomConditions(request)) continue;
                if (CollectionUtils.isNotEmpty(rangerPolicyItemEvaluator.getPolicyItem().getUsers())) {
                    users.addAll(rangerPolicyItemEvaluator.getPolicyItem().getUsers());
                }
                if (!CollectionUtils.isNotEmpty(rangerPolicyItemEvaluator.getPolicyItem().getGroups())) continue;
                groups.addAll(rangerPolicyItemEvaluator.getPolicyItem().getGroups());
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerDefaultPolicyEvaluator.getResourceAccessInfo(" + request + ", " + policyItems + ", " + users + ", " + groups + ")"));
        }
    }

    protected boolean matchResourceHead(RangerAccessResource resource) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerDefaultPolicyEvaluator.matchResourceHead(" + resource + ")"));
        }
        boolean ret = false;
        if (this.resourceMatcher != null) {
            ret = this.resourceMatcher.isHeadMatch(resource);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerDefaultPolicyEvaluator.matchResourceHead(" + resource + "): " + ret));
        }
        return ret;
    }

    protected boolean isMatch(Map<String, RangerPolicy.RangerPolicyResource> resources) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerDefaultPolicyEvaluator.isMatch(" + resources + ")"));
        }
        boolean ret = false;
        if (this.resourceMatcher != null) {
            ret = this.resourceMatcher.isMatch(resources);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerDefaultPolicyEvaluator.isMatch(" + resources + "): " + ret));
        }
        return ret;
    }

    protected boolean isAccessAllowed(String user, Set<String> userGroups, String accessType) {
        RangerPolicyItemEvaluator item;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerDefaultPolicyEvaluator.isAccessAllowed(" + user + ", " + userGroups + ", " + accessType + ")"));
        }
        boolean ret = false;
        RangerPerfTracer perf = null;
        if (RangerPerfTracer.isPerfTraceEnabled(PERF_POLICY_REQUEST_LOG)) {
            perf = RangerPerfTracer.getPerfTracer(PERF_POLICY_REQUEST_LOG, "RangerPolicyEvaluator.isAccessAllowed(hashCode=" + Integer.toHexString(System.identityHashCode(this)) + "," + this.perfTag + ")");
        }
        if ((item = this.getDeterminingPolicyItem(user, userGroups, accessType)) != null && item.getPolicyItemType() == 0) {
            ret = true;
        }
        RangerPerfTracer.log(perf);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerDefaultPolicyEvaluator.isAccessAllowed(" + user + ", " + userGroups + ", " + accessType + "): " + ret));
        }
        return ret;
    }

    @Override
    public StringBuilder toString(StringBuilder sb) {
        sb.append("RangerDefaultPolicyEvaluator={");
        super.toString(sb);
        sb.append("resourceMatcher={");
        if (this.resourceMatcher != null) {
            this.resourceMatcher.toString(sb);
        }
        sb.append("} ");
        sb.append("}");
        return sb;
    }

    private void preprocessPolicy(RangerPolicy policy, RangerServiceDef serviceDef) {
        if (policy == null || !this.hasAllow() && !this.hasDeny() || serviceDef == null) {
            return;
        }
        Map<String, Collection<String>> impliedAccessGrants = this.getImpliedAccessGrants(serviceDef);
        if (impliedAccessGrants == null || impliedAccessGrants.isEmpty()) {
            return;
        }
        this.preprocessPolicyItems(policy.getPolicyItems(), impliedAccessGrants);
        this.preprocessPolicyItems(policy.getDenyPolicyItems(), impliedAccessGrants);
        this.preprocessPolicyItems(policy.getAllowExceptions(), impliedAccessGrants);
        this.preprocessPolicyItems(policy.getDenyExceptions(), impliedAccessGrants);
        this.preprocessPolicyItems(policy.getDataMaskPolicyItems(), impliedAccessGrants);
    }

    private void preprocessPolicyItems(List<? extends RangerPolicy.RangerPolicyItem> policyItems, Map<String, Collection<String>> impliedAccessGrants) {
        for (RangerPolicy.RangerPolicyItem rangerPolicyItem : policyItems) {
            if (CollectionUtils.isEmpty(rangerPolicyItem.getAccesses())) continue;
            for (Map.Entry<String, Collection<String>> e : impliedAccessGrants.entrySet()) {
                String accessType = e.getKey();
                Collection<String> impliedGrants = e.getValue();
                RangerPolicy.RangerPolicyItemAccess access = this.getAccess(rangerPolicyItem, accessType);
                if (access == null) continue;
                for (String impliedGrant : impliedGrants) {
                    RangerPolicy.RangerPolicyItemAccess impliedAccess = this.getAccess(rangerPolicyItem, impliedGrant);
                    if (impliedAccess == null) {
                        impliedAccess = new RangerPolicy.RangerPolicyItemAccess(impliedGrant, access.getIsAllowed());
                        rangerPolicyItem.getAccesses().add(impliedAccess);
                        continue;
                    }
                    if (impliedAccess.getIsAllowed().booleanValue()) continue;
                    impliedAccess.setIsAllowed(access.getIsAllowed());
                }
            }
        }
    }

    private Map<String, Collection<String>> getImpliedAccessGrants(RangerServiceDef serviceDef) {
        HashMap ret = null;
        if (serviceDef != null && !CollectionUtils.isEmpty(serviceDef.getAccessTypes())) {
            for (RangerServiceDef.RangerAccessTypeDef accessTypeDef : serviceDef.getAccessTypes()) {
                HashSet<String> impliedAccessGrants;
                if (CollectionUtils.isEmpty(accessTypeDef.getImpliedGrants())) continue;
                if (ret == null) {
                    ret = new HashMap();
                }
                if ((impliedAccessGrants = (HashSet<String>)ret.get(accessTypeDef.getName())) == null) {
                    impliedAccessGrants = new HashSet<String>();
                    ret.put(accessTypeDef.getName(), impliedAccessGrants);
                }
                for (String impliedAccessGrant : accessTypeDef.getImpliedGrants()) {
                    impliedAccessGrants.add(impliedAccessGrant);
                }
            }
        }
        return ret;
    }

    private RangerPolicy.RangerPolicyItemAccess getAccess(RangerPolicy.RangerPolicyItem policyItem, String accessType) {
        RangerPolicy.RangerPolicyItemAccess ret = null;
        if (policyItem != null && CollectionUtils.isNotEmpty(policyItem.getAccesses())) {
            for (RangerPolicy.RangerPolicyItemAccess itemAccess : policyItem.getAccesses()) {
                if (!StringUtils.equalsIgnoreCase((String)itemAccess.getType(), (String)accessType)) continue;
                ret = itemAccess;
                break;
            }
        }
        return ret;
    }

    private List<RangerPolicyItemEvaluator> createPolicyItemEvaluators(RangerPolicy policy, RangerServiceDef serviceDef, RangerPolicyEngineOptions options, int policyItemType) {
        List<RangerPolicyItemEvaluator> ret = null;
        List<RangerPolicy.RangerPolicyItem> policyItems = null;
        if (this.isPolicyItemTypeEnabled(serviceDef, policyItemType)) {
            if (policyItemType == 0) {
                policyItems = policy.getPolicyItems();
            } else if (policyItemType == 1) {
                policyItems = policy.getDenyPolicyItems();
            } else if (policyItemType == 2) {
                policyItems = policy.getAllowExceptions();
            } else if (policyItemType == 3) {
                policyItems = policy.getDenyExceptions();
            }
        }
        if (CollectionUtils.isNotEmpty(policyItems)) {
            ret = new ArrayList();
            int policyItemCounter = 1;
            for (RangerPolicy.RangerPolicyItem policyItem : policyItems) {
                RangerDefaultPolicyItemEvaluator itemEvaluator = new RangerDefaultPolicyItemEvaluator(serviceDef, policy, policyItem, policyItemType, policyItemCounter++, options);
                itemEvaluator.init();
                ret.add(itemEvaluator);
                if (!CollectionUtils.isNotEmpty(itemEvaluator.getConditionEvaluators())) continue;
                this.customConditionsCount += itemEvaluator.getConditionEvaluators().size();
            }
        } else {
            ret = Collections.emptyList();
        }
        return ret;
    }

    private List<RangerDataMaskPolicyItemEvaluator> createDataMaskPolicyItemEvaluators(RangerPolicy policy, RangerServiceDef serviceDef, RangerPolicyEngineOptions options, List<RangerPolicy.RangerDataMaskPolicyItem> policyItems) {
        List<RangerDataMaskPolicyItemEvaluator> ret = null;
        if (CollectionUtils.isNotEmpty(policyItems)) {
            ret = new ArrayList();
            int policyItemCounter = 1;
            for (RangerPolicy.RangerDataMaskPolicyItem policyItem : policyItems) {
                RangerDefaultDataMaskPolicyItemEvaluator itemEvaluator = new RangerDefaultDataMaskPolicyItemEvaluator(serviceDef, policy, policyItem, policyItemCounter++, options);
                itemEvaluator.init();
                ret.add(itemEvaluator);
                if (!CollectionUtils.isNotEmpty(itemEvaluator.getConditionEvaluators())) continue;
                this.customConditionsCount += itemEvaluator.getConditionEvaluators().size();
            }
        } else {
            ret = Collections.emptyList();
        }
        return ret;
    }

    private List<RangerRowFilterPolicyItemEvaluator> createRowFilterPolicyItemEvaluators(RangerPolicy policy, RangerServiceDef serviceDef, RangerPolicyEngineOptions options, List<RangerPolicy.RangerRowFilterPolicyItem> policyItems) {
        List<RangerRowFilterPolicyItemEvaluator> ret = null;
        if (CollectionUtils.isNotEmpty(policyItems)) {
            ret = new ArrayList();
            int policyItemCounter = 1;
            for (RangerPolicy.RangerRowFilterPolicyItem policyItem : policyItems) {
                RangerDefaultRowFilterPolicyItemEvaluator itemEvaluator = new RangerDefaultRowFilterPolicyItemEvaluator(serviceDef, policy, policyItem, policyItemCounter++, options);
                itemEvaluator.init();
                ret.add(itemEvaluator);
                if (!CollectionUtils.isNotEmpty(itemEvaluator.getConditionEvaluators())) continue;
                this.customConditionsCount += itemEvaluator.getConditionEvaluators().size();
            }
        } else {
            ret = Collections.emptyList();
        }
        return ret;
    }

    private boolean isPolicyItemTypeEnabled(RangerServiceDef serviceDef, int policyItemType) {
        boolean ret = true;
        if (policyItemType == 1 || policyItemType == 2 || policyItemType == 3) {
            ret = ServiceDefUtil.getOption_enableDenyAndExceptionsInPolicies(serviceDef);
        }
        return ret;
    }

    protected <T extends RangerPolicyItemEvaluator> T getMatchingPolicyItem(RangerAccessRequest request, List<T> evaluators) {
        T ret = this.getMatchingPolicyItem(request, evaluators, null);
        return ret;
    }

    private <T extends RangerPolicyItemEvaluator> T getMatchingPolicyItem(RangerAccessRequest request, List<T> evaluators, List<T> exceptionEvaluators) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerDefaultPolicyEvaluator.getMatchingPolicyItem(" + request + ")"));
        }
        RangerPolicyItemEvaluator ret = null;
        if (CollectionUtils.isNotEmpty(evaluators)) {
            for (RangerPolicyItemEvaluator evaluator : evaluators) {
                if (!evaluator.isMatch(request)) continue;
                ret = evaluator;
                break;
            }
        }
        if (ret != null && CollectionUtils.isNotEmpty(exceptionEvaluators)) {
            for (RangerPolicyItemEvaluator exceptionEvaluator : exceptionEvaluators) {
                if (!exceptionEvaluator.isMatch(request)) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("RangerDefaultPolicyEvaluator.getMatchingPolicyItem(" + request + "): found exception policyItem(" + exceptionEvaluator.getPolicyItem() + "); ignoring the matchedPolicyItem(" + ret.getPolicyItem() + ")"));
                }
                ret = null;
                break;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerDefaultPolicyEvaluator.getMatchingPolicyItem(" + request + "): " + ret));
        }
        return (T)ret;
    }

    private <T extends RangerPolicyItemEvaluator> T getMatchingPolicyItem(String user, Set<String> userGroups, String accessType, List<T> evaluators, List<T> exceptionEvaluators) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerDefaultPolicyEvaluator.getMatchingPolicyItem(" + user + ", " + userGroups + ", " + accessType + ")"));
        }
        RangerPolicyItemEvaluator ret = null;
        if (CollectionUtils.isNotEmpty(evaluators)) {
            for (RangerPolicyItemEvaluator evaluator : evaluators) {
                if (!evaluator.matchUserGroup(user, userGroups) || !evaluator.matchAccessType(accessType)) continue;
                ret = evaluator;
                break;
            }
        }
        if (ret != null && CollectionUtils.isNotEmpty(exceptionEvaluators)) {
            for (RangerPolicyItemEvaluator exceptionEvaluator : exceptionEvaluators) {
                if (!exceptionEvaluator.matchUserGroup(user, userGroups) || !exceptionEvaluator.matchAccessType(accessType)) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("RangerDefaultPolicyEvaluator.getMatchingPolicyItem(" + user + ", " + userGroups + ", " + accessType + "): found exception policyItem(" + exceptionEvaluator.getPolicyItem() + "); ignoring the matchedPolicyItem(" + ret.getPolicyItem() + ")"));
                }
                ret = null;
                break;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerDefaultPolicyEvaluator.getMatchingPolicyItem(" + user + ", " + userGroups + ", " + accessType + "): " + ret));
        }
        return (T)ret;
    }
}

