/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.resourcematcher;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.resourcematcher.RangerResourceMatcher;

public abstract class RangerAbstractResourceMatcher
implements RangerResourceMatcher {
    private static final Log LOG = LogFactory.getLog(RangerAbstractResourceMatcher.class);
    public static final String WILDCARD_ASTERISK = "*";
    public static final String WILDCARDS = "*?";
    public static final String OPTIONS_SEP = ";";
    public static final String OPTION_NV_SEP = "=";
    public static final String OPTION_IGNORE_CASE = "ignoreCase";
    public static final String OPTION_WILD_CARD = "wildCard";
    protected RangerServiceDef.RangerResourceDef resourceDef = null;
    protected RangerPolicy.RangerPolicyResource policyResource = null;
    protected boolean optIgnoreCase = false;
    protected boolean optWildCard = false;
    protected List<String> policyValues = null;
    protected boolean policyIsExcludes = false;
    protected boolean isMatchAny = false;

    @Override
    public void setResourceDef(RangerServiceDef.RangerResourceDef resourceDef) {
        this.resourceDef = resourceDef;
    }

    @Override
    public void setPolicyResource(RangerPolicy.RangerPolicyResource policyResource) {
        this.policyResource = policyResource;
    }

    @Override
    public void init() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerAbstractResourceMatcher.init()");
        }
        this.optIgnoreCase = this.getBooleanOption(OPTION_IGNORE_CASE, true);
        this.optWildCard = this.getBooleanOption(OPTION_WILD_CARD, true);
        this.policyValues = new ArrayList<String>();
        boolean bl = this.policyIsExcludes = this.policyResource == null ? false : this.policyResource.getIsExcludes();
        if (this.policyResource != null && this.policyResource.getValues() != null) {
            boolean isWildCardPresent = false;
            for (String policyValue : this.policyResource.getValues()) {
                if (StringUtils.isEmpty((String)policyValue)) continue;
                if (this.optWildCard) {
                    if (StringUtils.containsOnly((String)policyValue, (String)WILDCARD_ASTERISK)) {
                        this.isMatchAny = true;
                    } else if (!isWildCardPresent && StringUtils.containsAny((String)policyValue, (String)WILDCARDS)) {
                        isWildCardPresent = true;
                    }
                }
                this.policyValues.add(policyValue);
            }
            boolean bl2 = this.optWildCard = this.optWildCard && isWildCardPresent;
        }
        if (this.policyValues.isEmpty()) {
            this.isMatchAny = true;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerAbstractResourceMatcher.init()");
        }
    }

    @Override
    public boolean isCompleteMatch(String resource) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerAbstractResourceMatcher.isCompleteMatch(" + resource + ")"));
        }
        boolean ret = false;
        if (CollectionUtils.isEmpty(this.policyValues)) {
            ret = StringUtils.isEmpty((String)resource);
        } else if (this.policyValues.size() == 1) {
            String policyValue = this.policyValues.get(0);
            if (this.isMatchAny) {
                ret = StringUtils.containsOnly((String)resource, (String)WILDCARD_ASTERISK);
            } else {
                boolean bl = ret = this.optIgnoreCase ? StringUtils.equalsIgnoreCase((String)resource, (String)policyValue) : StringUtils.equals((String)resource, (String)policyValue);
            }
            if (this.policyIsExcludes) {
                boolean bl = ret = !ret;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerAbstractResourceMatcher.isCompleteMatch(" + resource + "): " + ret));
        }
        return ret;
    }

    public String getOption(String name) {
        Map<String, String> options;
        String ret = null;
        Map<String, String> map = options = this.resourceDef != null ? this.resourceDef.getMatcherOptions() : null;
        if (options != null && name != null) {
            ret = options.get(name);
        }
        return ret;
    }

    public String getOption(String name, String defaultValue) {
        String ret = defaultValue;
        String val = this.getOption(name);
        if (val != null) {
            ret = val;
        }
        return ret;
    }

    public boolean getBooleanOption(String name, boolean defaultValue) {
        boolean ret = defaultValue;
        String val = this.getOption(name);
        if (val != null) {
            ret = Boolean.parseBoolean(val);
        }
        return ret;
    }

    public char getCharOption(String name, char defaultValue) {
        char ret = defaultValue;
        String val = this.getOption(name);
        if (!StringUtils.isEmpty((String)val)) {
            ret = val.charAt(0);
        }
        return ret;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.toString(sb);
        return sb.toString();
    }

    public StringBuilder toString(StringBuilder sb) {
        sb.append("RangerAbstractResourceMatcher={");
        sb.append("resourceDef={");
        if (this.resourceDef != null) {
            this.resourceDef.toString(sb);
        }
        sb.append("} ");
        sb.append("policyResource={");
        if (this.policyResource != null) {
            this.policyResource.toString(sb);
        }
        sb.append("} ");
        sb.append("optIgnoreCase={").append(this.optIgnoreCase).append("} ");
        sb.append("optWildCard={").append(this.optWildCard).append("} ");
        sb.append("policyValues={");
        if (this.policyValues != null) {
            for (String string : this.policyValues) {
                sb.append(string).append(",");
            }
        }
        sb.append("} ");
        sb.append("policyIsExcludes={").append(this.policyIsExcludes).append("} ");
        sb.append("isMatchAny={").append(this.isMatchAny).append("} ");
        sb.append("options={");
        if (this.resourceDef != null && this.resourceDef.getMatcherOptions() != null) {
            for (Map.Entry entry : this.resourceDef.getMatcherOptions().entrySet()) {
                sb.append((String)entry.getKey()).append(OPTION_NV_SEP).append((String)entry.getValue()).append(OPTIONS_SEP);
            }
        }
        sb.append("} ");
        sb.append("}");
        return sb;
    }

    boolean isAllValuesRequested(String resource) {
        boolean result;
        boolean bl = result = StringUtils.isEmpty((String)resource) || WILDCARD_ASTERISK.equals(resource);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("isAllValuesRequested(" + resource + "): " + result));
        }
        return result;
    }

    public boolean applyExcludes(boolean allValuesRequested, boolean resultWithoutExcludes) {
        if (!this.policyIsExcludes) {
            return resultWithoutExcludes;
        }
        if (allValuesRequested && !this.isMatchAny) {
            return resultWithoutExcludes;
        }
        return !resultWithoutExcludes;
    }
}

