/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.resourcematcher;

import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOCase;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ranger.plugin.resourcematcher.RangerAbstractResourceMatcher;

public class RangerDefaultResourceMatcher
extends RangerAbstractResourceMatcher {
    private static final Log LOG = LogFactory.getLog(RangerDefaultResourceMatcher.class);

    @Override
    public boolean isMatch(String resource) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerDefaultResourceMatcher.isMatch(" + resource + ")"));
        }
        boolean ret = false;
        boolean allValuesRequested = this.isAllValuesRequested(resource);
        if (allValuesRequested || this.isMatchAny) {
            ret = this.isMatchAny;
        } else {
            for (String policyValue : this.policyValues) {
                if (this.optWildCard) {
                    ret = this.optIgnoreCase ? FilenameUtils.wildcardMatch((String)resource, (String)policyValue, (IOCase)IOCase.INSENSITIVE) : FilenameUtils.wildcardMatch((String)resource, (String)policyValue, (IOCase)IOCase.SENSITIVE);
                } else {
                    boolean bl = ret = this.optIgnoreCase ? StringUtils.equalsIgnoreCase((String)resource, (String)policyValue) : StringUtils.equals((String)resource, (String)policyValue);
                }
                if (!ret) continue;
                break;
            }
        }
        ret = this.applyExcludes(allValuesRequested, ret);
        if (!ret && LOG.isDebugEnabled()) {
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            for (String policyValue : this.policyValues) {
                sb.append(policyValue);
                sb.append(" ");
            }
            sb.append("]");
            LOG.debug((Object)("RangerDefaultResourceMatcher.isMatch returns FALSE, (resource=" + resource + ", policyValues=" + sb.toString() + ")"));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerDefaultResourceMatcher.isMatch(" + resource + "): " + ret));
        }
        return ret;
    }

    @Override
    public StringBuilder toString(StringBuilder sb) {
        sb.append("RangerDefaultResourceMatcher={");
        super.toString(sb);
        sb.append("}");
        return sb;
    }
}

