/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.store.file;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.Path;
import org.apache.ranger.authorization.hadoop.config.RangerConfiguration;
import org.apache.ranger.plugin.model.RangerService;
import org.apache.ranger.plugin.model.RangerServiceResource;
import org.apache.ranger.plugin.model.RangerTag;
import org.apache.ranger.plugin.model.RangerTagDef;
import org.apache.ranger.plugin.model.RangerTagResourceMap;
import org.apache.ranger.plugin.store.AbstractTagStore;
import org.apache.ranger.plugin.store.PList;
import org.apache.ranger.plugin.store.RangerServiceResourceSignature;
import org.apache.ranger.plugin.store.TagPredicateUtil;
import org.apache.ranger.plugin.store.TagStore;
import org.apache.ranger.plugin.store.file.FileStoreUtil;
import org.apache.ranger.plugin.util.SearchFilter;
import org.apache.ranger.plugin.util.ServiceTags;

public class TagFileStore
extends AbstractTagStore {
    private static final Log LOG = LogFactory.getLog(TagFileStore.class);
    public static final String PROPERTY_TAG_FILE_STORE_DIR = "ranger.tag.store.file.dir";
    protected static final String FILE_PREFIX_TAG_DEF = "ranger-tagdef-";
    protected static final String FILE_PREFIX_TAG = "ranger-tag-";
    protected static final String FILE_PREFIX_RESOURCE = "ranger-serviceresource-";
    protected static final String FILE_PREFIX_TAG_RESOURCE_MAP = "ranger-tagresourcemap-";
    private String tagDataDir = null;
    private long nextTagDefId = 0L;
    private long nextTagId = 0L;
    private long nextServiceResourceId = 0L;
    private long nextTagResourceMapId = 0L;
    private TagPredicateUtil predicateUtil = null;
    private FileStoreUtil fileStoreUtil = null;
    private static volatile TagFileStore instance = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TagStore getInstance() {
        if (instance != null) return instance;
        Class<TagFileStore> clazz = TagFileStore.class;
        synchronized (TagFileStore.class) {
            if (instance != null) return instance;
            instance = new TagFileStore();
            instance.initStore();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    TagFileStore() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> TagFileStore.TagFileStore()");
        }
        this.tagDataDir = RangerConfiguration.getInstance().get(PROPERTY_TAG_FILE_STORE_DIR, "file:///etc/ranger/data");
        this.fileStoreUtil = new FileStoreUtil();
        this.predicateUtil = new TagPredicateUtil();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== TagFileStore.TagFileStore()");
        }
    }

    @Override
    public void init() throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> TagFileStore.init()");
        }
        super.init();
        this.fileStoreUtil.initStore(this.tagDataDir);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== TagFileStore.init()");
        }
    }

    protected void initStore() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> TagFileStore.initStore()");
        }
        this.fileStoreUtil.initStore(this.tagDataDir);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== TagFileStore.initStore()");
        }
    }

    @Override
    public RangerTagDef createTagDef(RangerTagDef tagDef) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> TagFileStore.createTagDef(" + tagDef + ")"));
        }
        RangerTagDef ret = null;
        try {
            this.preCreate(tagDef);
            tagDef.setId(this.nextTagDefId);
            ret = this.fileStoreUtil.saveToFile(tagDef, new Path(this.fileStoreUtil.getDataFile(FILE_PREFIX_TAG_DEF, this.nextTagDefId++)), false);
            this.postCreate(ret);
        }
        catch (Exception excp) {
            LOG.warn((Object)("TagFileStore.createTagDef(): failed to save tag-def '" + tagDef.getName() + "'"), (Throwable)excp);
            throw new Exception("failed to save tag-def '" + tagDef.getName() + "'", excp);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== TagFileStore.createTagDef(" + tagDef + ")"));
        }
        return ret;
    }

    @Override
    public RangerTagDef updateTagDef(RangerTagDef tagDef) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> TagFileStore.updateTagDef(" + tagDef + ")"));
        }
        RangerTagDef existing = null;
        if (tagDef.getId() == null) {
            existing = this.getTagDefByName(tagDef.getName());
            if (existing == null) {
                throw new Exception("tag-def does not exist: name=" + tagDef.getName());
            }
        } else {
            existing = this.getTagDef(tagDef.getId());
            if (existing == null) {
                throw new Exception("tag-def does not exist: id=" + tagDef.getId());
            }
        }
        RangerTagDef ret = null;
        try {
            this.preUpdate(existing);
            existing.setSource(tagDef.getSource());
            existing.setAttributeDefs(tagDef.getAttributeDefs());
            ret = this.fileStoreUtil.saveToFile(existing, new Path(this.fileStoreUtil.getDataFile(FILE_PREFIX_TAG_DEF, existing.getId())), true);
            this.postUpdate(existing);
        }
        catch (Exception excp) {
            LOG.warn((Object)("TagFileStore.updateTagDef(): failed to save tag-def '" + tagDef.getName() + "'"), (Throwable)excp);
            throw new Exception("failed to save tag-def '" + tagDef.getName() + "'", excp);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== TagFileStore.updateTagDef(" + tagDef + ")"));
        }
        return ret;
    }

    @Override
    public void deleteTagDefByName(String name) throws Exception {
        RangerTagDef existing;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> TagFileStore.deleteTagDef(" + name + ")"));
        }
        if ((existing = this.getTagDefByName(name)) != null) {
            try {
                this.deleteTagDef(existing);
            }
            catch (Exception excp) {
                throw new Exception("failed to delete tag-def with ID=" + name, excp);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== TagFileStore.deleteTagDef(" + name + ")"));
        }
    }

    @Override
    public void deleteTagDef(Long id) throws Exception {
        RangerTagDef existing;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> TagFileStore.deleteTagDef(" + id + ")"));
        }
        if ((existing = this.getTagDef(id)) != null) {
            this.deleteTagDef(existing);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== TagFileStore.deleteTagDef(" + id + ")"));
        }
    }

    @Override
    public RangerTagDef getTagDef(Long id) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> TagFileStore.getTagDef(" + id + ")"));
        }
        RangerTagDef ret = null;
        if (id != null) {
            SearchFilter filter = new SearchFilter("tagDefId", id.toString());
            List<RangerTagDef> tagDefs = this.getTagDefs(filter);
            RangerTagDef rangerTagDef = ret = CollectionUtils.isEmpty(tagDefs) ? null : tagDefs.get(0);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== TagFileStore.getTagDef(" + id + "): " + ret));
        }
        return ret;
    }

    @Override
    public RangerTagDef getTagDefByGuid(String guid) throws Exception {
        SearchFilter filter;
        List<RangerTagDef> tagDefs;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> TagFileStore.getTagDefByGuid(" + guid + ")"));
        }
        RangerTagDef ret = null;
        if (StringUtils.isNotBlank((String)guid) && CollectionUtils.isNotEmpty(tagDefs = this.getTagDefs(filter = new SearchFilter("tagDefGuid", guid)))) {
            ret = tagDefs.get(0);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== TagFileStore.getTagDefByGuid(" + guid + "): " + ret));
        }
        return ret;
    }

    @Override
    public RangerTagDef getTagDefByName(String name) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> TagFileStore.getTagDefByName(" + name + ")"));
        }
        RangerTagDef ret = null;
        if (StringUtils.isNotBlank((String)name)) {
            SearchFilter filter = new SearchFilter("tagType", name);
            List<RangerTagDef> tagDefs = this.getTagDefs(filter);
            RangerTagDef rangerTagDef = ret = CollectionUtils.isEmpty(tagDefs) ? null : tagDefs.get(0);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== TagFileStore.getTagDefByName(" + name + "): " + ret));
        }
        return ret;
    }

    @Override
    public List<RangerTagDef> getTagDefs(SearchFilter filter) throws Exception {
        List<RangerTagDef> ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> TagFileStore.getTagDefs()");
        }
        if (CollectionUtils.isNotEmpty(ret = this.getAllTagDefs()) && filter != null && !filter.isEmpty()) {
            CollectionUtils.filter(ret, (Predicate)this.predicateUtil.getPredicate(filter));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== TagFileStore.getTagDefs(): count=" + (ret == null ? 0 : ret.size())));
        }
        return ret;
    }

    @Override
    public PList<RangerTagDef> getPaginatedTagDefs(SearchFilter filter) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> TagFileStore.getPaginatedTagDefs()");
        }
        PList<RangerTagDef> ret = null;
        List<RangerTagDef> list = this.getTagDefs(filter);
        if (list != null) {
            ret = new PList<RangerTagDef>(list, 0, list.size(), list.size(), list.size(), filter.getSortType(), filter.getSortBy());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== TagFileStore.getPaginatedTagDefs(): count=" + (ret == null ? 0 : ret.getPageSize())));
        }
        return ret;
    }

    @Override
    public List<String> getTagTypes() throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> TagFileStore.getTagTypes()");
        }
        ArrayList<String> ret = new ArrayList<String>();
        List<RangerTag> allTags = this.getAllTags();
        for (RangerTag tag : allTags) {
            ret.add(tag.getType());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== TagFileStore.getTagTypes(): count=" + ret.size()));
        }
        return ret;
    }

    @Override
    public RangerTag createTag(RangerTag tag) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> TagFileStore.createTag(" + tag + ")"));
        }
        RangerTag ret = null;
        try {
            this.preCreate(tag);
            tag.setId(this.nextTagId);
            ret = this.fileStoreUtil.saveToFile(tag, new Path(this.fileStoreUtil.getDataFile(FILE_PREFIX_TAG, this.nextTagId++)), false);
            this.postCreate(ret);
        }
        catch (Exception excp) {
            LOG.warn((Object)("TagFileStore.createTag(): failed to save tag '" + tag.getType() + "'"), (Throwable)excp);
            throw new Exception("failed to save tag '" + tag.getType() + "'", excp);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== TagFileStore.createTag(" + tag + "): " + ret));
        }
        return ret;
    }

    @Override
    public RangerTag updateTag(RangerTag tag) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> TagFileStore.updateTag(" + tag + ")"));
        }
        RangerTag ret = null;
        try {
            this.preUpdate(tag);
            ret = this.fileStoreUtil.saveToFile(tag, new Path(this.fileStoreUtil.getDataFile(FILE_PREFIX_TAG, tag.getId())), true);
            this.postUpdate(tag);
        }
        catch (Exception excp) {
            LOG.warn((Object)("TagFileStore.updateTag(): failed to save tag '" + tag.getType() + "'"), (Throwable)excp);
            throw new Exception("failed to save tag '" + tag.getType() + "'", excp);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== TagFileStore.updateTag(" + tag + "): " + ret));
        }
        return ret;
    }

    @Override
    public void deleteTag(Long id) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> TagFileStore.deleteTag(" + id + ")"));
        }
        try {
            RangerTag tag = this.getTag(id);
            if (tag != null) {
                this.deleteTag(tag);
            }
        }
        catch (Exception excp) {
            throw new Exception("failed to delete tag with ID=" + id, excp);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== TagFileStore.deleteTag(" + id + ")"));
        }
    }

    @Override
    public RangerTag getTag(Long id) throws Exception {
        SearchFilter filter;
        List<RangerTag> tags;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> TagFileStore.getTag(" + id + ")"));
        }
        RangerTag ret = null;
        if (id != null && CollectionUtils.isNotEmpty(tags = this.getTags(filter = new SearchFilter("tagId", id.toString()))) && CollectionUtils.size(tags) == 1) {
            ret = tags.get(0);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== TagFileStore.getTagDef(" + id + "): " + ret));
        }
        return ret;
    }

    @Override
    public RangerTag getTagByGuid(String guid) throws Exception {
        SearchFilter filter;
        List<RangerTag> tags;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> TagFileStore.getTagByGuid(" + guid + ")"));
        }
        RangerTag ret = null;
        if (guid != null && CollectionUtils.isNotEmpty(tags = this.getTags(filter = new SearchFilter("tagGuid", guid))) && CollectionUtils.size(tags) == 1) {
            ret = tags.get(0);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== TagFileStore.getTagByGuid(" + guid + "): " + ret));
        }
        return ret;
    }

    @Override
    public List<RangerTag> getTagsByType(String type) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> TagFileStore.getTagsByType(" + type + ")"));
        }
        SearchFilter filter = new SearchFilter("tagType", type);
        List<RangerTag> ret = this.getTags(filter);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== TagFileStore.getTagsByType(" + type + "): count=" + (ret == null ? 0 : ret.size())));
        }
        return ret;
    }

    @Override
    public List<Long> getTagIdsForResourceId(Long resourceId) throws Exception {
        ArrayList<Long> ret = new ArrayList<Long>();
        List<RangerTag> tags = this.getTagsForResourceId(resourceId);
        if (CollectionUtils.isNotEmpty(tags)) {
            for (RangerTag tag : tags) {
                ret.add(tag.getId());
            }
        }
        return ret;
    }

    @Override
    public List<RangerTag> getTagsForResourceId(Long resourceId) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> TagFileStore.getTagsForResourceId(" + resourceId + ")"));
        }
        SearchFilter filter = new SearchFilter("resourceId", resourceId.toString());
        List<RangerTag> ret = this.getTags(filter);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== TagFileStore.getTagsForResourceId(" + resourceId + "): count=" + (ret == null ? 0 : ret.size())));
        }
        return ret;
    }

    @Override
    public List<RangerTag> getTagsForResourceGuid(String resourceGuid) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> TagFileStore.getTagsForResourceGuid(" + resourceGuid + ")"));
        }
        SearchFilter filter = new SearchFilter("resourceGuid", resourceGuid);
        List<RangerTag> ret = this.getTags(filter);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== TagFileStore.getTagsForResourceGuid(" + resourceGuid + "): count=" + (ret == null ? 0 : ret.size())));
        }
        return ret;
    }

    @Override
    public List<RangerTag> getTags(SearchFilter filter) throws Exception {
        List<RangerTag> ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> TagFileStore.getTags()");
        }
        if (CollectionUtils.isNotEmpty(ret = this.getAllTags()) && filter != null && !filter.isEmpty()) {
            CollectionUtils.filter(ret, (Predicate)this.predicateUtil.getPredicate(filter));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== TagFileStore.getTags(): count=" + (ret == null ? 0 : ret.size())));
        }
        return ret;
    }

    @Override
    public PList<RangerTag> getPaginatedTags(SearchFilter filter) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> TagFileStore.getPaginatedTags()");
        }
        PList<RangerTag> ret = null;
        List<RangerTag> list = this.getTags(filter);
        if (list != null) {
            ret = new PList<RangerTag>(list, 0, list.size(), list.size(), list.size(), filter.getSortType(), filter.getSortBy());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== TagFileStore.getPaginatedTags(): count=" + (ret == null ? 0 : ret.getPageSize())));
        }
        return ret;
    }

    @Override
    public RangerServiceResource createServiceResource(RangerServiceResource resource) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> TagFileStore.createServiceResource(" + resource + ")"));
        }
        RangerServiceResource ret = null;
        try {
            this.preCreate(resource);
            if (StringUtils.isEmpty((String)resource.getResourceSignature())) {
                RangerServiceResourceSignature serializer = new RangerServiceResourceSignature(resource);
                resource.setResourceSignature(serializer.getSignature());
            }
            resource.setId(this.nextServiceResourceId);
            ret = this.fileStoreUtil.saveToFile(resource, new Path(this.fileStoreUtil.getDataFile(FILE_PREFIX_RESOURCE, this.nextServiceResourceId++)), false);
            this.postCreate(ret);
        }
        catch (Exception excp) {
            LOG.warn((Object)("TagFileStore.createServiceResource(): failed to save resource '" + resource.getId() + "'"), (Throwable)excp);
            throw new Exception("failed to save service-resource '" + resource.getId() + "'", excp);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== TagFileStore.createServiceResource(" + resource + "): " + ret));
        }
        return ret;
    }

    @Override
    public RangerServiceResource updateServiceResource(RangerServiceResource resource) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> TagFileStore.updateServiceResource(" + resource + ")"));
        }
        RangerServiceResource ret = null;
        try {
            this.preUpdate(resource);
            if (StringUtils.isEmpty((String)resource.getResourceSignature())) {
                RangerServiceResourceSignature serializer = new RangerServiceResourceSignature(resource);
                resource.setResourceSignature(serializer.getSignature());
            }
            ret = this.fileStoreUtil.saveToFile(resource, new Path(this.fileStoreUtil.getDataFile(FILE_PREFIX_RESOURCE, resource.getId())), true);
            this.postUpdate(resource);
        }
        catch (Exception excp) {
            LOG.warn((Object)("TagFileStore.updateServiceResource(): failed to save resource '" + resource.getId() + "'"), (Throwable)excp);
            throw new Exception("failed to save service-resource '" + resource.getId() + "'", excp);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== TagFileStore.updateServiceResource(" + resource + "): " + ret));
        }
        return ret;
    }

    @Override
    public void deleteServiceResource(Long id) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> TagFileStore.deleteServiceResource(" + id + ")"));
        }
        try {
            RangerServiceResource resource = this.getServiceResource(id);
            if (resource != null) {
                this.deleteServiceResource(resource);
            }
        }
        catch (Exception excp) {
            throw new Exception("failed to delete service-resource with ID=" + id, excp);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== TagFileStore.deleteServiceResource(" + id + ")"));
        }
    }

    @Override
    public void deleteServiceResourceByGuid(String guid) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> TagFileStore.deleteServiceResourceByGuid(" + guid + ")"));
        }
        try {
            RangerServiceResource resource = this.getServiceResourceByGuid(guid);
            if (resource != null) {
                this.deleteServiceResource(resource);
            }
        }
        catch (Exception excp) {
            throw new Exception("failed to delete service-resource with GUID=" + guid, excp);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== TagFileStore.deleteServiceResourceByGuid(" + guid + ")"));
        }
    }

    @Override
    public RangerServiceResource getServiceResource(Long id) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> TagFileStore.getServiceResource(" + id + ")"));
        }
        RangerServiceResource ret = null;
        SearchFilter filter = new SearchFilter("resourceId", id.toString());
        List<RangerServiceResource> resources = this.getServiceResources(filter);
        if (CollectionUtils.isNotEmpty(resources)) {
            ret = resources.get(0);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== TagFileStore.getServiceResource(" + id + "): " + ret));
        }
        return ret;
    }

    @Override
    public RangerServiceResource getServiceResourceByGuid(String guid) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> TagFileStore.getServiceResourcesByGuid(" + guid + ")"));
        }
        RangerServiceResource ret = null;
        SearchFilter filter = new SearchFilter("resourceGuid", guid);
        List<RangerServiceResource> resources = this.getServiceResources(filter);
        if (CollectionUtils.isNotEmpty(resources)) {
            ret = resources.get(0);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== TagFileStore.getServiceResourcesByGuid(" + guid + "): " + ret));
        }
        return ret;
    }

    @Override
    public List<RangerServiceResource> getServiceResourcesByService(String serviceName) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> TagFileStore.getServiceResourcesByService(" + serviceName + ")"));
        }
        List<RangerServiceResource> ret = null;
        if (StringUtils.isNotBlank((String)serviceName)) {
            SearchFilter filter = new SearchFilter("serviceName", serviceName);
            ret = this.getServiceResources(filter);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== TagFileStore.getServiceResourcesByService(" + serviceName + "): count=" + (ret == null ? 0 : ret.size())));
        }
        return ret;
    }

    @Override
    public List<String> getServiceResourceGuidsByService(String serviceName) throws Exception {
        List<RangerServiceResource> serviceResources;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> TagFileStore.getServiceResourceGuidsByService(" + serviceName + ")"));
        }
        ArrayList<String> ret = null;
        if (StringUtils.isNotBlank((String)serviceName) && CollectionUtils.isNotEmpty(serviceResources = this.getServiceResourcesByService(serviceName))) {
            ret = new ArrayList<String>(serviceResources.size());
            for (RangerServiceResource serviceResource : serviceResources) {
                ret.add(serviceResource.getGuid());
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== TagFileStore.getServiceResourceGuidsByService(" + serviceName + "): count=" + (ret == null ? 0 : ret.size())));
        }
        return ret;
    }

    @Override
    public RangerServiceResource getServiceResourceByServiceAndResourceSignature(String serviceName, String resourceSignature) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> TagFileStore.getServiceResourceByServiceAndResourceSignature(" + serviceName + ", " + resourceSignature + ")"));
        }
        RangerServiceResource ret = null;
        if (StringUtils.isNotBlank((String)resourceSignature)) {
            SearchFilter filter = new SearchFilter();
            filter.setParam("resourceServiceName", serviceName);
            filter.setParam("resourceSignature", resourceSignature);
            List<RangerServiceResource> resources = this.getServiceResources(filter);
            RangerServiceResource rangerServiceResource = ret = CollectionUtils.isNotEmpty(resources) ? resources.get(0) : null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== TagFileStore.getServiceResourceByServiceAndResourceSignature(" + serviceName + ", " + resourceSignature + "): " + ret));
        }
        return ret;
    }

    @Override
    public List<RangerServiceResource> getServiceResources(SearchFilter filter) throws Exception {
        List<RangerServiceResource> ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> TagFileStore.getServiceResources()");
        }
        if (CollectionUtils.isNotEmpty(ret = this.getAllResources()) && filter != null && !filter.isEmpty()) {
            CollectionUtils.filter(ret, (Predicate)this.predicateUtil.getPredicate(filter));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== TagFileStore.getServicesResources(): count=" + (ret == null ? 0 : ret.size())));
        }
        return ret;
    }

    @Override
    public PList<RangerServiceResource> getPaginatedServiceResources(SearchFilter filter) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> TagFileStore.getPaginatedServiceResources()");
        }
        PList<RangerServiceResource> ret = null;
        List<RangerServiceResource> list = this.getServiceResources(filter);
        if (list != null) {
            ret = new PList<RangerServiceResource>(list, 0, list.size(), list.size(), list.size(), filter.getSortType(), filter.getSortBy());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== TagFileStore.getPaginatedServiceResources(): count=" + (ret == null ? 0 : ret.getPageSize())));
        }
        return ret;
    }

    @Override
    public RangerTagResourceMap createTagResourceMap(RangerTagResourceMap tagResourceMap) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> TagFileStore.createTagResourceMap(" + tagResourceMap + ")"));
        }
        this.preCreate(tagResourceMap);
        tagResourceMap.setId(this.nextTagResourceMapId);
        RangerTagResourceMap ret = this.fileStoreUtil.saveToFile(tagResourceMap, new Path(this.fileStoreUtil.getDataFile(FILE_PREFIX_TAG_RESOURCE_MAP, this.nextTagResourceMapId++)), false);
        this.postCreate(ret);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== TagFileStore.createTagResourceMap(" + tagResourceMap + "): " + ret));
        }
        return ret;
    }

    @Override
    public void deleteTagResourceMap(Long id) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> TagFileStore.deleteTagResourceMap(" + id + ")"));
        }
        try {
            RangerTagResourceMap tagResourceMap = this.getTagResourceMap(id);
            if (tagResourceMap != null) {
                Long tagId = tagResourceMap.getTagId();
                RangerTag tag = this.getTag(tagId);
                this.deleteTagResourceMap(tagResourceMap);
                if (tag != null && tag.getOwner() == 0) {
                    this.deleteTag(tagId);
                }
            }
        }
        catch (Exception excp) {
            throw new Exception("failed to delete tagResourceMap with ID=" + id, excp);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== TagFileStore.deleteTagResourceMap(" + id + ")"));
        }
    }

    @Override
    public RangerTagResourceMap getTagResourceMap(Long id) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> TagFileStore.getTagResourceMap(" + id + ")"));
        }
        RangerTagResourceMap ret = null;
        SearchFilter filter = new SearchFilter();
        filter.setParam("tagResourceMapId", id.toString());
        List<RangerTagResourceMap> list = this.getTagResourceMaps(filter);
        if (CollectionUtils.isNotEmpty(list)) {
            ret = list.get(0);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== TagFileStore.getTagResourceMap(" + id + "): " + ret));
        }
        return ret;
    }

    @Override
    public RangerTagResourceMap getTagResourceMapByGuid(String guid) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> TagFileStore.getTagResourceMapByGuid(" + guid + ")"));
        }
        RangerTagResourceMap ret = null;
        SearchFilter filter = new SearchFilter();
        filter.setParam("tagResourceMapGuid", guid.toString());
        List<RangerTagResourceMap> list = this.getTagResourceMaps(filter);
        if (CollectionUtils.isNotEmpty(list)) {
            ret = list.get(0);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== TagFileStore.getTagResourceMapByGuid(" + guid + "): " + ret));
        }
        return ret;
    }

    @Override
    public List<RangerTagResourceMap> getTagResourceMapsForTagId(Long tagId) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> TagFileStore.getTagResourceMapsForTagId(" + tagId + ")"));
        }
        SearchFilter filter = new SearchFilter();
        filter.setParam("tagId", tagId.toString());
        List<RangerTagResourceMap> ret = this.getTagResourceMaps(filter);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== TagFileStore.getTagResourceMapsForTagId(" + tagId + "): " + ret));
        }
        return ret;
    }

    @Override
    public List<RangerTagResourceMap> getTagResourceMapsForTagGuid(String tagGuid) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> TagFileStore.getTagResourceMapsForTagGuid(" + tagGuid + ")"));
        }
        List<RangerTagResourceMap> ret = null;
        RangerTag tag = this.getTagByGuid(tagGuid);
        if (tag != null) {
            SearchFilter filter = new SearchFilter();
            filter.setParam("tagId", tag.getId().toString());
            ret = this.getTagResourceMaps(filter);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== TagFileStore.getTagResourceMapsForTagGuid(" + tagGuid + "): " + ret));
        }
        return ret;
    }

    @Override
    public List<RangerTagResourceMap> getTagResourceMapsForResourceId(Long resourceId) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> TagFileStore.getTagResourceMap(" + resourceId + ")"));
        }
        SearchFilter filter = new SearchFilter();
        filter.setParam("resourceId", resourceId.toString());
        List<RangerTagResourceMap> ret = this.getTagResourceMaps(filter);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== TagFileStore.getTagResourceMap(" + resourceId + "): " + ret));
        }
        return ret;
    }

    @Override
    public List<RangerTagResourceMap> getTagResourceMapsForResourceGuid(String resourceGuid) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> TagFileStore.getTagResourceMapsForResourceGuid(" + resourceGuid + ")"));
        }
        List<RangerTagResourceMap> ret = null;
        RangerServiceResource resource = this.getServiceResourceByGuid(resourceGuid);
        if (resource != null) {
            SearchFilter filter = new SearchFilter();
            filter.setParam("resourceId", resource.getId().toString());
            ret = this.getTagResourceMaps(filter);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== TagFileStore.getTagResourceMapsForResourceGuid(" + resourceGuid + "): " + ret));
        }
        return ret;
    }

    @Override
    public RangerTagResourceMap getTagResourceMapForTagAndResourceId(Long tagId, Long resourceId) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> TagFileStore.getTagResourceMapForTagAndResourceId(" + tagId + ", " + resourceId + ")"));
        }
        RangerTagResourceMap ret = null;
        SearchFilter filter = new SearchFilter();
        filter.setParam("tagId", tagId.toString());
        filter.setParam("resourceId", resourceId.toString());
        List<RangerTagResourceMap> tagResourceMaps = this.getTagResourceMaps(filter);
        if (CollectionUtils.isNotEmpty(tagResourceMaps)) {
            ret = tagResourceMaps.get(0);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== TagFileStore.getTagResourceMapForTagAndResourceId(" + tagId + ", " + resourceId + "): " + ret));
        }
        return ret;
    }

    @Override
    public RangerTagResourceMap getTagResourceMapForTagAndResourceGuid(String tagGuid, String resrouceGuid) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> TagFileStore.getTagResourceMapForTagAndResourceGuid(" + tagGuid + ", " + resrouceGuid + ")"));
        }
        RangerTagResourceMap ret = null;
        SearchFilter filter = new SearchFilter();
        RangerTag tag = this.getTagByGuid(tagGuid);
        RangerServiceResource resource = this.getServiceResourceByGuid(resrouceGuid);
        if (tag != null && resource != null) {
            filter.setParam("tagId", tag.getId().toString());
            filter.setParam("resourceId", resource.getId().toString());
            List<RangerTagResourceMap> tagResourceMaps = this.getTagResourceMaps(filter);
            if (CollectionUtils.isNotEmpty(tagResourceMaps)) {
                ret = tagResourceMaps.get(0);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== TagFileStore.getTagResourceMapForTagAndResourceGuid(" + tagGuid + ", " + resrouceGuid + "): " + ret));
        }
        return ret;
    }

    @Override
    public List<RangerTagResourceMap> getTagResourceMaps(SearchFilter filter) throws Exception {
        List<RangerTagResourceMap> ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> TagFileStore.getTagResourceMaps()");
        }
        if (CollectionUtils.isNotEmpty(ret = this.getAllTaggedResources()) && filter != null && !filter.isEmpty()) {
            CollectionUtils.filter(ret, (Predicate)this.predicateUtil.getPredicate(filter));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== TagFileStore.getTagResourceMaps(): count=" + (ret == null ? 0 : ret.size())));
        }
        return ret;
    }

    @Override
    public PList<RangerTagResourceMap> getPaginatedTagResourceMaps(SearchFilter filter) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> TagFileStore.getPaginatedTagResourceMaps()");
        }
        PList<RangerTagResourceMap> ret = null;
        List<RangerTagResourceMap> list = this.getTagResourceMaps(filter);
        if (CollectionUtils.isNotEmpty(list)) {
            ret = new PList<RangerTagResourceMap>(list, 0, list.size(), list.size(), list.size(), filter.getSortType(), filter.getSortBy());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== TagFileStore.getPaginatedTagResourceMaps(): count=" + (ret == null ? 0 : ret.getPageSize())));
        }
        return ret;
    }

    @Override
    public ServiceTags getServiceTagsIfUpdated(String serviceName, Long lastKnownVersion) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> TagFileStore.getServiceTagsIfUpdated(" + serviceName + ", " + lastKnownVersion + ")"));
        }
        ServiceTags ret = null;
        boolean tagsChanged = true;
        RangerService service = null;
        try {
            service = this.svcStore.getServiceByName(serviceName);
        }
        catch (Exception exception) {
            LOG.error((Object)("Cannot find service for serviceName=" + serviceName));
            tagsChanged = false;
        }
        if (lastKnownVersion != null && service != null && service.getTagVersion() != null && lastKnownVersion.equals(service.getTagVersion())) {
            tagsChanged = false;
        }
        if (tagsChanged) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Changes to tagVersion detected, tagVersion in service=" + (service == null ? null : service.getTagVersion()) + ", Plugin-provided lastKnownVersion=" + lastKnownVersion));
            }
            ret = this.getServiceTags(serviceName);
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("No changes to tagVersion detected, tagVersion in service=" + (service == null ? null : service.getTagVersion()) + ", Plugin-provided lastKnownVersion=" + lastKnownVersion));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== TagFileStore.getServiceTagsIfUpdated(" + serviceName + ", " + lastKnownVersion + "): " + ret));
        }
        return ret;
    }

    @Override
    public ServiceTags getServiceTags(String serviceName) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> TagFileStore.getServiceTags(" + serviceName + ")"));
        }
        ServiceTags ret = new ServiceTags();
        RangerService service = null;
        try {
            service = this.svcStore.getServiceByName(serviceName);
        }
        catch (Exception exception) {
            LOG.error((Object)("Cannot find service for serviceName=" + serviceName));
        }
        SearchFilter filter = new SearchFilter();
        filter.setParam("resourceServiceName", serviceName);
        List<RangerServiceResource> serviceResources = this.getServiceResources(filter);
        ArrayList<RangerServiceResource> filteredServiceResources = new ArrayList<RangerServiceResource>();
        HashMap<Long, RangerTag> tagsMap = new HashMap<Long, RangerTag>();
        HashMap<Long, List<Long>> resourceToTagIdsMap = new HashMap<Long, List<Long>>();
        for (RangerServiceResource serviceResource : serviceResources) {
            List<RangerTag> tagList = this.getTagsForServiceResourceObject(serviceResource);
            if (!CollectionUtils.isNotEmpty(tagList)) continue;
            ArrayList<Long> tagIdList = new ArrayList<Long>();
            for (RangerTag tag : tagList) {
                tagsMap.put(tag.getId(), tag);
                tagIdList.add(tag.getId());
            }
            resourceToTagIdsMap.put(serviceResource.getId(), tagIdList);
            filteredServiceResources.add(serviceResource);
        }
        ret.setServiceName(serviceName);
        ret.setServiceResources(filteredServiceResources);
        ret.setResourceToTagIds(resourceToTagIdsMap);
        ret.setTags(tagsMap);
        if (service != null && service.getTagVersion() != null) {
            ret.setTagVersion(service.getTagVersion());
        }
        if (service != null && service.getTagUpdateTime() != null) {
            ret.setTagUpdateTime(service.getTagUpdateTime());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== TagFileStore.getServiceTags(" + serviceName + "): " + ret));
        }
        return ret;
    }

    @Override
    public Long getTagVersion(String serviceName) {
        RangerService service = null;
        try {
            service = this.svcStore.getServiceByName(serviceName);
        }
        catch (Exception exception) {
            LOG.error((Object)("Cannot find service for serviceName=" + serviceName));
        }
        return service != null ? service.getTagVersion() : null;
    }

    private List<RangerTag> getTagsForServiceResourceObject(RangerServiceResource serviceResource) throws Exception {
        ArrayList<RangerTag> tagList = new ArrayList<RangerTag>();
        if (serviceResource != null) {
            SearchFilter mapFilter = new SearchFilter();
            mapFilter.setParam("resourceId", serviceResource.getId().toString());
            List<RangerTagResourceMap> associations = this.getTagResourceMaps(mapFilter);
            if (CollectionUtils.isNotEmpty(associations)) {
                for (RangerTagResourceMap association : associations) {
                    RangerTag tag = this.getTag(association.getTagId());
                    if (tag == null) continue;
                    tagList.add(tag);
                }
            }
        }
        return tagList;
    }

    private List<RangerTagDef> getAllTagDefs() throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> TagFileStore.getAllTagDefs()");
        }
        ArrayList<RangerTagDef> ret = new ArrayList<RangerTagDef>();
        try {
            List<RangerTagDef> sds = this.fileStoreUtil.loadFromDir(new Path(this.fileStoreUtil.getDataDir()), FILE_PREFIX_TAG_DEF, RangerTagDef.class);
            if (CollectionUtils.isNotEmpty(sds)) {
                for (RangerTagDef sd : sds) {
                    if (sd == null) continue;
                    for (int i = 0; i < ret.size(); ++i) {
                        RangerTagDef currSd = (RangerTagDef)ret.get(i);
                        if (!StringUtils.equals((String)currSd.getName(), (String)sd.getName()) && !ObjectUtils.equals((Object)currSd.getId(), (Object)sd.getId())) continue;
                        ret.remove(i);
                    }
                    ret.add(sd);
                }
            }
            this.nextTagDefId = this.getMaxId(ret) + 1L;
        }
        catch (Exception excp) {
            LOG.error((Object)"TagFileStore.getAllTagDefs(): failed to read Tag-defs", (Throwable)excp);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== TagFileStore.getAllTagDefs(): count=" + ret.size()));
        }
        return ret;
    }

    private List<RangerTag> getAllTags() throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> TagFileStore.getAllTags()");
        }
        ArrayList<RangerTag> ret = new ArrayList<RangerTag>();
        try {
            List<RangerTag> sds = this.fileStoreUtil.loadFromDir(new Path(this.fileStoreUtil.getDataDir()), FILE_PREFIX_TAG, RangerTag.class);
            if (CollectionUtils.isNotEmpty(sds)) {
                for (RangerTag sd : sds) {
                    if (sd == null) continue;
                    for (int i = 0; i < ret.size(); ++i) {
                        RangerTag currSd = (RangerTag)ret.get(i);
                        if (!StringUtils.equals((String)currSd.getType(), (String)sd.getType()) && !ObjectUtils.equals((Object)currSd.getId(), (Object)sd.getId())) continue;
                        ret.remove(i);
                    }
                    ret.add(sd);
                }
            }
            this.nextTagId = this.getMaxId(ret) + 1L;
        }
        catch (Exception excp) {
            LOG.error((Object)"TagFileStore.getAllTags(): failed to read Tags", (Throwable)excp);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== TagFileStore.getAllTags(): count=" + ret.size()));
        }
        return ret;
    }

    private List<RangerServiceResource> getAllResources() throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> TagFileStore.getAllResources()");
        }
        ArrayList<RangerServiceResource> ret = new ArrayList<RangerServiceResource>();
        try {
            List<RangerServiceResource> sds = this.fileStoreUtil.loadFromDir(new Path(this.fileStoreUtil.getDataDir()), FILE_PREFIX_RESOURCE, RangerServiceResource.class);
            if (CollectionUtils.isNotEmpty(sds)) {
                for (RangerServiceResource sd : sds) {
                    if (sd == null) continue;
                    for (int i = 0; i < ret.size(); ++i) {
                        RangerServiceResource currSd = (RangerServiceResource)ret.get(i);
                        if (!ObjectUtils.equals((Object)currSd.getId(), (Object)sd.getId())) continue;
                        ret.remove(i);
                    }
                    ret.add(sd);
                }
            }
            this.nextServiceResourceId = this.getMaxId(ret) + 1L;
        }
        catch (Exception excp) {
            LOG.error((Object)"TagFileStore.getAllResources(): failed to read Resources", (Throwable)excp);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== TagFileStore.getAllResourcess(): count=" + ret.size()));
        }
        return ret;
    }

    private List<RangerTagResourceMap> getAllTaggedResources() throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> TagFileStore.getAllTaggedResources()");
        }
        ArrayList<RangerTagResourceMap> ret = new ArrayList<RangerTagResourceMap>();
        try {
            List<RangerTagResourceMap> resources = this.fileStoreUtil.loadFromDir(new Path(this.fileStoreUtil.getDataDir()), FILE_PREFIX_TAG_RESOURCE_MAP, RangerTagResourceMap.class);
            if (CollectionUtils.isNotEmpty(resources)) {
                for (RangerTagResourceMap resource : resources) {
                    if (resource == null) continue;
                    for (int i = 0; i < ret.size(); ++i) {
                        RangerTagResourceMap currResource = (RangerTagResourceMap)ret.get(i);
                        if (!ObjectUtils.equals((Object)currResource.getId(), (Object)resource.getId())) continue;
                        ret.remove(i);
                    }
                    ret.add(resource);
                }
            }
            this.nextTagResourceMapId = this.getMaxId(ret) + 1L;
        }
        catch (Exception excp) {
            LOG.error((Object)"TagFileStore.getAllTaggedResources(): failed to read tagged resources", (Throwable)excp);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== TagFileStore.getAllTaggedResources(): count=" + ret.size()));
        }
        return ret;
    }

    private void deleteTagDef(RangerTagDef tagDef) throws Exception {
        Path filePath = new Path(this.fileStoreUtil.getDataFile(FILE_PREFIX_TAG_DEF, tagDef.getId()));
        this.preDelete(tagDef);
        this.fileStoreUtil.deleteFile(filePath);
        this.postDelete(tagDef);
    }

    private void deleteTag(RangerTag tag) throws Exception {
        Path filePath = new Path(this.fileStoreUtil.getDataFile(FILE_PREFIX_TAG, tag.getId()));
        this.preDelete(tag);
        this.fileStoreUtil.deleteFile(filePath);
        this.postDelete(tag);
    }

    private void deleteServiceResource(RangerServiceResource resource) throws Exception {
        Path filePath = new Path(this.fileStoreUtil.getDataFile(FILE_PREFIX_RESOURCE, resource.getId()));
        this.preDelete(resource);
        this.fileStoreUtil.deleteFile(filePath);
        this.postDelete(resource);
    }

    private void deleteTagResourceMap(RangerTagResourceMap tagResourceMap) throws Exception {
        Path filePath = new Path(this.fileStoreUtil.getDataFile(FILE_PREFIX_TAG_RESOURCE_MAP, tagResourceMap.getId()));
        this.preDelete(tagResourceMap);
        this.fileStoreUtil.deleteFile(filePath);
        this.postDelete(tagResourceMap);
    }
}

