/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.util;

import com.google.common.base.Objects;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.ranger.authorization.hadoop.utils.RangerCredentialProvider;
import org.apache.ranger.authorization.utils.StringUtil;

public class RangerSslHelper {
    private static final Log LOG = LogFactory.getLog(RangerSslHelper.class);
    static final String RANGER_POLICYMGR_CLIENT_KEY_FILE = "xasecure.policymgr.clientssl.keystore";
    static final String RANGER_POLICYMGR_CLIENT_KEY_FILE_TYPE = "xasecure.policymgr.clientssl.keystore.type";
    static final String RANGER_POLICYMGR_CLIENT_KEY_FILE_CREDENTIAL = "xasecure.policymgr.clientssl.keystore.credential.file";
    static final String RANGER_POLICYMGR_CLIENT_KEY_FILE_CREDENTIAL_ALIAS = "sslKeyStore";
    static final String RANGER_POLICYMGR_CLIENT_KEY_FILE_TYPE_DEFAULT = "jks";
    static final String RANGER_POLICYMGR_TRUSTSTORE_FILE = "xasecure.policymgr.clientssl.truststore";
    static final String RANGER_POLICYMGR_TRUSTSTORE_FILE_TYPE = "xasecure.policymgr.clientssl.truststore.type";
    static final String RANGER_POLICYMGR_TRUSTSTORE_FILE_CREDENTIAL = "xasecure.policymgr.clientssl.truststore.credential.file";
    static final String RANGER_POLICYMGR_TRUSTSTORE_FILE_CREDENTIAL_ALIAS = "sslTrustStore";
    static final String RANGER_POLICYMGR_TRUSTSTORE_FILE_TYPE_DEFAULT = "jks";
    static final String RANGER_SSL_KEYMANAGER_ALGO_TYPE = "SunX509";
    static final String RANGER_SSL_TRUSTMANAGER_ALGO_TYPE = "SunX509";
    static final String RANGER_SSL_CONTEXT_ALGO_TYPE = "SSL";
    private String mKeyStoreURL = null;
    private String mKeyStoreAlias = null;
    private String mKeyStoreFile = null;
    private String mKeyStoreType = null;
    private String mTrustStoreURL = null;
    private String mTrustStoreAlias = null;
    private String mTrustStoreFile = null;
    private String mTrustStoreType = null;
    static final HostnameVerifier _Hv = new HostnameVerifier(){

        @Override
        public boolean verify(String urlHostName, SSLSession session) {
            return session.getPeerHost().equals(urlHostName);
        }
    };
    final String mSslConfigFileName;

    public RangerSslHelper(String sslConfigFileName) {
        this.mSslConfigFileName = sslConfigFileName;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerSslHelper(" + this.mSslConfigFileName + ")"));
        }
    }

    public SSLContext createContext() {
        this.readConfig();
        KeyManager[] kmList = this.getKeyManagers();
        TrustManager[] tmList = this.getTrustManagers();
        SSLContext sslContext = this.getSSLContext(kmList, tmList);
        return sslContext;
    }

    public HostnameVerifier getHostnameVerifier() {
        return _Hv;
    }

    void readConfig() {
        InputStream in = null;
        try {
            Configuration conf = new Configuration();
            in = this.getFileInputStream(this.mSslConfigFileName);
            if (in != null) {
                conf.addResource(in);
            }
            this.mKeyStoreURL = conf.get(RANGER_POLICYMGR_CLIENT_KEY_FILE_CREDENTIAL);
            this.mKeyStoreAlias = RANGER_POLICYMGR_CLIENT_KEY_FILE_CREDENTIAL_ALIAS;
            this.mKeyStoreType = conf.get(RANGER_POLICYMGR_CLIENT_KEY_FILE_TYPE, "jks");
            this.mKeyStoreFile = conf.get(RANGER_POLICYMGR_CLIENT_KEY_FILE);
            this.mTrustStoreURL = conf.get(RANGER_POLICYMGR_TRUSTSTORE_FILE_CREDENTIAL);
            this.mTrustStoreAlias = RANGER_POLICYMGR_TRUSTSTORE_FILE_CREDENTIAL_ALIAS;
            this.mTrustStoreType = conf.get(RANGER_POLICYMGR_TRUSTSTORE_FILE_TYPE, "jks");
            this.mTrustStoreFile = conf.get(RANGER_POLICYMGR_TRUSTSTORE_FILE);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)Objects.toStringHelper((String)"RangerSslHelper").add("keyStoreAlias", (Object)this.mKeyStoreAlias).add("keyStoreFile", (Object)this.mKeyStoreFile).add("keyStoreType", (Object)this.mKeyStoreType).add("keyStoreURL", (Object)this.mKeyStoreURL).add("trustStoreAlias", (Object)this.mTrustStoreAlias).add("trustStoreFile", (Object)this.mTrustStoreFile).add("trustStoreType", (Object)this.mTrustStoreType).add("trustStoreURL", (Object)this.mTrustStoreURL).toString());
            }
            this.close(in, this.mSslConfigFileName);
        }
        catch (IOException ioe) {
            try {
                LOG.error((Object)("Unable to load SSL Config FileName: [" + this.mSslConfigFileName + "]"), (Throwable)ioe);
                this.close(in, this.mSslConfigFileName);
            }
            catch (Throwable throwable) {
                this.close(in, this.mSslConfigFileName);
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeyManager[] getKeyManagers() {
        KeyManager[] kmList = null;
        String keyStoreFilepwd = this.getCredential(this.mKeyStoreURL, this.mKeyStoreAlias);
        if (!StringUtil.isEmpty(this.mKeyStoreFile) && !StringUtil.isEmpty(keyStoreFilepwd)) {
            InputStream in = null;
            try {
                in = this.getFileInputStream(this.mKeyStoreFile);
                if (in != null) {
                    KeyStore keyStore = KeyStore.getInstance(this.mKeyStoreType);
                    keyStore.load(in, keyStoreFilepwd.toCharArray());
                    KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance("SunX509");
                    keyManagerFactory.init(keyStore, keyStoreFilepwd.toCharArray());
                    kmList = keyManagerFactory.getKeyManagers();
                } else {
                    LOG.error((Object)("Unable to obtain keystore from file [" + this.mKeyStoreFile + "]"));
                }
            }
            catch (KeyStoreException e) {
                LOG.error((Object)"Unable to obtain from KeyStore", (Throwable)e);
            }
            catch (NoSuchAlgorithmException e) {
                LOG.error((Object)"SSL algorithm is available in the environment", (Throwable)e);
            }
            catch (CertificateException e) {
                LOG.error((Object)"Unable to obtain the requested certification ", (Throwable)e);
            }
            catch (FileNotFoundException e) {
                LOG.error((Object)"Unable to find the necessary SSL Keystore and TrustStore Files", (Throwable)e);
            }
            catch (IOException e) {
                LOG.error((Object)"Unable to read the necessary SSL Keystore and TrustStore Files", (Throwable)e);
            }
            catch (UnrecoverableKeyException e) {
                LOG.error((Object)"Unable to recover the key from keystore", (Throwable)e);
            }
            finally {
                this.close(in, this.mKeyStoreFile);
            }
        }
        return kmList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TrustManager[] getTrustManagers() {
        TrustManager[] tmList = null;
        String trustStoreFilepwd = this.getCredential(this.mTrustStoreURL, this.mTrustStoreAlias);
        if (!StringUtil.isEmpty(this.mTrustStoreFile) && !StringUtil.isEmpty(trustStoreFilepwd)) {
            InputStream in = null;
            try {
                in = this.getFileInputStream(this.mTrustStoreFile);
                if (in != null) {
                    KeyStore trustStore = KeyStore.getInstance(this.mTrustStoreType);
                    trustStore.load(in, trustStoreFilepwd.toCharArray());
                    TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance("SunX509");
                    trustManagerFactory.init(trustStore);
                    tmList = trustManagerFactory.getTrustManagers();
                } else {
                    LOG.error((Object)("Unable to obtain keystore from file [" + this.mTrustStoreFile + "]"));
                }
            }
            catch (KeyStoreException e) {
                LOG.error((Object)"Unable to obtain from KeyStore", (Throwable)e);
            }
            catch (NoSuchAlgorithmException e) {
                LOG.error((Object)"SSL algorithm is available in the environment", (Throwable)e);
            }
            catch (CertificateException e) {
                LOG.error((Object)"Unable to obtain the requested certification ", (Throwable)e);
            }
            catch (FileNotFoundException e) {
                LOG.error((Object)"Unable to find the necessary SSL Keystore and TrustStore Files", (Throwable)e);
            }
            catch (IOException e) {
                LOG.error((Object)"Unable to read the necessary SSL Keystore and TrustStore Files", (Throwable)e);
            }
            finally {
                this.close(in, this.mTrustStoreFile);
            }
        }
        return tmList;
    }

    private SSLContext getSSLContext(KeyManager[] kmList, TrustManager[] tmList) {
        try {
            if (kmList != null && tmList != null) {
                SSLContext sslContext = SSLContext.getInstance(RANGER_SSL_CONTEXT_ALGO_TYPE);
                sslContext.init(kmList, tmList, new SecureRandom());
                return sslContext;
            }
        }
        catch (NoSuchAlgorithmException e) {
            LOG.error((Object)"SSL algorithm is available in the environment", (Throwable)e);
        }
        catch (KeyManagementException e) {
            LOG.error((Object)"Unable to initialize the SSLContext", (Throwable)e);
        }
        return null;
    }

    private String getCredential(String url, String alias) {
        char[] credStr = RangerCredentialProvider.getInstance().getCredentialString(url, alias);
        return credStr == null ? null : new String(credStr);
    }

    private InputStream getFileInputStream(String fileName) throws IOException {
        InputStream in = null;
        if (!StringUtil.isEmpty(fileName)) {
            File f = new File(fileName);
            in = f.exists() ? new FileInputStream(f) : ClassLoader.getSystemResourceAsStream(fileName);
        }
        return in;
    }

    private void close(InputStream str, String filename) {
        if (str != null) {
            try {
                str.close();
            }
            catch (IOException excp) {
                LOG.error((Object)("Error while closing file: [" + filename + "]"), (Throwable)excp);
            }
        }
    }
}

