/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.admin.client;

import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.WebResource;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.security.PrivilegedAction;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.security.AccessControlException;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.ranger.admin.client.RangerAdminClient;
import org.apache.ranger.admin.client.datatype.RESTResponse;
import org.apache.ranger.audit.provider.MiscUtil;
import org.apache.ranger.authorization.hadoop.config.RangerConfiguration;
import org.apache.ranger.plugin.util.GrantRevokeRequest;
import org.apache.ranger.plugin.util.RangerRESTClient;
import org.apache.ranger.plugin.util.RangerRESTUtils;
import org.apache.ranger.plugin.util.ServicePolicies;
import org.apache.ranger.plugin.util.ServiceTags;

public class RangerAdminRESTClient
implements RangerAdminClient {
    private static final Log LOG = LogFactory.getLog(RangerAdminRESTClient.class);
    private String serviceName = null;
    private String pluginId = null;
    private RangerRESTClient restClient = null;
    private RangerRESTUtils restUtils = new RangerRESTUtils();

    public static <T> GenericType<List<T>> getGenericType(final T clazz) {
        ParameterizedType parameterizedGenericType = new ParameterizedType(){

            @Override
            public Type[] getActualTypeArguments() {
                return new Type[]{clazz.getClass()};
            }

            @Override
            public Type getRawType() {
                return List.class;
            }

            @Override
            public Type getOwnerType() {
                return List.class;
            }
        };
        return new GenericType<List<T>>(parameterizedGenericType){};
    }

    @Override
    public void init(String serviceName, String appId, String propertyPrefix) {
        this.serviceName = serviceName;
        this.pluginId = this.restUtils.getPluginId(serviceName, appId);
        String url = RangerConfiguration.getInstance().get(propertyPrefix + ".policy.rest.url");
        String sslConfigFileName = RangerConfiguration.getInstance().get(propertyPrefix + ".policy.rest.ssl.config.file");
        int restClientConnTimeOutMs = RangerConfiguration.getInstance().getInt(propertyPrefix + ".policy.rest.client.connection.timeoutMs", 120000);
        int restClientReadTimeOutMs = RangerConfiguration.getInstance().getInt(propertyPrefix + ".policy.rest.client.read.timeoutMs", 30000);
        this.init(url, sslConfigFileName, restClientConnTimeOutMs, restClientReadTimeOutMs);
    }

    @Override
    public ServicePolicies getServicePoliciesIfUpdated(final long lastKnownVersion) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerAdminRESTClient.getServicePoliciesIfUpdated(" + lastKnownVersion + ")"));
        }
        ServicePolicies ret = null;
        UserGroupInformation user = MiscUtil.getUGILoginUser();
        boolean isSecureMode = user != null && UserGroupInformation.isSecurityEnabled();
        ClientResponse response = null;
        if (isSecureMode) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Checking Service policy if updated as user : " + user));
            }
            PrivilegedAction<ClientResponse> action = new PrivilegedAction<ClientResponse>(){

                @Override
                public ClientResponse run() {
                    WebResource secureWebResource = RangerAdminRESTClient.this.createWebResource("/service/plugins/secure/policies/download/" + RangerAdminRESTClient.this.serviceName).queryParam("lastKnownVersion", Long.toString(lastKnownVersion)).queryParam("pluginId", RangerAdminRESTClient.this.pluginId);
                    return (ClientResponse)secureWebResource.accept(new String[]{"application/json"}).get(ClientResponse.class);
                }
            };
            response = (ClientResponse)user.doAs((PrivilegedAction)action);
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Checking Service policy if updated with old api call");
            }
            WebResource webResource = this.createWebResource("/service/plugins/policies/download/" + this.serviceName).queryParam("lastKnownVersion", Long.toString(lastKnownVersion)).queryParam("pluginId", this.pluginId);
            response = (ClientResponse)webResource.accept(new String[]{"application/json"}).get(ClientResponse.class);
        }
        if (response != null && response.getStatus() == 200) {
            ret = (ServicePolicies)response.getEntity(ServicePolicies.class);
        } else if (response == null || response.getStatus() != 304) {
            RESTResponse resp = RESTResponse.fromClientResponse(response);
            LOG.error((Object)("Error getting policies. secureMode=" + isSecureMode + ", user=" + user + ", response=" + resp.toString() + ", serviceName=" + this.serviceName));
            throw new Exception(resp.getMessage());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerAdminRESTClient.getServicePoliciesIfUpdated(" + lastKnownVersion + "): " + ret));
        }
        return ret;
    }

    @Override
    public void grantAccess(final GrantRevokeRequest request) throws Exception {
        boolean isSecureMode;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerAdminRESTClient.grantAccess(" + request + ")"));
        }
        ClientResponse response = null;
        UserGroupInformation user = MiscUtil.getUGILoginUser();
        boolean bl = isSecureMode = user != null && UserGroupInformation.isSecurityEnabled();
        if (isSecureMode) {
            PrivilegedAction<ClientResponse> action = new PrivilegedAction<ClientResponse>(){

                @Override
                public ClientResponse run() {
                    WebResource secureWebResource = RangerAdminRESTClient.this.createWebResource("/service/plugins/secure/services/grant/" + RangerAdminRESTClient.this.serviceName).queryParam("pluginId", RangerAdminRESTClient.this.pluginId);
                    return (ClientResponse)((WebResource.Builder)secureWebResource.accept(new String[]{"application/json"}).type("application/json")).post(ClientResponse.class, (Object)RangerAdminRESTClient.this.restClient.toJson(request));
                }
            };
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("grantAccess as user " + user));
            }
            response = (ClientResponse)user.doAs((PrivilegedAction)action);
        } else {
            WebResource webResource = this.createWebResource("/service/plugins/services/grant/" + this.serviceName).queryParam("pluginId", this.pluginId);
            response = (ClientResponse)((WebResource.Builder)webResource.accept(new String[]{"application/json"}).type("application/json")).post(ClientResponse.class, (Object)this.restClient.toJson(request));
        }
        if (response != null && response.getStatus() != 200) {
            RESTResponse resp = RESTResponse.fromClientResponse(response);
            LOG.error((Object)("grantAccess() failed: HTTP status=" + response.getStatus() + ", message=" + resp.getMessage() + ", isSecure=" + isSecureMode + (isSecureMode ? ", user=" + user : "")));
            if (response.getStatus() == 401) {
                throw new AccessControlException();
            }
            throw new Exception("HTTP " + response.getStatus() + " Error: " + resp.getMessage());
        }
        if (response == null) {
            throw new Exception("unknown error during grantAccess. serviceName=" + this.serviceName);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerAdminRESTClient.grantAccess(" + request + ")"));
        }
    }

    @Override
    public void revokeAccess(final GrantRevokeRequest request) throws Exception {
        boolean isSecureMode;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerAdminRESTClient.revokeAccess(" + request + ")"));
        }
        ClientResponse response = null;
        UserGroupInformation user = MiscUtil.getUGILoginUser();
        boolean bl = isSecureMode = user != null && UserGroupInformation.isSecurityEnabled();
        if (isSecureMode) {
            PrivilegedAction<ClientResponse> action = new PrivilegedAction<ClientResponse>(){

                @Override
                public ClientResponse run() {
                    WebResource secureWebResource = RangerAdminRESTClient.this.createWebResource("/service/plugins/secure/services/revoke/" + RangerAdminRESTClient.this.serviceName).queryParam("pluginId", RangerAdminRESTClient.this.pluginId);
                    return (ClientResponse)((WebResource.Builder)secureWebResource.accept(new String[]{"application/json"}).type("application/json")).post(ClientResponse.class, (Object)RangerAdminRESTClient.this.restClient.toJson(request));
                }
            };
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("revokeAccess as user " + user));
            }
            response = (ClientResponse)user.doAs((PrivilegedAction)action);
        } else {
            WebResource webResource = this.createWebResource("/service/plugins/services/revoke/" + this.serviceName).queryParam("pluginId", this.pluginId);
            response = (ClientResponse)((WebResource.Builder)webResource.accept(new String[]{"application/json"}).type("application/json")).post(ClientResponse.class, (Object)this.restClient.toJson(request));
        }
        if (response != null && response.getStatus() != 200) {
            RESTResponse resp = RESTResponse.fromClientResponse(response);
            LOG.error((Object)("revokeAccess() failed: HTTP status=" + response.getStatus() + ", message=" + resp.getMessage() + ", isSecure=" + isSecureMode + (isSecureMode ? ", user=" + user : "")));
            if (response.getStatus() == 401) {
                throw new AccessControlException();
            }
            throw new Exception("HTTP " + response.getStatus() + " Error: " + resp.getMessage());
        }
        if (response == null) {
            throw new Exception("unknown error. revokeAccess(). serviceName=" + this.serviceName);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerAdminRESTClient.revokeAccess(" + request + ")"));
        }
    }

    private void init(String url, String sslConfigFileName, int restClientConnTimeOutMs, int restClientReadTimeOutMs) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerAdminRESTClient.init(" + url + ", " + sslConfigFileName + ")"));
        }
        this.restClient = new RangerRESTClient(url, sslConfigFileName);
        this.restClient.setRestClientConnTimeOutMs(restClientConnTimeOutMs);
        this.restClient.setRestClientReadTimeOutMs(restClientReadTimeOutMs);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerAdminRESTClient.init(" + url + ", " + sslConfigFileName + ")"));
        }
    }

    private WebResource createWebResource(String url) {
        WebResource ret = this.restClient.getResource(url);
        return ret;
    }

    @Override
    public ServiceTags getServiceTagsIfUpdated(final long lastKnownVersion) throws Exception {
        boolean isSecureMode;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerAdminRESTClient.getServiceTagsIfUpdated(" + lastKnownVersion + "): "));
        }
        ServiceTags ret = null;
        ClientResponse response = null;
        WebResource webResource = null;
        UserGroupInformation user = MiscUtil.getUGILoginUser();
        boolean bl = isSecureMode = user != null && UserGroupInformation.isSecurityEnabled();
        if (isSecureMode) {
            PrivilegedAction<ClientResponse> action = new PrivilegedAction<ClientResponse>(){

                @Override
                public ClientResponse run() {
                    WebResource secureWebResource = RangerAdminRESTClient.this.createWebResource("/service/tags/secure/download/" + RangerAdminRESTClient.this.serviceName).queryParam("lastKnownVersion", Long.toString(lastKnownVersion)).queryParam("pluginId", RangerAdminRESTClient.this.pluginId);
                    return (ClientResponse)secureWebResource.accept(new String[]{"application/json"}).get(ClientResponse.class);
                }
            };
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("getServiceTagsIfUpdated as user " + user));
            }
            response = (ClientResponse)user.doAs((PrivilegedAction)action);
        } else {
            webResource = this.createWebResource("/service/tags/download/" + this.serviceName).queryParam("lastKnownVersion", Long.toString(lastKnownVersion)).queryParam("pluginId", this.pluginId);
            response = (ClientResponse)webResource.accept(new String[]{"application/json"}).get(ClientResponse.class);
        }
        if (response != null && response.getStatus() == 200) {
            ret = (ServiceTags)response.getEntity(ServiceTags.class);
        } else if (response == null || response.getStatus() != 304) {
            RESTResponse resp = RESTResponse.fromClientResponse(response);
            LOG.error((Object)("Error getting taggedResources. secureMode=" + isSecureMode + ", user=" + user + ", response=" + resp.toString() + ", serviceName=" + this.serviceName + ", lastKnownVersion=" + lastKnownVersion));
            throw new Exception(resp.getMessage());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerAdminRESTClient.getServiceTagsIfUpdated(" + lastKnownVersion + "): "));
        }
        return ret;
    }

    @Override
    public List<String> getTagTypes(String pattern) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerAdminRESTClient.getTagTypes(" + pattern + "): "));
        }
        List ret = null;
        String emptyString = "";
        UserGroupInformation user = MiscUtil.getUGILoginUser();
        boolean isSecureMode = user != null && UserGroupInformation.isSecurityEnabled();
        final WebResource webResource = this.createWebResource("/service/tags/lookup").queryParam("serviceName", this.serviceName).queryParam("pattern", pattern);
        ClientResponse response = null;
        if (isSecureMode) {
            PrivilegedAction<ClientResponse> action = new PrivilegedAction<ClientResponse>(){

                @Override
                public ClientResponse run() {
                    return (ClientResponse)webResource.accept(new String[]{"application/json"}).get(ClientResponse.class);
                }
            };
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("getTagTypes as user " + user));
            }
            response = (ClientResponse)user.doAs((PrivilegedAction)action);
        } else {
            response = (ClientResponse)webResource.accept(new String[]{"application/json"}).get(ClientResponse.class);
        }
        if (response == null || response.getStatus() != 200) {
            RESTResponse resp = RESTResponse.fromClientResponse(response);
            LOG.error((Object)("Error getting taggedResources. request=" + webResource.toString() + ", response=" + resp.toString() + ", serviceName=" + this.serviceName + ", pattern=" + pattern));
            throw new Exception(resp.getMessage());
        }
        ret = (List)response.getEntity(RangerAdminRESTClient.getGenericType(emptyString));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerAdminRESTClient.getTagTypes(" + pattern + "): " + ret));
        }
        return ret;
    }
}

