/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.policyengine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ranger.authorization.hadoop.config.RangerConfiguration;
import org.apache.ranger.plugin.contextenricher.RangerContextEnricher;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.policyengine.CacheMap;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerAccessResource;
import org.apache.ranger.plugin.policyengine.RangerAccessResult;
import org.apache.ranger.plugin.policyengine.RangerPolicyEngineOptions;
import org.apache.ranger.plugin.policyevaluator.RangerCachedPolicyEvaluator;
import org.apache.ranger.plugin.policyevaluator.RangerOptimizedPolicyEvaluator;
import org.apache.ranger.plugin.policyevaluator.RangerPolicyEvaluator;
import org.apache.ranger.plugin.util.RangerPerfTracer;
import org.apache.ranger.plugin.util.RangerResourceTrie;
import org.apache.ranger.plugin.util.ServiceDefUtil;
import org.apache.ranger.plugin.util.ServicePolicies;

class RangerPolicyRepository {
    private static final Log LOG = LogFactory.getLog(RangerPolicyRepository.class);
    private static final Log PERF_CONTEXTENRICHER_INIT_LOG = RangerPerfTracer.getPerfLogger("contextenricher.init");
    private final String serviceName;
    private final String appId;
    private final RangerServiceDef serviceDef;
    private final List<RangerPolicy> policies;
    private final long policyVersion;
    private List<RangerContextEnricher> contextEnrichers;
    private List<RangerPolicyEvaluator> policyEvaluators;
    private List<RangerPolicyEvaluator> dataMaskPolicyEvaluators;
    private List<RangerPolicyEvaluator> rowFilterPolicyEvaluators;
    private final AuditModeEnum auditModeEnum;
    private final Map<String, AuditInfo> accessAuditCache;
    private final String componentServiceName;
    private final RangerServiceDef componentServiceDef;
    private final Map<String, RangerResourceTrie> policyResourceTrie;
    private final Map<String, RangerResourceTrie> dataMaskResourceTrie;
    private final Map<String, RangerResourceTrie> rowFilterResourceTrie;

    RangerPolicyRepository(String appId, ServicePolicies servicePolicies, RangerPolicyEngineOptions options) {
        String auditMode;
        this.componentServiceName = this.serviceName = servicePolicies.getServiceName();
        this.componentServiceDef = this.serviceDef = ServiceDefUtil.normalize(servicePolicies.getServiceDef());
        this.appId = appId;
        this.policies = Collections.unmodifiableList(servicePolicies.getPolicies());
        long l = this.policyVersion = servicePolicies.getPolicyVersion() != null ? servicePolicies.getPolicyVersion() : -1L;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("RangerPolicyRepository : building resource-policy-repository for service " + this.serviceName));
        }
        this.auditModeEnum = StringUtils.equals((String)(auditMode = servicePolicies.getAuditMode()), (String)"audit-all") ? AuditModeEnum.AUDIT_ALL : (StringUtils.equals((String)auditMode, (String)"audit-none") ? AuditModeEnum.AUDIT_NONE : AuditModeEnum.AUDIT_DEFAULT);
        if (this.auditModeEnum == AuditModeEnum.AUDIT_DEFAULT) {
            String propertyName = "ranger.plugin." + this.serviceName + ".policyengine.auditcachesize";
            if (options.cacheAuditResults) {
                int RANGER_POLICYENGINE_AUDITRESULT_CACHE_SIZE = 65536;
                int auditResultCacheSize = RangerConfiguration.getInstance().getInt(propertyName, 65536);
                this.accessAuditCache = Collections.synchronizedMap(new CacheMap(auditResultCacheSize));
            } else {
                this.accessAuditCache = null;
            }
        } else {
            this.accessAuditCache = null;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("RangerPolicyRepository : building policy-repository for service[" + this.serviceName + "] with auditMode[" + (Object)((Object)this.auditModeEnum) + "]"));
        }
        this.init(options);
        if (options.disableTrieLookupPrefilter) {
            this.policyResourceTrie = null;
            this.dataMaskResourceTrie = null;
            this.rowFilterResourceTrie = null;
        } else {
            this.policyResourceTrie = this.createResourceTrieMap(this.policyEvaluators);
            this.dataMaskResourceTrie = this.createResourceTrieMap(this.dataMaskPolicyEvaluators);
            this.rowFilterResourceTrie = this.createResourceTrieMap(this.rowFilterPolicyEvaluators);
        }
    }

    RangerPolicyRepository(String appId, ServicePolicies.TagPolicies tagPolicies, RangerPolicyEngineOptions options, RangerServiceDef componentServiceDef, String componentServiceName) {
        this.serviceName = tagPolicies.getServiceName();
        this.componentServiceName = componentServiceName;
        this.serviceDef = this.normalizeAccessTypeDefs(ServiceDefUtil.normalize(tagPolicies.getServiceDef()), componentServiceDef.getName());
        this.componentServiceDef = componentServiceDef;
        this.appId = appId;
        this.policies = Collections.unmodifiableList(this.normalizeAndPrunePolicies(tagPolicies.getPolicies(), componentServiceDef.getName()));
        this.policyVersion = tagPolicies.getPolicyVersion() != null ? tagPolicies.getPolicyVersion() : -1L;
        String auditMode = tagPolicies.getAuditMode();
        this.auditModeEnum = StringUtils.equals((String)auditMode, (String)"audit-all") ? AuditModeEnum.AUDIT_ALL : (StringUtils.equals((String)auditMode, (String)"audit-none") ? AuditModeEnum.AUDIT_NONE : AuditModeEnum.AUDIT_DEFAULT);
        this.accessAuditCache = null;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("RangerPolicyRepository : building tag-policy-repository for tag service[" + this.serviceName + "] with auditMode[" + (Object)((Object)this.auditModeEnum) + "]"));
        }
        this.init(options);
        if (options.disableTrieLookupPrefilter) {
            this.policyResourceTrie = null;
            this.dataMaskResourceTrie = null;
            this.rowFilterResourceTrie = null;
        } else {
            this.policyResourceTrie = this.createResourceTrieMap(this.policyEvaluators);
            this.dataMaskResourceTrie = this.createResourceTrieMap(this.dataMaskPolicyEvaluators);
            this.rowFilterResourceTrie = this.createResourceTrieMap(this.rowFilterPolicyEvaluators);
        }
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public RangerServiceDef getServiceDef() {
        return this.serviceDef;
    }

    public List<RangerPolicy> getPolicies() {
        return this.policies;
    }

    public long getPolicyVersion() {
        return this.policyVersion;
    }

    public List<RangerContextEnricher> getContextEnrichers() {
        return this.contextEnrichers;
    }

    List<RangerPolicyEvaluator> getPolicyEvaluators() {
        return this.policyEvaluators;
    }

    List<RangerPolicyEvaluator> getPolicyEvaluators(RangerAccessResource resource) {
        String resourceStr = resource == null ? null : resource.getAsString();
        return this.policyResourceTrie == null || StringUtils.isEmpty((String)resourceStr) ? this.getPolicyEvaluators() : this.getPolicyEvaluators(this.policyResourceTrie, resource);
    }

    List<RangerPolicyEvaluator> getDataMaskPolicyEvaluators() {
        return this.dataMaskPolicyEvaluators;
    }

    List<RangerPolicyEvaluator> getDataMaskPolicyEvaluators(RangerAccessResource resource) {
        String resourceStr = resource == null ? null : resource.getAsString();
        return this.dataMaskResourceTrie == null || StringUtils.isEmpty((String)resourceStr) ? this.getDataMaskPolicyEvaluators() : this.getPolicyEvaluators(this.dataMaskResourceTrie, resource);
    }

    List<RangerPolicyEvaluator> getRowFilterPolicyEvaluators() {
        return this.rowFilterPolicyEvaluators;
    }

    List<RangerPolicyEvaluator> getRowFilterPolicyEvaluators(RangerAccessResource resource) {
        String resourceStr = resource == null ? null : resource.getAsString();
        return this.rowFilterResourceTrie == null || StringUtils.isEmpty((String)resourceStr) ? this.getRowFilterPolicyEvaluators() : this.getPolicyEvaluators(this.rowFilterResourceTrie, resource);
    }

    AuditModeEnum getAuditModeEnum() {
        return this.auditModeEnum;
    }

    private List<RangerPolicyEvaluator> getPolicyEvaluators(Map<String, RangerResourceTrie> resourceTrie, RangerAccessResource resource) {
        Set<String> resourceKeys;
        List<RangerPolicyEvaluator> ret = null;
        Set<String> set = resourceKeys = resource == null ? null : resource.getKeys();
        if (CollectionUtils.isNotEmpty(resourceKeys)) {
            boolean isRetModifiable = false;
            for (String resourceName : resourceKeys) {
                RangerResourceTrie trie = resourceTrie.get(resourceName);
                if (trie == null) continue;
                List resourceEvaluators = trie.getEvaluatorsForResource(resource.getValue(resourceName));
                if (CollectionUtils.isEmpty(resourceEvaluators)) {
                    ret = null;
                } else if (ret == null) {
                    ret = resourceEvaluators;
                } else if (isRetModifiable) {
                    ret.retainAll(resourceEvaluators);
                } else {
                    List<Object> longerList;
                    List<RangerPolicyEvaluator> shorterList;
                    if (ret.size() < resourceEvaluators.size()) {
                        shorterList = ret;
                        longerList = resourceEvaluators;
                    } else {
                        shorterList = resourceEvaluators;
                        longerList = ret;
                    }
                    ret = new ArrayList<RangerPolicyEvaluator>(shorterList);
                    ret.retainAll(longerList);
                    isRetModifiable = true;
                }
                if (!CollectionUtils.isEmpty(ret)) continue;
                ret = null;
                break;
            }
        }
        if (ret == null) {
            ret = Collections.emptyList();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerPolicyRepository.getPolicyEvaluators(" + resource.getAsString() + "): evaluatorCount=" + ret.size()));
        }
        return ret;
    }

    private RangerServiceDef normalizeAccessTypeDefs(RangerServiceDef serviceDef, String componentType) {
        List<RangerServiceDef.RangerAccessTypeDef> accessTypeDefs;
        if (serviceDef != null && StringUtils.isNotBlank((String)componentType) && CollectionUtils.isNotEmpty(accessTypeDefs = serviceDef.getAccessTypes())) {
            String prefix = componentType + ":";
            ArrayList<RangerServiceDef.RangerAccessTypeDef> unneededAccessTypeDefs = null;
            for (RangerServiceDef.RangerAccessTypeDef accessTypeDef : accessTypeDefs) {
                String accessType = accessTypeDef.getName();
                if (StringUtils.startsWith((String)accessType, (String)prefix)) {
                    String newAccessType = StringUtils.removeStart((String)accessType, (String)prefix);
                    accessTypeDef.setName(newAccessType);
                    Collection<String> impliedGrants = accessTypeDef.getImpliedGrants();
                    if (!CollectionUtils.isNotEmpty(impliedGrants)) continue;
                    ArrayList<String> newImpliedGrants = null;
                    for (String impliedGrant : impliedGrants) {
                        if (!StringUtils.startsWith((String)impliedGrant, (String)prefix)) continue;
                        String newImpliedGrant = StringUtils.removeStart((String)impliedGrant, (String)prefix);
                        if (newImpliedGrants == null) {
                            newImpliedGrants = new ArrayList<String>();
                        }
                        newImpliedGrants.add(newImpliedGrant);
                    }
                    accessTypeDef.setImpliedGrants(newImpliedGrants);
                    continue;
                }
                if (!StringUtils.contains((String)accessType, (String)":")) continue;
                if (unneededAccessTypeDefs == null) {
                    unneededAccessTypeDefs = new ArrayList<RangerServiceDef.RangerAccessTypeDef>();
                }
                unneededAccessTypeDefs.add(accessTypeDef);
            }
            if (unneededAccessTypeDefs != null) {
                accessTypeDefs.removeAll(unneededAccessTypeDefs);
            }
        }
        return serviceDef;
    }

    private List<RangerPolicy> normalizeAndPrunePolicies(List<RangerPolicy> rangerPolicies, String componentType) {
        if (CollectionUtils.isNotEmpty(rangerPolicies) && StringUtils.isNotBlank((String)componentType)) {
            ArrayList<RangerPolicy> policiesToPrune = null;
            for (RangerPolicy policy : rangerPolicies) {
                this.normalizeAndPrunePolicyItems(policy.getPolicyItems(), componentType);
                this.normalizeAndPrunePolicyItems(policy.getDenyPolicyItems(), componentType);
                this.normalizeAndPrunePolicyItems(policy.getAllowExceptions(), componentType);
                this.normalizeAndPrunePolicyItems(policy.getDenyExceptions(), componentType);
                this.normalizeAndPrunePolicyItems(policy.getDataMaskPolicyItems(), componentType);
                if (policy.getIsAuditEnabled().booleanValue() || !CollectionUtils.isEmpty(policy.getPolicyItems()) || !CollectionUtils.isEmpty(policy.getDenyPolicyItems()) || !CollectionUtils.isEmpty(policy.getAllowExceptions()) || !CollectionUtils.isEmpty(policy.getDenyExceptions()) || !CollectionUtils.isEmpty(policy.getDataMaskPolicyItems())) continue;
                if (policiesToPrune == null) {
                    policiesToPrune = new ArrayList<RangerPolicy>();
                }
                policiesToPrune.add(policy);
            }
            if (policiesToPrune != null) {
                rangerPolicies.removeAll(policiesToPrune);
            }
        }
        return rangerPolicies;
    }

    private List<? extends RangerPolicy.RangerPolicyItem> normalizeAndPrunePolicyItems(List<? extends RangerPolicy.RangerPolicyItem> policyItems, String componentType) {
        if (CollectionUtils.isNotEmpty(policyItems)) {
            String prefix = componentType + ":";
            ArrayList<RangerPolicy.RangerPolicyItem> itemsToPrune = null;
            for (RangerPolicy.RangerPolicyItem rangerPolicyItem : policyItems) {
                List<RangerPolicy.RangerPolicyItemAccess> policyItemAccesses = rangerPolicyItem.getAccesses();
                if (!CollectionUtils.isNotEmpty(policyItemAccesses)) continue;
                ArrayList<RangerPolicy.RangerPolicyItemAccess> accessesToPrune = null;
                for (RangerPolicy.RangerPolicyItemAccess access : policyItemAccesses) {
                    String accessType = access.getType();
                    if (StringUtils.startsWith((String)accessType, (String)prefix)) {
                        String newAccessType = StringUtils.removeStart((String)accessType, (String)prefix);
                        access.setType(newAccessType);
                        continue;
                    }
                    if (!accessType.contains(":")) continue;
                    if (accessesToPrune == null) {
                        accessesToPrune = new ArrayList<RangerPolicy.RangerPolicyItemAccess>();
                    }
                    accessesToPrune.add(access);
                }
                if (accessesToPrune != null) {
                    policyItemAccesses.removeAll(accessesToPrune);
                }
                if (!policyItemAccesses.isEmpty() || rangerPolicyItem.getDelegateAdmin().booleanValue()) continue;
                if (itemsToPrune == null) {
                    itemsToPrune = new ArrayList<RangerPolicy.RangerPolicyItem>();
                }
                itemsToPrune.add(rangerPolicyItem);
            }
            if (itemsToPrune != null) {
                policyItems.removeAll(itemsToPrune);
            }
        }
        return policyItems;
    }

    private static boolean isDelegateAdminPolicy(RangerPolicy policy) {
        boolean ret = RangerPolicyRepository.hasDelegateAdminItems(policy.getPolicyItems()) || RangerPolicyRepository.hasDelegateAdminItems(policy.getDenyPolicyItems()) || RangerPolicyRepository.hasDelegateAdminItems(policy.getAllowExceptions()) || RangerPolicyRepository.hasDelegateAdminItems(policy.getDenyExceptions());
        return ret;
    }

    private static boolean hasDelegateAdminItems(List<RangerPolicy.RangerPolicyItem> items) {
        boolean ret = false;
        if (CollectionUtils.isNotEmpty(items)) {
            for (RangerPolicy.RangerPolicyItem item : items) {
                if (!item.getDelegateAdmin().booleanValue()) continue;
                ret = true;
                break;
            }
        }
        return ret;
    }

    private static boolean skipBuildingPolicyEvaluator(RangerPolicy policy, RangerPolicyEngineOptions options) {
        boolean ret = false;
        if (!policy.getIsEnabled().booleanValue()) {
            ret = true;
        } else if (options.evaluateDelegateAdminOnly && !RangerPolicyRepository.isDelegateAdminPolicy(policy)) {
            ret = true;
        }
        return ret;
    }

    /*
     * WARNING - void declaration
     */
    private void init(RangerPolicyEngineOptions options) {
        ArrayList<RangerPolicyEvaluator> policyEvaluators = new ArrayList<RangerPolicyEvaluator>();
        ArrayList<RangerPolicyEvaluator> dataMaskPolicyEvaluators = new ArrayList<RangerPolicyEvaluator>();
        ArrayList<RangerPolicyEvaluator> rowFilterPolicyEvaluators = new ArrayList<RangerPolicyEvaluator>();
        for (RangerPolicy rangerPolicy : this.policies) {
            RangerPolicyEvaluator evaluator;
            if (RangerPolicyRepository.skipBuildingPolicyEvaluator(rangerPolicy, options) || (evaluator = this.buildPolicyEvaluator(rangerPolicy, this.serviceDef, options)) == null) continue;
            if (rangerPolicy.getPolicyType() == null || rangerPolicy.getPolicyType() == 0) {
                policyEvaluators.add(evaluator);
                continue;
            }
            if (rangerPolicy.getPolicyType() == 1) {
                dataMaskPolicyEvaluators.add(evaluator);
                continue;
            }
            if (rangerPolicy.getPolicyType() == 2) {
                rowFilterPolicyEvaluators.add(evaluator);
                continue;
            }
            LOG.warn((Object)("RangerPolicyEngine: ignoring policy id=" + rangerPolicy.getId() + " - invalid policyType '" + rangerPolicy.getPolicyType() + "'"));
        }
        Collections.sort(policyEvaluators);
        this.policyEvaluators = Collections.unmodifiableList(policyEvaluators);
        Collections.sort(dataMaskPolicyEvaluators);
        this.dataMaskPolicyEvaluators = Collections.unmodifiableList(dataMaskPolicyEvaluators);
        Collections.sort(rowFilterPolicyEvaluators);
        this.rowFilterPolicyEvaluators = Collections.unmodifiableList(rowFilterPolicyEvaluators);
        ArrayList<RangerContextEnricher> contextEnrichers = new ArrayList<RangerContextEnricher>();
        if (CollectionUtils.isNotEmpty(this.policyEvaluators) && !options.disableContextEnrichers && !CollectionUtils.isEmpty(this.serviceDef.getContextEnrichers())) {
            for (RangerServiceDef.RangerContextEnricherDef enricherDef : this.serviceDef.getContextEnrichers()) {
                RangerContextEnricher contextEnricher;
                if (enricherDef == null || (contextEnricher = this.buildContextEnricher(enricherDef)) == null) continue;
                contextEnrichers.add(contextEnricher);
            }
        }
        this.contextEnrichers = Collections.unmodifiableList(contextEnrichers);
        if (LOG.isDebugEnabled()) {
            RangerPolicy policy;
            LOG.debug((Object)("policy evaluation order: " + this.policyEvaluators.size() + " policies"));
            boolean bl = false;
            for (RangerPolicyEvaluator policyEvaluator : this.policyEvaluators) {
                void var6_10;
                policy = policyEvaluator.getPolicy();
                LOG.debug((Object)("policy evaluation order: #" + (int)(++var6_10) + " - policy id=" + policy.getId() + "; name=" + policy.getName() + "; evalOrder=" + policyEvaluator.getEvalOrder()));
            }
            LOG.debug((Object)("dataMask policy evaluation order: " + this.dataMaskPolicyEvaluators.size() + " policies"));
            boolean bl2 = false;
            for (RangerPolicyEvaluator policyEvaluator : this.dataMaskPolicyEvaluators) {
                void var6_12;
                policy = policyEvaluator.getPolicy();
                LOG.debug((Object)("dataMask policy evaluation order: #" + (int)(++var6_12) + " - policy id=" + policy.getId() + "; name=" + policy.getName() + "; evalOrder=" + policyEvaluator.getEvalOrder()));
            }
            LOG.debug((Object)("rowFilter policy evaluation order: " + this.dataMaskPolicyEvaluators.size() + " policies"));
            boolean bl3 = false;
            for (RangerPolicyEvaluator policyEvaluator : this.rowFilterPolicyEvaluators) {
                void var6_14;
                policy = policyEvaluator.getPolicy();
                LOG.debug((Object)("rowFilter policy evaluation order: #" + (int)(++var6_14) + " - policy id=" + policy.getId() + "; name=" + policy.getName() + "; evalOrder=" + policyEvaluator.getEvalOrder()));
            }
        }
    }

    private RangerContextEnricher buildContextEnricher(RangerServiceDef.RangerContextEnricherDef enricherDef) {
        String clsName;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerPolicyRepository.buildContextEnricher(" + enricherDef + ")"));
        }
        RangerContextEnricher ret = null;
        RangerPerfTracer perf = null;
        if (RangerPerfTracer.isPerfTraceEnabled(PERF_CONTEXTENRICHER_INIT_LOG)) {
            perf = RangerPerfTracer.getPerfTracer(PERF_CONTEXTENRICHER_INIT_LOG, "RangerContextEnricher.init(appId=" + this.appId + ",name=" + enricherDef.getName() + ")");
        }
        String name = enricherDef != null ? enricherDef.getName() : null;
        String string = clsName = enricherDef != null ? enricherDef.getEnricher() : null;
        if (!StringUtils.isEmpty((String)clsName)) {
            try {
                Class<?> enricherClass = Class.forName(clsName);
                ret = (RangerContextEnricher)enricherClass.newInstance();
            }
            catch (Exception excp) {
                LOG.error((Object)("failed to instantiate context enricher '" + clsName + "' for '" + name + "'"), (Throwable)excp);
            }
        }
        if (ret != null) {
            ret.setEnricherDef(enricherDef);
            ret.setServiceName(this.componentServiceName);
            ret.setServiceDef(this.componentServiceDef);
            ret.setAppId(this.appId);
            ret.init();
        }
        RangerPerfTracer.log(perf);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerPolicyRepository.buildContextEnricher(" + enricherDef + "): " + ret));
        }
        return ret;
    }

    private RangerPolicyEvaluator buildPolicyEvaluator(RangerPolicy policy, RangerServiceDef serviceDef, RangerPolicyEngineOptions options) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerPolicyRepository.buildPolicyEvaluator(" + policy + "," + serviceDef + ", " + options + ")"));
        }
        this.scrubPolicy(policy);
        RangerOptimizedPolicyEvaluator ret = StringUtils.equalsIgnoreCase((String)options.evaluatorType, (String)"cached") ? new RangerCachedPolicyEvaluator() : new RangerOptimizedPolicyEvaluator();
        ret.init(policy, serviceDef, options);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerPolicyRepository.buildPolicyEvaluator(" + policy + "," + serviceDef + "): " + ret));
        }
        return ret;
    }

    boolean setAuditEnabledFromCache(RangerAccessRequest request, RangerAccessResult result) {
        AuditInfo auditInfo;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerPolicyRepository.setAuditEnabledFromCache()");
        }
        AuditInfo auditInfo2 = auditInfo = this.accessAuditCache != null ? this.accessAuditCache.get(request.getResource().getAsString()) : null;
        if (auditInfo != null) {
            result.setIsAudited(auditInfo.getIsAudited());
            result.setAuditPolicyId(auditInfo.getAuditPolicyId());
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerPolicyRepository.setAuditEnabledFromCache():" + (auditInfo != null)));
        }
        return auditInfo != null;
    }

    void storeAuditEnabledInCache(RangerAccessRequest request, RangerAccessResult result) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerPolicyRepository.storeAuditEnabledInCache()");
        }
        if (this.accessAuditCache != null && result.getIsAuditedDetermined()) {
            this.accessAuditCache.put(request.getResource().getAsString(), new AuditInfo(result.getIsAudited(), result.getAuditPolicyId()));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerPolicyRepository.storeAuditEnabledInCache()");
        }
    }

    private boolean scrubPolicy(RangerPolicy policy) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerPolicyRepository.scrubPolicy(" + policy + ")"));
        }
        boolean altered = false;
        Long policyId = policy.getId();
        Map<String, RangerPolicy.RangerPolicyResource> resourceMap = policy.getResources();
        for (Map.Entry<String, RangerPolicy.RangerPolicyResource> entry : resourceMap.entrySet()) {
            String resourceName = entry.getKey();
            RangerPolicy.RangerPolicyResource resource = entry.getValue();
            Iterator<String> iterator = resource.getValues().iterator();
            while (iterator.hasNext()) {
                String value = iterator.next();
                if (value != null) continue;
                LOG.warn((Object)("RangerPolicyRepository.scrubPolicyResource: found null resource value for " + resourceName + " in policy " + policyId + "!  Removing..."));
                iterator.remove();
                altered = true;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerPolicyRepository.scrubPolicy(" + policy + "): " + altered));
        }
        return altered;
    }

    void reorderPolicyEvaluators() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> reorderEvaluators()");
        }
        if (this.policyResourceTrie != null) {
            this.reorderPolicyEvaluators(this.policyResourceTrie);
        } else {
            this.policyEvaluators = this.getReorderedPolicyEvaluators(this.policyEvaluators);
        }
        if (this.dataMaskResourceTrie != null) {
            this.reorderPolicyEvaluators(this.dataMaskResourceTrie);
        } else {
            this.dataMaskPolicyEvaluators = this.getReorderedPolicyEvaluators(this.dataMaskPolicyEvaluators);
        }
        if (this.rowFilterResourceTrie != null) {
            this.reorderPolicyEvaluators(this.rowFilterResourceTrie);
        } else {
            this.rowFilterPolicyEvaluators = this.getReorderedPolicyEvaluators(this.rowFilterPolicyEvaluators);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== reorderEvaluators()");
        }
    }

    private void reorderPolicyEvaluators(Map<String, RangerResourceTrie> trieMap) {
        if (trieMap != null) {
            for (Map.Entry<String, RangerResourceTrie> entry : trieMap.entrySet()) {
                RangerResourceTrie trie = entry.getValue();
                if (trie == null) continue;
                trie.reorderEvaluators();
            }
        }
    }

    private List<RangerPolicyEvaluator> getReorderedPolicyEvaluators(List<RangerPolicyEvaluator> evaluators) {
        List<RangerPolicyEvaluator> ret = evaluators;
        if (CollectionUtils.isNotEmpty(evaluators)) {
            ret = new ArrayList<RangerPolicyEvaluator>(evaluators);
            Collections.sort(ret);
            ret = Collections.unmodifiableList(ret);
        }
        return ret;
    }

    private Map<String, RangerResourceTrie> createResourceTrieMap(List<RangerPolicyEvaluator> evaluators) {
        HashMap<String, RangerResourceTrie<RangerPolicyEvaluator>> ret;
        if (CollectionUtils.isNotEmpty(evaluators) && this.serviceDef != null && CollectionUtils.isNotEmpty(this.serviceDef.getResources())) {
            ret = new HashMap<String, RangerResourceTrie<RangerPolicyEvaluator>>();
            for (RangerServiceDef.RangerResourceDef resourceDef : this.serviceDef.getResources()) {
                ret.put(resourceDef.getName(), new RangerResourceTrie<RangerPolicyEvaluator>(resourceDef, evaluators));
            }
        } else {
            ret = null;
        }
        return ret;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.toString(sb);
        return sb.toString();
    }

    public StringBuilder toString(StringBuilder sb) {
        sb.append("RangerPolicyRepository={");
        sb.append("serviceName={").append(this.serviceName).append("} ");
        sb.append("serviceDef={").append(this.serviceDef).append("} ");
        sb.append("appId={").append(this.appId).append("} ");
        sb.append("policyEvaluators={");
        if (this.policyEvaluators != null) {
            for (RangerPolicyEvaluator policyEvaluator : this.policyEvaluators) {
                if (policyEvaluator == null) continue;
                sb.append(policyEvaluator).append(" ");
            }
        }
        if (this.contextEnrichers != null) {
            for (RangerContextEnricher contextEnricher : this.contextEnrichers) {
                if (contextEnricher == null) continue;
                sb.append(contextEnricher).append(" ");
            }
        }
        sb.append("} ");
        return sb;
    }

    private static final class AuditInfo {
        final boolean isAudited;
        final long auditPolicyId;

        AuditInfo() {
            this(false, -1L);
        }

        AuditInfo(boolean isAudited, long auditPolicyId) {
            this.isAudited = isAudited;
            this.auditPolicyId = auditPolicyId;
        }

        long getAuditPolicyId() {
            return this.auditPolicyId;
        }

        boolean getIsAudited() {
            return this.isAudited;
        }
    }

    static enum AuditModeEnum {
        AUDIT_ALL,
        AUDIT_NONE,
        AUDIT_DEFAULT;

    }
}

