/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.policyevaluator;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ranger.plugin.model.RangerPolicy;
import org.apache.ranger.plugin.model.RangerServiceDef;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.apache.ranger.plugin.policyengine.RangerPolicyEngineOptions;
import org.apache.ranger.plugin.policyevaluator.RangerDefaultPolicyEvaluator;

public class RangerOptimizedPolicyEvaluator
extends RangerDefaultPolicyEvaluator {
    private static final Log LOG = LogFactory.getLog(RangerOptimizedPolicyEvaluator.class);
    private Set<String> groups = new HashSet<String>();
    private Set<String> users = new HashSet<String>();
    private Set<String> accessPerms = new HashSet<String>();
    private boolean delegateAdmin = false;
    private boolean hasAllPerms = false;
    private boolean hasPublicGroup = false;
    private static final String RANGER_POLICY_EVAL_MATCH_ANY_PATTERN_STRING = "*";
    private static final String RANGER_POLICY_EVAL_MATCH_ONE_CHARACTER_STRING = "?";
    private static final int RANGER_POLICY_EVAL_SCORE_DEFAULT = 10000;
    private static final int RANGER_POLICY_EVAL_SCORE_MAX_DISCOUNT_RESOURCE = 100;
    private static final int RANGER_POLICY_EVAL_SCORE_MAX_DISCOUNT_USERSGROUPS = 25;
    private static final int RANGER_POLICY_EVAL_SCORE_MAX_DISCOUNT_ACCESS_TYPES = 25;
    private static final int RANGER_POLICY_EVAL_SCORE_MAX_DISCOUNT_CUSTOM_CONDITIONS = 25;
    private static final int RANGER_POLICY_EVAL_SCORE_RESOURCE_DISCOUNT_MATCH_ANY_WILDCARD = 25;
    private static final int RANGER_POLICY_EVAL_SCORE_RESOURCE_DISCOUNT_HAS_MATCH_ANY_WILDCARD = 10;
    private static final int RANGER_POLICY_EVAL_SCORE_RESOURCE_DISCOUNT_HAS_MATCH_ONE_CHARACTER_WILDCARD = 5;
    private static final int RANGER_POLICY_EVAL_SCORE_RESOURCE_DISCOUNT_IS_EXCLUDES = 5;
    private static final int RANGER_POLICY_EVAL_SCORE_RESORUCE_DISCOUNT_IS_RECURSIVE = 5;
    private static final int RANGER_POLICY_EVAL_SCORE_CUSTOM_CONDITION_PENALTY = 5;

    @Override
    public void init(RangerPolicy policy, RangerServiceDef serviceDef, RangerPolicyEngineOptions options) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerOptimizedPolicyEvaluator.init()");
        }
        super.init(policy, serviceDef, options);
        this.preprocessPolicyItems(policy.getPolicyItems());
        this.preprocessPolicyItems(policy.getDenyPolicyItems());
        this.preprocessPolicyItems(policy.getAllowExceptions());
        this.preprocessPolicyItems(policy.getDenyExceptions());
        this.preprocessPolicyItems(policy.getDataMaskPolicyItems());
        this.hasAllPerms = this.checkIfHasAllPerms();
        for (String group : this.groups) {
            if (!group.equalsIgnoreCase("public")) continue;
            this.hasPublicGroup = true;
        }
        this.setEvalOrder(this.computeEvalOrder());
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"<== RangerOptimizedPolicyEvaluator.init()");
        }
    }

    public int computeEvalOrder() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerOptimizedPolicyEvaluator.computeEvalOrder()");
        }
        int evalOrder = 10000;
        RangerServiceDef serviceDef = this.getServiceDef();
        List<RangerServiceDef.RangerResourceDef> resourceDefs = serviceDef.getResources();
        RangerPolicy policy = this.getPolicy();
        ArrayList<LevelResourceNames> tmpList = new ArrayList<LevelResourceNames>();
        block0: for (Map.Entry<String, RangerPolicy.RangerPolicyResource> entry : policy.getResources().entrySet()) {
            String resourceName = entry.getKey();
            RangerPolicy.RangerPolicyResource policyResource = entry.getValue();
            List<String> resourceValues = policyResource.getValues();
            if (!CollectionUtils.isNotEmpty(resourceValues)) continue;
            for (RangerServiceDef.RangerResourceDef rangerResourceDef : resourceDefs) {
                if (!resourceName.equals(rangerResourceDef.getName())) continue;
                tmpList.add(new LevelResourceNames(rangerResourceDef.getLevel(), policyResource));
                continue block0;
            }
        }
        Collections.sort(tmpList);
        int resourceDiscount = 0;
        for (LevelResourceNames item : tmpList) {
            boolean foundStarWildcard = false;
            boolean foundQuestionWildcard = false;
            boolean foundMatchAny = false;
            for (String resourceName : item.policyResource.getValues()) {
                if (resourceName.isEmpty() || resourceName.equals(RANGER_POLICY_EVAL_MATCH_ANY_PATTERN_STRING)) {
                    foundMatchAny = true;
                    break;
                }
                if (resourceName.contains(RANGER_POLICY_EVAL_MATCH_ANY_PATTERN_STRING)) {
                    foundStarWildcard = true;
                    continue;
                }
                if (!resourceName.contains(RANGER_POLICY_EVAL_MATCH_ONE_CHARACTER_STRING)) continue;
                foundQuestionWildcard = true;
            }
            if (foundMatchAny) {
                resourceDiscount += 25;
                continue;
            }
            if (foundStarWildcard) {
                resourceDiscount += 10;
            } else if (foundQuestionWildcard) {
                resourceDiscount += 5;
            }
            RangerPolicy.RangerPolicyResource rangerPolicyResource = item.policyResource;
            if (rangerPolicyResource.getIsExcludes().booleanValue()) {
                resourceDiscount += 5;
            }
            if (!rangerPolicyResource.getIsRecursive().booleanValue()) continue;
            resourceDiscount += 5;
        }
        evalOrder -= Math.min(100, resourceDiscount);
        evalOrder = this.hasPublicGroup ? (evalOrder -= 25) : (evalOrder -= Math.min(this.groups.size() + this.users.size(), 25));
        evalOrder -= Math.round(25.0f * (float)this.accessPerms.size() / (float)serviceDef.getAccessTypes().size());
        int n = 25 - 5 * this.getCustomConditionsCount();
        if (n > 0) {
            evalOrder -= n;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerOptimizedPolicyEvaluator.computeEvalOrder(), policyName:" + policy.getName() + ", priority:" + evalOrder));
        }
        return evalOrder;
    }

    @Override
    protected boolean isAccessAllowed(String user, Set<String> userGroups, String accessType) {
        boolean ret;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerOptimizedPolicyEvaluator.isAccessAllowed(" + user + ", " + userGroups + ", " + accessType + ")"));
        }
        boolean bl = ret = this.hasMatchablePolicyItem(user, userGroups, accessType) && super.isAccessAllowed(user, userGroups, accessType);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("<== RangerOptimizedPolicyEvaluator.isAccessAllowed(" + user + ", " + userGroups + ", " + accessType + "): " + ret));
        }
        return ret;
    }

    @Override
    protected boolean hasMatchablePolicyItem(RangerAccessRequest request) {
        boolean ret = false;
        if (this.hasPublicGroup || this.users.contains(request.getUser()) || CollectionUtils.containsAny(this.groups, request.getUserGroups())) {
            ret = request.isAccessTypeDelegatedAdmin() ? this.delegateAdmin : (this.hasAllPerms ? true : request.isAccessTypeAny() || this.accessPerms.contains(request.getAccessType()));
        }
        return ret;
    }

    private boolean hasMatchablePolicyItem(String user, Set<String> userGroups, String accessType) {
        boolean ret = false;
        if (this.hasPublicGroup || this.users.contains(user) || CollectionUtils.containsAny(this.groups, userGroups)) {
            boolean isAdminAccess = StringUtils.equals((String)accessType, (String)"_admin");
            if (isAdminAccess) {
                ret = this.delegateAdmin;
            } else if (this.hasAllPerms) {
                ret = true;
            } else {
                boolean isAccessTypeAny = StringUtils.isEmpty((String)accessType) || StringUtils.equals((String)accessType, (String)"_any");
                ret = isAccessTypeAny || this.accessPerms.contains(accessType);
            }
        }
        return ret;
    }

    private void preprocessPolicyItems(List<? extends RangerPolicy.RangerPolicyItem> policyItems) {
        if (CollectionUtils.isNotEmpty(policyItems)) {
            for (RangerPolicy.RangerPolicyItem rangerPolicyItem : policyItems) {
                this.delegateAdmin = this.delegateAdmin || rangerPolicyItem.getDelegateAdmin() != false;
                List<RangerPolicy.RangerPolicyItemAccess> policyItemAccesses = rangerPolicyItem.getAccesses();
                for (RangerPolicy.RangerPolicyItemAccess policyItemAccess : policyItemAccesses) {
                    if (!policyItemAccess.getIsAllowed().booleanValue()) continue;
                    String accessType = policyItemAccess.getType();
                    this.accessPerms.add(accessType);
                }
                this.groups.addAll(rangerPolicyItem.getGroups());
                this.users.addAll(rangerPolicyItem.getUsers());
            }
        }
    }

    private boolean checkIfHasAllPerms() {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"==> RangerOptimizedPolicyEvaluator.checkIfHasAllPerms()");
        }
        boolean result = true;
        List<RangerServiceDef.RangerAccessTypeDef> serviceAccessTypes = this.getServiceDef().getAccessTypes();
        for (RangerServiceDef.RangerAccessTypeDef serviceAccessType : serviceAccessTypes) {
            if (this.accessPerms.contains(serviceAccessType.getName())) continue;
            result = false;
            break;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("==> RangerOptimizedPolicyEvaluator.checkIfHasAllPerms(), " + result));
        }
        return result;
    }

    static class LevelResourceNames
    implements Comparable<LevelResourceNames> {
        final int level;
        final RangerPolicy.RangerPolicyResource policyResource;

        public LevelResourceNames(int level, RangerPolicy.RangerPolicyResource policyResource) {
            this.level = level;
            this.policyResource = policyResource;
        }

        @Override
        public int compareTo(LevelResourceNames other) {
            return Integer.compare(this.level, other.level);
        }

        public boolean equals(Object other) {
            boolean ret = false;
            if (other != null && other instanceof LevelResourceNames) {
                ret = this == other || this.compareTo((LevelResourceNames)other) == 0;
            }
            return ret;
        }

        public int hashCode() {
            return Objects.hashCode(this.level);
        }
    }
}

